/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.blackjack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.andrespr.casinorocket.games.blackjack.BlackjackCard;

public final class BlackjackHand {
    private final List<BlackjackCard> cards = new ArrayList<BlackjackCard>();

    public void clear() {
        this.cards.clear();
    }

    public void add(BlackjackCard card) {
        this.cards.add(card);
    }

    public int size() {
        return this.cards.size();
    }

    public List<BlackjackCard> cards() {
        return Collections.unmodifiableList(this.cards);
    }

    public int hardValue() {
        int sum = 0;
        for (BlackjackCard c : this.cards) {
            sum += c.baseValue();
        }
        return sum;
    }

    public int bestValue() {
        int hard = this.hardValue();
        int aces = 0;
        for (BlackjackCard c : this.cards) {
            if (!c.isAce()) continue;
            ++aces;
        }
        if (aces == 0) {
            return hard;
        }
        int softCandidate = hard + 10;
        if (softCandidate <= 21) {
            return softCandidate;
        }
        return hard;
    }

    public boolean isSoft() {
        if (this.isBust()) {
            return false;
        }
        boolean hasAce = false;
        for (BlackjackCard c : this.cards) {
            if (!c.isAce()) continue;
            hasAce = true;
            break;
        }
        if (!hasAce) {
            return false;
        }
        return this.bestValue() == this.hardValue() + 10;
    }

    public boolean isBust() {
        return this.hardValue() > 21;
    }

    public boolean isNaturalBlackjack() {
        if (this.cards.size() != 2) {
            return false;
        }
        boolean hasAce = false;
        boolean hasTen = false;
        for (BlackjackCard c : this.cards) {
            if (c.isAce()) {
                hasAce = true;
            }
            if (!c.isTenValue()) continue;
            hasTen = true;
        }
        return hasAce && hasTen;
    }

    public String getValueText() {
        if (this.isNaturalBlackjack()) {
            return "Blackjack";
        }
        if (this.isBust()) {
            return "Bust";
        }
        int v = this.bestValue();
        if (this.isSoft()) {
            return "Soft " + v;
        }
        return Integer.toString(v);
    }
}

