/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.blackjack;

import net.andrespr.casinorocket.games.blackjack.BlackjackHand;
import net.andrespr.casinorocket.games.blackjack.BlackjackPhase;

public final class BlackjackRound {
    private BlackjackPhase phase = BlackjackPhase.IDLE;
    private long currentBet;
    private long winPayout;
    private final BlackjackHand playerHand = new BlackjackHand();
    private final BlackjackHand dealerHand = new BlackjackHand();
    private boolean dealerHoleHidden = true;
    private int resultSeq = 0;
    private int resultId = 0;
    private long resolvedBet = 0L;
    private long resolvedPayout = 0L;

    public BlackjackPhase getPhase() {
        return this.phase;
    }

    public long getCurrentBet() {
        return this.currentBet;
    }

    public long getWinPayout() {
        return this.winPayout;
    }

    public BlackjackHand getPlayerHand() {
        return this.playerHand;
    }

    public BlackjackHand getDealerHand() {
        return this.dealerHand;
    }

    public boolean isDealerHoleHidden() {
        return this.dealerHoleHidden;
    }

    public int getResultSeq() {
        return this.resultSeq;
    }

    public int getResultId() {
        return this.resultId;
    }

    public long getResolvedBet() {
        return this.resolvedBet;
    }

    public long getResolvedPayout() {
        return this.resolvedPayout;
    }

    public void setPhase(BlackjackPhase phase) {
        this.phase = phase;
    }

    public void setCurrentBet(long currentBet) {
        this.currentBet = Math.max(0L, currentBet);
    }

    public void setWinPayout(long winPayout) {
        this.winPayout = Math.max(0L, winPayout);
    }

    public void revealDealerHole() {
        this.dealerHoleHidden = false;
    }

    public void resetForNewRound(long bet) {
        this.playerHand.clear();
        this.dealerHand.clear();
        this.currentBet = bet;
        this.winPayout = 0L;
        this.dealerHoleHidden = true;
        this.phase = BlackjackPhase.PLAYER_TURN;
    }

    public void finishWithPayout(long payout) {
        this.winPayout = Math.max(0L, payout);
        this.resolvedBet = this.currentBet;
        this.resolvedPayout = this.winPayout;
        ++this.resultId;
        this.phase = this.winPayout == 0L ? BlackjackPhase.IDLE : BlackjackPhase.RESULT_PENDING;
    }

    public boolean canHit() {
        return this.phase == BlackjackPhase.PLAYER_TURN && !this.playerHand.isBust();
    }

    public boolean canStand() {
        return this.phase == BlackjackPhase.PLAYER_TURN;
    }

    public boolean canDoubleDown(long balance) {
        if (this.phase != BlackjackPhase.PLAYER_TURN) {
            return false;
        }
        if (this.playerHand.isBust()) {
            return false;
        }
        return balance >= this.currentBet;
    }

    public boolean canFinish() {
        return this.phase == BlackjackPhase.RESULT_PENDING;
    }

    public boolean canDoubleOrNothing() {
        return this.phase == BlackjackPhase.RESULT_PENDING && this.winPayout > 0L;
    }
}

