/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.blackjack;

import com.mojang.authlib.GameProfile;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ToLongFunction;
import net.andrespr.casinorocket.data.PlayerBlackjackData;
import net.andrespr.casinorocket.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public final class BlackjackUtils {
    private BlackjackUtils() {
    }

    public static class_2561 getLeaderboardText(MinecraftServer server, String key) {
        ToLongFunction<UUID> valueFn;
        String k;
        PlayerBlackjackData data = PlayerBlackjackData.get(server);
        switch (k = key.toLowerCase(Locale.ROOT)) {
            case "highest_win": {
                ToLongFunction<UUID> toLongFunction = data::getHighestWin;
                break;
            }
            case "total_win": {
                ToLongFunction<UUID> toLongFunction = data::getTotalWon;
                break;
            }
            case "total_lost": {
                ToLongFunction<UUID> toLongFunction = data::getTotalLost;
                break;
            }
            default: {
                ToLongFunction<UUID> toLongFunction = valueFn = null;
            }
        }
        if (valueFn == null) {
            return class_2561.method_43470((String)"Invalid key.").method_27692(class_124.field_1061);
        }
        ArrayList<Map.Entry> rows = new ArrayList<Map.Entry>();
        for (UUID id : data.getAllKnownPlayers()) {
            long v = valueFn.applyAsLong(id);
            if (k.equals("total_lost") ? v >= 0L : v <= 0L) continue;
            rows.add(new AbstractMap.SimpleEntry<UUID, Long>(id, v));
        }
        if (rows.isEmpty()) {
            return class_2561.method_43470((String)"No leaderboard entries yet.").method_27692(class_124.field_1080);
        }
        Comparator<Map.Entry> cmp = Comparator.comparingLong(Map.Entry::getValue);
        if (!k.equals("total_lost")) {
            cmp = cmp.reversed();
        }
        rows.sort(cmp);
        int limit = Math.min(10, rows.size());
        List top = rows.subList(0, limit);
        String titleLabel = switch (k) {
            case "highest_win" -> "Blackjack - Highest Win";
            case "total_win" -> "Blackjack - Total Won";
            case "total_lost" -> "Blackjack - Total Lost";
            default -> "Blackjack Leaderboard";
        };
        class_124 titleColor = switch (k) {
            case "highest_win" -> class_124.field_1065;
            case "total_win" -> class_124.field_1060;
            case "total_lost" -> class_124.field_1061;
            default -> class_124.field_1054;
        };
        class_5250 out = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)("Top 10 - " + titleLabel)).method_27695(new class_124[]{titleColor, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n"));
        for (int i = 0; i < top.size(); ++i) {
            int rank = i + 1;
            UUID id = (UUID)((Map.Entry)top.get(i)).getKey();
            long value = (Long)((Map.Entry)top.get(i)).getValue();
            String name = BlackjackUtils.resolveName(server, id);
            out.method_10852((class_2561)class_2561.method_43470((String)(rank + ". ")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(TextUtils.rankColors(rank))).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)BlackjackUtils.formatSignedMoney(value)).method_27692(class_124.field_1054));
            if (rank >= top.size()) continue;
            out.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        return out;
    }

    private static String resolveName(MinecraftServer server, UUID id) {
        Optional profile;
        class_3222 p = server.method_3760().method_14602(id);
        if (p != null) {
            return p.method_5477().getString();
        }
        class_3312 cache = server.method_3793();
        if (cache != null && (profile = cache.method_14512(id)).isPresent() && ((GameProfile)profile.get()).getName() != null) {
            return ((GameProfile)profile.get()).getName();
        }
        return BlackjackUtils.shortUuid(id);
    }

    private static String shortUuid(UUID id) {
        String s = id.toString().replace("-", "");
        return s.substring(0, 8);
    }

    private static String formatSignedMoney(long value) {
        if (value < 0L) {
            return "-" + TextUtils.formatCompactNoDecimal(-value);
        }
        return TextUtils.formatCompactNoDecimal(value);
    }
}

