/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.gachapon;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.andrespr.casinorocket.CasinoRocket;
import net.andrespr.casinorocket.block.custom.PokemonGachaMachineBlock;
import net.andrespr.casinorocket.config.GachaMachinesConfig;
import net.andrespr.casinorocket.data.GachaDataStorage;
import net.andrespr.casinorocket.data.GachaStats;
import net.andrespr.casinorocket.games.gachapon.GachaponUtils;
import net.andrespr.casinorocket.games.gachapon.PlushiesGachaponUtils;
import net.andrespr.casinorocket.games.gachapon.PokemonGachaponUtils;
import net.andrespr.casinorocket.item.ModItems;
import net.andrespr.casinorocket.sound.ModSounds;
import net.andrespr.casinorocket.util.CasinoRocketLogger;
import net.andrespr.casinorocket.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GachaMachinesUtils {
    private static final int DELAY_TICKS = 20;
    private static final Object2LongOpenHashMap<UUID> PLAYER_COOLDOWNS = new Object2LongOpenHashMap();
    private static final Object2ObjectOpenHashMap<class_2338, UUID> LAST_PLAYER_USED = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<UUID, class_2338> LAST_MACHINE_USED = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<class_2338, String> LAST_COIN_USED = new Object2ObjectOpenHashMap();
    private static final Set<Long> PENDING_PREMIER_BONUS = ConcurrentHashMap.newKeySet();
    private static final Map<Long, UUID> PENDING_PREMIER_USER = new ConcurrentHashMap<Long, UUID>();
    private static final Locale LOCALE = Locale.ROOT;
    private static final Map<UUID, Long> CLEAN_CONFIRMATION = new HashMap<UUID, Long>();

    public static class_1269 handleUse(class_1937 world, class_2338 pos, class_1657 player, String coinKey) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        long currentTick = world.method_8510();
        long machineKey = pos.method_10063();
        PLAYER_COOLDOWNS.object2LongEntrySet().removeIf(e -> currentTick > e.getLongValue());
        UUID currentUser = (UUID)LAST_PLAYER_USED.get((Object)pos);
        if (currentUser != null && !currentUser.equals(player.method_5667()) || PENDING_PREMIER_BONUS.contains(machineKey)) {
            CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_another_occupied", true, new Object[0]);
            return class_1269.field_5814;
        }
        LAST_MACHINE_USED.put((Object)player.method_5667(), (Object)pos);
        long playerCooldownEnd = PLAYER_COOLDOWNS.getLong((Object)player.method_5667());
        if (currentTick < playerCooldownEnd) {
            class_2338 lastUsed = (class_2338)LAST_MACHINE_USED.get((Object)player.method_5667());
            if (lastUsed != null && lastUsed.equals((Object)pos)) {
                CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_occupied", true, new Object[0]);
            } else {
                CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_another_occupied", true, new Object[0]);
            }
            return class_1269.field_5814;
        }
        player.method_6047().method_7934(1);
        PLAYER_COOLDOWNS.put((Object)player.method_5667(), currentTick + 20L);
        LAST_COIN_USED.put((Object)pos, (Object)coinKey);
        LAST_PLAYER_USED.put((Object)pos, (Object)player.method_5667());
        world.method_8396(null, pos, ModSounds.INSERTING_COIN, class_3419.field_15245, 1.0f, 1.0f);
        world.method_39279(pos, world.method_8320(pos).method_26204(), 20);
        CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_coin_inserted", false, new Object[0]);
        return class_1269.field_5812;
    }

    public static void finishDispense(class_3218 world, class_2338 pos, class_2350 facing) {
        long key = pos.method_10063();
        long currentTick = world.method_8510();
        if (PENDING_PREMIER_BONUS.remove(key)) {
            class_1657 user;
            UUID userId = PENDING_PREMIER_USER.remove(key);
            class_1657 class_16572 = user = userId != null ? world.method_18470(userId) : null;
            if (user == null) {
                return;
            }
            boolean pokemon = world.method_8320(pos).method_26204() instanceof PokemonGachaMachineBlock;
            GachaMachinesUtils.givePremierBonus(world, pos, facing, user, pokemon);
            LAST_COIN_USED.remove((Object)pos);
            LAST_PLAYER_USED.remove((Object)pos);
            return;
        }
        UUID uuid = (UUID)LAST_PLAYER_USED.get((Object)pos);
        class_1657 user = uuid != null ? world.method_18470(uuid) : null;
        class_2680 state = world.method_8320(pos);
        boolean pokemon = state.method_26204() instanceof PokemonGachaMachineBlock;
        String coinKey = (String)LAST_COIN_USED.getOrDefault((Object)pos, (Object)"copper");
        Map<String, Double> probs = CasinoRocket.CONFIG.gachaMachines.normalizedProbabilities(coinKey);
        Map<String, Double> pityAdjusted = GachaMachinesUtils.applyPity(probs, coinKey, user);
        String rarity = GachaMachinesUtils.pickWeightedRarity(world.method_8409(), pityAdjusted);
        class_1799 reward = GachaMachinesUtils.getRewardForRarity(rarity, pokemon);
        if (rarity.equalsIgnoreCase("legendary") && user != null) {
            GachaDataStorage data = GachaDataStorage.get(GachaMachinesUtils.requireServer(user.method_37908()));
            Map<String, Integer> playerMap = data.pityTracker.get(user.method_5667());
            if (playerMap != null) {
                playerMap.put(coinKey, 0);
                data.method_80();
                CasinoRocket.LOGGER.debug("[GachaMachines-Pity] {} pity reset for {}", (Object)coinKey, (Object)user.method_5477().getString());
            }
        }
        GachaMachinesUtils.spawnRarityParticles(world, pos, rarity);
        GachaMachinesUtils.playRaritySound((class_1937)world, pos, rarity);
        GachaMachinesUtils.spawnFireworkByRarity(world, pos, rarity);
        GachaMachinesUtils.dropFromFront((class_1937)world, pos, facing, reward);
        boolean scheduledBonus = false;
        if (user != null) {
            GachaDataStorage data = GachaDataStorage.get(world.method_8503());
            GachaStats stats = data.playerStats.computeIfAbsent(user.method_5667(), k -> new GachaStats(user.method_5477().getString()));
            stats.setPlayerName(user.method_5477().getString());
            stats.recordUse(coinKey, rarity);
            data.method_80();
            GachaMachinesConfig.PremierBonus config = CasinoRocket.CONFIG.gachaMachines.premier_bonus;
            if (config.enable && stats.getTotalCoinsUsed() % config.coinsToBonus == 0) {
                PENDING_PREMIER_BONUS.add(key);
                PENDING_PREMIER_USER.put(key, user.method_5667());
                world.method_39279(pos, world.method_8320(pos).method_26204(), 30);
                scheduledBonus = true;
            }
        }
        GachaMachinesUtils.giveUserFeedback(probs, coinKey, reward, user);
        if (!scheduledBonus || user == null) {
            LAST_COIN_USED.remove((Object)pos);
            LAST_PLAYER_USED.remove((Object)pos);
        }
        if (user != null) {
            int rarityDelay = GachaMachinesUtils.getRarityDelayTicks(rarity);
            if (scheduledBonus && rarityDelay < 60) {
                rarityDelay = 60;
            }
            long nextAvailable = currentTick + (long)rarityDelay;
            PLAYER_COOLDOWNS.put((Object)user.method_5667(), nextAvailable);
            LAST_MACHINE_USED.put((Object)user.method_5667(), (Object)pos);
        }
    }

    public static Map<String, Double> applyPity(Map<String, Double> probs, String coinKey, class_1657 player) {
        if (!CasinoRocket.CONFIG.gachaMachines.pity.enable) {
            return probs;
        }
        if (player == null) {
            return probs;
        }
        GachaDataStorage data = GachaDataStorage.get(GachaMachinesUtils.requireServer(player.method_37908()));
        GachaMachinesConfig.PityConfig.CoinPity pityData = GachaMachinesUtils.getPityData(coinKey);
        if (pityData == null || pityData.usesToMax <= 0 || pityData.maxLegendaryChance <= 0.0) {
            return probs;
        }
        UUID id = player.method_5667();
        Map playerMap = data.pityTracker.computeIfAbsent(id, k -> new HashMap());
        int uses = playerMap.getOrDefault(coinKey, 0) + 1;
        playerMap.put(coinKey, uses);
        double baseLegendary = probs.getOrDefault("legendary", 0.0);
        double t = Math.min(1.0, (double)uses / (double)pityData.usesToMax);
        double newLegendary = baseLegendary + (pityData.maxLegendaryChance - baseLegendary) * t;
        HashMap<String, Double> adjusted = new HashMap<String, Double>(probs);
        double diff = newLegendary - baseLegendary;
        if (diff > 0.0) {
            double totalOther = 1.0 - baseLegendary;
            for (String key : adjusted.keySet()) {
                if (key.equals("legendary")) continue;
                adjusted.put(key, (Double)adjusted.get(key) * (1.0 - diff) / totalOther);
            }
            adjusted.put("legendary", newLegendary);
        }
        CasinoRocket.LOGGER.debug("[GachaMachines-Pity] {} used {} {} times \u2192 legendary {}%", new Object[]{player.method_5477().getString(), coinKey, uses, newLegendary * 100.0});
        data.method_80();
        return adjusted;
    }

    public static String pickWeightedRarity(class_5819 random, Map<String, Double> probs) {
        double r = random.method_43058();
        double cumulative = 0.0;
        for (Map.Entry<String, Double> e : probs.entrySet()) {
            if (!(r <= (cumulative += e.getValue().doubleValue()))) continue;
            return e.getKey();
        }
        return "common";
    }

    public static class_1799 getRewardForRarity(String rarity, boolean pokemon) {
        class_1799 reward;
        String key = rarity.toLowerCase(LOCALE);
        if (pokemon) {
            reward = switch (key) {
                case "common" -> new class_1799((class_1935)ModItems.POKEMON_POKE_GACHAPON);
                case "uncommon" -> new class_1799((class_1935)ModItems.POKEMON_GREAT_GACHAPON);
                case "rare" -> new class_1799((class_1935)ModItems.POKEMON_ULTRA_GACHAPON);
                case "ultrarare" -> new class_1799((class_1935)ModItems.POKEMON_MASTER_GACHAPON);
                case "legendary" -> new class_1799((class_1935)ModItems.POKEMON_CHERISH_GACHAPON);
                case "bonus" -> new class_1799((class_1935)ModItems.POKEMON_PREMIER_GACHAPON);
                default -> class_1799.field_8037;
            };
        } else {
            switch (key) {
                case "common": {
                    class_1799 class_17992 = new class_1799((class_1935)ModItems.POKE_GACHAPON);
                    break;
                }
                case "uncommon": {
                    class_1799 class_17992 = new class_1799((class_1935)ModItems.GREAT_GACHAPON);
                    break;
                }
                case "rare": {
                    class_1799 class_17992 = new class_1799((class_1935)ModItems.ULTRA_GACHAPON);
                    break;
                }
                case "ultrarare": {
                    class_1799 class_17992 = new class_1799((class_1935)ModItems.MASTER_GACHAPON);
                    break;
                }
                case "legendary": {
                    class_1799 class_17992 = new class_1799((class_1935)ModItems.CHERISH_GACHAPON);
                    break;
                }
                case "bonus": {
                    class_1799 class_17992 = new class_1799((class_1935)ModItems.PREMIER_GACHAPON);
                    break;
                }
                default: {
                    class_1799 class_17992 = reward = class_1799.field_8037;
                }
            }
        }
        if (reward.method_7960()) {
            CasinoRocket.LOGGER.warn("[GachaMachines] No valid reward found for rarity '{}'", (Object)rarity);
        }
        return reward;
    }

    private static void givePremierBonus(class_3218 world, class_2338 pos, class_2350 facing, class_1657 user, boolean pokemon) {
        String bonusKey = "bonus";
        class_1799 bonus = GachaMachinesUtils.getRewardForRarity(bonusKey, pokemon);
        GachaMachinesUtils.spawnRarityParticles(world, pos, bonusKey);
        GachaMachinesUtils.playRaritySound((class_1937)world, pos, bonusKey);
        GachaMachinesUtils.dropFromFront((class_1937)world, pos, facing, bonus);
        GachaDataStorage data = GachaDataStorage.get(world.method_8503());
        GachaStats stats = data.playerStats.computeIfAbsent(user.method_5667(), k -> new GachaStats(user.method_5477().getString()));
        stats.recordBonus();
        data.method_80();
        CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_bonus_prize", true, new Object[0]);
    }

    public static void playRaritySound(class_1937 world, class_2338 pos, String rarity) {
        class_3414 sound;
        if (world.field_9236) {
            return;
        }
        switch (rarity.toLowerCase(LOCALE)) {
            case "common": {
                class_3414 class_34142 = ModSounds.COMMON_PRIZE;
                break;
            }
            case "uncommon": {
                class_3414 class_34142 = ModSounds.UNCOMMON_PRIZE;
                break;
            }
            case "rare": {
                class_3414 class_34142 = ModSounds.RARE_PRIZE;
                break;
            }
            case "ultrarare": {
                class_3414 class_34142 = ModSounds.ULTRARARE_PRIZE;
                break;
            }
            case "legendary": {
                class_3414 class_34142 = ModSounds.LEGENDARY_PRIZE;
                break;
            }
            case "bonus": {
                class_3414 class_34142 = ModSounds.BONUS_PRIZE;
                break;
            }
            default: {
                class_3414 class_34142 = sound = null;
            }
        }
        if (sound == null) {
            CasinoRocket.LOGGER.warn("[GachaMachines] No sound event defined for rarity '{}' at {}", (Object)rarity, (Object)pos);
            return;
        }
        world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
    }

    public static void spawnRarityParticles(class_3218 world, class_2338 pos, String rarity) {
        class_2400 particle;
        switch (rarity.toLowerCase(LOCALE)) {
            case "common": {
                class_2400 class_24002 = class_2398.field_11207;
                break;
            }
            case "uncommon": {
                class_2400 class_24002 = class_2398.field_11211;
                break;
            }
            case "rare": {
                class_2400 class_24002 = class_2398.field_11248;
                break;
            }
            case "ultrarare": {
                class_2400 class_24002 = class_2398.field_11216;
                break;
            }
            case "legendary": {
                class_2400 class_24002 = class_2398.field_11240;
                break;
            }
            case "bonus": {
                class_2400 class_24002 = class_2398.field_28479;
                break;
            }
            default: {
                class_2400 class_24002 = particle = null;
            }
        }
        if (particle == null) {
            CasinoRocket.LOGGER.warn("[GachaMachines] No particle effect defined for rarity '{}' at {}", (Object)rarity, (Object)pos);
            return;
        }
        world.method_14199((class_2394)particle, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 20, 0.3, 0.3, 0.3, 0.02);
    }

    public static void spawnFireworkByRarity(class_3218 world, class_2338 pos, String rarity) {
        class_9283.class_1782 shape;
        int color;
        int flight = 0;
        boolean trail = true;
        boolean twinkle = true;
        switch (rarity.toLowerCase(LOCALE)) {
            case "ultrarare": {
                color = 0x8000FF;
                shape = class_9283.class_1782.field_7976;
                break;
            }
            case "legendary": {
                color = 0xFF0000;
                shape = class_9283.class_1782.field_7973;
                break;
            }
            default: {
                return;
            }
        }
        IntArrayList colors = new IntArrayList(new int[]{color});
        class_9283 explosion = new class_9283(shape, (IntList)colors, (IntList)new IntArrayList(), trail, twinkle);
        class_9284 fwComponent = new class_9284(flight, List.of(explosion));
        class_1799 rocket = new class_1799((class_1935)class_1802.field_8639);
        rocket.method_57379(class_9334.field_49616, (Object)fwComponent);
        class_1671 entity = new class_1671((class_1937)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.0, (double)pos.method_10260() + 0.5, rocket);
        world.method_8649((class_1297)entity);
    }

    public static void giveUserFeedback(Map<String, Double> probs, String coinKey, class_1799 reward, class_1657 user) {
        if (user == null) {
            return;
        }
        CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_reward", true, reward.method_7964());
        if ((coinKey.equals("gold") || coinKey.equals("diamond")) && CasinoRocket.CONFIG.gachaMachines.pity.pityUpdateMessages) {
            GachaDataStorage data = GachaDataStorage.get(GachaMachinesUtils.requireServer(user.method_37908()));
            Map<String, Integer> playerMap = data.pityTracker.get(user.method_5667());
            double pityChance = GachaMachinesUtils.getCurrentLegendaryChance(coinKey, user, probs);
            int maxUses = GachaMachinesUtils.getMaxUses(coinKey);
            class_5250 coinName = Objects.requireNonNull(GachaMachinesUtils.getCoinStack(coinKey)).method_7964().method_27661();
            String formattedChance = String.format("%.2f", pityChance * 100.0);
            if (playerMap != null && playerMap.getOrDefault(coinKey, 0) == 0) {
                CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_pity_reset", false, coinName.method_27692(class_124.field_1065), class_2561.method_43470((String)formattedChance).method_27692(class_124.field_1054));
            } else if (playerMap != null && playerMap.getOrDefault(coinKey, 0) >= maxUses) {
                CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_pity_max", false, coinName.method_27692(class_124.field_1065), class_2561.method_43470((String)formattedChance).method_27692(class_124.field_1054));
            } else {
                CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_pity_update", false, coinName.method_27692(class_124.field_1065), class_2561.method_43470((String)formattedChance).method_27692(class_124.field_1054));
            }
        }
    }

    public static String getCoinKey(class_1799 stack) {
        if (stack.method_31574((class_1792)ModItems.COPPER_COIN)) {
            return "copper";
        }
        if (stack.method_31574((class_1792)ModItems.IRON_COIN)) {
            return "iron";
        }
        if (stack.method_31574((class_1792)ModItems.GOLD_COIN)) {
            return "gold";
        }
        if (stack.method_31574((class_1792)ModItems.DIAMOND_COIN)) {
            return "diamond";
        }
        return null;
    }

    public static class_1799 getCoinStack(String coinKey) {
        return switch (coinKey.toLowerCase(LOCALE)) {
            case "copper" -> new class_1799((class_1935)ModItems.COPPER_COIN);
            case "iron" -> new class_1799((class_1935)ModItems.IRON_COIN);
            case "gold" -> new class_1799((class_1935)ModItems.GOLD_COIN);
            case "diamond" -> new class_1799((class_1935)ModItems.DIAMOND_COIN);
            default -> class_1799.field_8037;
        };
    }

    public static GachaMachinesConfig.PityConfig.CoinPity getPityData(String coinKey) {
        return switch (coinKey) {
            case "iron" -> CasinoRocket.CONFIG.gachaMachines.pity.iron;
            case "gold" -> CasinoRocket.CONFIG.gachaMachines.pity.gold;
            case "diamond" -> CasinoRocket.CONFIG.gachaMachines.pity.diamond;
            default -> null;
        };
    }

    public static double getCurrentLegendaryChance(String coinKey, class_1657 player, Map<String, Double> baseProbs) {
        GachaDataStorage data = GachaDataStorage.get(GachaMachinesUtils.requireServer(player.method_37908()));
        Map<String, Integer> playerMap = data.pityTracker.get(player.method_5667());
        if (playerMap == null) {
            return baseProbs.getOrDefault("legendary", 0.0);
        }
        int uses = playerMap.getOrDefault(coinKey, 0);
        GachaMachinesConfig.PityConfig.CoinPity pityData = GachaMachinesUtils.getPityData(coinKey);
        if (pityData == null) {
            return baseProbs.getOrDefault("legendary", 0.0);
        }
        double base = baseProbs.getOrDefault("legendary", 0.0);
        double t = Math.min(1.0, (double)uses / (double)pityData.usesToMax);
        return base + (pityData.maxLegendaryChance - base) * t;
    }

    public static int getMaxUses(String coinKey) {
        GachaMachinesConfig.PityConfig.CoinPity pityData = GachaMachinesUtils.getPityData(coinKey);
        return pityData != null ? pityData.usesToMax : 1;
    }

    public static int getRarityDelayTicks(String rarity) {
        return switch (rarity.toLowerCase(LOCALE)) {
            case "uncommon" -> 20;
            case "rare" -> 35;
            case "ultrarare" -> 80;
            case "legendary" -> 70;
            case "bonus" -> 40;
            default -> 10;
        };
    }

    public static class_1269 handleEventUse(class_1937 world, class_2338 pos, class_1657 player) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        long currentTick = world.method_8510();
        PLAYER_COOLDOWNS.object2LongEntrySet().removeIf(e -> currentTick > e.getLongValue());
        long playerCooldownEnd = PLAYER_COOLDOWNS.getLong((Object)player.method_5667());
        if (currentTick < playerCooldownEnd) {
            CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_occupied", true, new Object[0]);
            return class_1269.field_5814;
        }
        PLAYER_COOLDOWNS.put((Object)player.method_5667(), currentTick + 20L);
        LAST_PLAYER_USED.put((Object)pos, (Object)player.method_5667());
        world.method_8396(null, pos, ModSounds.INSERTING_COIN, class_3419.field_15245, 1.0f, 1.0f);
        world.method_39279(pos, world.method_8320(pos).method_26204(), 20);
        CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_coin_inserted", false, new Object[0]);
        return class_1269.field_5812;
    }

    public static void finishEventDispense(class_3218 world, class_2338 pos, class_2350 facing) {
        class_1657 user;
        UUID uuid = (UUID)LAST_PLAYER_USED.remove((Object)pos);
        class_1657 class_16572 = user = uuid != null ? world.method_18470(uuid) : null;
        if (user == null) {
            return;
        }
        boolean pokemon = world.field_9229.method_43056();
        boolean hasItems = GachaponUtils.hasValidPool("event");
        boolean hasPokemon = PokemonGachaponUtils.hasValidPool("event");
        if (pokemon && !hasPokemon) {
            pokemon = false;
        }
        if (!pokemon && !hasItems) {
            pokemon = true;
        }
        class_1799 reward = pokemon ? new class_1799((class_1935)ModItems.POKEMON_EVENT_GACHAPON) : new class_1799((class_1935)ModItems.EVENT_GACHAPON);
        GachaMachinesUtils.spawnRarityParticles(world, pos, "rare");
        GachaMachinesUtils.playRaritySound((class_1937)world, pos, "rare");
        GachaMachinesUtils.spawnFireworkByRarity(world, pos, "rare");
        GachaMachinesUtils.dropFromFront((class_1937)world, pos, facing, reward);
        CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_reward", true, reward.method_7964());
        long nextAvailable = world.method_8510() + (long)GachaMachinesUtils.getRarityDelayTicks("rare");
        PLAYER_COOLDOWNS.put((Object)user.method_5667(), nextAvailable);
    }

    public static class_1269 handlePlushiesUse(class_1937 world, class_2338 pos, class_1657 player) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        long currentTick = world.method_8510();
        PLAYER_COOLDOWNS.object2LongEntrySet().removeIf(e -> currentTick > e.getLongValue());
        UUID currentUser = (UUID)LAST_PLAYER_USED.get((Object)pos);
        if (currentUser != null && !currentUser.equals(player.method_5667())) {
            CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_another_occupied", true, new Object[0]);
            return class_1269.field_5814;
        }
        LAST_MACHINE_USED.put((Object)player.method_5667(), (Object)pos);
        long playerCooldownEnd = PLAYER_COOLDOWNS.getLong((Object)player.method_5667());
        if (currentTick < playerCooldownEnd) {
            class_2338 lastUsed = (class_2338)LAST_MACHINE_USED.get((Object)player.method_5667());
            if (lastUsed != null && lastUsed.equals((Object)pos)) {
                CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_occupied", true, new Object[0]);
            } else {
                CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_another_occupied", true, new Object[0]);
            }
            return class_1269.field_5814;
        }
        PLAYER_COOLDOWNS.put((Object)player.method_5667(), currentTick + 20L);
        LAST_PLAYER_USED.put((Object)pos, (Object)player.method_5667());
        world.method_8396(null, pos, ModSounds.INSERTING_COIN, class_3419.field_15245, 1.0f, 1.0f);
        world.method_39279(pos, world.method_8320(pos).method_26204(), 20);
        CasinoRocketLogger.toPlayerTranslated(player, "message.casinorocket.gacha_machines_coin_inserted", false, new Object[0]);
        return class_1269.field_5812;
    }

    public static void finishPlushiesDispense(class_3218 world, class_2338 pos, class_2350 facing) {
        class_1657 user;
        long currentTick = world.method_8510();
        UUID uuid = (UUID)LAST_PLAYER_USED.remove((Object)pos);
        class_1657 class_16572 = user = uuid != null ? world.method_18470(uuid) : null;
        if (user == null) {
            return;
        }
        class_1799 reward = PlushiesGachaponUtils.pickPlushie(world.method_8409());
        if (reward.method_7960()) {
            CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.item_gachapon_empty", true, new Object[0]);
            CasinoRocket.LOGGER.warn("[PlushiesMachine] No valid plushies in config (or total weight 0).");
            return;
        }
        GachaMachinesUtils.spawnRarityParticles(world, pos, "rare");
        GachaMachinesUtils.playRaritySound((class_1937)world, pos, "rare");
        GachaMachinesUtils.spawnFireworkByRarity(world, pos, "rare");
        GachaMachinesUtils.dropFromFront((class_1937)world, pos, facing, reward);
        CasinoRocketLogger.toPlayerTranslated(user, "message.casinorocket.gacha_machines_reward", true, reward.method_7964());
        long nextAvailable = currentTick + (long)GachaMachinesUtils.getRarityDelayTicks("rare");
        PLAYER_COOLDOWNS.put((Object)user.method_5667(), nextAvailable);
        LAST_MACHINE_USED.put((Object)user.method_5667(), (Object)pos);
    }

    public static void dropFromFront(class_1937 world, class_2338 pos, class_2350 facing, class_1799 stack) {
        if (world.field_9236) {
            return;
        }
        double x = (double)pos.method_10263() + 0.5 + (double)facing.method_10148() * 0.7;
        double y = (double)pos.method_10264() + 0.7;
        double z = (double)pos.method_10260() + 0.5 + (double)facing.method_10165() * 0.7;
        class_1542 entity = new class_1542(world, x, y, z, stack.method_7972());
        double speed = 0.15;
        entity.method_18800((double)facing.method_10148() * speed, 0.1, (double)facing.method_10165() * speed);
        world.method_8649((class_1297)entity);
    }

    private static MinecraftServer requireServer(class_1937 world) {
        return Objects.requireNonNull(world.method_8503(), "[CasinoRocket] Server not found!");
    }

    public static class_2561 getPlayerStatsText(Object targetOrName, MinecraftServer server) {
        GachaDataStorage data = GachaDataStorage.get(server);
        GachaStats stats = null;
        String playerName = null;
        if (targetOrName instanceof class_3222) {
            class_3222 player = (class_3222)targetOrName;
            stats = data.playerStats.get(player.method_5667());
            playerName = stats != null && stats.getPlayerName() != null ? stats.getPlayerName() : player.method_5477().getString();
        } else if (targetOrName instanceof String) {
            String name = (String)targetOrName;
            for (GachaStats s : data.playerStats.values()) {
                if (s.getPlayerName() == null || !s.getPlayerName().equalsIgnoreCase(name)) continue;
                stats = s;
                playerName = name;
                break;
            }
        }
        if (stats == null || playerName == null) {
            return class_2561.method_43470((String)"No recorded stats for player.").method_27692(class_124.field_1080);
        }
        class_5250 text = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)"Gacha Machine Stats for ").method_27692(class_124.field_1067)).method_10852((class_2561)class_2561.method_43470((String)playerName).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)":\n").method_27692(class_124.field_1067)).method_10852((class_2561)class_2561.method_43470((String)"Total Coins Used: ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(stats.getTotalCoinsUsed() + "\n\n")).method_27692(class_124.field_1054));
        text.method_10852((class_2561)class_2561.method_43470((String)"Coins Inserted:\n").method_27692(class_124.field_1054));
        LinkedHashMap<String, Integer> coins = new LinkedHashMap<String, Integer>();
        coins.put("Copper", stats.copperUsed);
        coins.put("Iron", stats.ironUsed);
        coins.put("Gold", stats.goldUsed);
        coins.put("Diamond", stats.diamondUsed);
        int coinIndex = 0;
        int coinSize = coins.size();
        for (Map.Entry e : coins.entrySet()) {
            String coin = (String)e.getKey();
            int count = (Integer)e.getValue();
            text.method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(coin + ": ")).method_27692(TextUtils.coinColor(coin))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1054));
            if (++coinIndex >= coinSize) continue;
            text.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        text.method_10852((class_2561)class_2561.method_43470((String)"\n\nGachapon Rarity Obtained:\n").method_27692(class_124.field_1054));
        Set<Map.Entry<String, Integer>> entries = stats.getRarityCounts().entrySet();
        int index = 0;
        int size = entries.size();
        for (Map.Entry<String, Integer> e : entries) {
            String rarity = e.getKey();
            int count = e.getValue();
            text.method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(GachaMachinesUtils.capitalize(rarity) + ": ")).method_27692(TextUtils.rarityColor(rarity))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1054));
            if (++index >= size) continue;
            text.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        return text;
    }

    public static class_2561 getLeaderboardText(MinecraftServer server, String category, String key) {
        GachaDataStorage data = GachaDataStorage.get(server);
        data.playerStats.values().removeIf(Objects::isNull);
        String input = key.toLowerCase(Locale.ROOT);
        boolean isRarity = category.equalsIgnoreCase("rarity");
        boolean isCoin = category.equalsIgnoreCase("coins");
        if (!isRarity && !isCoin) {
            return class_2561.method_43470((String)"Invalid leaderboard type. Use 'rarity' or 'coins'.").method_27692(class_124.field_1061);
        }
        Comparator<Map.Entry> comparator = Comparator.comparingInt(e -> isRarity ? ((GachaStats)e.getValue()).getRarityCount(input) : ((GachaStats)e.getValue()).getCoinCount(input)).reversed();
        List<Map.Entry> sorted = data.playerStats.entrySet().stream().sorted(comparator).limit(10L).toList();
        if (sorted.isEmpty()) {
            return class_2561.method_43470((String)("No entries for " + category + " '" + key + "'.")).method_27692(class_124.field_1080);
        }
        class_124 titleColor = isRarity ? TextUtils.rarityColor(input) : TextUtils.coinColor(input);
        String titleLabel = (isRarity ? "Gacha Wins (" : "Coins Used (") + key.toUpperCase(Locale.ROOT) + ")";
        class_5250 out = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)("Top 10 - " + titleLabel)).method_27695(new class_124[]{titleColor, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n"));
        int rank = 1;
        for (Map.Entry e2 : sorted) {
            UUID id = (UUID)e2.getKey();
            GachaStats stats = (GachaStats)e2.getValue();
            String name = stats.getPlayerName() != null ? stats.getPlayerName() : GachaMachinesUtils.shortUuid(id);
            int count = isRarity ? stats.getRarityCount(input) : stats.getCoinCount(input);
            out.method_10852((class_2561)class_2561.method_43470((String)(rank + ". ")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(TextUtils.rankColors(rank))).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1054));
            if (rank++ >= sorted.size()) continue;
            out.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        return out;
    }

    public static class_2561 clearAllGachaData(MinecraftServer server, boolean confirm, @Nullable class_3222 sender) {
        UUID id = sender != null ? sender.method_5667() : UUID.randomUUID();
        long now = server.method_30002().method_8510();
        long window = 600L;
        if (!confirm) {
            CLEAN_CONFIRMATION.put(id, now);
            return class_2561.method_43470((String)"\u26a0 Are you sure you want to delete ALL Gacha data?\n").method_10852((class_2561)class_2561.method_43470((String)"Type again within 30 seconds:\n").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"'/casinorocket gachapon machines cleandata confirm'").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        }
        Long lastRequest = CLEAN_CONFIRMATION.get(id);
        if (lastRequest == null) {
            return class_2561.method_43470((String)"You must run '/casinorocket gachapon machines cleandata' first.").method_27692(class_124.field_1061);
        }
        if (now - lastRequest > window) {
            return class_2561.method_43470((String)"Confirmation expired. Type again '/casinorocket gachapon machines cleandata'").method_27692(class_124.field_1080);
        }
        CLEAN_CONFIRMATION.remove(id);
        GachaDataStorage data = GachaDataStorage.get(server);
        int playerCount = data.playerStats.size();
        int pityCount = data.pityTracker.size();
        data.playerStats.clear();
        data.pityTracker.clear();
        data.method_80();
        CasinoRocket.LOGGER.warn("[CasinoRocket] Cleared Gacha data: {} player stats, {} pity entries removed.", (Object)playerCount, (Object)pityCount);
        return class_2561.method_43470((String)"All Gacha data cleared successfully.\n").method_10852((class_2561)class_2561.method_43470((String)(playerCount + " player stats and " + pityCount + " pity entries removed.")).method_27692(class_124.field_1080));
    }

    public static class_2561 getMachineRatesText(@Nullable class_3222 player, String coinKey, boolean includePity) {
        Map<String, Double> base = CasinoRocket.CONFIG.gachaMachines.normalizedProbabilities(coinKey);
        if (base == null || base.isEmpty()) {
            return class_2561.method_43470((String)("No rates available for coin '" + coinKey + "'.")).method_27692(class_124.field_1061);
        }
        Map<String, Double> rates = new LinkedHashMap<String, Double>(base);
        if (includePity && player != null && CasinoRocket.CONFIG.gachaMachines.pity.enable) {
            rates = GachaMachinesUtils.previewPityAdjusted(base, coinKey, player);
        }
        class_5250 result = class_2561.method_43470((String)"");
        String title = includePity ? "Rates with Pity (" + coinKey.toUpperCase(Locale.ROOT) + ")" : "Base Rates (" + coinKey.toUpperCase(Locale.ROOT) + ")";
        result.method_10852((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1073)).method_27693("\n");
        boolean first = true;
        for (Map.Entry<String, Double> e : rates.entrySet()) {
            if (!first) {
                result.method_10852((class_2561)class_2561.method_43470((String)", "));
            }
            first = false;
            String rarity = GachaMachinesUtils.capitalize(e.getKey());
            double percentage = e.getValue() * 100.0;
            double rounded = (double)Math.round(percentage * 100.0) / 100.0;
            class_124 color = TextUtils.percentagesColor(rounded);
            result.method_10852((class_2561)class_2561.method_43470((String)(rarity + ": ")).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f%%", rounded)).method_27692(color)));
        }
        return result;
    }

    public static Map<String, Double> previewPityAdjusted(Map<String, Double> probs, String coinKey, class_3222 player) {
        double t;
        GachaMachinesConfig.PityConfig.CoinPity pityData = GachaMachinesUtils.getPityData(coinKey);
        if (pityData == null || !CasinoRocket.CONFIG.gachaMachines.pity.enable || player == null) {
            return probs;
        }
        GachaDataStorage data = GachaDataStorage.get(GachaMachinesUtils.requireServer(player.method_37908()));
        int uses = data.pityTracker.getOrDefault(player.method_5667(), Map.of()).getOrDefault(coinKey, 0);
        double baseLegendary = probs.getOrDefault("legendary", 0.0);
        double newLegendary = baseLegendary + (pityData.maxLegendaryChance - baseLegendary) * (t = Math.min(1.0, (double)uses / (double)pityData.usesToMax));
        if (newLegendary <= baseLegendary) {
            return probs;
        }
        LinkedHashMap<String, Double> adjusted = new LinkedHashMap<String, Double>(probs);
        double diff = newLegendary - baseLegendary;
        double totalOther = 1.0 - baseLegendary;
        for (String key : adjusted.keySet()) {
            if (key.equals("legendary")) continue;
            adjusted.put(key, (Double)adjusted.get(key) * (1.0 - diff) / totalOther);
        }
        adjusted.put("legendary", newLegendary);
        return adjusted;
    }

    public static Set<String> getRarityKeys() {
        return Set.of("common", "uncommon", "rare", "ultrarare", "legendary", "bonus");
    }

    public static Set<String> getCoinKeys() {
        return Set.of("copper", "iron", "gold", "diamond");
    }

    private static String capitalize(String s) {
        return s.isEmpty() ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private static String shortUuid(UUID id) {
        String s = id.toString();
        return "Player-" + s.substring(0, 8);
    }
}

