/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.gachapon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.andrespr.casinorocket.CasinoRocket;
import net.andrespr.casinorocket.config.ItemGachaponConfig;
import net.andrespr.casinorocket.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class GachaponUtils {
    private static final Map<String, CachedPool> CACHE = new ConcurrentHashMap<String, CachedPool>();
    private static final Set<String> WARNED_ITEMS = ConcurrentHashMap.newKeySet();

    public static void buildCache(Map<String, List<ItemGachaponConfig.GachaEntry>> pools) {
        CACHE.clear();
        WARNED_ITEMS.clear();
        for (Map.Entry<String, List<ItemGachaponConfig.GachaEntry>> poolEntry : pools.entrySet()) {
            String poolKey = poolEntry.getKey();
            List<ItemGachaponConfig.GachaEntry> entries = poolEntry.getValue();
            ArrayList<CachedEntry> valid = new ArrayList<CachedEntry>();
            int totalWeight = 0;
            for (ItemGachaponConfig.GachaEntry entry : entries) {
                class_2960 id = class_2960.method_60654((String)entry.itemId);
                if (!class_7923.field_41178.method_10250(id)) {
                    if (!WARNED_ITEMS.add(entry.itemId)) continue;
                    CasinoRocket.LOGGER.warn("[Gachapon] Invalid item in pool '{}': '{}'", (Object)poolKey, (Object)entry.itemId);
                    continue;
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                int count = Math.max(1, entry.count);
                int weight = Math.max(0, entry.weight);
                valid.add(new CachedEntry(item, count, weight));
                totalWeight += weight;
            }
            if (valid.isEmpty()) {
                CasinoRocket.LOGGER.warn("[Gachapon] Pool '{}' is empty or contains no valid items", (Object)poolKey);
            }
            int[] cumulative = new int[valid.size()];
            int cumulativeSum = 0;
            for (int i = 0; i < valid.size(); ++i) {
                cumulative[i] = cumulativeSum += ((CachedEntry)valid.get(i)).weight();
            }
            CACHE.put(poolKey, new CachedPool(Collections.unmodifiableList(valid), totalWeight, cumulative));
        }
        CasinoRocket.LOGGER.info("[Gachapon] Cache built with '{}' pools.", (Object)CACHE.size());
    }

    public static class_1799 pickItemReward(class_5819 random, String poolKey) {
        CachedPool pool = CACHE.get(poolKey);
        if (pool == null || pool.entries().isEmpty()) {
            return class_1799.field_8037;
        }
        int totalWeight = pool.totalWeight();
        if (totalWeight <= 0) {
            return class_1799.field_8037;
        }
        int roll = random.method_43048(totalWeight);
        int index = Arrays.binarySearch(pool.cumulativeWeights(), roll + 1);
        if (index < 0) {
            index = -index - 1;
        }
        if (index >= pool.entries().size()) {
            return class_1799.field_8037;
        }
        CachedEntry entry = pool.entries().get(index);
        return new class_1799((class_1935)entry.item(), entry.count());
    }

    public static class_2561 getPoolPercentages(String poolKey) {
        CachedPool pool = CACHE.get(poolKey);
        if (pool == null || pool.entries().isEmpty()) {
            return class_2561.method_43470((String)("Pool '" + poolKey + "' has no valid items.")).method_27692(class_124.field_1061);
        }
        int totalWeight = pool.totalWeight();
        if (totalWeight <= 0) {
            return class_2561.method_43470((String)("Pool '" + poolKey + "' has total weight 0.")).method_27692(class_124.field_1061);
        }
        class_5250 result = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Rates:").method_27692(class_124.field_1073)).method_27693("\n");
        ArrayList<CachedEntry> sorted = new ArrayList<CachedEntry>(pool.entries());
        sorted.sort((a, b) -> Integer.compare(b.weight(), a.weight()));
        boolean first = true;
        for (CachedEntry entry : sorted) {
            if (!first) {
                result.method_10852((class_2561)class_2561.method_43470((String)", "));
            }
            first = false;
            class_1799 stack = new class_1799((class_1935)entry.item());
            String name = stack.method_7964().getString();
            double percentage = (double)entry.weight() * 100.0 / (double)totalWeight;
            double rounded = (double)Math.round(percentage * 100.0) / 100.0;
            class_124 color = TextUtils.percentagesColor(rounded);
            result.method_10852((class_2561)class_2561.method_43470((String)(name + ": ")).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f%%", rounded)).method_27692(color)));
        }
        return result;
    }

    public static Set<String> getPools() {
        return CACHE.keySet();
    }

    public static boolean hasValidPool(String poolKey) {
        CachedPool pool = CACHE.get(poolKey);
        return pool != null && !pool.entries().isEmpty() && pool.totalWeight() > 0;
    }

    public record CachedEntry(class_1792 item, int count, int weight) {
    }

    public record CachedPool(List<CachedEntry> entries, int totalWeight, int[] cumulativeWeights) {
    }
}

