/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.gachapon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.andrespr.casinorocket.CasinoRocket;
import net.andrespr.casinorocket.config.PlushiesGachaponConfig;
import net.andrespr.casinorocket.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public final class PlushiesGachaponUtils {
    private static final List<CachedEntry> ENTRIES = new ArrayList<CachedEntry>();
    private static int TOTAL_WEIGHT = 0;
    private static int[] CUMULATIVE = new int[0];
    private static final Set<String> WARNED_ITEMS = ConcurrentHashMap.newKeySet();

    private PlushiesGachaponUtils() {
    }

    public static void buildCache(List<PlushiesGachaponConfig.GachaEntry> plushies) {
        ENTRIES.clear();
        WARNED_ITEMS.clear();
        TOTAL_WEIGHT = 0;
        if (plushies == null || plushies.isEmpty()) {
            CasinoRocket.LOGGER.warn("[PlushiesGachapon] Plushies list is empty.");
            CUMULATIVE = new int[0];
            return;
        }
        for (PlushiesGachaponConfig.GachaEntry entry : plushies) {
            if (entry == null || entry.itemId == null || entry.itemId.isBlank()) continue;
            class_2960 id = class_2960.method_60654((String)entry.itemId);
            if (!class_7923.field_41178.method_10250(id)) {
                if (!WARNED_ITEMS.add(entry.itemId)) continue;
                CasinoRocket.LOGGER.warn("[PlushiesGachapon] Invalid item '{}'", (Object)entry.itemId);
                continue;
            }
            int weight = Math.max(0, entry.weight);
            if (weight <= 0) continue;
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            ENTRIES.add(new CachedEntry(item, weight));
            TOTAL_WEIGHT += weight;
        }
        if (ENTRIES.isEmpty()) {
            CasinoRocket.LOGGER.warn("[PlushiesGachapon] No valid items found (all invalid or weight=0).");
            CUMULATIVE = new int[0];
            return;
        }
        CUMULATIVE = new int[ENTRIES.size()];
        int sum = 0;
        for (int i = 0; i < ENTRIES.size(); ++i) {
            PlushiesGachaponUtils.CUMULATIVE[i] = sum += ENTRIES.get(i).weight();
        }
        CasinoRocket.LOGGER.info("[PlushiesGachapon] Cache built with {} entries. TotalWeight={}", (Object)ENTRIES.size(), (Object)TOTAL_WEIGHT);
    }

    public static class_1799 pickPlushie(class_5819 random) {
        if (ENTRIES.isEmpty() || TOTAL_WEIGHT <= 0) {
            return class_1799.field_8037;
        }
        int roll = random.method_43048(TOTAL_WEIGHT);
        int idx = Arrays.binarySearch(CUMULATIVE, roll + 1);
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (idx < 0 || idx >= ENTRIES.size()) {
            return class_1799.field_8037;
        }
        CachedEntry entry = ENTRIES.get(idx);
        return new class_1799((class_1935)entry.item());
    }

    public static class_2561 getRates() {
        if (ENTRIES.isEmpty()) {
            return class_2561.method_43470((String)"Plushies list has no valid items.").method_27692(class_124.field_1061);
        }
        if (TOTAL_WEIGHT <= 0) {
            return class_2561.method_43470((String)"Plushies total weight is 0.").method_27692(class_124.field_1061);
        }
        class_5250 result = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Rates:").method_27692(class_124.field_1073)).method_27693("\n");
        ArrayList<CachedEntry> sorted = new ArrayList<CachedEntry>(ENTRIES);
        sorted.sort((a, b) -> Integer.compare(b.weight(), a.weight()));
        boolean first = true;
        for (CachedEntry e : sorted) {
            if (!first) {
                result.method_10852((class_2561)class_2561.method_43470((String)", "));
            }
            first = false;
            class_1799 stack = new class_1799((class_1935)e.item());
            String name = stack.method_7964().getString();
            double pct = (double)e.weight() * 100.0 / (double)TOTAL_WEIGHT;
            double rounded = (double)Math.round(pct * 100.0) / 100.0;
            class_124 color = TextUtils.percentagesColor(rounded);
            result.method_10852((class_2561)class_2561.method_43470((String)(name + ": ")).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f%%", rounded)).method_27692(color)));
        }
        return result;
    }

    public static int getEntryCount() {
        return ENTRIES.size();
    }

    public static boolean hasRewards() {
        return PlushiesGachaponUtils.getEntryCount() > 0;
    }

    public record CachedEntry(class_1792 item, int weight) {
    }
}

