/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.slot;

import java.util.ArrayList;
import net.andrespr.casinorocket.games.slot.SlotLineResult;
import net.andrespr.casinorocket.games.slot.SlotSpinResult;
import net.andrespr.casinorocket.games.slot.SlotSymbol;

public class SlotLines {
    public static final int[][] MODE1 = new int[][]{{1, 0}, {1, 1}, {1, 2}};
    public static final int[][][] MODE2 = new int[][][]{new int[][]{{0, 0}, {0, 1}, {0, 2}}, new int[][]{{1, 0}, {1, 1}, {1, 2}}, new int[][]{{2, 0}, {2, 1}, {2, 2}}};
    public static final int[][][] MODE3 = new int[][][]{new int[][]{{0, 0}, {0, 1}, {0, 2}}, new int[][]{{1, 0}, {1, 1}, {1, 2}}, new int[][]{{2, 0}, {2, 1}, {2, 2}}, new int[][]{{0, 0}, {1, 1}, {2, 2}}, new int[][]{{2, 0}, {1, 1}, {0, 2}}};

    private static int[][][] getLines(int mode) {
        Object object;
        switch (mode) {
            case 2: {
                object = MODE2;
                break;
            }
            case 3: {
                object = MODE3;
                break;
            }
            default: {
                int[][][] nArrayArray = new int[1][][];
                object = nArrayArray;
                nArrayArray[0] = MODE1;
            }
        }
        return object;
    }

    private static SlotLineResult evaluateLine(SlotSymbol[][] matrix, int[][] coords, int baseBet, int lineIndex) {
        boolean allSame;
        SlotSymbol a = matrix[coords[0][0]][coords[0][1]];
        SlotSymbol b = matrix[coords[1][0]][coords[1][1]];
        SlotSymbol c = matrix[coords[2][0]][coords[2][1]];
        SlotSymbol target = a;
        boolean bl = allSame = a == b && b == c;
        if (target == SlotSymbol.CHERRY) {
            int cherryCount;
            int multiplier;
            if (a == SlotSymbol.CHERRY && b != SlotSymbol.CHERRY) {
                multiplier = 2;
                cherryCount = 1;
            } else if (a == SlotSymbol.CHERRY && b == SlotSymbol.CHERRY && c != SlotSymbol.CHERRY) {
                multiplier = 3;
                cherryCount = 2;
            } else if (a == SlotSymbol.CHERRY && b == SlotSymbol.CHERRY && c == SlotSymbol.CHERRY) {
                multiplier = 5;
                cherryCount = 3;
            } else {
                multiplier = 0;
                cherryCount = 0;
            }
            return new SlotLineResult(multiplier > 0, SlotSymbol.CHERRY, cherryCount, multiplier, baseBet * multiplier, lineIndex);
        }
        if (target == SlotSymbol.HAUNTER) {
            return new SlotLineResult(false, null, 0, 0, 0, lineIndex);
        }
        if (allSame) {
            int multiplier = target.getTripleMultiplier();
            return new SlotLineResult(true, target, 3, multiplier, baseBet * multiplier, lineIndex);
        }
        return new SlotLineResult(false, null, 0, 0, 0, lineIndex);
    }

    public static SlotSpinResult evaluateSpin(SlotSymbol[][] matrix, int baseBet, int mode) {
        int[][][] lines = SlotLines.getLines(mode);
        ArrayList<SlotLineResult> results = new ArrayList<SlotLineResult>();
        int total = 0;
        for (int i = 0; i < lines.length; ++i) {
            int[][] line = lines[i];
            SlotLineResult result = SlotLines.evaluateLine(matrix, line, baseBet, i);
            results.add(result);
            total += result.lineWin();
        }
        return new SlotSpinResult(matrix, total, results);
    }
}

