/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.slot;

import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.andrespr.casinorocket.config.CasinoRocketConfig;
import net.andrespr.casinorocket.config.SlotMachineConfig;

public final class SlotMachineConstants {
    private static final List<Integer> FALLBACK_BET_VALUES = List.of(10, 25, 50, 100, 250, 500, 1000, 5000, 10000, 25000, 50000, 100000, 250000, 500000, 1000000, 5000000);

    private SlotMachineConstants() {
    }

    private static SlotMachineConfig cfg() {
        CasinoRocketConfig root = (CasinoRocketConfig)AutoConfig.getConfigHolder(CasinoRocketConfig.class).getConfig();
        return root.slotMachine;
    }

    public static List<Integer> betValues() {
        try {
            List<Integer> v = SlotMachineConstants.cfg().betValues;
            return v == null || v.isEmpty() ? FALLBACK_BET_VALUES : v;
        }
        catch (Exception e) {
            return FALLBACK_BET_VALUES;
        }
    }

    public static int defaultBetBase() {
        List<Integer> v = SlotMachineConstants.betValues();
        return v.isEmpty() ? 10 : v.getFirst();
    }

    public static int defaultLinesMode() {
        return 1;
    }

    public static int getBetMultiplierForMode(int mode) {
        try {
            SlotMachineConfig c = SlotMachineConstants.cfg();
            return switch (mode) {
                case 2 -> Math.max(1, c.betMultipliers.mode2);
                case 3 -> Math.max(1, c.betMultipliers.mode3);
                default -> Math.max(1, c.betMultipliers.mode1);
            };
        }
        catch (Exception e) {
            return switch (mode) {
                case 2 -> 3;
                case 3 -> 5;
                default -> 1;
            };
        }
    }
}

