/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.slot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.andrespr.casinorocket.config.SlotMachineConfig;
import net.andrespr.casinorocket.games.slot.SlotSymbol;

public class SlotReels {
    private static int REEL_SIZE = 256;
    private static SlotSymbol[] REEL1;
    private static SlotSymbol[] REEL2;
    private static SlotSymbol[] REEL3;
    public static SlotSymbol[][] STRIPS;

    public static int reelSize() {
        return REEL_SIZE;
    }

    public static void reloadFromConfig(SlotMachineConfig cfg) {
        REEL_SIZE = Math.max(16, Math.min(cfg.reels.reelSize, 4096));
        REEL1 = SlotReels.buildReel(cfg.reels.reel1, REEL_SIZE, 12866032L);
        REEL2 = SlotReels.buildReel(cfg.reels.reel2, REEL_SIZE, 12874706L);
        REEL3 = SlotReels.buildReel(cfg.reels.reel3, REEL_SIZE, 12870339L);
        STRIPS = new SlotSymbol[][]{REEL1, REEL2, REEL3};
    }

    public static SlotSymbol get(SlotSymbol[] reel, int index) {
        int i = Math.floorMod(index, REEL_SIZE);
        return reel[i];
    }

    private static SlotSymbol[] buildReel(SlotMachineConfig.ReelStrip strip, int reelSize, long seed) {
        List<SlotSymbol> list = new ArrayList(reelSize);
        for (Map.Entry<SlotSymbol, Integer> e : strip.counts.entrySet()) {
            int count = Math.max(0, e.getValue());
            for (int i = 0; i < count; ++i) {
                list.add(e.getKey());
            }
        }
        if (list.size() > reelSize) {
            list = list.subList(0, reelSize);
        } else if (list.size() < reelSize) {
            int remaining = reelSize - list.size();
            for (int i = 0; i < remaining; ++i) {
                list.add(strip.fillSymbol);
            }
        }
        Random r = new Random(seed);
        for (int i = 0; i < 5; ++i) {
            Collections.shuffle(list, r);
        }
        return list.toArray(new SlotSymbol[0]);
    }
}

