/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.network.c2s_handlers.slots;

import java.util.UUID;
import net.andrespr.casinorocket.data.PlayerSlotMachineData;
import net.andrespr.casinorocket.games.slot.SlotMachineConstants;
import net.andrespr.casinorocket.games.slot.SlotSpinEngine;
import net.andrespr.casinorocket.games.slot.SlotSpinResult;
import net.andrespr.casinorocket.network.c2s.slots.DoSpinC2SPayload;
import net.andrespr.casinorocket.network.s2c.SendSpinResultS2CPayload;
import net.andrespr.casinorocket.screen.custom.slot.SlotMachineScreenHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class DoSpinReceiver {
    public static void handle(DoSpinC2SPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        if (!(player.field_7512 instanceof SlotMachineScreenHandler)) {
            return;
        }
        PlayerSlotMachineData storage = PlayerSlotMachineData.get(server);
        UUID uuid = player.method_5667();
        long balance = storage.getBalance(uuid);
        int betBase = storage.getBetBase(uuid);
        int linesMode = storage.getLinesMode(uuid);
        if (betBase <= 0 || linesMode <= 0) {
            return;
        }
        int betMultiplier = SlotMachineConstants.getBetMultiplierForMode(linesMode);
        long cost = (long)betBase * (long)betMultiplier;
        if (balance < cost) {
            return;
        }
        storage.addTotalSpent(uuid, cost);
        long afterCost = balance - cost;
        SlotSpinResult spinResult = SlotSpinEngine.spinAndEvaluate(betBase, linesMode);
        long spinWin = spinResult.totalWin();
        storage.addTotalWon(uuid, spinWin);
        storage.setLastWin(uuid, spinWin);
        storage.updateHighestWin(uuid, spinWin);
        long newBalance = afterCost + spinWin;
        storage.setBalance(uuid, newBalance);
        ServerPlayNetworking.send((class_3222)player, (class_8710)SendSpinResultS2CPayload.from(newBalance, linesMode, spinResult));
    }
}

