/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.network.s2c;

import java.util.ArrayList;
import java.util.List;
import net.andrespr.casinorocket.games.slot.SlotLineResult;
import net.andrespr.casinorocket.games.slot.SlotSpinResult;
import net.andrespr.casinorocket.games.slot.SlotSymbol;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SendSpinResultS2CPayload(long newBalance, int totalWin, int modeUsed, int[] matrix, List<LineWin> wins) implements class_8710
{
    public static final class_2960 ID_RAW = class_2960.method_60655((String)"casinorocket", (String)"spin_result");
    public static final class_8710.class_9154<SendSpinResultS2CPayload> ID = new class_8710.class_9154(ID_RAW);
    public static final class_9139<class_9129, SendSpinResultS2CPayload> CODEC = class_9139.method_56438(SendSpinResultS2CPayload::write, SendSpinResultS2CPayload::read);

    public static SendSpinResultS2CPayload from(long newBalance, int modeUsed, SlotSpinResult result) {
        SlotSymbol[][] matrixSymbols = result.matrix();
        int[] flat = new int[9];
        int idx = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                flat[idx++] = matrixSymbols[row][col].ordinal();
            }
        }
        ArrayList<LineWin> wins = new ArrayList<LineWin>();
        for (SlotLineResult line : result.lines()) {
            if (!line.win()) continue;
            wins.add(new LineWin(line.symbol().ordinal(), line.count(), line.multiplier(), line.lineWin(), line.lineIndex()));
        }
        return new SendSpinResultS2CPayload(newBalance, result.totalWin(), modeUsed, flat, wins);
    }

    private static void write(SendSpinResultS2CPayload payload, class_9129 buf) {
        buf.method_52974(payload.newBalance());
        buf.method_53002(payload.totalWin());
        buf.method_53002(payload.modeUsed());
        int[] m = payload.matrix();
        for (int i = 0; i < 9; ++i) {
            buf.method_53002(m[i]);
        }
        List<LineWin> wins = payload.wins();
        buf.method_53002(wins.size());
        for (LineWin w : wins) {
            buf.method_53002(w.symbolOrdinal());
            buf.method_53002(w.count());
            buf.method_53002(w.multiplier());
            buf.method_53002(w.winAmount());
            buf.method_53002(w.lineIndex());
        }
    }

    private static SendSpinResultS2CPayload read(class_9129 buf) {
        long newBalance = buf.readLong();
        int totalWin = buf.readInt();
        int modeUsed = buf.readInt();
        int[] matrix = new int[9];
        for (int i = 0; i < 9; ++i) {
            matrix[i] = buf.readInt();
        }
        int winCount = buf.readInt();
        ArrayList<LineWin> wins = new ArrayList<LineWin>(winCount);
        for (int i = 0; i < winCount; ++i) {
            int symbolOrdinal = buf.readInt();
            int count = buf.readInt();
            int multiplier = buf.readInt();
            int winAmount = buf.readInt();
            int lineIndex = buf.readInt();
            wins.add(new LineWin(symbolOrdinal, count, multiplier, winAmount, lineIndex));
        }
        return new SendSpinResultS2CPayload(newBalance, totalWin, modeUsed, matrix, wins);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public record LineWin(int symbolOrdinal, int count, int multiplier, int winAmount, int lineIndex) {
    }
}

