/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.network.s2c.sender;

import java.util.List;
import net.andrespr.casinorocket.data.PlayerBlackjackData;
import net.andrespr.casinorocket.games.blackjack.BlackjackCard;
import net.andrespr.casinorocket.games.blackjack.BlackjackGameController;
import net.andrespr.casinorocket.games.blackjack.BlackjackHand;
import net.andrespr.casinorocket.games.blackjack.BlackjackPhase;
import net.andrespr.casinorocket.games.blackjack.BlackjackRound;
import net.andrespr.casinorocket.network.s2c.SendBlackjackStateS2CPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class BlackjackStateSender {
    private BlackjackStateSender() {
    }

    public static void send(class_3222 player, class_2338 pos, PlayerBlackjackData storage, BlackjackGameController controller) {
        BlackjackRound round = controller.getRound();
        BlackjackHand playerHand = round.getPlayerHand();
        BlackjackHand dealerHand = round.getDealerHand();
        long balance = storage.getBalance(player.method_5667());
        int betIndex = storage.getBetIndex(player.method_5667());
        int[] playerCards = BlackjackStateSender.toCardIds(playerHand.cards());
        int[] dealerCards = round.isDealerHoleHidden() ? BlackjackStateSender.toDealerCardsWithHiddenHole(dealerHand.cards()) : BlackjackStateSender.toCardIds(dealerHand.cards());
        String playerValueText = playerHand.getValueText();
        String dealerValueText = round.isDealerHoleHidden() ? "?" : dealerHand.getValueText();
        boolean canPlay = round.getPhase() == BlackjackPhase.IDLE;
        boolean canHit = round.canHit();
        boolean canStand = round.canStand();
        boolean canDoubleDown = round.canDoubleDown(balance);
        boolean canFinish = round.canFinish();
        boolean canDoubleOrNothing = round.canDoubleOrNothing();
        SendBlackjackStateS2CPayload payload = new SendBlackjackStateS2CPayload(pos, "blackjack", balance, betIndex, round.getCurrentBet(), round.getPhase(), round.getWinPayout(), round.getResultSeq(), controller.getResultId(), controller.getLastResolvedBet(), controller.getLastResolvedPayout(), !round.isDealerHoleHidden(), playerCards, dealerCards, playerValueText, dealerValueText, canPlay, canHit, canStand, canDoubleDown, canFinish, canDoubleOrNothing);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    private static int[] toCardIds(List<BlackjackCard> cards) {
        int[] out = new int[cards.size()];
        for (int i = 0; i < cards.size(); ++i) {
            BlackjackCard c = cards.get(i);
            out[i] = c.j() * 13 + c.i();
        }
        return out;
    }

    private static int[] toDealerCardsWithHiddenHole(List<BlackjackCard> cards) {
        int[] out = new int[cards.size()];
        for (int i = 0; i < cards.size(); ++i) {
            if (i == 1) {
                out[i] = -1;
                continue;
            }
            BlackjackCard c = cards.get(i);
            out[i] = c.j() * 13 + c.i();
        }
        return out;
    }
}

