/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.screen.custom.blackjack;

import com.mojang.blaze3d.systems.RenderSystem;
import net.andrespr.casinorocket.games.blackjack.BlackjackAction;
import net.andrespr.casinorocket.games.blackjack.BlackjackPhase;
import net.andrespr.casinorocket.games.blackjack.BlackjackRules;
import net.andrespr.casinorocket.network.c2s.blackjack.BlackjackActionC2SPayload;
import net.andrespr.casinorocket.network.c2s.blackjack.ChangeBlackjackBetIndexC2SPayload;
import net.andrespr.casinorocket.network.s2c.SendBlackjackStateS2CPayload;
import net.andrespr.casinorocket.screen.ModGuiTextures;
import net.andrespr.casinorocket.screen.custom.CasinoMachineScreen;
import net.andrespr.casinorocket.screen.custom.blackjack.BlackjackTableScreenHandler;
import net.andrespr.casinorocket.screen.widget.CommonButton;
import net.andrespr.casinorocket.screen.widget.ModButtons;
import net.andrespr.casinorocket.screen.widget.SlotButton;
import net.andrespr.casinorocket.sound.ModSounds;
import net.andrespr.casinorocket.util.CasinoRocketLogger;
import net.andrespr.casinorocket.util.TextUtils;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_757;
import net.minecraft.class_8710;

public class BlackjackTableScreen
extends CasinoMachineScreen<BlackjackTableScreenHandler> {
    private CommonButton playBtn;
    private CommonButton hitBtn;
    private CommonButton standBtn;
    private CommonButton doubleDownBtn;
    private CommonButton finishBtn;
    private CommonButton doubleOrNothingBtn;
    private SlotButton betButton;
    private SlotButton withdrawButton;
    private SlotButton plusButton;
    private SlotButton subtractButton;
    private long balance = 0L;
    private int betIndex = 0;
    private long currentBet = 0L;
    private BlackjackPhase phase = BlackjackPhase.IDLE;
    private long winPayout = 0L;
    private int[] playerCards = new int[0];
    private int[] dealerCards = new int[0];
    private String playerValueText = "";
    private String dealerValueText = "";
    private boolean canPlay;
    private boolean canHit;
    private boolean canStand;
    private boolean canDoubleDown;
    private boolean canFinish;
    private boolean canDoubleOrNothing;
    private int lastSeenResultId = -1;
    private class_2561 resultText = null;
    private int resultColor = 0xFFFFFF;
    private int resultTicks = 0;

    public BlackjackTableScreen(BlackjackTableScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_2792 = 242;
        this.field_2779 = 222;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int baseX = (this.field_22789 - this.field_2792) / 2;
        int baseY = (this.field_22790 - this.field_2779) / 2;
        this.betButton = ModButtons.bet(baseX, baseY, 6, 6, b -> this.onBetPressed());
        this.withdrawButton = ModButtons.withdraw(baseX, baseY, 164, 6, b -> this.onWithdrawPressed());
        this.subtractButton = ModButtons.subtract(baseX, baseY, 84, 18, b -> this.onSubtractPressed());
        this.plusButton = ModButtons.plus(baseX, baseY, 145, 18, b -> this.onPlusPressed());
        this.method_37063((class_364)this.betButton);
        this.method_37063((class_364)this.withdrawButton);
        this.method_37063((class_364)this.subtractButton);
        this.method_37063((class_364)this.plusButton);
        this.playBtn = ModButtons.play(baseX, baseY, 166, 133, b -> this.sendAction(BlackjackAction.PLAY));
        this.hitBtn = ModButtons.hit(baseX, baseY, 166, 148, b -> this.sendAction(BlackjackAction.HIT));
        this.standBtn = ModButtons.stand(baseX, baseY, 166, 163, b -> this.sendAction(BlackjackAction.STAND));
        this.doubleDownBtn = ModButtons.doubleDown(baseX, baseY, 166, 178, b -> this.sendAction(BlackjackAction.DOUBLE_DOWN));
        this.finishBtn = ModButtons.finish(baseX, baseY, 166, 148, b -> this.sendAction(BlackjackAction.FINISH));
        this.doubleOrNothingBtn = ModButtons.doubleOrNothing(baseX, baseY, 166, 163, b -> this.sendAction(BlackjackAction.DOUBLE_OR_NOTHING));
        this.method_37063((class_364)this.playBtn);
        this.method_37063((class_364)this.hitBtn);
        this.method_37063((class_364)this.standBtn);
        this.method_37063((class_364)this.doubleDownBtn);
        this.method_37063((class_364)this.finishBtn);
        this.method_37063((class_364)this.doubleOrNothingBtn);
        this.updateButtons();
    }

    private void sendAction(BlackjackAction action) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        if (action == BlackjackAction.HIT) {
            this.field_22787.field_1724.method_5783(ModSounds.CARD, 1.0f, 1.0f);
        }
        ClientPlayNetworking.send((class_8710)new BlackjackActionC2SPayload(((BlackjackTableScreenHandler)this.field_2797).getMachinePos(), ((BlackjackTableScreenHandler)this.field_2797).getMachineKey(), action));
    }

    private void onPlusPressed() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new ChangeBlackjackBetIndexC2SPayload(true));
        }
    }

    private void onSubtractPressed() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new ChangeBlackjackBetIndexC2SPayload(false));
        }
    }

    public void applyState(SendBlackjackStateS2CPayload p) {
        this.balance = p.balance();
        this.betIndex = p.betIndex();
        this.currentBet = p.currentBet();
        this.phase = p.phase();
        this.winPayout = p.winPayout();
        this.playerCards = p.playerCards();
        this.dealerCards = p.dealerCards();
        this.playerValueText = p.playerValueText();
        this.dealerValueText = p.dealerValueText();
        this.canPlay = p.canPlay();
        this.canHit = p.canHit();
        this.canStand = p.canStand();
        this.canDoubleDown = p.canDoubleDown();
        this.canFinish = p.canFinish();
        this.canDoubleOrNothing = p.canDoubleOrNothing();
        this.updateButtons();
        if (this.lastSeenResultId == -1) {
            this.lastSeenResultId = p.resultId();
        } else if (p.resultId() != this.lastSeenResultId) {
            this.lastSeenResultId = p.resultId();
            this.showResultText(p.resolvedBet(), p.resolvedPayout());
            this.playResultSound(p.resolvedBet(), p.resolvedPayout());
        }
    }

    public void method_37432() {
        super.method_37432();
        if (this.resultTicks > 0) {
            --this.resultTicks;
            if (this.resultTicks == 0) {
                this.resultText = null;
            }
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ModGuiTextures.BLACKJACK_TABLE_GUI);
        context.method_25302(ModGuiTextures.BLACKJACK_TABLE_GUI, x, y, 0, 0, this.field_2792, this.field_2779);
        this.drawDealerCards(context, x, y, this.dealerCards);
        this.drawPlayerCards(context, x, y, this.playerCards);
    }

    protected void method_2388(class_332 ctx, int mouseX, int mouseY) {
        this.drawCenteredTextInBox(ctx, class_2561.method_43471((String)"gui.casinorocket.blackjack_table.bet_amount").getString(), 85, 7, 155, 14, 0xFFFFFF);
        this.drawCenteredTextInBox(ctx, class_2561.method_43469((String)"gui.casinorocket.blackjack_table.dealers_hand", (Object[])new Object[]{this.dealerValueText}).getString(), 53, 46, 188, 53, 0xFFFFFF);
        this.drawCenteredTextInBox(ctx, class_2561.method_43469((String)"gui.casinorocket.blackjack_table.players_hand", (Object[])new Object[]{this.playerValueText}).getString(), 15, 143, 150, 150, 0xFFFFFF);
        this.drawCenteredTextInBox(ctx, class_2561.method_43471((String)"gui.casinorocket.blackjack_table.balance").getString(), 15, 209, 64, 216, 0xFFFFFF);
        this.drawCenteredTextInBox(ctx, class_2561.method_43471((String)"gui.casinorocket.blackjack_table.last_win").getString(), 130, 209, 179, 216, 0xFFFFFF);
        if (this.resultText != null && this.resultTicks > 0) {
            this.drawCenteredTextInBox(ctx, this.resultText.getString(), 49, 131, 116, 138, this.resultColor);
        }
        this.drawNumericValues(ctx);
    }

    private void drawNumericValues(class_332 ctx) {
        long betAmount = BlackjackRules.BET_VALUES.get(this.betIndex);
        this.drawRightAlignedTextInBox(ctx, TextUtils.formatCompact(betAmount), 101, 20, 128, 27, this.resolveInsufficientBalance(this.balance, this.betIndex));
        this.drawRightAlignedTextInBox(ctx, TextUtils.formatCompact(this.balance), 73, 209, 100, 216, 65280);
        this.drawRightAlignedTextInBox(ctx, TextUtils.formatCompact(this.winPayout), 188, 209, 215, 216, this.winPayout > 0L ? 65280 : 0xAAAAAA);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isBusy() && this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (keyCode == 256) {
                CasinoRocketLogger.toPlayerTranslated((class_1657)this.field_22787.field_1724, "gui.casinorocket.blackjack.esc", true, new Object[0]);
                return true;
            }
            if (this.field_22787.field_1690 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25419() {
        if (this.isBusy()) {
            return;
        }
        super.method_25419();
    }

    @Override
    protected boolean returnToMachineOnEsc() {
        return false;
    }

    private boolean isBusy() {
        return this.phase != BlackjackPhase.IDLE;
    }

    private void drawDealerCards(class_332 context, int guiX, int guiY, int[] cards) {
        if (cards == null || cards.length == 0) {
            return;
        }
        for (int i = 0; i < cards.length; ++i) {
            int yRel;
            int cardId = cards[i];
            int slot = i % 4;
            int loop = i / 4;
            if (slot == 0) {
                xRel = 90;
                yRel = 64;
            } else if (slot == 1) {
                xRel = 128;
                yRel = 64;
            } else if (slot == 2) {
                xRel = 166;
                yRel = 62;
            } else {
                xRel = 52;
                yRel = 62;
            }
            this.drawCardAt(context, guiX + (xRel += loop * 7), guiY + yRel, cardId);
        }
    }

    private void drawPlayerCards(class_332 context, int guiX, int guiY, int[] cards) {
        if (cards == null || cards.length == 0) {
            return;
        }
        for (int i = 0; i < cards.length; ++i) {
            int cardId = cards[i];
            int slot = i % 4;
            int loop = i / 4;
            int yRel = 160;
            int xRel = slot == 0 ? 17 : (slot == 1 ? 53 : (slot == 2 ? 89 : 125));
            this.drawCardAt(context, guiX + (xRel += loop * 7), guiY + yRel, cardId);
        }
    }

    private void drawCardAt(class_332 context, int x, int y, int cardId) {
        if (cardId < 0) {
            context.method_25290(ModGuiTextures.CARD_BOTTOM, x, y, 0.0f, 0.0f, 24, 32, 24, 32);
            return;
        }
        this.drawCardFromSpritesheet(context, x, y, cardId);
    }

    private void drawCardFromSpritesheet(class_332 context, int x, int y, int cardId) {
        int i = Math.floorMod(cardId, 13);
        int j = Math.floorDiv(cardId, 13);
        int u = i * 24;
        int v = j * 32;
        context.method_25290(ModGuiTextures.CARDS_SPRITESHEET, x, y, (float)u, (float)v, 24, 32, 312, 128);
    }

    private void updateButtons() {
        boolean showResult;
        boolean idle;
        boolean bl = idle = this.phase == BlackjackPhase.IDLE;
        if (this.betButton != null) {
            this.betButton.field_22764 = true;
            this.betButton.field_22763 = idle;
            this.betButton.setFakePressed(!idle);
        }
        if (this.withdrawButton != null) {
            this.withdrawButton.field_22764 = true;
            this.withdrawButton.field_22763 = idle;
            this.withdrawButton.setFakePressed(!idle);
        }
        if (this.plusButton != null) {
            this.plusButton.field_22764 = true;
            this.plusButton.field_22763 = idle;
            this.plusButton.setFakePressed(!idle);
        }
        if (this.subtractButton != null) {
            this.subtractButton.field_22764 = true;
            this.subtractButton.field_22763 = idle;
            this.subtractButton.setFakePressed(!idle);
        }
        this.updateBetIndexButtons();
        boolean showCore = this.phase == BlackjackPhase.IDLE || this.phase == BlackjackPhase.PLAYER_TURN || this.phase == BlackjackPhase.DEALER_TURN;
        boolean bl2 = showResult = this.phase == BlackjackPhase.RESULT_PENDING;
        if (this.playBtn != null) {
            this.playBtn.field_22764 = showCore;
            boolean bl3 = this.playBtn.field_22763 = showCore && this.canPlay;
        }
        if (this.hitBtn != null) {
            this.hitBtn.field_22764 = showCore;
            boolean bl4 = this.hitBtn.field_22763 = showCore && this.canHit;
        }
        if (this.standBtn != null) {
            this.standBtn.field_22764 = showCore;
            boolean bl5 = this.standBtn.field_22763 = showCore && this.canStand;
        }
        if (this.doubleDownBtn != null) {
            this.doubleDownBtn.field_22764 = showCore;
            boolean bl6 = this.doubleDownBtn.field_22763 = showCore && this.canDoubleDown;
        }
        if (this.finishBtn != null) {
            this.finishBtn.field_22764 = showResult;
            boolean bl7 = this.finishBtn.field_22763 = showResult && this.canFinish;
        }
        if (this.doubleOrNothingBtn != null) {
            this.doubleOrNothingBtn.field_22764 = showResult;
            this.doubleOrNothingBtn.field_22763 = showResult && this.canDoubleOrNothing;
        }
    }

    private void updateBetIndexButtons() {
        int max = BlackjackRules.BET_VALUES.size() - 1;
        this.subtractButton.field_22763 = this.betIndex > 0 && this.phase == BlackjackPhase.IDLE;
        this.plusButton.field_22763 = this.betIndex < max && this.phase == BlackjackPhase.IDLE;
        this.subtractButton.setForcedPressed(this.betIndex == 0);
        this.plusButton.setForcedPressed(this.betIndex == max);
    }

    private void playResultSound(long resolvedBet, long resolvedPayout) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        if (resolvedPayout > resolvedBet) {
            this.field_22787.field_1724.method_5783(ModSounds.WIN, 1.0f, 1.0f);
            return;
        }
        if (resolvedPayout == resolvedBet && resolvedBet > 0L) {
            this.field_22787.field_1724.method_5783(ModSounds.DRAW, 1.0f, 1.0f);
            return;
        }
        this.field_22787.field_1724.method_5783(ModSounds.LOSE, 1.0f, 1.0f);
    }

    private void drawCenteredTextInBox(class_332 ctx, String text, int x1, int y1, int x2, int y2, int color) {
        int textWidth = this.field_22793.method_1727(text);
        int textHeight = 8;
        int cx = x1 + (x2 - x1 - textWidth) / 2;
        int cy = y1 + (y2 - y1 - textHeight) / 2;
        ctx.method_51433(this.field_22793, text, cx, cy, color, true);
    }

    private void drawRightAlignedTextInBox(class_332 ctx, String text, int x1, int y1, int x2, int y2, int color) {
        int textWidth = this.field_22793.method_1727(text);
        int textHeight = 8;
        int cx = x2 - textWidth;
        int cy = y1 + (y2 - y1 - textHeight) / 2;
        ctx.method_51433(this.field_22793, text, cx, cy, color, true);
    }

    private int resolveInsufficientBalance(long balance, int betIndex) {
        long betAmount = BlackjackRules.BET_VALUES.get(betIndex);
        boolean insufficientBalance = betAmount > balance;
        return insufficientBalance ? 0xFF5555 : 65280;
    }

    private void showResultText(long bet, long payout) {
        if (payout > bet) {
            this.resultText = class_2561.method_43471((String)"gui.casinorocket.blackjack.win");
            this.resultColor = 0xFFFFFF;
        } else if (payout == bet && bet > 0L) {
            this.resultText = class_2561.method_43471((String)"gui.casinorocket.blackjack.draw");
            this.resultColor = 0xAAAAAA;
        } else {
            this.resultText = class_2561.method_43471((String)"gui.casinorocket.blackjack.lose");
            this.resultColor = 0xFF5555;
        }
        this.resultTicks = 40;
    }
}

