/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.screen.custom.common;

import java.util.List;
import net.andrespr.casinorocket.data.PlayerBlackjackData;
import net.andrespr.casinorocket.data.PlayerSlotMachineData;
import net.andrespr.casinorocket.network.s2c.sender.MachineBalanceSender;
import net.andrespr.casinorocket.screen.ModScreenHandlers;
import net.andrespr.casinorocket.screen.opening.CommonMachineOpenData;
import net.andrespr.casinorocket.screen.widget.WithdrawSlot;
import net.andrespr.casinorocket.util.IMachineBoundHandler;
import net.andrespr.casinorocket.util.MoneyCalculator;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class WithdrawScreenHandler
extends class_1703
implements IMachineBoundHandler {
    private final class_2338 pos;
    private final String machineKey;
    private final class_1277 inventory = new class_1277(27);

    public WithdrawScreenHandler(int syncId, class_1661 playerInventory, CommonMachineOpenData data) {
        this(syncId, playerInventory, data.pos(), data.machineKey());
    }

    public WithdrawScreenHandler(int syncId, class_1661 playerInventory, class_2338 pos, String machineKey) {
        super(ModScreenHandlers.WITHDRAW_SCREEN_HANDLER, syncId);
        this.machineKey = machineKey;
        this.pos = pos;
        this.inventory.method_5489(arg_0 -> ((WithdrawScreenHandler)this).method_7609(arg_0));
        this.addChestInventory((class_1263)this.inventory);
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        class_1657 player = playerInventory.field_7546;
        if (!player.method_37908().field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            long balance = this.resolveBalance(player);
            this.loadStacksIntoSlots(MoneyCalculator.calculateChipWithdraw(balance));
            this.inventory.method_5431();
            this.method_7623();
            MachineBalanceSender.send(serverPlayer, machineKey, balance);
        }
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    private void addChestInventory(class_1263 inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new WithdrawSlot(inventory, l + i * 9, 7 + l * 18, 19 + i * 18));
            }
        }
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + i * 9 + 9, 7 + l * 18, 85 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 7 + i * 18, 143));
        }
    }

    private long resolveBalance(class_1657 player) {
        if (player.method_5682() == null) {
            return 0L;
        }
        return switch (this.machineKey) {
            case "slots" -> PlayerSlotMachineData.get(player.method_5682()).getBalance(player.method_5667());
            case "blackjack" -> PlayerBlackjackData.get(player.method_5682()).getBalance(player.method_5667());
            default -> 0L;
        };
    }

    public void loadStacksIntoSlots(List<class_1799> stacks) {
        int i;
        for (i = 0; i < this.inventory.method_5439(); ++i) {
            this.inventory.method_5447(i, class_1799.field_8037);
        }
        i = 0;
        for (class_1799 stack : stacks) {
            if (i >= this.inventory.method_5439()) break;
            this.inventory.method_5447(i, stack.method_7972());
            ++i;
        }
        this.inventory.method_5431();
        this.method_7623();
    }

    public void clearWithdrawInventory() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            this.inventory.method_5447(i, class_1799.field_8037);
        }
        this.inventory.method_5431();
        this.method_7623();
    }

    @Override
    public class_2338 getMachinePos() {
        return this.pos;
    }

    @Override
    public String getMachineKey() {
        return this.machineKey;
    }
}

