/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.screen.custom.slot;

import com.mojang.blaze3d.systems.RenderSystem;
import net.andrespr.casinorocket.games.slot.SlotMachineConstants;
import net.andrespr.casinorocket.network.c2s.slots.ChangeBetBaseC2SPayload;
import net.andrespr.casinorocket.network.c2s.slots.ChangeLinesModeC2SPayload;
import net.andrespr.casinorocket.screen.ModGuiTextures;
import net.andrespr.casinorocket.screen.custom.CasinoMachineScreen;
import net.andrespr.casinorocket.screen.custom.slot.SlotMachineMenuScreenHandler;
import net.andrespr.casinorocket.screen.opening.MouseRestore;
import net.andrespr.casinorocket.screen.widget.ModButtons;
import net.andrespr.casinorocket.screen.widget.SlotButton;
import net.andrespr.casinorocket.util.TextUtils;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_757;
import net.minecraft.class_8710;

public class SlotMachineMenuScreen
extends CasinoMachineScreen<SlotMachineMenuScreenHandler> {
    private long balance = 0L;
    private int betBase = 10;
    private int linesMode = 1;
    private SlotButton plusButton;
    private SlotButton subtractButton;
    private SlotButton mode1Button;
    private SlotButton mode2Button;
    private SlotButton mode3Button;

    public SlotMachineMenuScreen(SlotMachineMenuScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_2792 = 200;
        this.field_2779 = 236;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int baseX = (this.field_22789 - this.field_2792) / 2;
        int baseY = (this.field_22790 - this.field_2779) / 2;
        this.plusButton = ModButtons.plus(baseX, baseY, 67, 36, b -> this.onPlusPressed());
        this.subtractButton = ModButtons.subtract(baseX, baseY, 6, 36, b -> this.onSubtractPressed());
        this.mode1Button = ModButtons.mode1(baseX, baseY, 6, 67, b -> this.onMode1Pressed());
        this.mode2Button = ModButtons.mode2(baseX, baseY, 6, 82, b -> this.onMode2Pressed());
        this.mode3Button = ModButtons.mode3(baseX, baseY, 6, 97, b -> this.onMode3Pressed());
        this.method_37063((class_364)this.plusButton);
        this.method_37063((class_364)this.subtractButton);
        this.method_37063((class_364)this.mode1Button);
        this.method_37063((class_364)this.mode2Button);
        this.method_37063((class_364)this.mode3Button);
        this.updateSettings(((SlotMachineMenuScreenHandler)this.field_2797).getInitialBalance(), ((SlotMachineMenuScreenHandler)this.field_2797).getInitialBetBase(), ((SlotMachineMenuScreenHandler)this.field_2797).getInitialLinesMode());
    }

    private void onPlusPressed() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new ChangeBetBaseC2SPayload(true));
        }
    }

    private void onSubtractPressed() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new ChangeBetBaseC2SPayload(false));
        }
    }

    private void onMode1Pressed() {
        this.sendMode(1);
    }

    private void onMode2Pressed() {
        this.sendMode(2);
    }

    private void onMode3Pressed() {
        this.sendMode(3);
    }

    private void sendMode(int mode) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new ChangeLinesModeC2SPayload(mode));
        }
    }

    protected void method_37432() {
        super.method_37432();
        MouseRestore.applyIfPending(this.field_22787);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ModGuiTextures.SLOT_MACHINE_MENU_GUI);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25302(ModGuiTextures.SLOT_MACHINE_MENU_GUI, x, y, 0, 0, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.casinorocket.slot_machine.settings_bet_amount"), 7, 25, 0xFFFFFF, true);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.casinorocket.slot_machine.settings_lines"), 7, 56, 0xFFFFFF, true);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.casinorocket.slot_machine.settings_one_line"), 23, 70, 0xFFFFFF, true);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.casinorocket.slot_machine.settings_three_lines"), 23, 85, 0xFFFFFF, true);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.casinorocket.slot_machine.settings_five_lines"), 23, 100, 0xFFFFFF, true);
        int mult = SlotMachineConstants.getBetMultiplierForMode(this.linesMode);
        int finalBet = this.betBase * mult;
        String formatted = TextUtils.formatCompact(finalBet);
        context.method_51433(this.field_22793, formatted, 23, 38, 43520, true);
        int srcY = (this.linesMode - 1) * 30;
        context.method_25290(ModGuiTextures.LINES_LAYOUT, 21, 112, 0.0f, (float)srcY, 43, 30, 43, 90);
    }

    public void updateSettings(long balance, int base, int lines) {
        this.balance = balance;
        this.betBase = base;
        this.linesMode = lines;
        this.updateButtonStates();
        this.updateModeButtons();
    }

    private void updateButtonStates() {
        int index = SlotMachineConstants.betValues().indexOf(this.betBase);
        this.subtractButton.field_22763 = index > 0;
        this.plusButton.field_22763 = index < SlotMachineConstants.betValues().size() - 1;
        this.subtractButton.setForcedPressed(index == 0);
        this.plusButton.setForcedPressed(index == SlotMachineConstants.betValues().size() - 1);
    }

    private void updateModeButtons() {
        this.mode1Button.setForcedPressed(this.linesMode == 1);
        this.mode2Button.setForcedPressed(this.linesMode == 2);
        this.mode3Button.setForcedPressed(this.linesMode == 3);
        this.mode1Button.field_22763 = this.linesMode != 1;
        this.mode2Button.field_22763 = this.linesMode != 2;
        this.mode3Button.field_22763 = this.linesMode != 3;
    }
}

