/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.screen.custom.slot;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.andrespr.casinorocket.games.slot.SlotLineResult;
import net.andrespr.casinorocket.games.slot.SlotMachineConstants;
import net.andrespr.casinorocket.games.slot.SlotReels;
import net.andrespr.casinorocket.games.slot.SlotSymbol;
import net.andrespr.casinorocket.network.c2s.slots.DoSpinC2SPayload;
import net.andrespr.casinorocket.screen.ModGuiTextures;
import net.andrespr.casinorocket.screen.custom.CasinoMachineScreen;
import net.andrespr.casinorocket.screen.custom.slot.SlotMachineScreenHandler;
import net.andrespr.casinorocket.screen.layout.DancingClefairy;
import net.andrespr.casinorocket.screen.layout.SlotLineSprite;
import net.andrespr.casinorocket.screen.opening.MouseRestore;
import net.andrespr.casinorocket.screen.widget.ModButtons;
import net.andrespr.casinorocket.screen.widget.SlotButton;
import net.andrespr.casinorocket.sound.ModSounds;
import net.andrespr.casinorocket.util.CasinoRocketLogger;
import net.andrespr.casinorocket.util.TextUtils;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_757;
import net.minecraft.class_8710;

public class SlotMachineScreen
extends CasinoMachineScreen<SlotMachineScreenHandler> {
    private long balance = 0L;
    private long pendingBalance = -1L;
    private int betAmount = 10;
    private List<SlotLineResult> lastWins = List.of();
    private int lastWinAmount = 0;
    private int pendingWinAmount = -1;
    private int linesMode = 1;
    private SlotButton spinButton;
    private SlotButton betButton;
    private SlotButton menuButton;
    private SlotButton withdrawButton;
    private SlotLineSprite lineOneSprite;
    private SlotLineSprite lineTwoSprite;
    private SlotLineSprite lineThreeTopSprite;
    private SlotLineSprite lineThreeBottomSprite;
    private final Set<WinLine> flashingLines = EnumSet.noneOf(WinLine.class);
    private final Set<WinLine> pendingFlashingLines = EnumSet.noneOf(WinLine.class);
    private int pendingFlashTicks = 0;
    private boolean flashVisible = true;
    private int flashTicksRemaining = 0;
    private int flashTickCounter = 0;
    private static final int SYMBOL_SIZE = 32;
    private static final int[] COLUMN_X = new int[]{55, 94, 133};
    private static final int ROW_Y = 53;
    private static final int VIRTUAL_ROWS = 5;
    private boolean isSpinning = false;
    private final int[] reelIndex = new int[3];
    private final int[] targetTopIndex = new int[3];
    private final float[] reelOffset = new float[3];
    private final int[] reelTimer = new int[3];
    private final boolean[] reelSpinning = new boolean[3];
    private static final float reelVelocity = 24.0f;
    private DancingClefairy clefairy;
    private boolean hasSpunOnce = false;

    public SlotMachineScreen(SlotMachineScreenHandler handler, class_1661 inv, class_2561 title) {
        super(handler, inv, title);
        this.field_2792 = 220;
        this.field_2779 = 205;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.initRandomReels();
        int baseX = (this.field_22789 - this.field_2792) / 2;
        int baseY = (this.field_22790 - this.field_2779) / 2;
        this.betButton = ModButtons.bet(baseX, baseY, 4, 4, b -> this.onBetPressed());
        this.menuButton = ModButtons.menu(baseX, baseY, 83, 4, b -> this.onMenuPressed());
        this.withdrawButton = ModButtons.withdraw(baseX, baseY, 144, 4, b -> this.onWithdrawPressed());
        this.spinButton = ModButtons.spin(baseX, baseY, 90, 161, b -> this.onSpinPressed());
        this.method_37063((class_364)this.betButton);
        this.method_37063((class_364)this.menuButton);
        this.method_37063((class_364)this.withdrawButton);
        this.method_37063((class_364)this.spinButton);
        this.lineOneSprite = new SlotLineSprite(ModGuiTextures.SLOT_LINE_ONE, 160, 14);
        this.lineTwoSprite = new SlotLineSprite(ModGuiTextures.SLOT_LINE_TWO, 160, 14);
        this.lineThreeTopSprite = new SlotLineSprite(ModGuiTextures.SLOT_LINE_THREE_TOP, 160, 112);
        this.lineThreeBottomSprite = new SlotLineSprite(ModGuiTextures.SLOT_LINE_THREE_BOTTOM, 160, 112);
        this.clefairy = new DancingClefairy(ModGuiTextures.DANCING_CLEFAIRY, 22, 23);
        this.updateDisplay(((SlotMachineScreenHandler)this.field_2797).getInitialBalance(), ((SlotMachineScreenHandler)this.field_2797).getInitialBetBase(), ((SlotMachineScreenHandler)this.field_2797).getInitialLinesMode());
    }

    private void initRandomReels() {
        for (int col = 0; col < 3; ++col) {
            int len = SlotReels.STRIPS[col].length;
            this.reelIndex[col] = ThreadLocalRandom.current().nextInt(len);
            this.reelOffset[col] = 0.0f;
            this.reelSpinning[col] = false;
            this.reelTimer[col] = 0;
            this.targetTopIndex[col] = this.reelIndex[col];
        }
    }

    private void onSpinPressed() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null && !this.isSpinning) {
            ClientPlayNetworking.send((class_8710)new DoSpinC2SPayload());
        }
    }

    public void onSpinResult(SlotSymbol[][] matrix, List<SlotLineResult> wins, int modeUsed, int totalWin, long newBalance) {
        this.lastWins = wins;
        this.linesMode = modeUsed;
        this.pendingWinAmount = totalWin;
        this.pendingBalance = newBalance;
        this.pendingFlashingLines.clear();
        this.pendingFlashTicks = 0;
        if (!wins.isEmpty()) {
            int maxFlash = 0;
            for (SlotLineResult win : wins) {
                WinLine lineId = this.mapWinToLine(win);
                this.pendingFlashingLines.add(lineId);
                int lineFlash = this.getFlashDurationForLine(win);
                if (lineFlash <= maxFlash) continue;
                maxFlash = lineFlash;
            }
            this.pendingFlashTicks = maxFlash;
        }
        for (int col = 0; col < 3; ++col) {
            SlotSymbol top = matrix[0][col];
            SlotSymbol middle = matrix[1][col];
            SlotSymbol bottom = matrix[2][col];
            SlotSymbol[] strip = SlotReels.STRIPS[col];
            int len = strip.length;
            int found = this.reelIndex[col];
            for (int i = 0; i < len; ++i) {
                SlotSymbol a = strip[(i + 1) % len];
                SlotSymbol b = strip[(i + 2) % len];
                SlotSymbol c = strip[(i + 3) % len];
                if (a != top || b != middle || c != bottom) continue;
                found = i;
                break;
            }
            this.targetTopIndex[col] = found;
        }
        this.startSpinAnimation();
    }

    private void startSpinAnimation() {
        this.isSpinning = true;
        this.hasSpunOnce = true;
        this.updateSpinButtonState();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_5783(ModSounds.REELS_SPINNING, 1.0f, 1.0f);
        }
        if (this.spinButton != null) {
            this.spinButton.field_22763 = false;
        }
        this.reelTimer[0] = 40;
        this.reelTimer[1] = 46;
        this.reelTimer[2] = 54;
        for (int col = 0; col < 3; ++col) {
            this.reelOffset[col] = 0.0f;
            this.reelSpinning[col] = true;
        }
    }

    private void finishSpin() {
        this.isSpinning = false;
        if (this.pendingBalance >= 0L) {
            this.balance = this.pendingBalance;
            this.pendingBalance = -1L;
        }
        if (this.pendingWinAmount >= 0) {
            this.lastWinAmount = this.pendingWinAmount;
            this.pendingWinAmount = -1;
        }
        if (this.spinButton != null) {
            this.spinButton.field_22763 = true;
        }
        this.flashingLines.clear();
        if (this.pendingFlashTicks > 0 && !this.pendingFlashingLines.isEmpty()) {
            this.flashingLines.addAll(this.pendingFlashingLines);
            this.flashTicksRemaining = this.pendingFlashTicks;
            this.flashVisible = true;
            this.flashTickCounter = 0;
            this.playWinSound(this.lastWins);
        }
        this.updateSpinButtonState();
    }

    public void method_37432() {
        super.method_37432();
        MouseRestore.applyIfPending(this.field_22787);
        if (this.isSpinning) {
            boolean anySpinning = false;
            for (int col = 0; col < 3; ++col) {
                if (!this.reelSpinning[col]) continue;
                anySpinning = true;
                int len = SlotReels.STRIPS[col].length;
                int n = col;
                this.reelOffset[n] = this.reelOffset[n] + 24.0f;
                if (this.reelOffset[col] >= 32.0f) {
                    int n2 = col;
                    this.reelOffset[n2] = this.reelOffset[n2] - 32.0f;
                    this.reelIndex[col] = (this.reelIndex[col] + 1) % len;
                }
                int n3 = col;
                this.reelTimer[n3] = this.reelTimer[n3] - 1;
                if (this.reelTimer[col] > 0) continue;
                this.reelIndex[col] = this.targetTopIndex[col];
                this.reelOffset[col] = 0.0f;
                this.reelSpinning[col] = false;
            }
            if (!anySpinning) {
                this.finishSpin();
            }
        } else if (this.flashTicksRemaining > 0 && !this.flashingLines.isEmpty()) {
            --this.flashTicksRemaining;
            ++this.flashTickCounter;
            if (this.flashTickCounter >= 2) {
                this.flashTickCounter = 0;
                boolean bl = this.flashVisible = !this.flashVisible;
            }
            if (this.flashTicksRemaining <= 0) {
                this.flashingLines.clear();
                this.flashVisible = true;
            }
        }
        this.updateSpinButtonState();
        this.updateUiLockState();
        if (this.clefairy != null) {
            this.clefairy.tick(this.getClefairyPhase());
        }
    }

    private void drawSymbols(class_332 ctx, int originX, int originY) {
        for (int col = 0; col < 3; ++col) {
            SlotSymbol[] strip = SlotReels.STRIPS[col];
            int len = strip.length;
            for (int row = 0; row < 5; ++row) {
                int stripIndex = (this.reelIndex[col] + row) % len;
                SlotSymbol symbol = strip[stripIndex];
                if (symbol == null) continue;
                class_2960 texture = ModGuiTextures.SlotTextures.SYMBOL_TEXTURES.get((Object)symbol);
                int drawX = originX + COLUMN_X[col];
                int drawY = originY + 53 + (row - 1) * 32 + (int)this.reelOffset[col];
                ctx.method_25290(texture, drawX, drawY, 0.0f, 0.0f, 32, 32, 32, 32);
            }
        }
    }

    private void drawLines(class_332 context, int originX, int originY) {
        if (this.lineOneSprite == null) {
            return;
        }
        int x = originX + 30;
        int yDiag = originY + 47;
        int yTop = originY + 70;
        int yMid = originY + 96;
        int yBottom = originY + 122;
        boolean centerOnByMode = this.linesMode >= 1;
        boolean horizontalsOnByMode = this.linesMode >= 2;
        boolean diagonalsOnByMode = this.linesMode >= 3;
        boolean centerWinning = this.flashingLines.contains((Object)WinLine.CENTER);
        boolean topWinning = this.flashingLines.contains((Object)WinLine.TOP);
        boolean bottomWinning = this.flashingLines.contains((Object)WinLine.BOTTOM);
        boolean diagTopWinning = this.flashingLines.contains((Object)WinLine.DIAG_TOP);
        boolean diagBottomWinning = this.flashingLines.contains((Object)WinLine.DIAG_BOTTOM);
        boolean centerEnabled = centerOnByMode && (!centerWinning || this.flashVisible);
        boolean topEnabled = horizontalsOnByMode && (!topWinning || this.flashVisible);
        boolean bottomEnabled = horizontalsOnByMode && (!bottomWinning || this.flashVisible);
        boolean diagTopEnabled = diagonalsOnByMode && (!diagTopWinning || this.flashVisible);
        boolean diagBottomEnabled = diagonalsOnByMode && (!diagBottomWinning || this.flashVisible);
        this.lineThreeTopSprite.render(context, x, yDiag, diagTopEnabled);
        this.lineTwoSprite.render(context, x, yTop, topEnabled);
        this.lineOneSprite.render(context, x, yMid, centerEnabled);
        this.lineTwoSprite.render(context, x, yBottom, bottomEnabled);
        this.lineThreeBottomSprite.render(context, x, yDiag, diagBottomEnabled);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ModGuiTextures.SLOT_MACHINE_GUI);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(ModGuiTextures.REELS, x + 50, y + 47, 0.0f, 0.0f, 120, 112, 120, 112);
        this.drawSymbols(context, x, y);
        context.method_25302(ModGuiTextures.SLOT_MACHINE_GUI, x, y, 0, 0, this.field_2792, this.field_2779);
        this.drawLines(context, x, y);
        if (this.clefairy != null) {
            this.clefairy.render(context, x + 7, y + 131);
            this.clefairy.render(context, x + 191, y + 131);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        this.drawBalanceAmount(context);
        this.drawBetAmount(context);
        this.drawWinAmount(context);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isBusy() && this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (keyCode == 256) {
                CasinoRocketLogger.toPlayerTranslated((class_1657)this.field_22787.field_1724, "gui.casinorocket.slot_machine.esc", true, new Object[0]);
                return true;
            }
            if (this.field_22787.field_1690 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25419() {
        if (this.isBusy()) {
            return;
        }
        super.method_25419();
    }

    @Override
    protected boolean returnToMachineOnEsc() {
        return false;
    }

    public void updateBalance(long amount) {
        this.balance = amount;
    }

    public void updateDisplay(long balance, int betBase, int linesMode) {
        this.balance = balance;
        this.linesMode = linesMode;
        int mult = SlotMachineConstants.getBetMultiplierForMode(linesMode);
        this.betAmount = betBase * mult;
    }

    private void updateSpinButtonState() {
        if (this.spinButton == null) {
            return;
        }
        boolean spinning = this.isSpinning;
        boolean flashing = this.flashTicksRemaining > 0;
        boolean busy = spinning || flashing;
        this.spinButton.field_22763 = !busy;
        this.spinButton.setForcedPressed(busy);
    }

    private WinLine mapWinToLine(SlotLineResult win) {
        int idx = win.lineIndex();
        if (this.linesMode == 1) {
            return WinLine.CENTER;
        }
        if (this.linesMode == 2) {
            return switch (idx) {
                case 0 -> WinLine.TOP;
                case 1 -> WinLine.CENTER;
                case 2 -> WinLine.BOTTOM;
                default -> WinLine.CENTER;
            };
        }
        return switch (idx) {
            case 0 -> WinLine.TOP;
            case 1 -> WinLine.CENTER;
            case 2 -> WinLine.BOTTOM;
            case 3 -> WinLine.DIAG_TOP;
            case 4 -> WinLine.DIAG_BOTTOM;
            default -> WinLine.CENTER;
        };
    }

    private int getFlashDurationForLine(SlotLineResult win) {
        int seconds;
        SlotSymbol symbol = win.symbol();
        if (symbol == null) {
            seconds = 2;
        } else {
            switch (symbol) {
                case PIKACHU: {
                    seconds = 3;
                    break;
                }
                case MEW: {
                    seconds = 4;
                    break;
                }
                case ROCKET: {
                    seconds = 6;
                    break;
                }
                case SEVEN: {
                    seconds = 8;
                    break;
                }
                default: {
                    seconds = 2;
                }
            }
        }
        return seconds * 20;
    }

    private void playWinSound(List<SlotLineResult> wins) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        if (wins.isEmpty()) {
            return;
        }
        Enum best = null;
        for (SlotLineResult win : wins) {
            SlotSymbol s = win.symbol();
            if (s == null || best != null && s.getTripleMultiplier() <= ((SlotSymbol)best).getTripleMultiplier()) continue;
            best = s;
        }
        if (best == null) {
            return;
        }
        switch (1.$SwitchMap$net$andrespr$casinorocket$games$slot$SlotSymbol[best.ordinal()]) {
            case 4: {
                this.field_22787.field_1724.method_5783(ModSounds.JACKPOT, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.field_22787.field_1724.method_5783(ModSounds.LEGENDARY_PRIZE, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.field_22787.field_1724.method_5783(ModSounds.ULTRARARE_PRIZE, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.field_22787.field_1724.method_5783(ModSounds.RARE_PRIZE, 1.0f, 1.0f);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.field_22787.field_1724.method_5783(ModSounds.COMMON_PRIZE, 1.0f, 1.0f);
                break;
            }
            case 8: {
                this.field_22787.field_1724.method_5783(ModSounds.BONUS_PRIZE, 1.0f, 1.0f);
                break;
            }
        }
    }

    private DancingClefairy.Phase getClefairyPhase() {
        if (this.isSpinning) {
            return DancingClefairy.Phase.NEUTRAL;
        }
        if (!this.hasSpunOnce) {
            return DancingClefairy.Phase.NEUTRAL;
        }
        if (this.lastWinAmount > 0) {
            return DancingClefairy.Phase.WIN;
        }
        return DancingClefairy.Phase.LOSS;
    }

    private boolean isBusy() {
        boolean flashing = this.flashTicksRemaining > 0 && !this.flashingLines.isEmpty();
        return this.isSpinning || flashing;
    }

    private void updateUiLockState() {
        boolean busy = this.isBusy();
        if (this.spinButton != null) {
            this.spinButton.field_22763 = !busy;
            this.spinButton.setForcedPressed(busy);
        }
        if (this.betButton != null) {
            boolean bl = this.betButton.field_22763 = !busy;
        }
        if (this.menuButton != null) {
            boolean bl = this.menuButton.field_22763 = !busy;
        }
        if (this.withdrawButton != null) {
            boolean bl = this.withdrawButton.field_22763 = !busy;
        }
        if (this.betButton != null) {
            this.betButton.setFakePressed(busy);
        }
        if (this.menuButton != null) {
            this.menuButton.setFakePressed(busy);
        }
        if (this.withdrawButton != null) {
            this.withdrawButton.setFakePressed(busy);
        }
    }

    private void drawBetAmount(class_332 context) {
        String formatted = TextUtils.formatCompact(this.betAmount);
        int width = this.field_22793.method_1727(formatted);
        int drawX = Math.max(146 - width, 120);
        context.method_51433(this.field_22793, formatted, drawX, 36, (long)this.betAmount > this.balance ? 0xFF5555 : 65280, true);
        context.method_51433(this.field_22793, "Bet Amount", 60, 36, 0xFFFFFF, true);
    }

    private void drawBalanceAmount(class_332 context) {
        String formatted = TextUtils.formatLarge(this.balance);
        int width = this.field_22793.method_1727(formatted);
        int drawX = Math.max(64 - width, 17);
        context.method_51433(this.field_22793, formatted, drawX, 186, 65280, true);
    }

    private void drawWinAmount(class_332 context) {
        String formatted = TextUtils.formatLarge(this.lastWinAmount);
        int width = this.field_22793.method_1727(formatted);
        int drawX = Math.max(188 - width, 141);
        context.method_51433(this.field_22793, formatted, drawX, 186, 65280, true);
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    private static enum WinLine {
        CENTER,
        TOP,
        BOTTOM,
        DIAG_TOP,
        DIAG_BOTTOM;

    }
}

