/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.util;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Set;
import net.andrespr.casinorocket.CasinoRocket;
import net.andrespr.casinorocket.util.CasinoRocketLogger;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CobblemonUtils {
    private static final Set<String> CHERISH_BALL_POKEMON = Set.of("roaringmoon", "ironvaliant", "articuno", "zapdos", "moltres", "raikou", "entei", "suicune", "regirock", "regice", "registeel", "regieleki", "regidrago", "regigigas", "heatran", "cresselia", "tapukoko", "tapulele", "tapubulu", "tapufini", "magikarp", "gholdengo", "netherite_gholdengo", "mew", "diancie");

    public static PokemonProperties safeParse(String input, class_3222 player, MinecraftServer server) {
        PokemonProperties properties = CobblemonUtils.tryParse(input);
        if (properties == null) {
            CasinoRocketLogger.toPlayerTranslated((class_1657)player, "message.casinorocket.species_not_found", false, input);
            String messageToOps = String.format("[Cobblemon] Player " + player.method_5477().getString() + " tried to claim " + player.method_5477().getString(), input + " but failed! (species not found)");
            CasinoRocketLogger.toOps(server, CasinoRocketLogger.LogLevel.ERROR, messageToOps);
            return null;
        }
        return properties;
    }

    @Nullable
    public static PokemonProperties tryParse(String input) {
        String propertiesString = CobblemonUtils.toPropertiesString(input);
        String expectedSpecies = CobblemonUtils.getRawId(input);
        PokemonProperties pokemon = PokemonProperties.Companion.parse(propertiesString);
        String species = pokemon.getSpecies();
        if (species == null || !CobblemonUtils.stripNamespace(species).equalsIgnoreCase(expectedSpecies)) {
            CasinoRocket.LOGGER.warn("[Cobblemon] Invalid Pok\u00e9mon string: {}", (Object)input);
            return null;
        }
        return pokemon;
    }

    public static IVs createFixedIVs(int fixedIVs) {
        IVs ivs = new IVs();
        ivs.set((Stat)Stats.HP, fixedIVs);
        ivs.set((Stat)Stats.ATTACK, fixedIVs);
        ivs.set((Stat)Stats.DEFENCE, fixedIVs);
        ivs.set((Stat)Stats.SPECIAL_ATTACK, fixedIVs);
        ivs.set((Stat)Stats.SPECIAL_DEFENCE, fixedIVs);
        ivs.set((Stat)Stats.SPEED, fixedIVs);
        return ivs;
    }

    public static void addPokemon(PokemonProperties properties, class_3222 player) {
        Pokemon pokemon = properties.create();
        String pokemonName = pokemon.getSpecies().getTranslatedName().getString();
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        boolean added = party.add(pokemon);
        if (added) {
            CasinoRocketLogger.toPlayerTranslated((class_1657)player, "message.casinorocket.pokemon_received_party", true, pokemonName);
        } else {
            CasinoRocketLogger.toPlayerTranslated((class_1657)player, "message.casinorocket.pokemon_box_full", true, pokemonName);
            CasinoRocket.LOGGER.warn("[Cobblemon] Player {} tried to claim Pok\u00e9mon ({}) but has no space in PC!", (Object)player.method_5477().getString(), (Object)pokemonName);
        }
    }

    public static String getRawId(String pokemonId) {
        String rawPokemonId = pokemonId.toLowerCase();
        if (rawPokemonId.startsWith("alolan_")) {
            return rawPokemonId.replace("alolan_", "");
        }
        if (rawPokemonId.startsWith("galarian_")) {
            return rawPokemonId.replace("galarian_", "");
        }
        if (rawPokemonId.startsWith("hisuian_")) {
            return rawPokemonId.replace("hisuian_", "");
        }
        if (rawPokemonId.startsWith("paldean_")) {
            return rawPokemonId.replace("paldean_", "");
        }
        if (rawPokemonId.startsWith("netherite_")) {
            return rawPokemonId.replace("netherite_", "");
        }
        if (rawPokemonId.endsWith("_m")) {
            return rawPokemonId.replace("_m", "");
        }
        if (rawPokemonId.endsWith("_f")) {
            return rawPokemonId.replace("_f", "");
        }
        return rawPokemonId;
    }

    public static String toPropertiesString(String configId) {
        String id = configId.toLowerCase();
        if (id.startsWith("alolan_")) {
            String species = id.substring("alolan_".length());
            return species + " alolan";
        }
        if (id.startsWith("galarian_")) {
            String species = id.substring("galarian_".length());
            return species + " galarian";
        }
        if (id.startsWith("hisuian_")) {
            String species = id.substring("hisuian_".length());
            return species + " hisuian";
        }
        if (id.startsWith("paldean_")) {
            String species = id.substring("paldean_".length());
            return species + " paldean";
        }
        if (id.startsWith("netherite_")) {
            String species = id.substring("netherite_".length());
            return species + " netherite_coating=full";
        }
        if (id.endsWith("_m")) {
            String species = id.replace("_m", "");
            return species + " gender=male";
        }
        if (id.endsWith("_f")) {
            String species = id.replace("_f", "");
            return species + " gender=female";
        }
        return id;
    }

    private static String stripNamespace(String id) {
        if (id.contains(":")) {
            return id.substring(id.indexOf(":") + 1);
        }
        return id;
    }

    public static boolean itWillBeShiny(class_5819 random, String shiny) {
        String key;
        return switch (key = shiny.toLowerCase()) {
            case "default" -> CobblemonUtils.defaultOdds(random);
            case "boosted" -> CobblemonUtils.boostedOdds(random);
            case "yes" -> true;
            default -> false;
        };
    }

    public static boolean defaultOdds(class_5819 random) {
        int roll = random.method_43048(2048);
        return roll == 1;
    }

    public static boolean boostedOdds(class_5819 random) {
        int roll = random.method_43048(512);
        return roll == 1;
    }

    public static String getCherishBallIfLegendary(String pokemonId) {
        if (pokemonId == null) {
            return null;
        }
        String id = pokemonId.toLowerCase().trim();
        if (CHERISH_BALL_POKEMON.contains(id = id.replaceFirst("^(alolan_|galarian_|hisuian_|paldean_)", ""))) {
            return "cherish_ball";
        }
        return "premier_ball";
    }

    public static String getPokemonName(PokemonProperties properties) {
        Pokemon pokemon = properties.create();
        return pokemon.getSpecies().getTranslatedName().getString();
    }
}

