/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.andrespr.casinorocket.item.ModItems;
import net.andrespr.casinorocket.item.custom.BillItem;
import net.andrespr.casinorocket.item.custom.ChipItem;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class MoneyCalculator {
    public static MoneyResult calculateDenomination(long value) {
        if (value <= 0L) {
            return new MoneyResult(ModItems.BILL_10, 1);
        }
        List<BillItem> bills = ModItems.ALL_BILL_ITEMS.stream().map(item -> (BillItem)((Object)item)).sorted(Comparator.comparingLong(BillItem::getValue).reversed()).toList();
        for (BillItem bill : bills) {
            long billValue = bill.getValue();
            if (billValue <= 0L || value % billValue != 0L) continue;
            long amount = value / billValue;
            if (amount > 64L) {
                amount = 64L;
            }
            return new MoneyResult(bill, (int)amount);
        }
        return new MoneyResult(ModItems.BILL_10, 1);
    }

    public static List<class_1799> calculateChipWithdraw(long amount) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        if (amount <= 0L) {
            return result;
        }
        List<ChipItem> chips = ModItems.ALL_CHIP_ITEMS.stream().map(item -> (ChipItem)((Object)item)).sorted(Comparator.comparingLong(ChipItem::getValue).reversed()).toList();
        long remaining = amount;
        for (ChipItem chip : chips) {
            long count;
            long value = chip.getValue();
            if (value <= 0L || (count = remaining / value) <= 0L) continue;
            while (count > 0L) {
                int stackSize = (int)Math.min(64L, count);
                result.add(new class_1799((class_1935)chip, stackSize));
                count -= (long)stackSize;
                remaining -= (long)stackSize * value;
            }
            if (remaining > 0L) continue;
            break;
        }
        return result;
    }

    public record MoneyResult(BillItem billType, int amount) {
    }
}

