/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.util;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_124;

public class TextUtils {
    public static String formatCompact(long number) {
        String suffix;
        double value;
        if (number >= 1000000000000000000L) {
            value = (double)number / 1.0E18;
            suffix = "Qi";
        } else if (number >= 1000000000000000L) {
            value = (double)number / 1.0E15;
            suffix = "Q";
        } else if (number >= 1000000000000L) {
            value = (double)number / 1.0E12;
            suffix = "T";
        } else if (number >= 1000000000L) {
            value = (double)number / 1.0E9;
            suffix = "B";
        } else if (number >= 1000000L) {
            value = (double)number / 1000000.0;
            suffix = "M";
        } else if (number >= 1000L) {
            value = (double)number / 1000.0;
            suffix = "K";
        } else {
            return String.valueOf(number);
        }
        value = Math.floor(value * 10.0) / 10.0;
        String formatted = String.format("%.1f%s", value, suffix);
        return formatted.replace(".0", "");
    }

    public static String formatLarge(long number) {
        if (number < 1000L) {
            return String.format("%,d", number);
        }
        if (number < 1000000L) {
            String promoted = TextUtils.tryPromote(number, 1000L, "K");
            if (promoted != null) {
                return promoted;
            }
            return String.format("%,d", number);
        }
        if (number < 1000000000L) {
            String promoted = TextUtils.tryPromote(number, 1000000L, "M");
            if (promoted != null) {
                return promoted;
            }
            long valueK = number / 1000L;
            return String.format("%,dK", valueK);
        }
        if (number < 1000000000000L) {
            String promoted = TextUtils.tryPromote(number, 1000000000L, "B");
            if (promoted != null) {
                return promoted;
            }
            long valueM = number / 1000000L;
            return String.format("%,dM", valueM);
        }
        if (number < 1000000000000000L) {
            String promoted = TextUtils.tryPromote(number, 1000000000000L, "T");
            if (promoted != null) {
                return promoted;
            }
            long valueB = number / 1000000000L;
            return String.format("%,dB", valueB);
        }
        long valueT = number / 1000000000000L;
        return String.format("%,dT", valueT);
    }

    private static String tryPromote(long number, long unit, String suffix) {
        if (number < unit) {
            return null;
        }
        if (number % unit == 0L) {
            double value = (double)number / (double)unit;
            return String.format(Locale.US, "%.1f%s", value, suffix);
        }
        long tenth = unit / 10L;
        if (number % tenth == 0L) {
            double value = (double)number / (double)unit;
            return String.format(Locale.US, "%.1f%s", value, suffix);
        }
        return null;
    }

    public static String formatCompactNoDecimal(long number) {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setGroupingUsed(true);
        nf.setMaximumFractionDigits(0);
        if (number >= 1000000000000000000L) {
            return nf.format(number / 1000000000000000L) + "Q";
        }
        if (number >= 1000000000000000L) {
            return nf.format(number / 1000000000000L) + "T";
        }
        if (number >= 1000000000000L) {
            return nf.format(number / 1000000000L) + "B";
        }
        if (number >= 1000000000L) {
            return nf.format(number / 1000000L) + "M";
        }
        if (number >= 1000000L) {
            return nf.format(number / 1000L) + "K";
        }
        return nf.format(number);
    }

    public static class_124 percentagesColor(double percentage) {
        if (percentage >= 5.01) {
            return class_124.field_1060;
        }
        if (percentage >= 1.01) {
            return class_124.field_1054;
        }
        if (percentage >= 0.1) {
            return class_124.field_1061;
        }
        return class_124.field_1079;
    }

    public static class_124 rarityColor(String rarity) {
        return switch (rarity.toLowerCase(Locale.ROOT)) {
            case "common", "bonus" -> class_124.field_1068;
            case "uncommon" -> class_124.field_1078;
            case "rare" -> class_124.field_1065;
            case "ultrarare" -> class_124.field_1076;
            case "legendary" -> class_124.field_1061;
            default -> class_124.field_1080;
        };
    }

    public static class_124 coinColor(String rarity) {
        return switch (rarity.toLowerCase(Locale.ROOT)) {
            case "copper" -> class_124.field_1061;
            case "iron" -> class_124.field_1068;
            case "gold" -> class_124.field_1065;
            case "diamond" -> class_124.field_1075;
            default -> class_124.field_1080;
        };
    }

    public static class_124 rankColors(int rank) {
        return switch (rank) {
            case 1 -> class_124.field_1065;
            case 2 -> class_124.field_1075;
            case 3 -> class_124.field_1060;
            default -> class_124.field_1068;
        };
    }

    public static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

