/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.villager;

import java.util.Map;
import java.util.TreeMap;
import net.andrespr.casinorocket.villager.shops.BankerShops;
import net.andrespr.casinorocket.villager.shops.BattleGearShops;
import net.andrespr.casinorocket.villager.shops.CashierShops;
import net.andrespr.casinorocket.villager.shops.ChipDealerShops;
import net.andrespr.casinorocket.villager.shops.GachaDealerShops;
import net.andrespr.casinorocket.villager.shops.IShop;
import net.andrespr.casinorocket.villager.shops.PrizeDealerShops;
import net.andrespr.casinorocket.villager.shops.SnackmasterShops;
import net.andrespr.casinorocket.villager.shops.TMInstructorShops;

public final class ShopsRegistry {
    private static final Map<String, IShop> SHOPS = new TreeMap<String, IShop>(String.CASE_INSENSITIVE_ORDER);

    private ShopsRegistry() {
    }

    public static void register(IShop shop) {
        SHOPS.put(shop.getName(), shop);
    }

    public static IShop get(String name) {
        return SHOPS.get(name);
    }

    public static Map<String, IShop> all() {
        return SHOPS;
    }

    public static void bootstrap() {
        ShopsRegistry.register(new ChipDealerShops());
        ShopsRegistry.register(new CashierShops());
        ShopsRegistry.register(new PrizeDealerShops());
        ShopsRegistry.register(new TMInstructorShops());
        ShopsRegistry.register(new BattleGearShops());
        ShopsRegistry.register(new SnackmasterShops());
        ShopsRegistry.register(new GachaDealerShops());
        ShopsRegistry.register(new BankerShops());
    }
}

