/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.villager;

import java.util.List;
import net.andrespr.casinorocket.CasinoRocket;
import net.andrespr.casinorocket.item.custom.BillItem;
import net.andrespr.casinorocket.item.custom.ChipItem;
import net.andrespr.casinorocket.util.MoneyCalculator;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7923;

public class VillagerTradeHelper {
    public static class_2487 makeShopCompound(String category, class_2499 offers) {
        class_2487 shop = new class_2487();
        shop.method_10582("Category", category);
        shop.method_10566("Offers", (class_2520)offers);
        return shop;
    }

    public static class_2487 makeOffer(String itemId, String price) {
        class_2487 offer = new class_2487();
        class_2487 item = new class_2487();
        item.method_10582("id", itemId);
        item.method_10567("Count", (byte)1);
        item.method_10569("count", 1);
        offer.method_10566("Item", (class_2520)item);
        offer.method_10582("Price", price);
        return offer;
    }

    public static class_2487 makeVanillaShopCompound(class_2499 trades) {
        class_2487 offers = new class_2487();
        offers.method_10566("Recipes", (class_2520)trades);
        return offers;
    }

    public static class_2487 makeVanillaOffer(String buyItem, int buyCount, String sellItem, int sellCount) {
        class_2487 trade = new class_2487();
        class_2487 buy = new class_2487();
        buy.method_10582("id", buyItem);
        buy.method_10567("Count", (byte)buyCount);
        buy.method_10569("count", buyCount);
        trade.method_10566("buy", (class_2520)buy);
        class_2487 sell = new class_2487();
        sell.method_10582("id", sellItem);
        sell.method_10567("Count", (byte)sellCount);
        sell.method_10569("count", sellCount);
        trade.method_10566("sell", (class_2520)sell);
        trade.method_10556("rewardExp", false);
        trade.method_10569("maxUses", 999999);
        trade.method_10569("uses", 0);
        trade.method_10548("priceMultiplier", 0.0f);
        trade.method_10569("demand", 0);
        trade.method_10569("specialPrice", 0);
        trade.method_10569("xp", 0);
        trade.method_10556("ignorePriceMultiplier", true);
        return trade;
    }

    public static void makeMoneyToChipOffer(class_2499 trades, ChipItem chip) {
        String chipId = class_7923.field_41178.method_10221((Object)chip).toString();
        String value = String.valueOf(chip.getValue());
        trades.add((Object)VillagerTradeHelper.makeOffer(chipId, value));
    }

    public static void makeChipToMoneyOffer(class_2499 trades, ChipItem chip) {
        String chipId = class_7923.field_41178.method_10221((Object)chip).toString();
        MoneyCalculator.MoneyResult result = MoneyCalculator.calculateDenomination(chip.getValue());
        String billId = class_7923.field_41178.method_10221((Object)result.billType()).toString();
        trades.add((Object)VillagerTradeHelper.makeVanillaOffer(chipId, 1, billId, result.amount()));
    }

    public static void makeInCashOffer(class_2499 trades, BillItem bill) {
        String billId = class_7923.field_41178.method_10221((Object)bill).toString();
        String value = String.valueOf(bill.getValue());
        trades.add((Object)VillagerTradeHelper.makeOffer(billId, value));
    }

    public static void makeListOffer(class_2499 trades, List<String> entries, String modID, String price) {
        for (String entry : entries) {
            trades.add((Object)VillagerTradeHelper.makeOffer(modID + ":" + entry, price));
        }
    }

    public static void makeCoinOffer(class_2499 trades, class_1792 coin) {
        String coinId = class_7923.field_41178.method_10221((Object)coin).toString();
        String coinPrice = CasinoRocket.CONFIG.gachaMachines.getCoinPrice(coinId);
        trades.add((Object)VillagerTradeHelper.makeOffer(coinId, coinPrice));
    }

    public static void makeGachaponOffer(class_2499 trades, class_1792 gachapon) {
        String gachaponId = class_7923.field_41178.method_10221((Object)gachapon).toString();
        boolean isGachaponEnable = CasinoRocket.CONFIG.gachaMachines.getGachaponEnable(gachaponId);
        if (isGachaponEnable) {
            String gachaponPrice = CasinoRocket.CONFIG.gachaMachines.getGachaponPrice(gachaponId);
            trades.add((Object)VillagerTradeHelper.makeOffer(gachaponId, gachaponPrice));
        }
    }

    public static class ShopData {
        public final class_2499 shops;
        public final String profession;
        public final int suitId;
        public class_2487 offersNbt;
        public final String jobBlockId;

        public ShopData(class_2499 shops, String profession, int suitId) {
            this(shops, profession, suitId, null);
        }

        public ShopData(class_2499 shops, String profession, int suitId, String jobBlockId) {
            this.shops = shops;
            this.profession = profession;
            this.suitId = suitId;
            this.jobBlockId = jobBlockId;
        }

        public ShopData withOffers(class_2487 offers) {
            this.offersNbt = offers;
            return this;
        }
    }
}

