/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.battle.effect;

import com.cobblemon.mod.common.battles.BattleSide;
import com.github.yajatkaul.mega_showdown.api.codec.BattleEffect;
import com.github.yajatkaul.mega_showdown.battle.effect.AbstractSideHandler;
import com.github.yajatkaul.mega_showdown.battle.effect.EffectWrapper;
import com.github.yajatkaul.mega_showdown.datapack.MegaShowdownDatapackRegister;
import java.lang.runtime.SwitchBootstraps;

public class HazardEffect
extends AbstractSideHandler {
    public static void handleHazard(BattleSide side, String hazardName, int ticks) {
        EffectWrapper effect = HazardEffect.getEffect(hazardName);
        if (effect == null || ticks % effect.tickInterval() != 0) {
            return;
        }
        side.getActivePokemon().forEach(pokemon -> {
            if (pokemon.getBattlePokemon() != null && pokemon.getBattlePokemon().getEntity() != null) {
                HazardEffect.sendEntityEffect(side.getBattle(), effect, pokemon.getBattlePokemon().getEntity(), "root");
            }
        });
    }

    private static EffectWrapper getEffect(String hazard) {
        for (BattleEffect battleEffect : MegaShowdownDatapackRegister.BATTLE_EFFECT_REGISTRY) {
            if (!battleEffect.type().equals((Object)BattleEffect.BattleEffectType.HAZARD) || !battleEffect.name().equals(hazard)) continue;
            return new EffectWrapper(battleEffect.tickInterval(), battleEffect.id());
        }
        String string = hazard;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"stealthrock", "stickyweb", "spikes", "toxicspikes"}, (Object)string, n)) {
            case 0 -> EffectWrapper.STEALTH_ROCKS;
            case 1 -> EffectWrapper.STICKY_WEB;
            case 2 -> EffectWrapper.SPIKES;
            case 3 -> EffectWrapper.TOXIC_SPIKES;
            default -> null;
        };
    }
}

