/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render;

import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.render.renderTypes.MSDRenderTypes;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4013;
import net.minecraft.class_5944;
import org.jetbrains.annotations.NotNull;

public class TeraMapLoader
implements class_4013 {
    public static final HashMap<String, String> REGISTRY = new HashMap();
    private static final String DIRECTORY = "mega_showdown/tera_map";

    public static void load() {
        class_3300 rm = class_310.method_1551().method_1478();
        REGISTRY.clear();
        Set resources = rm.method_14488(DIRECTORY, path -> path.method_12832().endsWith(".json")).keySet();
        for (class_2960 id : resources) {
            try {
                InputStream stream = ((class_3298)rm.method_14486(id).get()).method_14482();
                try {
                    TeraMap codec = (TeraMap)TeraMap.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(stream))).result().orElseThrow();
                    REGISTRY.putAll(codec.colorMap);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.error("Failed loading tera map JSON: {}", (Object)id, (Object)e);
            }
        }
        MegaShowdown.LOGGER.info("Loaded {} custom tera map", (Object)REGISTRY.size());
    }

    public static class_5944 getColorShaderMap(String color) {
        return switch (color) {
            case "red" -> MSDRenderTypes.teraFire;
            case "blue" -> MSDRenderTypes.teraWater;
            case "green" -> MSDRenderTypes.teraGrass;
            case "yellow" -> MSDRenderTypes.teraElectric;
            case "brown" -> MSDRenderTypes.teraGround;
            case "light_blue" -> MSDRenderTypes.teraFlying;
            case "purple" -> MSDRenderTypes.teraDragon;
            case "pink" -> MSDRenderTypes.teraFairy;
            case "black" -> MSDRenderTypes.teraDark;
            case "gray" -> MSDRenderTypes.teraSteel;
            case "light_grey" -> MSDRenderTypes.teraIce;
            case "orange" -> MSDRenderTypes.teraFighting;
            case "lime" -> MSDRenderTypes.teraBug;
            case "teal" -> MSDRenderTypes.teraPoison;
            case "indigo" -> MSDRenderTypes.teraGhost;
            case "magenta" -> MSDRenderTypes.teraPsychic;
            case "tan" -> MSDRenderTypes.teraRock;
            case "navy" -> MSDRenderTypes.teraNormal;
            case "white" -> MSDRenderTypes.teraStellar;
            default -> {
                MegaShowdown.LOGGER.error("Unknown tera shader color '{}'", (Object)color);
                yield MSDRenderTypes.teraStellar;
            }
        };
    }

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
        TeraMapLoader.load();
        return super.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
    }

    public void method_14491(class_3300 resourceManager) {
    }

    @NotNull
    public String method_22322() {
        return "mega_showdown";
    }

    public record TeraMap(Map<String, String> colorMap) {
        public static Codec<TeraMap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("aspectShaderMap").forGetter(TeraMap::colorMap)).apply((Applicative)instance, TeraMap::new));
    }
}

