/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import github.jorgaomc.LegendaryMonuments;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ShrineTracker {
    public static final int PROGRESS_MAX = 8;
    private static final Map<String, Map<UUID, Map<ShrineType, Integer>>> worldPlayerProgress = new ConcurrentHashMap<String, Map<UUID, Map<ShrineType, Integer>>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type PROGRESS_TYPE = new TypeToken<Map<String, Map<UUID, Map<ShrineType, Integer>>>>(){}.getType();
    private static File progressDataFile;

    private static String getWorldId(class_3218 world) {
        if (world == null) {
            LegendaryMonuments.LOGGER.error("World is null in getWorldId()");
            return "unknown";
        }
        try {
            MinecraftServer server = world.method_8503();
            String levelName = server.method_27728().method_150();
            if (levelName == null || levelName.isEmpty()) {
                LegendaryMonuments.LOGGER.error("Level name is null/empty, using fallback");
                return "unknown_world_" + System.currentTimeMillis();
            }
            long worldSeed = world.method_8412();
            int spawnX = world.method_43126().method_10263();
            int spawnZ = world.method_43126().method_10260();
            String worldSpecificData = worldSeed + "_" + spawnX + "_" + spawnZ;
            int worldDataHash = worldSpecificData.hashCode();
            String uniqueWorldId = String.format("%s_%d", levelName, Math.abs(worldDataHash));
            return uniqueWorldId;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Exception while generating world ID, using fallback", (Throwable)e);
            return "error_world_" + System.currentTimeMillis();
        }
    }

    private static File getServerDataDirectory(MinecraftServer server) {
        File serverDir = null;
        try {
            serverDir = server.method_3831().toFile();
            if (serverDir != null && serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to get server run directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("user.dir"));
            if (serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to use current working directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("user.home"), "minecraft-shrine-data");
            if (!serverDir.exists()) {
                serverDir.mkdirs();
            }
            if (serverDir.exists() && serverDir.canWrite()) {
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to use user home directory", (Throwable)e);
        }
        try {
            serverDir = new File(System.getProperty("java.io.tmpdir"), "minecraft-shrine-data");
            if (!serverDir.exists()) {
                serverDir.mkdirs();
            }
            if (serverDir.exists() && serverDir.canWrite()) {
                LegendaryMonuments.LOGGER.warn("Using temp directory for shrine data - data will be lost on reboot!");
                return serverDir;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to use temp directory", (Throwable)e);
        }
        LegendaryMonuments.LOGGER.error("CRITICAL: Could not find any writable directory for shrine data!");
        return null;
    }

    private static void ensureStorageInitialized(MinecraftServer server) {
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.warn("progressDataFile is null, attempting lazy initialization...");
            LegendaryMonuments.LOGGER.info("Server instance available: {}", (Object)(server != null ? 1 : 0));
            if (server != null) {
                ShrineTracker.initializeStorage(server);
            } else {
                LegendaryMonuments.LOGGER.error("Cannot initialize storage: server is null");
            }
        }
    }

    public static void initializeStorage(MinecraftServer server) {
        try {
            boolean created;
            LegendaryMonuments.LOGGER.info("=== STARTING SHRINE TRACKER INITIALIZATION ===");
            File serverDir = ShrineTracker.getServerDataDirectory(server);
            if (serverDir == null) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Could not find any writable directory for shrine tracking");
                return;
            }
            File dataDir = new File(serverDir, "legendary-monuments-data");
            if (!dataDir.exists() && !(created = dataDir.mkdirs())) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Failed to create data directory for shrine tracking");
                LegendaryMonuments.LOGGER.error("Data directory path: {}", (Object)dataDir.getAbsolutePath());
                if (dataDir.getParentFile() != null) {
                    LegendaryMonuments.LOGGER.error("Parent directory exists: {}", (Object)dataDir.getParentFile().exists());
                    LegendaryMonuments.LOGGER.error("Parent directory writable: {}", (Object)dataDir.getParentFile().canWrite());
                    LegendaryMonuments.LOGGER.error("Parent directory path: {}", (Object)dataDir.getParentFile().getAbsolutePath());
                }
                return;
            }
            if (!dataDir.canWrite()) {
                LegendaryMonuments.LOGGER.error("CRITICAL: Data directory exists but is not writable: {}", (Object)dataDir.getAbsolutePath());
                return;
            }
            progressDataFile = new File(dataDir, "shrine_progress.json");
            if (progressDataFile.exists()) {
                try (FileReader reader = new FileReader(progressDataFile);){
                    Map loadedData = (Map)GSON.fromJson((Reader)reader, PROGRESS_TYPE);
                    if (loadedData != null) {
                        worldPlayerProgress.clear();
                        for (Map.Entry worldEntry : loadedData.entrySet()) {
                            ConcurrentHashMap playerMap = new ConcurrentHashMap((Map)worldEntry.getValue());
                            worldPlayerProgress.put((String)worldEntry.getKey(), playerMap);
                        }
                        int totalPlayers = 0;
                        for (Map<UUID, Map<ShrineType, Integer>> worldMap : worldPlayerProgress.values()) {
                            if (worldMap == null) continue;
                            totalPlayers += worldMap.size();
                        }
                        LegendaryMonuments.LOGGER.info("Successfully loaded shrine progress data for {} worlds and {} total players", (Object)loadedData.size(), (Object)totalPlayers);
                    } else {
                        LegendaryMonuments.LOGGER.warn("Progress file exists but contains no data (null)");
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("IOException while loading shrine progress data", (Throwable)e);
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Exception processing progress data file, starting with empty data", (Throwable)e);
                    worldPlayerProgress.clear();
                }
            } else {
                LegendaryMonuments.LOGGER.info("No existing progress file found, creating new one...");
                try {
                    created = progressDataFile.createNewFile();
                    LegendaryMonuments.LOGGER.info("Created new shrine progress data file: {}", (Object)created);
                    if (!created) {
                        LegendaryMonuments.LOGGER.error("Failed to create new progress file!");
                        return;
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("IOException creating shrine progress data file", (Throwable)e);
                    return;
                }
            }
            if (progressDataFile != null && progressDataFile.exists() && progressDataFile.getParentFile().canWrite()) {
                LegendaryMonuments.LOGGER.info("=== SHRINE TRACKER INITIALIZATION SUCCESSFUL ===");
            } else {
                LegendaryMonuments.LOGGER.error("=== SHRINE TRACKER INITIALIZATION FAILED ===");
                LegendaryMonuments.LOGGER.error("progressDataFile is null: {}", (Object)(progressDataFile == null ? 1 : 0));
                if (progressDataFile != null) {
                    LegendaryMonuments.LOGGER.error("progressDataFile exists: {}", (Object)progressDataFile.exists());
                    LegendaryMonuments.LOGGER.error("progressDataFile parent writable: {}", (Object)(progressDataFile.getParentFile() != null && progressDataFile.getParentFile().canWrite() ? 1 : 0));
                }
                progressDataFile = null;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("=== CRITICAL ERROR DURING SHRINE TRACKER INITIALIZATION ===", (Throwable)e);
            progressDataFile = null;
        }
    }

    public static void loadPlayerProgress(class_3222 player) {
        try {
            if (player == null) {
                LegendaryMonuments.LOGGER.error("Cannot load player progress: player is null");
                return;
            }
            ShrineTracker.ensureStorageInitialized(player.method_5682());
            UUID playerUUID = player.method_5667();
            String worldId = ShrineTracker.getWorldId((class_3218)player.method_37908());
            worldPlayerProgress.computeIfAbsent(worldId, k -> new ConcurrentHashMap());
            Map<UUID, Map<ShrineType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            if (worldProgress.containsKey(playerUUID)) {
                return;
            }
            worldProgress.putIfAbsent(playerUUID, new ConcurrentHashMap());
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Unexpected error loading player progress", (Throwable)e);
        }
    }

    public static synchronized void saveAllPlayerData() {
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save player shrine data: progressDataFile is null");
            return;
        }
        try (FileWriter writer = new FileWriter(progressDataFile);){
            GSON.toJson(worldPlayerProgress, (Appendable)writer);
            ((Writer)writer).flush();
            int n = worldPlayerProgress.values().stream().mapToInt(Map::size).sum();
        }
        catch (IOException e) {
            LegendaryMonuments.LOGGER.error("Failed to save player shrine data", (Throwable)e);
        }
    }

    public static void savePlayerData(class_3222 player) {
        if (player == null) {
            LegendaryMonuments.LOGGER.warn("Cannot save player shrine data: player is null");
            return;
        }
        ShrineTracker.ensureStorageInitialized(player.method_5682());
        if (progressDataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save player shrine data: file not initialized (even after lazy init attempt)");
            return;
        }
        String worldId = ShrineTracker.getWorldId((class_3218)player.method_37908());
        UUID playerUUID = player.method_5667();
        Map<UUID, Map<ShrineType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
        if (worldProgress == null || !worldProgress.containsKey(playerUUID)) {
            LegendaryMonuments.LOGGER.info("No data to save for player {} in world {}", (Object)player.method_5477().getString(), (Object)worldId);
            return;
        }
        ShrineTracker.saveAllPlayerData();
        LegendaryMonuments.LOGGER.info("Saved shrine progress for player {} in world {}", (Object)player.method_5477().getString(), (Object)worldId);
    }

    public static Map<ShrineType, Integer> getPlayerProgress(UUID playerUUID, class_1937 world) {
        try {
            if (!(world instanceof class_3218)) {
                LegendaryMonuments.LOGGER.warn("getPlayerProgress called with non-ServerWorld: {}", (Object)world.getClass().getSimpleName());
                return new HashMap<ShrineType, Integer>();
            }
            String worldId = ShrineTracker.getWorldId((class_3218)world);
            worldPlayerProgress.computeIfAbsent(worldId, k -> new ConcurrentHashMap());
            Map<UUID, Map<ShrineType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            worldProgress.putIfAbsent(playerUUID, new ConcurrentHashMap());
            Map<ShrineType, Integer> playerData = worldProgress.get(playerUUID);
            return playerData;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error retrieving player progress", (Throwable)e);
            return new HashMap<ShrineType, Integer>();
        }
    }

    public static int recordStakeFound(class_1657 player, ShrineType type) {
        try {
            if (player == null) {
                LegendaryMonuments.LOGGER.error("Cannot record stake: player is null");
                return 0;
            }
            if (player.method_37908().field_9236) {
                LegendaryMonuments.LOGGER.info("Ignoring client-side stake recording attempt");
                return 0;
            }
            String worldId = ShrineTracker.getWorldId((class_3218)player.method_37908());
            UUID playerUUID = player.method_5667();
            LegendaryMonuments.LOGGER.info("Recording stake of type {} for player {}", (Object)type.getDisplayName(), (Object)player.method_5477().getString());
            worldPlayerProgress.computeIfAbsent(worldId, k -> new ConcurrentHashMap());
            Map<UUID, Map<ShrineType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
            worldProgress.putIfAbsent(playerUUID, new ConcurrentHashMap());
            Map<ShrineType, Integer> progress = worldProgress.get(playerUUID);
            int currentProgress = progress.getOrDefault((Object)type, 0);
            int newProgress = currentProgress + 1;
            progress.put(type, newProgress);
            if (player instanceof class_3222) {
                try {
                    ShrineTracker.savePlayerData((class_3222)player);
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Failed to save player data after stake update", (Throwable)e);
                }
            }
            return newProgress;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Unexpected error recording stake", (Throwable)e);
            return 0;
        }
    }

    public static int getProgress(class_1657 player, ShrineType type) {
        if (player == null) {
            return 0;
        }
        Map<ShrineType, Integer> progress = ShrineTracker.getPlayerProgress(player.method_5667(), player.method_37908());
        return progress.getOrDefault((Object)type, 0);
    }

    public static void setProgress(class_1657 player, ShrineType type, int value) {
        if (player == null || player.method_37908().field_9236) {
            return;
        }
        String worldId = ShrineTracker.getWorldId((class_3218)player.method_37908());
        UUID playerUUID = player.method_5667();
        worldPlayerProgress.computeIfAbsent(worldId, k -> new ConcurrentHashMap());
        Map<UUID, Map<ShrineType, Integer>> worldProgress = worldPlayerProgress.get(worldId);
        worldProgress.putIfAbsent(playerUUID, new ConcurrentHashMap());
        Map<ShrineType, Integer> progress = worldProgress.get(playerUUID);
        progress.put(type, value);
        if (player instanceof class_3222) {
            ShrineTracker.savePlayerData((class_3222)player);
        }
    }

    public static enum ShrineType {
        FIRESCOURGE("Firescourge"),
        GRASSWITHER("Grasswither"),
        ICEREND("Icerend"),
        GROUNDBLIGHT("Groundblight");

        private final String displayName;

        private ShrineType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

