/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.serialization.MapCodec;
import github.jorgaomc.blocks.entity.MeltanBoxBlockEntity;
import github.jorgaomc.util.LegendaryEffects;
import github.jorgaomc.util.PerfectIvHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class MeltanBoxBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final MapCodec<MeltanBoxBlock> CODEC = MapCodec.unit(() -> null);
    private static final class_265 SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)18.0, (double)6.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)18.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)3.0, (double)6.0, (double)10.0), class_2248.method_9541((double)1.0, (double)6.0, (double)6.0, (double)3.0, (double)18.0, (double)10.0), class_2248.method_9541((double)13.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), class_2248.method_9541((double)13.0, (double)6.0, (double)6.0, (double)15.0, (double)18.0, (double)10.0), class_2248.method_9541((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)18.0, (double)10.0)});

    public MapCodec<? extends class_2248> method_53969() {
        return MapCodec.unit((Object)((Object)this));
    }

    public MeltanBoxBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042());
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11034 -> this.rotateShape(class_2350.field_11043, class_2350.field_11034, SHAPE);
            case class_2350.field_11035 -> this.rotateShape(class_2350.field_11043, class_2350.field_11035, SHAPE);
            case class_2350.field_11039 -> this.rotateShape(class_2350.field_11043, class_2350.field_11039, SHAPE);
            default -> SHAPE;
        };
    }

    private class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        if (from == to) {
            return shape;
        }
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MeltanBoxBlockEntity(pos, state);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 handStack = player.method_5998(class_1268.field_5808);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof MeltanBoxBlockEntity) {
            MeltanBoxBlockEntity blockEntity = (MeltanBoxBlockEntity)class_25862;
            if (blockEntity.isReady()) {
                this.spawnMeltan((class_3218)world, pos, player);
                world.method_22352(pos, false);
                return class_1269.field_5812;
            }
            if (handStack.method_7960()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You need to fill the box with metals to summon Meltan!").method_27692(class_124.field_1080), true);
                return class_1269.field_5812;
            }
            int pointsToAdd = 0;
            if (handStack.method_31574(class_1802.field_27022)) {
                pointsToAdd = 1;
            } else if (handStack.method_31574(class_1802.field_8620)) {
                pointsToAdd = 2;
            } else if (handStack.method_31574(class_1802.field_8695)) {
                pointsToAdd = 3;
            } else if (handStack.method_31574(class_1802.field_22020)) {
                pointsToAdd = 50;
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"This box only accepts metal ingots").method_27692(class_124.field_1080), true);
                return class_1269.field_5812;
            }
            int pointsNeeded = 50 - blockEntity.getPointsCollected();
            int itemsToConsume = Math.min(handStack.method_7947(), (pointsNeeded + pointsToAdd - 1) / pointsToAdd);
            if (itemsToConsume <= 0) {
                return class_1269.field_5812;
            }
            ((class_3218)world).method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14833, class_3419.field_15245, 0.3f, 1.5f);
            handStack.method_7934(itemsToConsume);
            boolean ready = blockEntity.addPoints(pointsToAdd * itemsToConsume);
            if (!ready) {
                player.method_7353((class_2561)class_2561.method_43470((String)(blockEntity.getPointsCollected() + "/50 metal value stored")).method_27692(class_124.field_1080), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Meltan Box is ready to summon Meltan!").method_27692(class_124.field_1080), true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void spawnMeltan(class_3218 world, class_2338 pos, class_1657 player) {
        LegendaryEffects.spawnMeltanEffect(world, pos);
        boolean isShiny = world.method_8409().method_43057() < 0.02f;
        try {
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("meltan");
            properties.setLevel(Integer.valueOf(5));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((class_1937)world, pokemon, CobblemonEntities.POKEMON);
            PerfectIvHelper.enforceAtLeastThreePerfectIvs(entity);
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.2, (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            world.method_8649((class_1297)entity);
            class_5250 message = isShiny ? class_2561.method_43470((String)"A SHINY Meltan has appeared from the box!").method_27692(class_124.field_1065) : class_2561.method_43470((String)"A Meltan has appeared from the box!").method_27692(class_124.field_1080);
            player.method_7353((class_2561)message, false);
        }
        catch (Exception e) {
            System.err.println("Error spawning Meltan: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

