/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.ModItems;
import github.jorgaomc.screen.RegiStatueScreen;
import github.jorgaomc.util.PerfectIvHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;

public class RegiStatueBlock
extends class_2248 {
    public static final class_2754<RegiType> REGI_TYPE = class_2754.method_11850((String)"regi_type", RegiType.class);
    public static final class_2754<ActivationState> ACTIVATION = class_2754.method_11850((String)"activation", ActivationState.class);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    private static final class_265 STATUE_SHAPE;

    public RegiStatueBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(REGI_TYPE, (Comparable)((Object)RegiType.REGIROCK))).method_11657(ACTIVATION, (Comparable)((Object)ActivationState.INACTIVE))).method_11657(FACING, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{REGI_TYPE, ACTIVATION, FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return STATUE_SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return STATUE_SHAPE;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236 && player.method_7337() && state.method_11654(ACTIVATION) == ActivationState.INACTIVE) {
            this.openRegiStatueScreen(pos, state);
        }
        return class_1269.field_5812;
    }

    @Environment(value=EnvType.CLIENT)
    private void openRegiStatueScreen(class_2338 pos, class_2680 state) {
        class_310.method_1551().method_1507((class_437)new RegiStatueScreen(pos, (RegiType)((Object)state.method_11654(REGI_TYPE))));
    }

    public void activateStatue(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_11654(ACTIVATION) == ActivationState.INACTIVE) {
            world.method_8501(pos, (class_2680)state.method_11657(ACTIVATION, (Comparable)((Object)ActivationState.ACTIVATED)));
            world.method_39279(pos, (class_2248)this, 60);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(ACTIVATION) == ActivationState.ACTIVATED) {
            this.spawnRegiAndBreak(world, pos, (RegiType)((Object)state.method_11654(REGI_TYPE)));
        }
    }

    private void spawnRegiAndBreak(class_3218 world, class_2338 pos, RegiType regiType) {
        boolean isShiny = world.method_8409().method_43057() < 0.02f;
        String pokemonName = regiType.getPokemonName();
        try {
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies(pokemonName);
            properties.setLevel(Integer.valueOf(70));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((class_1937)world, pokemon, CobblemonEntities.POKEMON);
            PerfectIvHelper.enforceAtLeastThreePerfectIvs(entity);
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            world.method_8649((class_1297)entity);
            this.giveTabletToNearestPlayerOrDrop(world, pos, regiType);
            world.method_22352(pos, false);
            world.method_18456().forEach(player -> {
                if (player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) <= 100.0) {
                    class_5250 message = isShiny ? class_2561.method_43470((String)("A shiny " + regiType.getDisplayName() + " has awakened!")).method_27692(class_124.field_1065) : class_2561.method_43470((String)(regiType.getDisplayName() + " has awakened!")).method_27692(class_124.field_1076);
                    player.method_7353((class_2561)message, false);
                }
            });
        }
        catch (Exception e) {
            System.err.println("Error spawning " + pokemonName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void giveTabletToNearestPlayerOrDrop(class_3218 world, class_2338 pos, RegiType regiType) {
        class_1799 tablet = this.getTabletForRegi(regiType);
        if (tablet == null || tablet.method_7960()) {
            return;
        }
        class_1657 nearest = null;
        double nearestDistSq = Double.MAX_VALUE;
        double radiusSq = 256.0;
        for (class_1657 p : world.method_18456()) {
            double dSq = p.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            if (!(dSq <= radiusSq) || !(dSq < nearestDistSq)) continue;
            nearestDistSq = dSq;
            nearest = p;
        }
        if (nearest != null) {
            nearest.method_7270(tablet);
        } else {
            class_1542 drop = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, tablet);
            world.method_8649((class_1297)drop);
        }
    }

    private class_1799 getTabletForRegi(RegiType regiType) {
        switch (regiType.ordinal()) {
            case 1: {
                return new class_1799((class_1935)ModItems.REGISTEEL_TABLET);
            }
            case 0: {
                return new class_1799((class_1935)ModItems.REGIROCK_TABLET);
            }
            case 2: {
                return new class_1799((class_1935)ModItems.REGICE_TABLET);
            }
            case 3: {
                return new class_1799((class_1935)ModItems.REGIELEKI_TABLET);
            }
            case 4: {
                return new class_1799((class_1935)ModItems.REGIDRAGO_TABLET);
            }
        }
        return new class_1799((class_1935)ModItems.TITAN_CORE);
    }

    static {
        class_265 head = class_259.method_1081((double)-0.25, (double)0.625, (double)-0.25, (double)1.25, (double)2.0, (double)1.25);
        class_265 neck = class_259.method_1081((double)-0.1875, (double)0.375, (double)-0.1875, (double)1.1875, (double)0.625, (double)1.1875);
        class_265 body = class_259.method_1081((double)-0.25, (double)-1.0, (double)-0.25, (double)1.25, (double)0.375, (double)1.25);
        class_265 rightArmUpper = class_259.method_1081((double)-0.750625, (double)-0.188125, (double)-0.313125, (double)0.500625, (double)0.313125, (double)0.188125);
        class_265 rightArmLower = class_259.method_1081((double)-0.75, (double)-0.0625, (double)-0.3125, (double)-0.25, (double)1.0, (double)0.1875);
        class_265 leftArmUpper = class_259.method_1081((double)0.499375, (double)-0.188125, (double)-0.313125, (double)1.750625, (double)0.313125, (double)0.188125);
        class_265 leftArmLower = class_259.method_1081((double)1.25, (double)-0.0625, (double)-0.3125, (double)1.75, (double)1.0, (double)0.1875);
        STATUE_SHAPE = class_259.method_17786((class_265)head, (class_265[])new class_265[]{neck, body, rightArmUpper, rightArmLower, leftArmUpper, leftArmLower});
    }

    public static enum RegiType implements class_3542
    {
        REGIROCK("regirock", "Regirock", "regirock"),
        REGISTEEL("registeel", "Registeel", "registeel"),
        REGICE("regice", "Regice", "regice"),
        REGIELEKI("regieleki", "Regieleki", "regieleki"),
        REGIDRAGO("regidrago", "Regidrago", "regidrago"),
        REGIGIGAS("regigigas", "Regigigas", "regigigas");

        private final String name;
        private final String displayName;
        private final String pokemonName;

        private RegiType(String name, String displayName, String pokemonName) {
            this.name = name;
            this.displayName = displayName;
            this.pokemonName = pokemonName;
        }

        public String method_15434() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPokemonName() {
            return this.pokemonName;
        }
    }

    public static enum ActivationState implements class_3542
    {
        INACTIVE("inactive"),
        ACTIVATED("activated");

        private final String name;

        private ActivationState(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

