/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.blocks.entity.SanctuaryBlockEntity;
import github.jorgaomc.network.SanctuaryOpenScreenS2CPacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class SanctuaryBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    private static final int DEFAULT_RADIUS = 50;
    private static final class_265 SHAPE = class_259.method_1077();
    private static final Map<String, SanctuaryCache> DIMENSION_CACHES = new ConcurrentHashMap<String, SanctuaryCache>();
    public static final MapCodec<SanctuaryBlock> CODEC = SanctuaryBlock.method_54094(SanctuaryBlock::new);

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public SanctuaryBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HALF, FACING, ACTIVE});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(HALF) == class_2756.field_12607) {
            return new SanctuaryBlockEntity(pos, state);
        }
        return null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        if (blockPos.method_10264() < world.method_31600() - 1 && world.method_8320(blockPos.method_10084()).method_26166(ctx)) {
            return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2338 blockPos = pos.method_10084();
        world.method_8652(blockPos, (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
        if (!world.field_9236 && state.method_11654(HALF) == class_2756.field_12607) {
            String dimKey = SanctuaryBlock.getDimensionKey(world);
            SanctuaryCache cache = DIMENSION_CACHES.computeIfAbsent(dimKey, k -> new SanctuaryCache());
            SanctuaryData data = new SanctuaryData();
            data.dimensionKey = dimKey;
            cache.add(pos, data);
            class_2586 be = world.method_8321(pos);
            if (be instanceof SanctuaryBlockEntity) {
                SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
                sbe.fromData(data);
                sbe.method_5431();
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)class_2398.field_11207, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 50, (double)data.horizontalRadius / 2.0, 0.5, (double)data.horizontalRadius / 2.0, 0.02);
            }
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (state.method_11654(HALF) != class_2756.field_12607) {
            class_2680 blockState = world.method_8320(pos.method_10074());
            return blockState.method_27852((class_2248)this) && blockState.method_11654(HALF) == class_2756.field_12607;
        }
        return super.method_9558(state, world, pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (half == class_2756.field_12607) {
            return class_259.method_1084((class_265)SHAPE, (class_265)SHAPE.method_1096(0.0, 1.0, 0.0));
        }
        return class_259.method_1084((class_265)SHAPE, (class_265)SHAPE.method_1096(0.0, -1.0, 0.0));
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
        class_2338 otherHalfPos = doubleBlockHalf == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
        class_2680 otherHalfState = world.method_8320(otherHalfPos);
        if (otherHalfState.method_27852((class_2248)this) && otherHalfState.method_11654(HALF) != doubleBlockHalf) {
            world.method_8652(otherHalfPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, otherHalfPos, class_2248.method_9507((class_2680)otherHalfState));
        }
        if (!world.field_9236) {
            class_2338 lowerPos = doubleBlockHalf == class_2756.field_12607 ? pos : pos.method_10074();
            String dimKey = SanctuaryBlock.getDimensionKey(world);
            SanctuaryCache cache = DIMENSION_CACHES.get(dimKey);
            if (cache != null) {
                cache.remove(lowerPos);
            }
        }
        super.method_9576(world, pos, state, player);
        return otherHalfState;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2338 lowerPos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
        class_2680 lowerState = world.method_8320(lowerPos);
        class_2338 upperPos = lowerPos.method_10084();
        if (player.method_7337()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SanctuaryOpenScreenS2CPacket.send(serverPlayer, lowerPos);
            }
        } else {
            boolean newActive;
            String dimKey = SanctuaryBlock.getDimensionKey(world);
            SanctuaryCache cache = DIMENSION_CACHES.computeIfAbsent(dimKey, k -> new SanctuaryCache());
            SanctuaryData data = cache.get(lowerPos);
            if (data == null) {
                data = new SanctuaryData();
                data.dimensionKey = dimKey;
                cache.add(lowerPos, data);
            }
            data.active = newActive = !data.active;
            class_2586 be = world.method_8321(lowerPos);
            if (be instanceof SanctuaryBlockEntity) {
                SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
                sbe.fromData(data);
                sbe.method_5431();
            }
            world.method_8652(lowerPos, (class_2680)lowerState.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(newActive)), 3);
            world.method_8652(upperPos, (class_2680)world.method_8320(upperPos).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(newActive)), 3);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                if (newActive) {
                    serverWorld.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14703, class_3419.field_15245, 1.0f, 1.0f);
                    serverWorld.method_14199((class_2394)class_2398.field_11207, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 50, (double)data.horizontalRadius / 2.0, 1.0, (double)data.horizontalRadius / 2.0, 0.02);
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Sanctuary has been activated. Area is now protected.").method_27692(class_124.field_1060), true);
                } else {
                    serverWorld.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_19344, class_3419.field_15245, 1.0f, 1.0f);
                    serverWorld.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 25, (double)data.horizontalRadius / 4.0, 0.5, (double)data.horizontalRadius / 4.0, 0.05);
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Sanctuary has been deactivated. Area protection removed.").method_27692(class_124.field_1054), true);
                }
            }
        }
        return class_1269.field_5812;
    }

    public static SanctuaryData getSanctuaryData(class_2338 pos, String dimensionKey) {
        SanctuaryCache cache = DIMENSION_CACHES.get(dimensionKey);
        if (cache == null) {
            return null;
        }
        return cache.get(pos);
    }

    public static void updateSanctuaryDataWithWorld(class_1937 world, class_2338 pos, boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) {
        String dimKey = SanctuaryBlock.getDimensionKey(world);
        SanctuaryCache cache = DIMENSION_CACHES.computeIfAbsent(dimKey, k -> new SanctuaryCache());
        SanctuaryData data = cache.get(pos);
        if (data == null) {
            data = new SanctuaryData();
            cache.add(pos, data);
        }
        data.active = active;
        data.explosionProtection = explosionProtection;
        data.blockPlacement = blockPlacement;
        data.blockBreaking = blockBreaking;
        data.mobSpawning = mobSpawning;
        data.horizontalRadius = Math.max(1, Math.min(100, horizontalRadius));
        data.verticalRadius = Math.max(1, Math.min(100, verticalRadius));
        data.dimensionKey = dimKey;
        class_2586 be = world.method_8321(pos);
        if (be instanceof SanctuaryBlockEntity) {
            SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
            sbe.fromData(data);
            sbe.method_5431();
        }
        if (!world.field_9236) {
            class_2680 lowerState = world.method_8320(pos);
            class_2680 upperState = world.method_8320(pos.method_10084());
            if (lowerState.method_26204() instanceof SanctuaryBlock && lowerState.method_11654(HALF) == class_2756.field_12607) {
                world.method_8652(pos, (class_2680)lowerState.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            }
            if (upperState.method_26204() instanceof SanctuaryBlock && upperState.method_11654(HALF) == class_2756.field_12609) {
                world.method_8652(pos.method_10084(), (class_2680)upperState.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            }
        }
    }

    public static void registerSanctuaryFromEntity(class_1937 world, class_2338 pos, SanctuaryData data) {
        String dimKey;
        if (world.field_9236) {
            return;
        }
        data.dimensionKey = dimKey = SanctuaryBlock.getDimensionKey(world);
        SanctuaryCache cache = DIMENSION_CACHES.computeIfAbsent(dimKey, k -> new SanctuaryCache());
        cache.add(pos, data);
    }

    public static boolean isExplosionBlocked(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return false;
        }
        String dimKey = SanctuaryBlock.getDimensionKey(world);
        SanctuaryCache cache = DIMENSION_CACHES.get(dimKey);
        return cache != null && cache.isProtected(world, pos, ProtectionType.EXPLOSION);
    }

    public static boolean isBlockPlacementBlocked(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return false;
        }
        String dimKey = SanctuaryBlock.getDimensionKey(world);
        SanctuaryCache cache = DIMENSION_CACHES.get(dimKey);
        return cache != null && cache.isProtected(world, pos, ProtectionType.BLOCK_PLACE);
    }

    public static boolean isBlockBreakingBlocked(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return false;
        }
        String dimKey = SanctuaryBlock.getDimensionKey(world);
        SanctuaryCache cache = DIMENSION_CACHES.get(dimKey);
        return cache != null && cache.isProtected(world, pos, ProtectionType.BLOCK_BREAK);
    }

    public static boolean isMobSpawningBlocked(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return false;
        }
        String dimKey = SanctuaryBlock.getDimensionKey(world);
        SanctuaryCache cache = DIMENSION_CACHES.get(dimKey);
        return cache != null && cache.isProtected(world, pos, ProtectionType.MOB_SPAWN);
    }

    private static String getDimensionKey(class_1937 world) {
        try {
            return world.method_27983().method_29177().toString();
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    private static boolean isWithinRadius(class_2338 pos, class_2338 sanctuaryPos, int horizontalRadius, int verticalRadius) {
        int dx = pos.method_10263() - sanctuaryPos.method_10263();
        int dy = pos.method_10264() - sanctuaryPos.method_10264();
        int dz = pos.method_10260() - sanctuaryPos.method_10260();
        int horizontalDistanceSquared = dx * dx + dz * dz;
        int verticalDistance = Math.abs(dy);
        return horizontalDistanceSquared <= horizontalRadius * horizontalRadius && verticalDistance <= verticalRadius;
    }

    private static class SanctuaryCache {
        private final Map<class_2338, SanctuaryData> sanctuaries = new ConcurrentHashMap<class_2338, SanctuaryData>();
        private volatile long lastCleanup = System.currentTimeMillis();
        private static final long CLEANUP_INTERVAL = 60000L;

        private SanctuaryCache() {
        }

        public void add(class_2338 pos, SanctuaryData data) {
            this.sanctuaries.put(pos, data);
        }

        public void remove(class_2338 pos) {
            this.sanctuaries.remove(pos);
        }

        public SanctuaryData get(class_2338 pos) {
            return this.sanctuaries.get(pos);
        }

        public boolean isProtected(class_1937 world, class_2338 pos, ProtectionType type) {
            long now = System.currentTimeMillis();
            if (now - this.lastCleanup > 60000L) {
                this.cleanup(world);
                this.lastCleanup = now;
            }
            for (Map.Entry<class_2338, SanctuaryData> entry : this.sanctuaries.entrySet()) {
                SanctuaryData data = entry.getValue();
                if (!data.active) continue;
                class_2338 sanctuaryPos = entry.getKey();
                int maxRadius = Math.max(data.horizontalRadius, data.verticalRadius);
                if (Math.abs(pos.method_10263() - sanctuaryPos.method_10263()) > maxRadius || Math.abs(pos.method_10260() - sanctuaryPos.method_10260()) > maxRadius || Math.abs(pos.method_10264() - sanctuaryPos.method_10264()) > maxRadius || !this.isProtectionEnabled(data, type) || !SanctuaryBlock.isWithinRadius(pos, sanctuaryPos, data.horizontalRadius, data.verticalRadius)) continue;
                return true;
            }
            return false;
        }

        private boolean isProtectionEnabled(SanctuaryData data, ProtectionType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> data.explosionProtection;
                case 1 -> data.blockPlacement;
                case 2 -> data.blockBreaking;
                case 3 -> data.mobSpawning;
            };
        }

        private void cleanup(class_1937 world) {
            this.sanctuaries.entrySet().removeIf(entry -> {
                class_2338 pos = (class_2338)entry.getKey();
                if (!world.method_22340(pos)) {
                    return false;
                }
                class_2680 state = world.method_8320(pos);
                if (!(state.method_26204() instanceof SanctuaryBlock)) {
                    return true;
                }
                if (!state.method_28498(HALF)) {
                    return true;
                }
                return state.method_11654(HALF) != class_2756.field_12607;
            });
        }
    }

    public static class SanctuaryData {
        public volatile boolean active;
        public volatile boolean explosionProtection;
        public volatile boolean blockPlacement;
        public volatile boolean blockBreaking;
        public volatile boolean mobSpawning;
        public volatile int horizontalRadius;
        public volatile int verticalRadius;
        public String dimensionKey;

        public SanctuaryData() {
            this.active = true;
            this.explosionProtection = true;
            this.blockPlacement = true;
            this.blockBreaking = true;
            this.mobSpawning = true;
            this.horizontalRadius = 50;
            this.verticalRadius = 50;
        }

        public SanctuaryData(boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) {
            this.active = active;
            this.explosionProtection = explosionProtection;
            this.blockPlacement = blockPlacement;
            this.blockBreaking = blockBreaking;
            this.mobSpawning = mobSpawning;
            this.horizontalRadius = horizontalRadius;
            this.verticalRadius = verticalRadius;
        }
    }

    public static enum ProtectionType {
        EXPLOSION,
        BLOCK_PLACE,
        BLOCK_BREAK,
        MOB_SPAWN;

    }
}

