/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks;

import github.jorgaomc.blocks.MultiBlockBase;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_6880;

public abstract class ShrineBlock
extends MultiBlockBase {
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 SHAPE = class_259.method_1077();
    private final ShrineType shrineType;

    public ShrineBlock(class_4970.class_2251 settings, ShrineType shrineType) {
        super(settings.method_22488());
        this.shrineType = shrineType;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)MAIN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public ShrineType getShrineType() {
        return this.shrineType;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 playerFacing = ctx.method_8042();
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)MAIN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FACING, (Comparable)playerFacing.method_10153());
    }

    @Override
    public class_2338[] getOccupiedPositions(class_2338 mainPos) {
        return this.getOccupiedPositionsWithState(null, mainPos, this.method_9564());
    }

    public class_2338[] getOccupiedPositionsWithState(class_4538 world, class_2338 mainPos, class_2680 state) {
        class_1937 worldInstance;
        class_2680 worldState;
        class_2338[] positions = new class_2338[9];
        class_2350 facing = class_2350.field_11043;
        if (state != null && state.method_28498((class_2769)FACING)) {
            facing = (class_2350)state.method_11654((class_2769)FACING);
        } else if (world != null && world instanceof class_1937 && (worldState = (worldInstance = (class_1937)world).method_8320(mainPos)).method_28498((class_2769)FACING)) {
            facing = (class_2350)worldState.method_11654((class_2769)FACING);
        }
        class_2350 upDown = class_2350.field_11036;
        class_2350 leftRight = facing == class_2350.field_11043 || facing == class_2350.field_11035 ? class_2350.field_11034 : class_2350.field_11043;
        positions[0] = mainPos;
        if (facing == class_2350.field_11043) {
            positions[1] = mainPos.method_10067();
            positions[2] = mainPos.method_10078();
        } else if (facing == class_2350.field_11035) {
            positions[1] = mainPos.method_10078();
            positions[2] = mainPos.method_10067();
        } else if (facing == class_2350.field_11034) {
            positions[1] = mainPos.method_10095();
            positions[2] = mainPos.method_10072();
        } else {
            positions[1] = mainPos.method_10072();
            positions[2] = mainPos.method_10095();
        }
        positions[3] = mainPos.method_10084();
        positions[4] = positions[1].method_10084();
        positions[5] = positions[2].method_10084();
        positions[6] = mainPos.method_10074();
        positions[7] = positions[1].method_10074();
        positions[8] = positions[2].method_10074();
        return positions;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)MAIN) == false;
    }

    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 direction) {
        if (!((Boolean)state.method_11654((class_2769)MAIN)).booleanValue()) {
            return true;
        }
        if (adjacentBlockState.method_27852((class_2248)this)) {
            return true;
        }
        return super.method_9522(state, adjacentBlockState, direction);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2338 mainPos;
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (((Boolean)state.method_11654((class_2769)MAIN)).booleanValue()) {
            mainPos = pos;
        } else {
            Optional<class_2338> optMainPos = this.findMainBlock(world, pos, state);
            if (optMainPos.isEmpty()) {
                return class_1269.field_5814;
            }
            mainPos = optMainPos.get();
        }
        int progress = this.getPlayerProgress(player);
        if (progress >= 8) {
            this.spawnPokemon((class_3218)world, mainPos, player);
            this.setPlayerProgress(player, progress - 8);
            class_3218 serverWorld = (class_3218)world;
            this.createParticleExplosion(serverWorld, mainPos);
            this.destroyNearbyShrines((class_3218)world, mainPos, 10);
            this.destroyNearbyBedrock((class_3218)world, mainPos, 10);
            return class_1269.field_5812;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("You need to collect more power from " + this.getShrineTypeName() + " stakes. Current progress: " + progress + "/8")).method_27692(class_124.field_1065), true);
        return class_1269.field_5812;
    }

    protected abstract int getPlayerProgress(class_1657 var1);

    protected abstract void setPlayerProgress(class_1657 var1, int var2);

    protected abstract String getShrineTypeName();

    protected abstract void spawnPokemon(class_3218 var1, class_2338 var2, class_1657 var3);

    protected void destroyNearbyBedrock(class_3218 world, class_2338 center, int radius) {
        int bottomY = world.method_31607();
        int topY = world.method_31600();
        int minX = center.method_10263() - radius;
        int maxX = center.method_10263() + radius;
        int minY = Math.max(bottomY, center.method_10264() - radius);
        int maxY = Math.min(topY - 1, center.method_10264() + radius);
        int minZ = center.method_10260() - radius;
        int maxZ = center.method_10260() + radius;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 bp = new class_2338(x, y, z);
                    if (!world.method_8320(bp).method_27852(class_2246.field_9987)) continue;
                    world.method_8652(bp, class_2246.field_10124.method_9564(), 3);
                }
            }
        }
    }

    protected void destroyNearbyShrines(class_3218 world, class_2338 center, int radius) {
        int bottomY = world.method_31607();
        int topY = world.method_31600();
        int minX = center.method_10263() - radius;
        int maxX = center.method_10263() + radius;
        int minY = Math.max(bottomY, center.method_10264() - radius);
        int maxY = Math.min(topY - 1, center.method_10264() + radius);
        int minZ = center.method_10260() - radius;
        int maxZ = center.method_10260() + radius;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 bp = new class_2338(x, y, z);
                    class_2248 block = world.method_8320(bp).method_26204();
                    if (!(block instanceof ShrineBlock)) continue;
                    world.method_8650(bp, false);
                }
            }
        }
    }

    protected void createParticleExplosion(class_3218 world, class_2338 centerPos) {
        world.method_60511(null, (double)centerPos.method_10263() + 0.5, (double)centerPos.method_10264() + 1.5, (double)centerPos.method_10260() + 0.5, (class_6880)class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8503().method_3734().method_44252(world.method_8503().method_3739().method_9227(world).method_9208(new class_243((double)centerPos.method_10263() + 0.5, (double)centerPos.method_10264() + 1.5, (double)centerPos.method_10260() + 0.5)).method_9217(), "particle minecraft:explosion ~ ~ ~ 2 2 2 0.1 10 force");
        for (int i = 0; i < 50; ++i) {
            double offsetX = world.field_9229.method_43058() * 4.0 - 2.0;
            double offsetY = world.field_9229.method_43058() * 4.0;
            double offsetZ = world.field_9229.method_43058() * 4.0 - 2.0;
            world.method_8406((class_2394)class_2398.field_11237, (double)centerPos.method_10263() + 0.5 + offsetX, (double)centerPos.method_10264() + 1.0 + offsetY, (double)centerPos.method_10260() + 0.5 + offsetZ, offsetX * 0.1, offsetY * 0.15, offsetZ * 0.1);
        }
    }

    public static enum ShrineType {
        FIRESCOURGE,
        GRASSWITHER,
        ICEREND,
        GROUNDBLIGHT;

    }
}

