/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.blocks.PokemonTrialSpawnerBlock;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8967;

public class PokemonTrialSpawnerBlockEntity
extends class_2586 {
    private static final int ACTIVATION_RADIUS = 5;
    private static final int LEASH_RADIUS = 30;
    private static final int SPAWN_RANGE = 4;
    private static final int MAX_POKEMON_PER_WAVE = 3;
    private static final int COOLDOWN_TICKS = 36000;
    private final Random random = new Random();
    private final Set<UUID> participatingPlayers = new HashSet<UUID>();
    private final List<UUID> spawnedPokemonUUIDs = new ArrayList<UUID>();
    private int currentWave = 0;
    private int maxWaves = 3;
    private int ticksSinceLastSpawn = 0;
    private boolean isActive = false;
    private int cooldownTicks = 0;
    private long nextResetGameTime = 0L;
    private int ambientTick = 0;
    private long lastPlayerScanTick = -100L;
    private List<class_3222> cachedNearbySurvivalPlayers = Collections.emptyList();
    private final List<Wave> waves = new ArrayList<Wave>();
    private final List<RewardEntry> rewards = new ArrayList<RewardEntry>();
    private static final String[] NORMAL_POKEMON = new String[]{"gengar", "malamar", "raichu", "altaria", "snorlax"};
    private static final String[] OMINOUS_POKEMON = new String[]{"garchomp", "gardevoir", "charizard", "venusaur", "blastoise"};

    public PokemonTrialSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.POKEMON_TRIAL_SPAWNER_BE, pos, state);
        if (!state.method_28498(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE) && state.method_26204() instanceof PokemonTrialSpawnerBlock) {
            this.method_31664(state.method_26204().method_9564());
        }
        this.initDefaultConfigIfEmpty();
    }

    public void serverTick(class_3218 world, class_2338 pos, class_2680 state) {
        if (!(state.method_26204() instanceof PokemonTrialSpawnerBlock) || !state.method_28498(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE)) {
            if (world.method_8320(pos).method_26204() instanceof PokemonTrialSpawnerBlock) {
                class_2680 newState = (class_2680)((class_2680)world.method_8320(pos).method_26204().method_9564().method_11657((class_2769)PokemonTrialSpawnerBlock.OMINOUS, (Comparable)Boolean.valueOf(false))).method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47383);
                world.method_8501(pos, newState);
            }
            return;
        }
        class_8967 currentState = (class_8967)state.method_11654(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE);
        switch (currentState) {
            case field_47383: {
                if (this.getNearbySurvivalPlayersCached(world, 5).isEmpty()) break;
                world.method_8501(pos, (class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47384));
                break;
            }
            case field_47384: {
                this.handleWaitingForPlayers(world, pos, state);
                break;
            }
            case field_47385: {
                this.handleActiveTrial(world, pos, state);
                break;
            }
            case field_47386: {
                this.handleWaitingForReward(world, pos, state);
                break;
            }
            case field_47387: {
                this.handleEjectingReward(world, pos, state);
                break;
            }
            case field_47388: {
                this.handleCooldown(world, pos, state);
            }
        }
    }

    public void startTrial(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.participatingPlayers.clear();
            this.participatingPlayers.add(player.method_5667());
            this.currentWave = 0;
            this.spawnedPokemonUUIDs.clear();
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47384));
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_47206, class_3419.field_15245, 1.0f, 1.0f);
            player.method_7353((class_2561)class_2561.method_43470((String)"Trial Started! Defeat the Pokemon!").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), true);
        }
    }

    private void handleWaitingForPlayers(class_3218 world, class_2338 pos, class_2680 state) {
        List<class_3222> nearbyPlayers = this.getNearbySurvivalPlayersCached(world, 5);
        if (!nearbyPlayers.isEmpty()) {
            for (class_3222 player : nearbyPlayers) {
                this.participatingPlayers.add(player.method_5667());
            }
            world.method_8501(pos, (class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47385));
            this.isActive = true;
            this.spawnNextWave(world);
        }
    }

    private void handleActiveTrial(class_3218 world, class_2338 pos, class_2680 state) {
        this.spawnedPokemonUUIDs.removeIf(uuid -> {
            class_1297 entity = world.method_14190(uuid);
            return entity == null || !entity.method_5805();
        });
        ++this.ambientTick;
        if (this.ambientTick % 20 == 0) {
            double cx = (double)pos.method_10263() + 0.5;
            double cy = (double)pos.method_10264() + 1.2;
            double cz = (double)pos.method_10260() + 0.5;
            world.method_14199((class_2394)class_2398.field_11215, cx, cy, cz, 4, 0.4, 0.2, 0.4, 0.0);
            if (((Boolean)state.method_11654((class_2769)PokemonTrialSpawnerBlock.OMINOUS)).booleanValue()) {
                world.method_14199((class_2394)class_2398.field_22246, cx, cy + 0.2, cz, 1, 0.2, 0.1, 0.2, 0.0);
            }
        }
        if (this.ambientTick % 200 == 0) {
            try {
                Field ambientField = class_3417.class.getField("BLOCK_TRIAL_SPAWNER_AMBIENT");
                Object ambientObj = ambientField.get(null);
                if (ambientObj instanceof class_3414) {
                    class_3414 ambient = (class_3414)ambientObj;
                    world.method_8396(null, pos, ambient, class_3419.field_15245, 0.6f, 1.0f);
                } else {
                    world.method_8396(null, pos, class_3417.field_47206, class_3419.field_15245, 0.5f, 1.0f);
                }
            }
            catch (Throwable t) {
                world.method_8396(null, pos, class_3417.field_47206, class_3419.field_15245, 0.5f, 1.0f);
            }
        }
        if (this.spawnedPokemonUUIDs.isEmpty()) {
            ++this.ticksSinceLastSpawn;
            if (this.ticksSinceLastSpawn > 40) {
                ++this.currentWave;
                if (this.currentWave >= this.maxWaves) {
                    world.method_8501(pos, (class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47386));
                } else {
                    this.spawnNextWave(world);
                    this.ticksSinceLastSpawn = 0;
                }
            }
        }
        if (this.getNearbySurvivalPlayersCached(world, 30).isEmpty()) {
            this.resetTrial(world, pos, state);
        }
    }

    private void handleWaitingForReward(class_3218 world, class_2338 pos, class_2680 state) {
        world.method_8501(pos, (class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47387));
    }

    private void handleEjectingReward(class_3218 world, class_2338 pos, class_2680 state) {
        this.rollAndDropRewards(world);
        world.method_8501(pos, (class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47388));
        this.cooldownTicks = 36000;
        this.nextResetGameTime = world.method_8510() + 36000L;
        world.method_8396(null, pos, class_3417.field_47211, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void handleCooldown(class_3218 world, class_2338 pos, class_2680 state) {
        if (this.nextResetGameTime <= 0L && this.cooldownTicks > 0) {
            this.nextResetGameTime = world.method_8510() + (long)this.cooldownTicks;
        }
        boolean elapsed = false;
        if (this.nextResetGameTime > 0L) {
            elapsed = world.method_8510() >= this.nextResetGameTime;
        } else {
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
            }
            boolean bl = elapsed = this.cooldownTicks <= 0;
        }
        if (elapsed) {
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47384)).method_11657((class_2769)PokemonTrialSpawnerBlock.OMINOUS, (Comparable)Boolean.valueOf(false)));
            this.participatingPlayers.clear();
            this.spawnedPokemonUUIDs.clear();
            this.isActive = false;
            this.currentWave = 0;
            this.cooldownTicks = 0;
            this.nextResetGameTime = 0L;
        }
    }

    private void spawnNextWave(class_3218 world) {
        this.maxWaves = Math.max(this.waves.size(), 1);
        if (this.currentWave < this.waves.size() && !this.waves.get((int)this.currentWave).spawns.isEmpty()) {
            for (SpawnEntry entry : this.waves.get((int)this.currentWave).spawns) {
                int c = Math.max(1, entry.count);
                for (int i = 0; i < c; ++i) {
                    this.spawnPokemon(world, entry.species, entry.species_features, entry.level);
                }
            }
        } else {
            boolean ominous = (Boolean)world.method_8320(this.field_11867).method_11654((class_2769)PokemonTrialSpawnerBlock.OMINOUS);
            String[] pool = ominous ? OMINOUS_POKEMON : NORMAL_POKEMON;
            int count = Math.min(3, pool.length);
            for (int i = 0; i < count; ++i) {
                this.spawnPokemon(world, pool[this.random.nextInt(pool.length)], ominous ? 60 : 50);
            }
        }
    }

    private void spawnPokemon(class_3218 world, String species, int level) {
        this.spawnPokemon(world, species, null, level);
    }

    private String normalizeFormName(String form) {
        String normalized;
        if (form == null) {
            return "";
        }
        return switch (normalized = form.toLowerCase(Locale.ROOT).replace('-', '_').trim()) {
            case "hisui" -> "hisuian";
            case "alola" -> "alolan";
            case "galar" -> "galarian";
            case "paldea" -> "paldean";
            default -> normalized;
        };
    }

    private void spawnPokemon(class_3218 world, String species, List<String> speciesFeatures, int level) {
        try {
            PokemonEntity entity;
            block21: {
                StringBuilder propsBuilder = new StringBuilder();
                String baseSpecies = species == null ? "missingno" : species.trim();
                propsBuilder.append(baseSpecies);
                if (speciesFeatures != null && !speciesFeatures.isEmpty()) {
                    for (String feature : speciesFeatures) {
                        if (feature == null || feature.isEmpty()) continue;
                        normalized = this.normalizeFormName(feature);
                        propsBuilder.append(" ").append(normalized).append("=true");
                    }
                } else {
                    String[] parts = baseSpecies.split("\\s+");
                    if (parts.length > 1) {
                        propsBuilder = new StringBuilder(parts[0]);
                        for (int i = 1; i < parts.length; ++i) {
                            normalized = this.normalizeFormName(parts[i]);
                            propsBuilder.append(" ").append(normalized).append("=true");
                        }
                    }
                }
                propsBuilder.append(" level=").append(level);
                propsBuilder.append(" uncatchable=yes");
                String propsString = propsBuilder.toString();
                PokemonProperties properties = PokemonProperties.Companion.parse(propsString);
                Pokemon pokemon = properties.create();
                try {
                    this.setTrialPokemonUncatchable(pokemon, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                entity = new PokemonEntity((class_1937)world, pokemon, CobblemonEntities.POKEMON);
                try {
                    this.setTrialPokemonUncatchable(null, entity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double radius = 1.5 + this.random.nextDouble() * 0.75;
                double sx = (double)this.field_11867.method_10263() + 0.5 + Math.cos(angle) * radius;
                double sz = (double)this.field_11867.method_10260() + 0.5 + Math.sin(angle) * radius;
                double sy = this.field_11867.method_10264();
                entity.method_5808(sx, sy, sz, this.random.nextFloat() * 360.0f, 0.0f);
                entity.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
                try {
                    entity.method_5834(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                world.method_8649((class_1297)entity);
                try {
                    class_2995 scoreboard = world.method_14170();
                    class_268 team = scoreboard.method_1153("lm_glow_dark_gray");
                    if (team == null) {
                        team = scoreboard.method_1171("lm_glow_dark_gray");
                        team.method_1141(class_124.field_1063);
                    } else if (team.method_1202() != class_124.field_1063) {
                        team.method_1141(class_124.field_1063);
                    }
                    String entry = entity.method_5845();
                    scoreboard.method_1172(entry, team);
                }
                catch (Throwable ignore) {
                    try {
                        class_2995 scoreboard = world.method_14170();
                        class_268 team = scoreboard.method_1153("lm_glow_dark_gray");
                        if (team == null) break block21;
                        String entry = entity.method_5845();
                        for (Method m : scoreboard.getClass().getMethods()) {
                            if (!m.getName().equals("addPlayerToTeam") || m.getParameterCount() != 2) continue;
                            m.invoke((Object)scoreboard, entry, team);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.spawnedPokemonUUIDs.add(entity.method_5667());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDefaultConfigIfEmpty() {
        if (this.waves.isEmpty()) {
            Wave w1 = new Wave();
            w1.spawns.add(new SpawnEntry("zorua", 25, 3));
            this.waves.add(w1);
            Wave w2 = new Wave();
            w2.spawns.add(new SpawnEntry("zorua", 35, 3));
            this.waves.add(w2);
            Wave w3 = new Wave();
            w3.spawns.add(new SpawnEntry("zoroark", 50, 1));
            this.waves.add(w3);
        }
        if (this.rewards.isEmpty()) {
            this.rewards.add(new RewardEntry("minecraft:emerald", 2, 5, 0.8));
            this.rewards.add(new RewardEntry("minecraft:gold_ingot", 3, 8, 0.7));
            this.rewards.add(new RewardEntry("minecraft:diamond", 1, 2, 0.25));
        }
        this.maxWaves = this.waves.size();
    }

    private void rollAndDropRewards(class_3218 world) {
        for (RewardEntry r : this.rewards) {
            if (r == null || r.itemId == null || !(this.random.nextDouble() <= Math.max(0.0, Math.min(1.0, r.chance)))) continue;
            int min = Math.max(1, r.min);
            int max = Math.max(min, r.max);
            int count = min + this.random.nextInt(max - min + 1);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(this.safeId(r.itemId));
            if (item == null) continue;
            class_1799 stack = new class_1799((class_1935)item, count);
            class_1542 drop = new class_1542((class_1937)world, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5, stack);
            world.method_8649((class_1297)drop);
        }
    }

    private class_2960 safeId(String str) {
        if (str == null || str.isEmpty()) {
            return class_2960.method_60655((String)"minecraft", (String)"air");
        }
        if (str.contains(":")) {
            return class_2960.method_60654((String)str);
        }
        return class_2960.method_60655((String)"minecraft", (String)str);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 wavesList = new class_2499();
        for (Wave w : this.waves) {
            class_2487 wTag = new class_2487();
            class_2499 spawnsList = new class_2499();
            for (SpawnEntry e : w.spawns) {
                class_2487 eTag = new class_2487();
                eTag.method_10582("species", e.species);
                if (e.species_features != null && !e.species_features.isEmpty()) {
                    class_2499 features = new class_2499();
                    for (String f : e.species_features) {
                        features.add((Object)class_2519.method_23256((String)f));
                    }
                    eTag.method_10566("species_features", (class_2520)features);
                }
                eTag.method_10569("level", e.level);
                eTag.method_10569("count", e.count);
                spawnsList.add((Object)eTag);
            }
            wTag.method_10566("spawns", (class_2520)spawnsList);
            wavesList.add((Object)wTag);
        }
        nbt.method_10566("waves", (class_2520)wavesList);
        class_2499 rewardsList = new class_2499();
        for (RewardEntry r : this.rewards) {
            class_2487 rTag = new class_2487();
            rTag.method_10582("item", r.itemId);
            rTag.method_10569("min", r.min);
            rTag.method_10569("max", r.max);
            rTag.method_10549("chance", r.chance);
            rewardsList.add((Object)rTag);
        }
        nbt.method_10566("rewards", (class_2520)rewardsList);
        nbt.method_10569("cooldownTicks", this.cooldownTicks);
        nbt.method_10544("nextResetGameTime", this.nextResetGameTime);
        nbt.method_10569("currentWave", this.currentWave);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        super.method_11014(nbt, registryLookup);
        this.waves.clear();
        this.rewards.clear();
        if (nbt.method_10573("waves", 9)) {
            class_2499 wavesList = nbt.method_10554("waves", 10);
            for (i = 0; i < wavesList.size(); ++i) {
                class_2487 wTag = wavesList.method_10602(i);
                Wave w = new Wave();
                class_2499 spawnsList = wTag.method_10554("spawns", 10);
                for (int j = 0; j < spawnsList.size(); ++j) {
                    class_2487 eTag = spawnsList.method_10602(j);
                    SpawnEntry e = new SpawnEntry();
                    e.species = eTag.method_10558("species");
                    if (eTag.method_10573("species_features", 9)) {
                        class_2499 fList = eTag.method_10554("species_features", 8);
                        for (int k = 0; k < fList.size(); ++k) {
                            e.species_features.add(fList.method_10608(k));
                        }
                    }
                    e.level = eTag.method_10550("level");
                    e.count = eTag.method_10550("count");
                    w.spawns.add(e);
                }
                this.waves.add(w);
            }
        }
        if (nbt.method_10573("rewards", 9)) {
            class_2499 rewardsList = nbt.method_10554("rewards", 10);
            for (i = 0; i < rewardsList.size(); ++i) {
                class_2487 rTag = rewardsList.method_10602(i);
                RewardEntry r = new RewardEntry();
                r.itemId = rTag.method_10558("item");
                r.min = rTag.method_10550("min");
                r.max = rTag.method_10550("max");
                r.chance = rTag.method_10574("chance");
                this.rewards.add(r);
            }
        }
        this.cooldownTicks = nbt.method_10550("cooldownTicks");
        this.nextResetGameTime = nbt.method_10545("nextResetGameTime") ? nbt.method_10537("nextResetGameTime") : 0L;
        this.currentWave = nbt.method_10550("currentWave");
        this.initDefaultConfigIfEmpty();
    }

    private boolean isSurvival(class_3222 p) {
        class_1934 gm = p.field_13974 != null ? p.field_13974.method_14257() : null;
        return gm == class_1934.field_9215;
    }

    private List<class_3222> getNearbySurvivalPlayers(class_3218 world, int radius) {
        class_238 searchBox = new class_238(this.field_11867).method_1014((double)radius);
        return world.method_8390(class_3222.class, searchBox, this::isSurvival);
    }

    private List<class_3222> getNearbySurvivalPlayersCached(class_3218 world, int radius) {
        long now = world.method_8510();
        if (now - this.lastPlayerScanTick >= 10L) {
            class_238 searchBox = new class_238(this.field_11867).method_1014(30.0);
            this.cachedNearbySurvivalPlayers = world.method_8390(class_3222.class, searchBox, this::isSurvival);
            this.lastPlayerScanTick = now;
        }
        if (radius >= 30) {
            return this.cachedNearbySurvivalPlayers;
        }
        double cx = (double)this.field_11867.method_10263() + 0.5;
        double cy = (double)this.field_11867.method_10264() + 0.5;
        double cz = (double)this.field_11867.method_10260() + 0.5;
        double maxDistSq = (double)radius * (double)radius;
        ArrayList<class_3222> filtered = new ArrayList<class_3222>();
        for (class_3222 p : this.cachedNearbySurvivalPlayers) {
            if (!(p.method_5649(cx, cy, cz) <= maxDistSq)) continue;
            filtered.add(p);
        }
        return filtered;
    }

    private void resetTrial(class_3218 world, class_2338 pos, class_2680 state) {
        for (UUID uuid : this.spawnedPokemonUUIDs) {
            class_1297 entity = world.method_14190(uuid);
            if (entity == null) continue;
            entity.method_31472();
        }
        this.spawnedPokemonUUIDs.clear();
        this.participatingPlayers.clear();
        this.isActive = false;
        this.currentWave = 0;
        this.ticksSinceLastSpawn = 0;
        world.method_8501(pos, (class_2680)state.method_11657(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)class_8967.field_47383));
    }

    private void setTrialPokemonUncatchable(Pokemon pokemon, PokemonEntity entity) {
        if (pokemon != null) {
            this.tryToggleCaptureViaReflection(pokemon, new String[]{"setCapturable", "setCatchable", "setCanBeCaptured", "setCatchingAllowed"}, new String[]{"capturable", "catchable", "canBeCaptured", "catchingAllowed"});
        }
        if (entity != null) {
            this.tryToggleCaptureViaReflection(entity, new String[]{"setCapturable", "setCatchable", "setCanBeCaptured", "setCatchingAllowed", "setCaptureAllowed"}, new String[]{"capturable", "catchable", "canBeCaptured", "catchingAllowed", "captureAllowed"});
            try {
                entity.method_5780("lm_trial_uncatchable");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void tryToggleCaptureViaReflection(Object target, String[] methodNames, String[] fieldNames) {
        Class<?> cls = target.getClass();
        for (String name : methodNames) {
            try {
                Method m = cls.getMethod(name, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(target, false);
                return;
            }
            catch (Throwable m) {
            }
        }
        for (String fname : fieldNames) {
            try {
                Field f = cls.getDeclaredField(fname);
                f.setAccessible(true);
                if (f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                f.set(target, false);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class Wave {
        public final List<SpawnEntry> spawns = new ArrayList<SpawnEntry>();
    }

    public static class SpawnEntry {
        public String species;
        public List<String> species_features = new ArrayList<String>();
        public int level;
        public int count;

        public SpawnEntry() {
        }

        public SpawnEntry(String species, int level, int count) {
            this.species = species;
            this.level = level;
            this.count = count;
        }

        public SpawnEntry(String species, List<String> speciesFeatures, int level, int count) {
            this.species = species;
            if (speciesFeatures != null) {
                this.species_features.addAll(speciesFeatures);
            }
            this.level = level;
            this.count = count;
        }
    }

    public static class RewardEntry {
        public String itemId;
        public int min = 1;
        public int max = 1;
        public double chance = 1.0;

        public RewardEntry() {
        }

        public RewardEntry(String itemId, int min, int max, double chance) {
            this.itemId = itemId;
            this.min = min;
            this.max = max;
            this.chance = chance;
        }
    }
}

