/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import github.jorgaomc.ModItems;
import github.jorgaomc.client.screen.ChunkImage;
import github.jorgaomc.network.LegendaryTrackingPayloads;
import github.jorgaomc.screen.ArcPhoneScreenHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendaryTrackingScreen
extends class_465<ArcPhoneScreenHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegendaryTrackingScreen.class);
    private static final class_2960 PHONE_OUTLINE = class_2960.method_60655((String)"legendarymonuments", (String)"textures/gui/arc_phone_outline.png");
    private static final class_2960 PHONE_SCREEN = class_2960.method_60655((String)"legendarymonuments", (String)"textures/gui/arc_phone_map_screen.png");
    private static final class_2960 TRACKING_ARROW = class_2960.method_60655((String)"legendarymonuments", (String)"textures/gui/tracking_arrow.png");
    private static final class_2960 ICON_FALLBACK = class_2960.method_60655((String)"minecraft", (String)"textures/item/barrier.png");
    private static final class_2960 LOCATE_REQUEST_ID = class_2960.method_60655((String)"legendarymonuments", (String)"locate_request");
    private static final class_2960 LOCATE_RESPONSE_ID = class_2960.method_60655((String)"legendarymonuments", (String)"locate_response");
    private static final class_2960 KEYITEM_REQUEST_ID = class_2960.method_60655((String)"legendarymonuments", (String)"keyitem_check_request");
    private static final class_2960 KEYITEM_RESPONSE_ID = class_2960.method_60655((String)"legendarymonuments", (String)"keyitem_check_response");
    private static final int PHONE_OUTLINE_WIDTH = 700;
    private static final int PHONE_OUTLINE_HEIGHT = 390;
    private static final int PHONE_SCREEN_WIDTH = 330;
    private static final int PHONE_SCREEN_HEIGHT = 194;
    private static final int MAP_WIDTH = 240;
    private static final int MAP_HEIGHT = 112;
    private static final int MAP_CELL_SIZE = 16;
    private static final int OUTLINE_X_OFFSET = 81;
    private static final int OUTLINE_Y_OFFSET = 0;
    private class_4185 dropdownButton;
    private boolean dropdownOpen = false;
    private int scrollOffset = 0;
    private static final int DROPDOWN_HEIGHT = 100;
    private static final int ITEM_HEIGHT = 15;
    private static final Map<String, Boolean> KEY_ITEM_CACHE = new HashMap<String, Boolean>();
    private static final Map<String, Long> KEY_ITEM_LAST_REQUEST = new HashMap<String, Long>();
    private static final long KEY_ITEM_REQUEST_COOLDOWN_MS = 3000L;
    private static int staticSelectedStructureIndex = 0;
    private int selectedStructureIndex = staticSelectedStructureIndex;
    private static Set<String> completedStructures = new HashSet<String>();
    private static final int STRUCTURE_ICON_SIZE = 24;
    private static final StructureData[] STRUCTURES = new StructureData[]{new StructureData("Dragonspiral Tower", ModItems.LIGHTSTONE_SHARD, "legendarymonuments:dragonspiraltower"), new StructureData("Turnback Cave", class_1802.field_47315, "legendarymonuments:turnback_cave"), new StructureData("Ecruteak Village", ModItems.CLEAR_BELL, "legendarymonuments:traditional_village/ecruteak"), new StructureData("Heatran Cave", ModItems.MAGMA_STONE, "legendarymonuments:heatran_cave"), new StructureData("Firescourge Shrine", ModItems.FIRESCOURGE_SEAL, "legendarymonuments:firescourge_shrine"), new StructureData("Grasswither Shrine", ModItems.GRASSWITHER_SEAL, "legendarymonuments:grasswither_shrine"), new StructureData("Groundblight Shrine", ModItems.GROUNDBLIGHT_SEAL, "legendarymonuments:groundblight_shrine"), new StructureData("Icerend Shrine", ModItems.ICEREND_SEAL, "legendarymonuments:icerend_shrine"), new StructureData("Southern Island", class_1802.field_28354, "legendarymonuments:southern_island"), new StructureData("Hoopa Pyramid", class_1802.field_8056, "legendarymonuments:hoopa_pyramid"), new StructureData("Lugia Temple", ModItems.VORTEX_STONE, "legendarymonuments:lugia_temple"), new StructureData("Eternatus Cocoon", ModItems.GALAR_PARTICLE, "legendarymonuments:eternatus_cocoon"), new StructureData("Sword Monument", class_1802.field_8288, "legendarymonuments:sword"), new StructureData("Shield Monument", class_1802.field_8288, "legendarymonuments:shield"), new StructureData("Kyurem Cave", ModItems.IDEALS_BOTTLE, "legendarymonuments:kyuremcave"), new StructureData("Dyna Tree", class_1802.field_42688, "legendarymonuments:dyna_tree"), new StructureData("Giratina Island", ModItems.ORIGIN_INGOT, "legendarymonuments:giratina_island"), new StructureData("Final Island", ModItems.OLD_SEA_MAP, "legendarymonuments:final_island"), new StructureData("Snowpoint Temple", ModItems.GOLEM_SCRAP, "legendarymonuments:snowpoint_temple"), new StructureData("Spear Pillar", ModItems.RED_CHAIN, "legendarymonuments:spear_pillar"), new StructureData("Lake Valor", class_1802.field_8711, "legendarymonuments:lake_valor"), new StructureData("Lake Acuity", class_1802.field_16998, "legendarymonuments:lake_acuity"), new StructureData("Lake Verity", class_1802.field_28659, "legendarymonuments:lake_verity"), new StructureData("Liberty Island", ModItems.LIBERTY_PASS, "legendarymonuments:liberty_island")};
    private String errorMessage = null;
    private int errorTimer = 0;
    private static final int MAX_CHUNK_CACHE = 300;
    private final Map<class_1923, ChunkImage> chunkImageCache = new LinkedHashMap<class_1923, ChunkImage>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<class_1923, ChunkImage> eldest) {
            if (this.size() > 300) {
                try {
                    if (eldest.getValue() != null) {
                        eldest.getValue().dispose();
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to dispose chunk image", t);
                }
                return true;
            }
            return false;
        }
    };
    private int cachedMapX = 0;
    private int cachedMapY = 0;
    private int locateRequestCooldown = 0;
    private static final int LOCATE_REQUEST_COOLDOWN_TICKS = 20;
    private static final long STRUCTURE_REQUEST_COOLDOWN_MS = 5000L;

    private static boolean idsMatch(String idA, String idB) {
        String bB;
        String nsB;
        if (idA == null || idB == null) {
            return false;
        }
        if (idA.equals(idB)) {
            return true;
        }
        int ca = idA.indexOf(58);
        int cb = idB.indexOf(58);
        if (ca <= 0 || cb <= 0) {
            return false;
        }
        String nsA = idA.substring(0, ca);
        if (!nsA.equals(nsB = idB.substring(0, cb))) {
            return false;
        }
        String pA = idA.substring(ca + 1);
        String pB = idB.substring(cb + 1);
        String bA = LegendaryTrackingScreen.basePath(pA);
        if (bA.equals(bB = LegendaryTrackingScreen.basePath(pB))) {
            return true;
        }
        return pA.startsWith(bB) || pB.startsWith(bA);
    }

    private static String basePath(String path) {
        int i;
        if (path == null || path.isEmpty()) {
            return path;
        }
        for (i = path.length() - 1; i >= 0 && Character.isDigit(path.charAt(i)); --i) {
        }
        if (i >= 0 && (path.charAt(i) == '_' || path.charAt(i) == '-')) {
            return path.substring(0, i);
        }
        return path.substring(0, i + 1);
    }

    public static void registerPayloadTypes() {
        try {
            PayloadTypeRegistry.playC2S().register(LocateRequestPayload.ID, LocateRequestPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(LocateResponsePayload.ID, LocateResponsePayload.CODEC);
            PayloadTypeRegistry.playC2S().register(KeyItemCheckRequestPayload.ID, KeyItemCheckRequestPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(KeyItemCheckResponsePayload.ID, KeyItemCheckResponsePayload.CODEC);
            LOGGER.info("Registered LegendaryTrackingScreen payload types");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register LegendaryTrackingScreen payload types", (Throwable)e);
            throw e;
        }
    }

    public LegendaryTrackingScreen(ArcPhoneScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, (class_2561)class_2561.method_43473());
        this.field_2792 = 330;
        this.field_2779 = 194;
        this.selectedStructureIndex = staticSelectedStructureIndex;
        LOGGER.info("LegendaryTrackingScreen initialized with selected index: {}", (Object)this.selectedStructureIndex);
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = -1000;
        if (this.selectedStructureIndex < 0 || this.selectedStructureIndex >= STRUCTURES.length) {
            this.selectedStructureIndex = 0;
            staticSelectedStructureIndex = 0;
        }
        int buttonX = (this.field_22789 - 120) / 2;
        int buttonY = this.field_22790 / 2 - 75;
        this.dropdownButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)this.getSelectedStructureName()), button -> this.toggleDropdown()).method_46434(buttonX, buttonY, 120, 20).method_46431();
        this.method_37063((class_364)this.dropdownButton);
        LOGGER.info("Screen initialized with structure: {}", (Object)this.getSelectedStructureName());
    }

    public void method_25432() {
        super.method_25432();
        staticSelectedStructureIndex = this.selectedStructureIndex;
        LOGGER.info("Screen closed, saved selected index: {}", (Object)this.selectedStructureIndex);
        for (ChunkImage ci : this.chunkImageCache.values()) {
            try {
                ci.dispose();
            }
            catch (Throwable t) {
                LOGGER.warn("Error disposing chunk image", t);
            }
        }
        this.chunkImageCache.clear();
    }

    private void toggleDropdown() {
        this.dropdownOpen = !this.dropdownOpen;
    }

    private String getSelectedStructureName() {
        if (this.selectedStructureIndex >= 0 && this.selectedStructureIndex < STRUCTURES.length) {
            return LegendaryTrackingScreen.STRUCTURES[this.selectedStructureIndex].name;
        }
        return "Select Structure";
    }

    private boolean hasRequiredItem(StructureData structure) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return false;
        }
        try {
            for (class_1799 s : this.field_22787.field_1724.method_31548().field_7547) {
                if (s == null || s.method_7960() || s.method_7909() != structure.requiredItem) continue;
                LOGGER.debug("Found {} in player inventory", (Object)structure.requiredItem.method_7848().getString());
                return true;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Error checking inventory", t);
        }
        try {
            long last;
            String itemId = class_7923.field_41178.method_10221((Object)structure.requiredItem).toString();
            Boolean cached = KEY_ITEM_CACHE.get(itemId);
            if (cached != null) {
                if (cached.booleanValue()) {
                    LOGGER.debug("Server cache says player has {} in Key Items", (Object)itemId);
                }
                return cached;
            }
            long now = System.currentTimeMillis();
            if (now - (last = KEY_ITEM_LAST_REQUEST.getOrDefault(itemId, 0L).longValue()) > 3000L) {
                KEY_ITEM_LAST_REQUEST.put(itemId, now);
                try {
                    ClientPlayNetworking.send((class_8710)new LegendaryTrackingPayloads.KeyItemCheckRequestPayload(itemId));
                    LOGGER.debug("Requested key item presence for {}", (Object)itemId);
                }
                catch (Throwable sendErr) {
                    LOGGER.warn("Failed to send key item check request: {}", (Object)sendErr.getMessage());
                }
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Key item check request failed (non-fatal)", t);
        }
        LOGGER.debug("Required item {} not found locally; awaiting server key-items response for {}", (Object)structure.requiredItem.method_7848().getString(), (Object)structure.name);
        return false;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int outlineX = centerX - 350 + 81;
        int outlineY = centerY - 195 + 0;
        int phoneScreenX = centerX - 165;
        int phoneScreenY = centerY - 97;
        this.cachedMapX = phoneScreenX + 45;
        this.cachedMapY = phoneScreenY + 61;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_25290(PHONE_OUTLINE, outlineX, outlineY, 0.0f, 0.0f, 700, 390, 700, 390);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.method_25290(PHONE_SCREEN, phoneScreenX, phoneScreenY, 0.0f, 0.0f, 330, 194, 330, 194);
        RenderSystem.disableBlend();
        context.method_25294(this.cachedMapX, this.cachedMapY, this.cachedMapX + 240, this.cachedMapY + 112, -16777216);
        this.drawMapWithChunks(context, this.cachedMapX, this.cachedMapY);
        int playerX = this.cachedMapX + 120;
        int playerY = this.cachedMapY + 56;
        context.method_25294(playerX - 2, playerY - 2, playerX + 2, playerY + 2, -16711936);
        RenderSystem.disableBlend();
    }

    private void drawMapWithChunks(class_332 context, int mapX, int mapY) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        int playerChunkX = playerPos.method_10263() >> 4;
        int playerChunkZ = playerPos.method_10260() >> 4;
        int chunksHorizontal = Math.max(1, (int)Math.ceil(15.0));
        int chunksVertical = Math.max(1, (int)Math.ceil(7.0));
        int startChunkX = playerChunkX - chunksHorizontal / 2;
        int startChunkZ = playerChunkZ - chunksVertical / 2;
        for (int x = 0; x < chunksHorizontal; ++x) {
            for (int z = 0; z < chunksVertical; ++z) {
                int chunkX = startChunkX + x;
                int chunkZ = startChunkZ + z;
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                int cellX = mapX + x * 16;
                int cellY = mapY + z * 16;
                ChunkImage chunkImage = this.chunkImageCache.get(chunkPos);
                if (chunkImage == null) {
                    try {
                        chunkImage = new ChunkImage((class_1937)this.field_22787.field_1687, chunkPos, playerPos.method_10264());
                        this.chunkImageCache.put(chunkPos, chunkImage);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Failed to create ChunkImage", t);
                    }
                }
                if (chunkImage != null) {
                    try {
                        chunkImage.bindTexture();
                        context.method_25290(chunkImage.textureId, cellX, cellY, 0.0f, 0.0f, 16, 16, 16, 16);
                    }
                    catch (Throwable t) {
                        context.method_25294(cellX, cellY, cellX + 16, cellY + 16, -12303292);
                    }
                } else {
                    context.method_25294(cellX, cellY, cellX + 16, cellY + 16, -12303292);
                }
                context.method_49601(cellX, cellY, 16, 16, -10066330);
            }
        }
        this.drawStructureIcons(context, mapX, mapY, this.field_22787.field_1724.method_24515());
    }

    private void drawStructureIcons(class_332 context, int mapX, int mapY, class_2338 playerPos) {
        for (StructureData structure : STRUCTURES) {
            if (!structure.isLocated || structure.position == null) continue;
            int structureMapX = mapX + 120 + (structure.position.method_10263() - playerPos.method_10263()) * 16 / 16;
            int structureMapY = mapY + 56 + (structure.position.method_10260() - playerPos.method_10260()) * 16 / 16;
            if (structureMapX < mapX || structureMapX > mapX + 240 - 24 || structureMapY < mapY || structureMapY > mapY + 112 - 24) continue;
            class_2960 structureIcon = class_2960.method_60655((String)"legendarymonuments", (String)("textures/gui/structure_icons/" + structure.iconName + ".png"));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                context.method_25290(structureIcon, structureMapX - 12, structureMapY - 12, 0.0f, 0.0f, 24, 24, 24, 24);
                if (structure.isCompleted) {
                    context.method_51433(this.field_22787.field_1772, "\u2713", structureMapX + 12, structureMapY - 12 - 2, -11141291, true);
                }
            }
            catch (Throwable t) {
                int color = structure.isCompleted ? -11141291 : -43691;
                context.method_25294(structureMapX - 3, structureMapY - 3, structureMapX + 3, structureMapY + 3, color);
            }
            RenderSystem.disableBlend();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.errorTimer > 0) {
            --this.errorTimer;
            if (this.errorTimer <= 0) {
                this.errorMessage = null;
            }
        }
        this.drawTrackingInfo(context);
        if (this.dropdownOpen) {
            this.drawDropdown(context, mouseX, mouseY);
        }
        if (this.errorMessage != null && this.field_22787 != null) {
            int errorX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)class_2561.method_30163((String)this.errorMessage)) / 2;
            int errorY = this.field_22790 / 2 + 60;
            context.method_51439(this.field_22793, class_2561.method_30163((String)this.errorMessage), errorX, errorY, -65536, true);
        }
        this.method_2380(context, mouseX, mouseY);
        if (this.locateRequestCooldown > 0) {
            --this.locateRequestCooldown;
        }
    }

    private void sendLocateRequest(StructureData structure) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        if (this.locateRequestCooldown > 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - structure.lastRequestTime < 5000L) {
            LOGGER.debug("Skipping locate request for {} - too soon since last request", (Object)structure.name);
            return;
        }
        try {
            LegendaryTrackingPayloads.LocateRequestPayload payload = new LegendaryTrackingPayloads.LocateRequestPayload(structure.structureId, this.field_22787.field_1724.method_24515(), structure.isCompleted);
            ClientPlayNetworking.send((class_8710)payload);
            this.locateRequestCooldown = 20;
            structure.lastRequestTime = currentTime;
            LOGGER.info("Sent locate request for: {} at player pos: {}", (Object)structure.name, (Object)this.field_22787.field_1724.method_24515());
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to send locate request packet", t);
            this.errorMessage = "Failed to send locate request: " + t.getMessage();
            this.errorTimer = 100;
        }
    }

    public static void registerClientReceivers() {
        try {
            ClientPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.LocateResponsePayload.ID, (payload, context) -> {
                try {
                    context.client().execute(() -> {
                        LOGGER.info("Received locate response: {} -> found:{} pos:{}", new Object[]{payload.structureId(), payload.found(), payload.pos()});
                        boolean foundStructure = false;
                        for (StructureData s : STRUCTURES) {
                            if (!LegendaryTrackingScreen.idsMatch(s.structureId, payload.structureId())) continue;
                            s.isLocated = payload.found();
                            s.position = payload.found() ? payload.pos() : null;
                            foundStructure = true;
                            if (s.structureId.equals(payload.structureId())) {
                                LOGGER.info("Updated structure: {} -> located:{} pos:{}", new Object[]{s.name, s.isLocated, s.position});
                                break;
                            }
                            LOGGER.info("Updated structure (fuzzy match: {} ~ {}): {} -> located:{} pos:{}", new Object[]{s.structureId, payload.structureId(), s.name, s.isLocated, s.position});
                            break;
                        }
                        if (!foundStructure) {
                            LOGGER.warn("Received locate response for unknown structure: {}", (Object)payload.structureId());
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Error processing locate response", (Throwable)e);
                }
            });
            ClientPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.KeyItemCheckResponsePayload.ID, (payload, context) -> {
                try {
                    context.client().execute(() -> {
                        KEY_ITEM_CACHE.put(payload.itemId(), payload.has());
                        LOGGER.info("Key item check result: {} -> {}", (Object)payload.itemId(), (Object)payload.has());
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Error processing key item response", (Throwable)e);
                }
            });
            LOGGER.info("Successfully registered locate and key-item response receivers");
        }
        catch (Throwable t) {
            LOGGER.error("Failed to register client locate receiver", t);
        }
    }

    private void drawTrackingInfo(class_332 context) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        StructureData selectedStructure = STRUCTURES[this.selectedStructureIndex];
        boolean clientThinksMissing = !this.hasRequiredItem(selectedStructure);
        int baseY = this.field_22790 / 2 + 30;
        if (!selectedStructure.isLocated && this.locateRequestCooldown == 0) {
            LOGGER.debug("Requesting locate for: {}", (Object)selectedStructure.name);
            this.sendLocateRequest(selectedStructure);
        }
        if (selectedStructure.position == null) {
            String notFoundText = selectedStructure.isLocated ? "Structure not found in range" : "Searching for structure...";
            int textX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)class_2561.method_30163((String)notFoundText)) / 2;
            int color = selectedStructure.isLocated ? -48060 : -22016;
            context.method_51439(this.field_22793, class_2561.method_30163((String)notFoundText), textX, baseY, color, true);
            return;
        }
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        class_2338 structurePos = selectedStructure.position;
        double distance = Math.sqrt(playerPos.method_10262((class_2382)structurePos));
        double deltaX = structurePos.method_10263() - playerPos.method_10263();
        double deltaZ = structurePos.method_10260() - playerPos.method_10260();
        float playerYaw = this.field_22787.field_1724.method_36454();
        double absoluteAngle = Math.atan2(deltaZ, deltaX);
        double relativeAngle = absoluteAngle - Math.toRadians(playerYaw);
        String distanceText = String.format("Distance: %.0f blocks", distance);
        int textX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)class_2561.method_30163((String)distanceText)) / 2;
        int textY = this.field_22790 / 2 + 30;
        context.method_51439(this.field_22793, class_2561.method_30163((String)distanceText), textX, textY, 0xFFFFFF, true);
        String directionText = this.getDirectionText(deltaX, deltaZ);
        int dirTextX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)class_2561.method_30163((String)directionText)) / 2;
        int dirTextY = this.field_22790 / 2 + 42;
        context.method_51439(this.field_22793, class_2561.method_30163((String)directionText), dirTextX, dirTextY, -3355444, true);
        String coordText = String.format("Coords: %d, %d, %d", structurePos.method_10263(), structurePos.method_10264(), structurePos.method_10260());
        int coordTextX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)class_2561.method_30163((String)coordText)) / 2;
        int coordTextY = this.field_22790 / 2 + 54;
        context.method_51439(this.field_22793, class_2561.method_30163((String)coordText), coordTextX, coordTextY, -8388480, false);
        int mapCenterX = this.field_22789 / 2;
        int mapCenterY = this.field_22790 / 2 - 25;
        this.drawDynamicArrow(context, mapCenterX, mapCenterY, relativeAngle, distance);
    }

    private String getDirectionText(double deltaX, double deltaZ) {
        double absZ;
        String ewDirection = deltaX > 0.0 ? "East" : "West";
        String nsDirection = deltaZ > 0.0 ? "South" : "North";
        double absX = Math.abs(deltaX);
        if (absX > (absZ = Math.abs(deltaZ)) * 2.0) {
            return ewDirection;
        }
        if (absZ > absX * 2.0) {
            return nsDirection;
        }
        return nsDirection + "-" + ewDirection;
    }

    private void drawDynamicArrow(class_332 context, int centerX, int centerY, double angle, double distance) {
        int baseSize = 18;
        int arrowSize = (int)Math.max(14.0, Math.min(20.0, (double)baseSize + (1000.0 - Math.min(distance, 1000.0)) / 100.0));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)Math.toDegrees(angle)));
        float scale = (float)arrowSize / 16.0f;
        context.method_51448().method_22905(scale, scale, 1.0f);
        context.method_25290(TRACKING_ARROW, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        context.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        context.method_25294(centerX - 1, centerY - 1, centerX + 1, centerY + 1, -1);
    }

    private void drawDropdown(class_332 context, int mouseX, int mouseY) {
        int buttonX = this.dropdownButton.method_46426();
        int buttonY = this.dropdownButton.method_46427() + this.dropdownButton.method_25364();
        int buttonWidth = this.dropdownButton.method_25368();
        context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + 100, -14540254);
        context.method_49601(buttonX, buttonY, buttonWidth, 100, -7829368);
        int visibleItems = 6;
        int maxScroll = Math.max(0, STRUCTURES.length - visibleItems);
        for (int i = this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)maxScroll); i < Math.min(STRUCTURES.length, this.scrollOffset + visibleItems); ++i) {
            boolean hasItem;
            boolean isHovered;
            int itemY = buttonY + (i - this.scrollOffset) * 15;
            StructureData structure = STRUCTURES[i];
            boolean bl = isHovered = mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= itemY && mouseY <= itemY + 15;
            if (isHovered) {
                context.method_25294(buttonX, itemY, buttonX + buttonWidth, itemY + 15, -12303292);
            }
            int textColor = (hasItem = this.hasRequiredItem(structure)) ? -1 : -10066330;
            context.method_51439(this.field_22793, class_2561.method_30163((String)structure.name), buttonX + 5, itemY + 3, textColor, false);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dropdownOpen) {
            int buttonX = this.dropdownButton.method_46426();
            int buttonY = this.dropdownButton.method_46427() + this.dropdownButton.method_25364();
            int buttonWidth = this.dropdownButton.method_25368();
            if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 100)) {
                int clickedIndex = (int)((mouseY - (double)buttonY) / 15.0) + this.scrollOffset;
                if (clickedIndex >= 0 && clickedIndex < STRUCTURES.length) {
                    StructureData selected = STRUCTURES[clickedIndex];
                    boolean hadItemClientSide = this.hasRequiredItem(selected);
                    this.selectedStructureIndex = clickedIndex;
                    staticSelectedStructureIndex = clickedIndex;
                    this.dropdownButton.method_25355(class_2561.method_30163((String)selected.name));
                    this.dropdownOpen = false;
                    this.errorMessage = null;
                    if (!hadItemClientSide) {
                        this.errorMessage = "You don't have " + selected.requiredItem.method_7848().getString();
                        this.errorTimer = 80;
                        LOGGER.info("Selected {} without client-side item; informing player about missing item {}", (Object)selected.name, (Object)selected.requiredItem.method_7848().getString());
                    } else {
                        LOGGER.info("Selected structure: {} (index: {})", (Object)selected.name, (Object)clickedIndex);
                    }
                    selected.isLocated = false;
                    selected.position = null;
                    selected.lastRequestTime = 0L;
                    this.sendLocateRequest(selected);
                }
                return true;
            }
            this.dropdownOpen = false;
        }
        if (button == 0 && this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_2338 playerPos = this.field_22787.field_1724.method_24515();
            int mapX = this.cachedMapX;
            int mapY = this.cachedMapY;
            for (StructureData structure : STRUCTURES) {
                if (!structure.isLocated || structure.position == null) continue;
                int structureMapX = mapX + 120 + (structure.position.method_10263() - playerPos.method_10263()) * 16 / 16;
                int structureMapY = mapY + 56 + (structure.position.method_10260() - playerPos.method_10260()) * 16 / 16;
                if (!(mouseX >= (double)(structureMapX - 12)) || !(mouseX <= (double)(structureMapX + 12)) || !(mouseY >= (double)(structureMapY - 12)) || !(mouseY <= (double)(structureMapY + 12))) continue;
                boolean bl = structure.isCompleted = !structure.isCompleted;
                if (structure.isCompleted) {
                    completedStructures.add(structure.structureId);
                    structure.isLocated = false;
                    structure.position = null;
                    structure.lastRequestTime = 0L;
                    this.sendLocateRequest(structure);
                    LOGGER.info("Marked {} as completed, requesting next instance", (Object)structure.name);
                } else {
                    completedStructures.remove(structure.structureId);
                    LOGGER.info("Unmarked {} as completed", (Object)structure.name);
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.dropdownOpen) {
            int buttonX = this.dropdownButton.method_46426();
            int buttonY = this.dropdownButton.method_46427() + this.dropdownButton.method_25364();
            int buttonWidth = this.dropdownButton.method_25368();
            if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 100)) {
                this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)verticalAmount), (int)0, (int)Math.max(0, STRUCTURES.length - 6));
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public static void refreshStructureLocations() {
        for (StructureData structure : STRUCTURES) {
            structure.isLocated = false;
            structure.position = null;
            structure.lastRequestTime = 0L;
        }
        LOGGER.info("Refreshed all structure locations");
    }

    public static void debugNetworking() {
        LOGGER.info("=== DEBUG NETWORKING INFO ===");
        LOGGER.info("Locate Request ID: {}", (Object)LOCATE_REQUEST_ID);
        LOGGER.info("Locate Response ID: {}", (Object)LOCATE_RESPONSE_ID);
        LOGGER.info("Structures count: {}", (Object)STRUCTURES.length);
        for (int i = 0; i < STRUCTURES.length; ++i) {
            StructureData s = STRUCTURES[i];
            LOGGER.info("  {}: {} -> located:{} pos:{}", new Object[]{i, s.name, s.isLocated, s.position});
        }
        LOGGER.info("Selected index: {}", (Object)staticSelectedStructureIndex);
        LOGGER.info("==============================");
    }

    public record LocateRequestPayload(String structureId, class_2338 playerPos, boolean isCompleted) implements class_8710
    {
        public static final class_8710.class_9154<LocateRequestPayload> ID = new class_8710.class_9154(LOCATE_REQUEST_ID);
        public static final class_9139<class_2540, LocateRequestPayload> CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, LocateRequestPayload::structureId, (class_9139)class_2338.field_48404, LocateRequestPayload::playerPos, (class_9139)class_9135.field_48547, LocateRequestPayload::isCompleted, LocateRequestPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record LocateResponsePayload(String structureId, boolean found, class_2338 pos) implements class_8710
    {
        public static final class_8710.class_9154<LocateResponsePayload> ID = new class_8710.class_9154(LOCATE_RESPONSE_ID);
        public static final class_9139<class_2540, LocateResponsePayload> CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, LocateResponsePayload::structureId, (class_9139)class_9135.field_48547, LocateResponsePayload::found, (class_9139)class_2338.field_48404, LocateResponsePayload::pos, LocateResponsePayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record KeyItemCheckRequestPayload(String itemId) implements class_8710
    {
        public static final class_8710.class_9154<KeyItemCheckRequestPayload> ID = new class_8710.class_9154(KEYITEM_REQUEST_ID);
        public static final class_9139<class_2540, KeyItemCheckRequestPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48554, KeyItemCheckRequestPayload::itemId, KeyItemCheckRequestPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record KeyItemCheckResponsePayload(String itemId, boolean has) implements class_8710
    {
        public static final class_8710.class_9154<KeyItemCheckResponsePayload> ID = new class_8710.class_9154(KEYITEM_RESPONSE_ID);
        public static final class_9139<class_2540, KeyItemCheckResponsePayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, KeyItemCheckResponsePayload::itemId, (class_9139)class_9135.field_48547, KeyItemCheckResponsePayload::has, KeyItemCheckResponsePayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private static class StructureData {
        public final String name;
        public final class_1792 requiredItem;
        public final String structureId;
        public final String iconName;
        public class_2338 position;
        public boolean isLocated = false;
        public boolean isCompleted = false;
        public long lastRequestTime = 0L;

        public StructureData(String name, class_1792 requiredItem, String structureId) {
            this.name = name;
            this.requiredItem = requiredItem;
            this.structureId = structureId;
            String rawPath = structureId.substring(structureId.indexOf(58) + 1);
            this.iconName = rawPath.contains("/") ? rawPath.substring(rawPath.lastIndexOf(47) + 1) : rawPath;
            this.position = null;
        }
    }
}

