/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.data.ClientPlayerDataCache;
import github.jorgaomc.data.PlayerAppData;
import github.jorgaomc.network.UnlockAppC2SPacket;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class SystemUpgradesScreen
extends class_437 {
    private static final class_2960 PHONE_OUTLINE = class_2960.method_60655((String)"legendarymonuments", (String)"textures/gui/arc_phone_outline.png");
    private static final class_2960 PHONE_SCREEN = class_2960.method_60655((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_screen.png");
    private static final class_2960 APP_ICONS = class_2960.method_60655((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_icons.png");
    private static final int SCREEN_WIDTH = 330;
    private static final int SCREEN_HEIGHT = 194;
    private static final int APP_ICON_SIZE = 48;
    private static final int OUTLINE_X_OFFSET = 81;
    private static final int OUTLINE_Y_OFFSET = 0;
    private static final int TOP_TITLE_SPACE = 40;
    private static final int LEFT_PADDING = 60;
    private static final int LEFT_PADDING_SECOND_COLUMN = 185;
    private static final int APPS_PER_ROW = 2;
    private static final int GAP_Y = 30;
    private static final int TEXT_GAP = 8;
    private static final AppIcon[] UPGRADE_APPS = new AppIcon[]{new AppIcon(0, 0, "PC", "PC Upgrade"), new AppIcon(0, 0, "Pok\u00e9dex", "Pok\u00e9dex Upgrade"), new AppIcon(0, 0, "Heal", "Heal Upgrade"), new AppIcon(0, 0, "Ender Chest", "Ender Chest Upgrade")};

    public SystemUpgradesScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.legendarymonuments.system_upgrades"));
    }

    protected void method_25426() {
        super.method_25426();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        this.drawScreenElements(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.legendarymonuments.system_upgrades"), this.field_22789 / 2, (this.field_22790 - 194) / 2 + 22, 0xFFFFFF);
        int screenX = (this.field_22789 - 330) / 2;
        int screenY = (this.field_22790 - 194) / 2;
        for (int i = 0; i < UPGRADE_APPS.length; ++i) {
            AppIcon app = UPGRADE_APPS[i];
            if (this.isMouseOverApp(mouseX, mouseY, screenX + app.x, screenY + app.y)) {
                context.method_51438(this.field_22793, class_2561.method_30163((String)app.name), mouseX, mouseY);
            }
            List<class_1799> costs = this.getCostStacks(app.name);
            int baseX = screenX + app.x + 48 + 10;
            int baseY = screenY + app.y + 4;
            int iconSize = 16;
            for (int ci = 0; ci < costs.size(); ++ci) {
                int cx = baseX;
                int cy = baseY + ci * (iconSize + 6);
                if (mouseX < cx || mouseX >= cx + iconSize || mouseY < cy || mouseY >= cy + iconSize) continue;
                class_1799 stack = costs.get(ci);
                context.method_51438(this.field_22793, stack.method_7964(), mouseX, mouseY);
            }
        }
    }

    private void drawScreenElements(class_332 context, int mouseX, int mouseY, float delta) {
        int outlineWidth = 700;
        int outlineHeight = 390;
        int outlineX = (this.field_22789 - outlineWidth) / 2 + 81;
        int outlineY = (this.field_22790 - outlineHeight) / 2 + 0;
        int screenX = (this.field_22789 - 330) / 2;
        int screenY = (this.field_22790 - 194) / 2;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_25290(PHONE_OUTLINE, outlineX, outlineY, 0.0f, 0.0f, outlineWidth, outlineHeight, outlineWidth, outlineHeight);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.method_25290(PHONE_SCREEN, screenX, screenY, 0.0f, 0.0f, 330, 194, 330, 194);
        RenderSystem.disableBlend();
        for (int i = 0; i < UPGRADE_APPS.length; ++i) {
            AppIcon app = UPGRADE_APPS[i];
            int row = i / 2;
            int col = i % 2;
            int appX = col == 0 ? 60 : 185;
            int appY = 40 + row * 78;
            app.x = appX;
            app.y = appY;
            context.method_25290(APP_ICONS, screenX + appX, screenY + appY, 0.0f, (float)((i + 5) * 48), 48, 48, 48, 432);
            context.method_27535(this.field_22793, class_2561.method_30163((String)app.description), screenX + appX + 24 - this.field_22793.method_1727(app.description) / 2, screenY + appY + 48 + 8, 0xFFFFFF);
            PlayerAppData appData = ClientPlayerDataCache.getAppData();
            boolean isUnlocked = appData.isAppUnlocked(app.name);
            if (isUnlocked) {
                context.method_51433(this.field_22793, "\u2713", screenX + appX + 48 - 10, screenY + appY + 48 - 10, 0x55FF55, true);
            } else {
                context.method_51433(this.field_22793, "\u2717", screenX + appX + 48 - 10, screenY + appY + 48 - 10, 0xFF5555, true);
            }
            List<class_1799> costs = this.getCostStacks(app.name);
            int costBaseX = screenX + appX + 48 + 10;
            int costBaseY = screenY + appY + 4;
            int iconSize = 16;
            for (int ci = 0; ci < costs.size(); ++ci) {
                class_1799 stack = costs.get(ci);
                int ix = costBaseX;
                int iy = costBaseY + ci * (iconSize + 6);
                context.method_51427(stack, ix, iy);
                String amount = "x" + stack.method_7947();
                context.method_25303(this.field_22793, amount, ix + iconSize + 4, iy + 4, 0xFFFFFF);
            }
        }
        RenderSystem.disableBlend();
    }

    private boolean isMouseOverApp(int mouseX, int mouseY, int appX, int appY) {
        return mouseX >= appX && mouseX < appX + 48 && mouseY >= appY && mouseY < appY + 48;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int screenX = (this.field_22789 - 330) / 2;
            int screenY = (this.field_22790 - 194) / 2;
            for (int i = 0; i < UPGRADE_APPS.length; ++i) {
                AppIcon app = UPGRADE_APPS[i];
                if (!this.isMouseOverApp((int)mouseX, (int)mouseY, screenX + app.x, screenY + app.y)) continue;
                this.handleAppClick(i);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void handleAppClick(int appIndex) {
        AppIcon app = UPGRADE_APPS[appIndex];
        String appName = app.name;
        PlayerAppData appData = ClientPlayerDataCache.getAppData();
        if (appData.isAppUnlocked(appName)) {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"message.legendarymonuments.app_already_unlocked", (Object[])new Object[]{appName}), true);
            }
            LegendaryMonuments.LOGGER.info("App {} is already unlocked", (Object)appName);
            return;
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            try {
                ClientPlayNetworking.send((class_8710)new UnlockAppC2SPacket(appName));
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"message.legendarymonuments.app_unlock_requested", (Object[])new Object[]{appName}), true);
            }
            catch (Throwable t) {
                LegendaryMonuments.LOGGER.error("Failed to send unlock request for app {}", (Object)appName, (Object)t);
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    private List<class_1799> getCostStacks(String appName) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        class_1792 upgrade = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"upgrade"));
        list.add(new class_1799((class_1935)upgrade, 1));
        switch (appName) {
            case "Pok\u00e9dex": {
                list.add(new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"pokedex_white")), 1));
                break;
            }
            case "PC": {
                list.add(new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"pc")), 1));
                break;
            }
            case "Ender Chest": {
                list.add(new class_1799((class_1935)class_1802.field_8466, 1));
                break;
            }
            case "Heal": {
                list.add(new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)"healing_machine")), 1));
                break;
            }
        }
        return list;
    }

    private static class AppIcon {
        public int x;
        public int y;
        public final String name;
        public final String description;

        public AppIcon(int x, int y, String name, String description) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.description = description;
        }
    }
}

