/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.Random;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DreamStringEventHandler {
    private static final Random RANDOM = new Random();
    private static final float DROP_CHANCE = 0.1f;

    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon faintedPokemon = event.getPokemon();
                if (faintedPokemon == null) {
                    return Unit.INSTANCE;
                }
                if (faintedPokemon.getOwnerUUID() == null) {
                    DreamStringEventHandler.processWildPokemonDefeat(faintedPokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error processing Pok\u00e9mon fainted event for Dream String", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        LegendaryMonuments.LOGGER.info("Registered Dream String drop handler");
    }

    private static void processWildPokemonDefeat(Pokemon defeatedPokemon) {
        try {
            if (defeatedPokemon.getEntity() != null && defeatedPokemon.getEntity().method_37908() != null) {
                defeatedPokemon.getEntity().method_37908().method_18456().forEach(player -> {
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        double distance = player.method_5739((class_1297)defeatedPokemon.getEntity());
                        if (distance <= 32.0) {
                            DreamStringEventHandler.maybeDropDreamString(serverPlayer);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Could not process wild pokemon defeat for Dream String drop", (Throwable)e);
        }
    }

    private static void maybeDropDreamString(class_3222 player) {
        try {
            long timeOfDay = player.method_37908().method_8532() % 24000L;
            if (timeOfDay >= 13000L && timeOfDay <= 23000L && RANDOM.nextFloat() < 0.1f) {
                LegendaryMonuments.LOGGER.info("Player {} defeated a Pok\u00e9mon at night, dropping Dream String", (Object)player.method_5477().getString());
                class_1799 dreamString = new class_1799((class_1935)ModItems.DREAM_STRING);
                player.method_31548().method_7394(dreamString);
                player.method_7353((class_2561)class_2561.method_43471((String)"item.legendarymonuments.dream_string.drop"), false);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error attempting to drop Dream String for player {}", (Object)player.method_5477().getString(), (Object)e);
        }
    }
}

