/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.data.KeyItemsDataManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class KeyItemsEventHandler {
    public static void register() {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            if (player != null) {
                try {
                    class_3218 world = (class_3218)player.method_37908();
                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                    dataManager.method_80();
                    LegendaryMonuments.LOGGER.info("Triggered save for disconnecting player: {}", (Object)player.method_5477().getString());
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Error saving key items data for disconnecting player: {}", (Object)player.method_5477().getString(), (Object)e);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LegendaryMonuments.LOGGER.info("Server stopping, performing final save of all key items data...");
            try {
                for (class_3218 world : server.method_3738()) {
                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                    dataManager.method_80();
                    LegendaryMonuments.LOGGER.info("Final save triggered for world: {}", (Object)world.method_27983().method_29177());
                }
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error during final save of key items data", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Thread autoSaveThread = new Thread(() -> {
                while (!server.method_3750()) {
                    try {
                        Thread.sleep(300000L);
                        if (server.method_3750()) continue;
                        server.execute(() -> {
                            try {
                                for (class_3218 world : server.method_3738()) {
                                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                                    dataManager.method_80();
                                }
                                LegendaryMonuments.LOGGER.debug("Periodic key items auto-save completed");
                            }
                            catch (Exception e) {
                                LegendaryMonuments.LOGGER.error("Error in periodic auto-save", (Throwable)e);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            });
            autoSaveThread.setDaemon(true);
            autoSaveThread.setName("KeyItems-AutoSave");
            autoSaveThread.start();
            LegendaryMonuments.LOGGER.info("Key Items auto-save thread started (5-minute intervals)");
        });
    }
}

