/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import github.jorgaomc.util.PerfectIvHelper;
import github.jorgaomc.world.dimension.HallOfOriginTeleporter;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AzureFluteTeleporter {
    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31574(ModItems.AZURE_FLUTE)) {
                if (!world.method_8608() && player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    LegendaryMonuments.LOGGER.info("Player {} used Azure Flute", (Object)player.method_5477().getString());
                    if (world.method_27983() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY) {
                        HallOfOriginTeleporter.teleportFromHallOfOrigin(serverPlayer);
                    } else {
                        HallOfOriginTeleporter.teleportToHallOfOrigin(serverPlayer);
                        serverPlayer.method_6092(new class_1293(class_1294.field_5919, 60, 4, false, false));
                        if (!serverPlayer.method_7337()) {
                            stack.method_7934(1);
                        }
                        MinecraftServer server = serverPlayer.method_5682();
                        server.execute(() -> AzureFluteTeleporter.scheduleTask(server, 60, () -> {
                            try {
                                class_3218 targetWorld = server.method_3847(HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY);
                                if (targetWorld == null) {
                                    LegendaryMonuments.LOGGER.warn("Hall of Origin world not found; cannot spawn Arceus");
                                    return;
                                }
                                List stands = targetWorld.method_8390(class_1531.class, new class_238(-3.0E7, -64.0, -3.0E7, 3.0E7, 320.0, 3.0E7), e -> {
                                    if (e.method_5797() == null) {
                                        return false;
                                    }
                                    String n = e.method_5797().getString();
                                    return n != null && n.toLowerCase(Locale.ROOT).equals("arceus");
                                });
                                if (stands.isEmpty()) {
                                    LegendaryMonuments.LOGGER.warn("No armor stand named 'arceus' found; Arceus not spawned");
                                    return;
                                }
                                class_1531 anchor = (class_1531)stands.get(0);
                                PokemonProperties properties = new PokemonProperties();
                                properties.setSpecies("Arceus");
                                properties.setLevel(Integer.valueOf(90));
                                try {
                                    properties.setMoves(List.of("punishment", "judgment", "refresh", "cosmicpower"));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                Pokemon pokemon = properties.create();
                                PokemonEntity entity = new PokemonEntity((class_1937)targetWorld, pokemon, CobblemonEntities.POKEMON);
                                PerfectIvHelper.enforceAtLeastThreePerfectIvs(entity);
                                entity.method_5814(anchor.method_23317(), anchor.method_23318(), anchor.method_23321());
                                try {
                                    entity.method_5971();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                targetWorld.method_8649((class_1297)entity);
                                LegendaryMonuments.LOGGER.info("Spawned Arceus at armor stand position in Hall of Origin");
                            }
                            catch (Exception ex) {
                                LegendaryMonuments.LOGGER.error("Failed to spawn Arceus via Azure Flute", (Throwable)ex);
                            }
                        }));
                    }
                    player.method_7357().method_7906(ModItems.AZURE_FLUTE, 40);
                }
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
        LegendaryMonuments.LOGGER.info("Registered Azure Flute teleporter callbacks");
    }

    private static void scheduleTask(MinecraftServer server, int ticks, Runnable task) {
        new Thread(() -> {
            try {
                Thread.sleep((long)ticks * 50L);
                server.execute(task);
            }
            catch (InterruptedException e) {
                LegendaryMonuments.LOGGER.error("Task scheduling interrupted", (Throwable)e);
            }
        }).start();
    }
}

