/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class KeldeoDangoItem
extends class_1792 {
    private static final double SHINY_CHANCE = 0.02;

    public KeldeoDangoItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        boolean successful = this.spawnKeldeo(world, player);
        if (successful) {
            world.method_8396(null, player.method_24515(), class_3417.field_14703, class_3419.field_15248, 1.0f, 1.0f);
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    private boolean spawnKeldeo(class_1937 world, class_1657 player) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)world;
        try {
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("Keldeo");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            try {
                properties.setMoves(List.of("secretsword", "calmmind", "surf", "lowkick"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Method m = null;
                try {
                    m = PokemonProperties.class.getMethod("setPerfectIVs", Integer.TYPE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (m == null) {
                    try {
                        m = PokemonProperties.class.getMethod("setPerfectIvs", Integer.TYPE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (m == null) {
                    try {
                        m = PokemonProperties.class.getMethod("setGuaranteedPerfectIvs", Integer.TYPE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (m == null) {
                    try {
                        m = PokemonProperties.class.getMethod("setGuaranteedIVs", Integer.TYPE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (m != null) {
                    m.invoke((Object)properties, 3);
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            Pokemon pokemon = properties.create();
            try {
                this.applyThreeRandomPerfectIVs(pokemon);
            }
            catch (Throwable t) {
                try {
                    LegendaryMonuments.LOGGER.warn("Couldn't set Keldeo IVs to 3 perfect via reflection: {}", (Object)t.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            PokemonEntity entity = new PokemonEntity((class_1937)serverWorld, pokemon, CobblemonEntities.POKEMON);
            try {
                this.enforceThreePerfectIvsViaNbt(entity);
            }
            catch (Throwable t) {
                try {
                    LegendaryMonuments.LOGGER.warn("NBT fallback to set Keldeo IVs failed: {}", (Object)t.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            double spawnX = player.method_23317() + player.method_5720().field_1352 * 3.0;
            double spawnY = player.method_23318() + 1.0;
            double spawnZ = player.method_23321() + player.method_5720().field_1350 * 3.0;
            this.spawnKeldeoEffect(serverWorld, new class_2338((int)spawnX, (int)spawnY, (int)spawnZ));
            entity.method_5814(spawnX, spawnY, spawnZ);
            serverWorld.method_8649((class_1297)entity);
            if (isShiny) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Curry of Justice tasted amazingly! ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"A SHINY Keldeo appears!").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Curry of Justice tasted great! ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"A Keldeo appears!").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067})), false);
            }
            LegendaryMonuments.LOGGER.info("Spawned {} Keldeo for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.method_5477().getString());
            return true;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Keldeo", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)"The Curry of Justice fizzles out unsuccessfully.").method_27692(class_124.field_1061), true);
            return false;
        }
    }

    private void applyThreeRandomPerfectIVs(Pokemon pokemon) {
        block55: {
            Object ivContainer;
            block54: {
                Method m = null;
                try {
                    m = pokemon.getClass().getMethod("setPerfectIVs", Integer.TYPE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (m == null) {
                    try {
                        m = pokemon.getClass().getMethod("setPerfectIvs", Integer.TYPE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (m == null) {
                    try {
                        m = pokemon.getClass().getMethod("setGuaranteedPerfectIvs", Integer.TYPE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (m == null) {
                    try {
                        m = pokemon.getClass().getMethod("setGuaranteedIVs", Integer.TYPE);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (m != null) {
                    m.invoke((Object)pokemon, 3);
                    return;
                }
                ivContainer = null;
                try {
                    ivContainer = pokemon.getClass().getMethod("getIvs", new Class[0]).invoke((Object)pokemon, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (ivContainer == null) {
                    try {
                        ivContainer = pokemon.getClass().getMethod("getIVs", new Class[0]).invoke((Object)pokemon, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (ivContainer == null) {
                    try {
                        Object stats = pokemon.getClass().getMethod("getStats", new Class[0]).invoke((Object)pokemon, new Object[0]);
                        if (stats == null) break block54;
                        try {
                            ivContainer = stats.getClass().getMethod("getIvs", new Class[0]).invoke(stats, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (ivContainer == null) {
                            try {
                                ivContainer = stats.getClass().getMethod("getIVs", new Class[0]).invoke(stats, new Object[0]);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable stats) {
                        // empty catch block
                    }
                }
            }
            String[] all = new String[]{"hp", "atk", "def", "spa", "spd", "spe"};
            ArrayList list = new ArrayList();
            Collections.addAll(list, all);
            Collections.shuffle(list, new Random());
            HashSet<String> chosen = new HashSet<String>();
            for (int i = 0; i < 3 && i < list.size(); ++i) {
                chosen.add((String)list.get(i));
            }
            if (ivContainer == null) break block55;
            for (String stat : chosen) {
                Method sm2;
                boolean set = false;
                String camel = switch (stat) {
                    case "hp" -> "Hp";
                    case "atk" -> "Atk";
                    case "def" -> "Def";
                    case "spa" -> "Spa";
                    case "spd" -> "Spd";
                    default -> "Spe";
                };
                try {
                    sm2 = ivContainer.getClass().getMethod("set" + camel, Integer.TYPE);
                    sm2.invoke(ivContainer, 31);
                    set = true;
                }
                catch (Throwable sm2) {
                    // empty catch block
                }
                if (!set) {
                    try {
                        sm2 = ivContainer.getClass().getMethod("set", String.class, Integer.TYPE);
                        sm2.invoke(ivContainer, stat, 31);
                        set = true;
                    }
                    catch (Throwable sm3) {
                        // empty catch block
                    }
                }
                if (set) continue;
                try {
                    Method pm = ivContainer.getClass().getMethod("put", Object.class, Object.class);
                    pm.invoke(ivContainer, stat, 31);
                    set = true;
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        try {
            Method gm = pokemon.getClass().getMethod("setStatIv", String.class, Integer.TYPE);
            String[] all2 = new String[]{"hp", "atk", "def", "spa", "spd", "spe"};
            List<String> l2 = Arrays.asList(all2);
            Collections.shuffle(l2, new Random());
            for (int i = 0; i < 3 && i < l2.size(); ++i) {
                gm.invoke((Object)pokemon, l2.get(i), 31);
            }
            return;
        }
        catch (Throwable throwable) {
            try {
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    private void enforceThreePerfectIvsViaNbt(PokemonEntity entity) {
        try {
            class_2487 ivsData;
            class_2487 nbt = new class_2487();
            try {
                entity.method_5647(nbt);
            }
            catch (Throwable t) {
                try {
                    Method wm = entity.getClass().getMethod("writeNbt", class_2487.class);
                    wm.invoke((Object)entity, nbt);
                }
                catch (Throwable t2) {
                    try {
                        Method wm2 = entity.getClass().getMethod("saveNbt", class_2487.class);
                        wm2.invoke((Object)entity, nbt);
                    }
                    catch (Throwable ignored) {
                        return;
                    }
                }
            }
            if (!nbt.method_10545("Pokemon")) {
                try {
                    LegendaryMonuments.LOGGER.warn("Pokemon NBT tag not found in entity");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            class_2487 pokemonData = nbt.method_10562("Pokemon");
            if (!pokemonData.method_10545("IVs")) {
                pokemonData.method_10566("IVs", (class_2520)new class_2487());
            }
            if (!(ivsData = pokemonData.method_10562("IVs")).method_10545("Base")) {
                ivsData.method_10566("Base", (class_2520)new class_2487());
            }
            class_2487 baseIvs = ivsData.method_10562("Base");
            String[] allStats = new String[]{"cobblemon:hp", "cobblemon:attack", "cobblemon:defence", "cobblemon:special_attack", "cobblemon:special_defence", "cobblemon:speed"};
            ArrayList statList = new ArrayList();
            Collections.addAll(statList, allStats);
            Collections.shuffle(statList, new Random());
            for (int i = 0; i < 3 && i < statList.size(); ++i) {
                baseIvs.method_10569((String)statList.get(i), 31);
            }
            ivsData.method_10566("Base", (class_2520)baseIvs);
            pokemonData.method_10566("IVs", (class_2520)ivsData);
            nbt.method_10566("Pokemon", (class_2520)pokemonData);
            boolean applied = false;
            try {
                entity.method_5651(nbt);
                applied = true;
            }
            catch (Throwable t) {
                try {
                    Method rm = entity.getClass().getMethod("readNbt", class_2487.class);
                    rm.setAccessible(true);
                    rm.invoke((Object)entity, nbt);
                    applied = true;
                }
                catch (Throwable t2) {
                    try {
                        Method rm2 = entity.getClass().getMethod("readCustomDataFromNbt", class_2487.class);
                        rm2.setAccessible(true);
                        rm2.invoke((Object)entity, nbt);
                        applied = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (!applied) {
                try {
                    LegendaryMonuments.LOGGER.warn("Could not apply NBT to set Keldeo IVs; spawn will continue without change");
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    LegendaryMonuments.LOGGER.info("Successfully applied 3 perfect IVs to Keldeo via NBT");
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable outer) {
            try {
                LegendaryMonuments.LOGGER.warn("Failed NBT IV enforcement for Keldeo: {}", (Object)outer.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.curry_of_justice.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.curry_of_justice.tooltip.2").method_27692(class_124.field_1078));
        super.method_7851(stack, context, tooltip, type);
    }

    private void spawnKeldeoEffect(class_3218 world, class_2338 pos) {
        class_5819 random = world.method_8409();
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14987, class_3419.field_15254, 1.0f, 1.2f);
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14887, class_3419.field_15254, 1.0f, 1.0f);
        class_2168 source = world.method_8503().method_3739().method_9208(pos.method_46558()).method_9227(world).method_9217();
        for (int height = 0; height < 8; ++height) {
            int h = height;
            world.method_8503().execute(() -> world.method_8503().method_3734().method_44252(source, "particle minecraft:splash ~ " + ((double)pos.method_10264() + (double)h * 0.5) + " ~ 1 0.1 1 0.1 20 force"));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.method_8503().method_3734().method_44252(source, "particle minecraft:dust 0.0 0.6 1.0 1.5 ~ ~1 ~ 3 2 3 0.05 100 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:dust 0.9 0.2 0.3 1.0 ~ ~1 ~ 3 2 3 0.05 70 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:splash ~ ~1 ~ 3 2 3 0.4 150 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:bubble_column_up ~ ~1 ~ 2 2 2 0.2 100 force");
        for (int i = 0; i < 24; ++i) {
            double angle = (double)i * Math.PI / 12.0;
            double distance = 3.0;
            double x = (double)pos.method_10263() + Math.cos(angle) * distance;
            double z = (double)pos.method_10260() + Math.sin(angle) * distance;
            world.method_8503().method_3734().method_44252(source, "particle minecraft:dust 0.6 0.5 0.2 1.0 " + x + " " + ((double)pos.method_10264() + 0.1) + " " + z + " 0.2 0.0 0.2 0 1 force");
        }
        world.method_8503().execute(() -> {
            try {
                Thread.sleep(300L);
                world.method_8503().method_3734().method_44252(source, "particle minecraft:splash ~ ~1 ~ 2 2 2 0.2 80 force");
                world.method_8503().method_3734().method_44252(source, "particle minecraft:end_rod ~ ~1.5 ~ 0.2 1.5 0.2 0.05 50 force");
                world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14831, class_3419.field_15254, 1.0f, 1.0f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

