/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModDataComponentTypes;
import github.jorgaomc.ModItems;
import github.jorgaomc.component.UrnProgressComponent;
import github.jorgaomc.util.PerfectIvHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class UrnItem
extends class_1792 {
    private final String pokemonName;
    private final String pokemonType;
    private final boolean isGalarian;
    private final int requiredProgress;
    private static final class_3414 THUNDER_SOUND = class_3417.field_14865;
    private static final class_3414 EXPLODE_SOUND = (class_3414)class_3417.field_15152.comp_349();
    private static final class_3419 AMBIENT = class_3419.field_15256;

    public UrnItem(String pokemonName, String pokemonType, boolean isGalarian) {
        super(new class_1792.class_1793().method_7889(1).method_57349(ModDataComponentTypes.URN_PROGRESS_COMPONENT, (Object)new UrnProgressComponent(0)));
        this.pokemonName = pokemonName;
        this.pokemonType = pokemonType;
        this.isGalarian = isGalarian;
        this.requiredProgress = isGalarian ? 75 : 50;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        UrnProgressComponent progressComponent = (UrnProgressComponent)stack.method_57825(ModDataComponentTypes.URN_PROGRESS_COMPONENT, (Object)new UrnProgressComponent(0));
        if (progressComponent.isComplete(this.requiredProgress)) {
            this.spawnLegendaryPokemon(world, player);
            stack.method_7934(1);
            return class_1271.method_22427((Object)stack);
        }
        class_124 progressColor = UrnItem.getTypeFormatting(this.pokemonType);
        player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.progress", (Object[])new Object[]{progressComponent.progress(), this.requiredProgress}).method_27692(progressColor), true);
        return class_1271.method_22427((Object)stack);
    }

    private void spawnLegendaryPokemon(class_1937 world, class_1657 player) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        Random random = new Random();
        boolean isShiny = random.nextDouble() < 0.02;
        double spawnX = player.method_23317() + player.method_5720().field_1352 * 3.0;
        double spawnY = player.method_23318() + 1.0;
        double spawnZ = player.method_23321() + player.method_5720().field_1350 * 3.0;
        try {
            this.spawnLegendaryBirdEffect(serverWorld, player, new class_2338((int)spawnX, (int)spawnY, (int)spawnZ), this.pokemonType);
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error creating particle effect for {}", (Object)this.pokemonName, (Object)e);
        }
        if (this.isGalarian) {
            this.spawnGalarianPokemon(serverWorld, player, isShiny);
        } else {
            this.spawnRegularPokemon(serverWorld, player, isShiny);
        }
        if (this.pokemonName.equalsIgnoreCase("moltres")) {
            player.method_31548().method_7398(new class_1799((class_1935)ModItems.MOLTEN_STONE));
            player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.stone.received", (Object[])new Object[]{"Molten Stone"}).method_27692(class_124.field_1061), false);
        } else if (this.pokemonName.equalsIgnoreCase("articuno")) {
            player.method_31548().method_7398(new class_1799((class_1935)ModItems.ARCTIC_STONE));
            player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.stone.received", (Object[])new Object[]{"Arctic Stone"}).method_27692(class_124.field_1075), false);
        } else if (this.pokemonName.equalsIgnoreCase("zapdos")) {
            player.method_31548().method_7398(new class_1799((class_1935)ModItems.ZAP_STONE));
            player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.stone.received", (Object[])new Object[]{"Zap Stone"}).method_27692(class_124.field_1054), false);
        }
    }

    private void spawnRegularPokemon(class_3218 world, class_1657 player, boolean isShiny) {
        try {
            Pokemon pokemon;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies(this.pokemonName.toLowerCase());
            properties.setLevel(Integer.valueOf(40));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            if ((pokemon = properties.create()) == null) {
                LegendaryMonuments.LOGGER.error("Failed to create Pok\u00e9mon object for {}", (Object)this.pokemonName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to summon Pok\u00e9mon").method_27692(class_124.field_1061), true);
                return;
            }
            this.removeMementoMove(pokemon);
            PokemonEntity entity = new PokemonEntity((class_1937)world, pokemon, CobblemonEntities.POKEMON);
            PerfectIvHelper.enforceAtLeastThreePerfectIvs(entity);
            if (entity == null) {
                LegendaryMonuments.LOGGER.error("Failed to create entity for {}", (Object)this.pokemonName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to summon Pok\u00e9mon").method_27692(class_124.field_1061), true);
                return;
            }
            double spawnX = player.method_23317() + player.method_5720().field_1352 * 3.0;
            double spawnY = player.method_23318() + 1.0;
            double spawnZ = player.method_23321() + player.method_5720().field_1350 * 3.0;
            entity.method_5814(spawnX, spawnY, spawnZ);
            boolean spawned = world.method_8649((class_1297)entity);
            if (!spawned) {
                LegendaryMonuments.LOGGER.error("Failed to spawn {} for player {}", (Object)this.pokemonName, (Object)player.method_5477().getString());
                int x = (int)Math.floor(spawnX);
                int y = (int)Math.floor(spawnY);
                int z = (int)Math.floor(spawnZ);
                String command = "pokespawnat " + x + " " + y + " " + z + " " + this.pokemonName + " lvl=40 move1=!memento";
                if (isShiny) {
                    command = command + " shiny";
                }
                world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), command);
            }
            class_124 typeColor = UrnItem.getTypeFormatting(this.pokemonType);
            String pokemonDisplayName = this.pokemonName.substring(0, 1).toUpperCase() + this.pokemonName.substring(1);
            if (isShiny) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u2728 ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.spawned.shiny", (Object[])new Object[]{pokemonDisplayName}).method_27692(typeColor)), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.spawned", (Object[])new Object[]{pokemonDisplayName}).method_27692(typeColor), false);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error spawning {}", (Object)this.pokemonName, (Object)e);
            player.method_7353((class_2561)class_2561.method_43470((String)"Failed to summon Pok\u00e9mon").method_27692(class_124.field_1061), true);
        }
    }

    private void spawnGalarianPokemon(class_3218 world, class_1657 player, boolean isShiny) {
        try {
            PokemonProperties properties;
            Pokemon pokemon;
            double spawnX = player.method_23317() + player.method_5720().field_1352 * 3.0;
            double spawnY = player.method_23318() + 1.0;
            double spawnZ = player.method_23321() + player.method_5720().field_1350 * 3.0;
            String propertiesString = this.pokemonName.toLowerCase() + " galarian=true level=50";
            if (isShiny) {
                propertiesString = propertiesString + " shiny=true";
            }
            if ((pokemon = (properties = PokemonProperties.Companion.parse(propertiesString)).create()) == null) {
                LegendaryMonuments.LOGGER.error("Failed to create Galarian Pok\u00e9mon object for {}", (Object)this.pokemonName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to summon Galarian Pok\u00e9mon").method_27692(class_124.field_1061), true);
                return;
            }
            this.removeMementoMove(pokemon);
            PokemonEntity entity = new PokemonEntity((class_1937)world, pokemon, CobblemonEntities.POKEMON);
            PerfectIvHelper.enforceAtLeastThreePerfectIvs(entity);
            if (entity == null) {
                LegendaryMonuments.LOGGER.error("Failed to create entity for Galarian {}", (Object)this.pokemonName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to summon Galarian Pok\u00e9mon").method_27692(class_124.field_1061), true);
                return;
            }
            entity.method_5814(spawnX, spawnY, spawnZ);
            boolean spawned = world.method_8649((class_1297)entity);
            if (!spawned) {
                LegendaryMonuments.LOGGER.error("Failed to spawn Galarian {} for player {}", (Object)this.pokemonName, (Object)player.method_5477().getString());
            }
            class_124 typeColor = UrnItem.getTypeFormatting(this.pokemonType);
            String pokemonDisplayName = "Galarian " + this.pokemonName.substring(0, 1).toUpperCase() + this.pokemonName.substring(1);
            if (isShiny) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u2728 ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.spawned.shiny", (Object[])new Object[]{pokemonDisplayName}).method_27692(typeColor)), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.spawned", (Object[])new Object[]{pokemonDisplayName}).method_27692(typeColor), false);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error spawning Galarian {}", (Object)this.pokemonName, (Object)e);
            player.method_7353((class_2561)class_2561.method_43470((String)"Failed to summon Galarian Pok\u00e9mon").method_27692(class_124.field_1061), true);
        }
    }

    private void removeMementoMove(Pokemon pokemon) {
        try {
            MoveSet moveSet = pokemon.getMoveSet();
            for (int i = 0; i < 4; ++i) {
                Move move = moveSet.get(i);
                if (move == null || !"memento".equalsIgnoreCase(move.getName())) continue;
                moveSet.setMove(i, null);
                LegendaryMonuments.LOGGER.info("Removed Memento move from spawned {}", (Object)this.pokemonName);
                break;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to remove Memento move from {}: {}", (Object)this.pokemonName, (Object)e.getMessage());
        }
    }

    public String getPokemonType() {
        return this.pokemonType;
    }

    public int getRequiredProgress() {
        return this.requiredProgress;
    }

    public static class_124 getTypeFormatting(String type) {
        return switch (type.toLowerCase()) {
            case "fire" -> class_124.field_1061;
            case "electric" -> class_124.field_1054;
            case "ice" -> class_124.field_1075;
            case "water" -> class_124.field_1078;
            case "grass" -> class_124.field_1060;
            case "poison" -> class_124.field_1064;
            case "fairy" -> class_124.field_1076;
            case "fighting" -> class_124.field_1065;
            case "psychic" -> class_124.field_1076;
            case "ghost" -> class_124.field_1064;
            case "dark" -> class_124.field_1064;
            case "dragon" -> class_124.field_1079;
            case "ground" -> class_124.field_1065;
            case "rock" -> class_124.field_1080;
            case "steel" -> class_124.field_1080;
            default -> class_124.field_1068;
        };
    }

    private void spawnLegendaryBirdEffect(class_3218 world, class_1657 player, class_2338 pos, String elementType) {
        class_5819 random = world.method_8409();
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), THUNDER_SOUND, AMBIENT, 1.0f, 0.8f);
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), EXPLODE_SOUND, AMBIENT, 0.7f, 1.2f);
        class_2168 source = world.method_8503().method_3739().method_9208(pos.method_46558()).method_9227(world).method_9217();
        for (int i = 0; i < 5; ++i) {
            int delay = i * 10;
            world.method_8503().execute(() -> {
                try {
                    Thread.sleep(delay);
                    for (int j = 0; j < 36; ++j) {
                        double angle = (double)j * Math.PI / 18.0;
                        double radius = 3.0;
                        double x = (double)pos.method_10263() + Math.cos(angle) * radius;
                        double z = (double)pos.method_10260() + Math.sin(angle) * radius;
                        world.method_8503().method_3734().method_44252(source, String.format("particle minecraft:cloud %s %s %s 0.2 0.2 0.2 0.02 1 force", x, (double)pos.method_10264() + 1.5, z));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        switch (elementType.toLowerCase()) {
            case "fire": {
                this.createFireBirdEffect(world, source, pos);
                break;
            }
            case "electric": {
                this.createElectricBirdEffect(world, source, pos);
                break;
            }
            case "ice": {
                this.createIceBirdEffect(world, source, pos);
                break;
            }
            default: {
                world.method_8503().method_3734().method_44252(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.1 50 force");
                world.method_8503().method_3734().method_44252(source, "particle minecraft:explosion ~ ~1 ~ 2 2 2 0.1 10 force");
            }
        }
    }

    private void createFireBirdEffect(class_3218 world, class_2168 source, class_2338 pos) {
        world.method_8503().method_3734().method_44252(source, "particle minecraft:flame ~ ~1 ~ 3 2 3 0.1 100 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:lava ~ ~1 ~ 2 1 2 0.1 30 force");
        for (int height = 0; height < 8; ++height) {
            int h = height;
            world.method_8503().execute(() -> world.method_8503().method_3734().method_44252(source, "particle minecraft:flame ~ " + ((double)pos.method_10264() + (double)h * 0.5) + " ~ 1 0.1 1 0.1 20 force"));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14970, AMBIENT, 1.0f, 0.8f);
    }

    private void createElectricBirdEffect(class_3218 world, class_2168 source, class_2338 pos) {
        for (int i = 0; i < 5; ++i) {
            double offsetX = (world.method_8409().method_43058() - 0.5) * 5.0;
            double offsetZ = (world.method_8409().method_43058() - 0.5) * 5.0;
            class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
            lightning.method_24203((double)pos.method_10263() + offsetX, (double)pos.method_10264(), (double)pos.method_10260() + offsetZ);
            lightning.method_29498(true);
            world.method_8649((class_1297)lightning);
        }
        world.method_8503().method_3734().method_44252(source, "particle minecraft:electric_spark ~ ~1 ~ 3 2 3 0.5 100 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:flash ~ ~1 ~ 0.3 0.3 0.3 0.1 10 force");
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14956, AMBIENT, 1.0f, 1.0f);
    }

    private void createIceBirdEffect(class_3218 world, class_2168 source, class_2338 pos) {
        world.method_8503().method_3734().method_44252(source, "particle minecraft:snowflake ~ ~1 ~ 3 2 3 0.05 150 force");
        world.method_8503().method_3734().method_44252(source, "particle minecraft:item_snowball ~ ~1 ~ 3 2 3 0.1 100 force");
        for (int radius = 1; radius < 8; radius += 2) {
            int r = radius;
            world.method_8503().execute(() -> {
                for (int i = 0; i < 36; ++i) {
                    double angle = (double)i * Math.PI / 18.0;
                    double x = (double)pos.method_10263() + Math.cos(angle) * (double)r;
                    double z = (double)pos.method_10260() + Math.sin(angle) * (double)r;
                    world.method_8503().method_3734().method_44252(source, String.format("particle minecraft:dust 0.8 0.9 1.0 1.5 %s %s %s 0.1 0.0 0.1 0 1 force", x, (double)pos.method_10264() + 0.1, z));
                }
            });
            try {
                Thread.sleep(75L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15081, AMBIENT, 1.0f, 0.6f);
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_26980, AMBIENT, 1.0f, 0.8f);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (!stack.method_57826(ModDataComponentTypes.URN_PROGRESS_COMPONENT)) {
            return;
        }
        UrnProgressComponent progressComponent = (UrnProgressComponent)stack.method_57824(ModDataComponentTypes.URN_PROGRESS_COMPONENT);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.tooltip.type", (Object[])new Object[]{this.pokemonType}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.legendarymonuments.urn.tooltip.progress", (Object[])new Object[]{progressComponent.progress(), this.requiredProgress}).method_27692(progressComponent.isComplete(this.requiredProgress) ? class_124.field_1060 : class_124.field_1054));
        if (progressComponent.isComplete(this.requiredProgress)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.urn.tooltip.ready").method_27692(class_124.field_1060));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.legendarymonuments.urn.tooltip.instruction").method_27692(class_124.field_1080));
        }
        super.method_7851(stack, context, tooltip, type);
    }
}

