/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class HealCooldowns {
    private static final HealCooldowns INSTANCE = new HealCooldowns();
    private final Map<UUID, Long> lastHealUse = new HashMap<UUID, Long>();

    private HealCooldowns() {
    }

    public static HealCooldowns getInstance() {
        return INSTANCE;
    }

    public long getLastHealUse(UUID playerUuid) {
        return this.lastHealUse.getOrDefault(playerUuid, 0L);
    }

    public void setLastHealUse(UUID playerUuid, long time) {
        this.lastHealUse.put(playerUuid, time);
    }

    public void clearLastHealUse(UUID playerUuid) {
        this.lastHealUse.remove(playerUuid);
    }

    public void clearAll() {
        this.lastHealUse.clear();
    }

    public int getRemainingCooldown(UUID playerUuid, int cooldownSeconds) {
        long lastUse;
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeElapsed = currentTime - (lastUse = this.getLastHealUse(playerUuid));
        if (timeElapsed >= (long)cooldownSeconds) {
            return 0;
        }
        return (int)((long)cooldownSeconds - timeElapsed);
    }
}

