/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.network.HealCooldowns;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record HealPacket() implements class_8710
{
    public static final class_8710.class_9154<HealPacket> ID = new class_8710.class_9154(class_2960.method_60655((String)"legendarymonuments", (String)"heal"));
    public static final class_9139<class_9129, HealPacket> CODEC = class_9139.method_56431((Object)new HealPacket());
    private static final int COOLDOWN_SECONDS = 600;

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void sendToServer() {
        ClientPlayNetworking.send((class_8710)new HealPacket());
    }

    public static void registerPayload() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            server.execute(() -> {
                try {
                    long currentTime = System.currentTimeMillis() / 1000L;
                    long lastUse = HealCooldowns.getInstance().getLastHealUse(player.method_5667());
                    long timeElapsed = currentTime - lastUse;
                    if (timeElapsed < 600L) {
                        int remainingSeconds = (int)(600L - timeElapsed);
                        player.method_7353((class_2561)class_2561.method_43470((String)(remainingSeconds + " seconds left until you can heal your Pok\u00e9mon again")).method_10862(class_2583.field_24360.method_36139(16580864)), true);
                        LegendaryMonuments.LOGGER.info("Player {} tried to heal but must wait {} more seconds", (Object)player.method_5477().getString(), (Object)remainingSeconds);
                        return;
                    }
                    if (PlayerExtensionsKt.isInBattle((class_3222)player)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"You cannot heal your Pok\u00e9mon while in battle!").method_10862(class_2583.field_24360.method_36139(16580864)), true);
                        LegendaryMonuments.LOGGER.info("Player {} tried to heal while in battle", (Object)player.method_5477().getString());
                        return;
                    }
                    HealCooldowns.getInstance().setLastHealUse(player.method_5667(), currentTime);
                    PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
                    party.heal();
                    player.method_7353((class_2561)class_2561.method_43470((String)"Your Pok\u00e9mon have been healed!").method_10862(class_2583.field_24360.method_36139(65280)), true);
                    LegendaryMonuments.LOGGER.info("Healed all Pok\u00e9mon for player {} via Arc Phone", (Object)player.method_5477().getString());
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Failed to heal Pok\u00e9mon for player " + player.method_5477().getString(), (Throwable)e);
                    player.method_7353((class_2561)class_2561.method_43470((String)"Failed to heal your Pok\u00e9mon. Please try again.").method_10862(class_2583.field_24360.method_36139(16580864)), true);
                }
            });
        });
    }
}

