/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.util;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import github.jorgaomc.LegendaryMonuments;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class PerfectIvHelper {
    private PerfectIvHelper() {
    }

    public static void enforceAtLeastThreePerfectIvs(PokemonEntity entity) {
        try {
            class_2487 ivsData;
            class_2487 nbt = new class_2487();
            boolean wrote = false;
            try {
                entity.method_5647(nbt);
                wrote = true;
            }
            catch (Throwable t) {
                try {
                    Method wm = entity.getClass().getMethod("writeNbt", class_2487.class);
                    wm.invoke((Object)entity, nbt);
                    wrote = true;
                }
                catch (Throwable t2) {
                    try {
                        Method wm2 = entity.getClass().getMethod("saveNbt", class_2487.class);
                        wm2.invoke((Object)entity, nbt);
                        wrote = true;
                    }
                    catch (Throwable wm2) {
                        // empty catch block
                    }
                }
            }
            if (!wrote) {
                return;
            }
            if (!nbt.method_10545("Pokemon")) {
                try {
                    LegendaryMonuments.LOGGER.warn("Pokemon NBT tag not found in entity while enforcing IVs");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            class_2487 pokemonData = nbt.method_10562("Pokemon");
            if (!pokemonData.method_10545("IVs")) {
                pokemonData.method_10566("IVs", (class_2520)new class_2487());
            }
            if (!(ivsData = pokemonData.method_10562("IVs")).method_10545("Base")) {
                ivsData.method_10566("Base", (class_2520)new class_2487());
            }
            class_2487 baseIvs = ivsData.method_10562("Base");
            String[] allStats = new String[]{"cobblemon:hp", "cobblemon:attack", "cobblemon:defence", "cobblemon:special_attack", "cobblemon:special_defence", "cobblemon:speed"};
            ArrayList statList = new ArrayList();
            Collections.addAll(statList, allStats);
            Collections.shuffle(statList, new Random());
            for (int i = 0; i < 3 && i < statList.size(); ++i) {
                baseIvs.method_10569((String)statList.get(i), 31);
            }
            ivsData.method_10566("Base", (class_2520)baseIvs);
            pokemonData.method_10566("IVs", (class_2520)ivsData);
            nbt.method_10566("Pokemon", (class_2520)pokemonData);
            boolean applied = false;
            try {
                entity.method_5651(nbt);
                applied = true;
            }
            catch (Throwable t) {
                try {
                    Method rm = entity.getClass().getMethod("readNbt", class_2487.class);
                    rm.setAccessible(true);
                    rm.invoke((Object)entity, nbt);
                    applied = true;
                }
                catch (Throwable t2) {
                    try {
                        Method rm2 = entity.getClass().getMethod("readCustomDataFromNbt", class_2487.class);
                        rm2.setAccessible(true);
                        rm2.invoke((Object)entity, nbt);
                        applied = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (!applied) {
                try {
                    LegendaryMonuments.LOGGER.warn("Failed to apply NBT for perfect IV enforcement");
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    LegendaryMonuments.LOGGER.debug("Applied at least three perfect IVs via NBT");
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable outer) {
            try {
                LegendaryMonuments.LOGGER.warn("IV enforcement error: {}", (Object)outer.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

