/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.ModBlocks;
import github.jorgaomc.world.feature.DistortionTreeFeature;
import github.jorgaomc.world.feature.MiniMountainFeature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;

public class DistortionIslandDecorationFeature
extends class_3031<Config> {
    private static final int SEARCH_RADIUS = 40;
    private static final int MIN_ISLAND_SIZE = 25;

    public DistortionIslandDecorationFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41144, (class_2960)class_2960.method_60655((String)"legendarymonuments", (String)"distortion_island_decoration"), (Object)((Object)new DistortionIslandDecorationFeature(Config.CODEC)));
    }

    public boolean method_13151(class_5821<Config> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        Config config = (Config)context.method_33656();
        List<class_2338> surfacePositions = this.findIslandSurfaces(world, origin);
        if (surfacePositions.size() < 25) {
            return false;
        }
        class_2338 center = this.calculateIslandCenter(surfacePositions);
        int estimatedRadius = this.estimateIslandRadius(surfacePositions, center);
        boolean isMegaIsland = estimatedRadius > 60;
        List<class_2338> lakePositions = this.findLakeAreas(world, center, estimatedRadius);
        int lakeRadius = lakePositions.isEmpty() ? 0 : this.estimateLakeRadius(lakePositions, center);
        this.placeIslandDecorations(world, random, center, estimatedRadius, surfacePositions, lakeRadius, isMegaIsland, config);
        List<class_2338> edgePositions = this.findEdgePositions(surfacePositions, center, estimatedRadius);
        this.generateHangingColumns(world, random, edgePositions, center, estimatedRadius, isMegaIsland);
        if (isMegaIsland && estimatedRadius > 80 && (double)random.method_43057() < config.waterFallChance * 1.5 || !isMegaIsland && estimatedRadius > 25 && (double)random.method_43057() < config.waterFallChance) {
            this.generateWaterfalls(world, random, center, estimatedRadius, isMegaIsland);
        }
        return true;
    }

    private List<class_2338> findIslandSurfaces(class_5281 world, class_2338 origin) {
        ArrayList<class_2338> surfaces = new ArrayList<class_2338>();
        HashSet<Long> seenXZ = new HashSet<Long>();
        int approxY = this.estimateSurfaceYNearOrigin(world, origin);
        int yMin = approxY - 40;
        int yMax = approxY + 30;
        yMin = Math.max(yMin, -64);
        yMax = Math.min(yMax, 384);
        for (int dx = -40; dx <= 40; ++dx) {
            for (int dz = -40; dz <= 40; ++dz) {
                class_2338 found;
                int z;
                int x = origin.method_10263() + dx;
                long key = (long)x << 32 ^ (long)(z = origin.method_10260() + dz) & 0xFFFFFFFFL;
                if (seenXZ.contains(key) || (found = this.findSurfaceOnColumn(world, x, z, yMin, yMax)) == null) continue;
                surfaces.add(found);
                seenXZ.add(key);
            }
        }
        return surfaces;
    }

    private class_2338 findSurfaceOnColumn(class_5281 world, int x, int z, int yMin, int yMax) {
        for (int y = yMax; y >= yMin; --y) {
            class_2338 pos = new class_2338(x, y, z);
            if (!this.isIslandSurfaceBlockSafe(world, pos)) continue;
            return pos;
        }
        return null;
    }

    private int estimateSurfaceYNearOrigin(class_5281 world, class_2338 origin) {
        int startY = origin.method_10264();
        int yTop = Math.min(startY + 40, 384);
        int yBottom = Math.max(startY - 60, -64);
        for (int y = yTop; y >= yBottom; --y) {
            class_2338 pos = new class_2338(origin.method_10263(), y, origin.method_10260());
            if (!this.isIslandSurfaceBlockSafe(world, pos)) continue;
            return y;
        }
        return startY;
    }

    private boolean isIslandSurfaceBlockSafe(class_5281 world, class_2338 pos) {
        try {
            class_2680 currentBlock = world.method_8320(pos);
            class_2680 aboveBlock = world.method_8320(pos.method_10084());
            boolean isTopBlock = currentBlock.method_27852(ModBlocks.DISTORTION_COBBLESTONE) || currentBlock.method_27852(ModBlocks.DISTORTION_STONE);
            return isTopBlock && (aboveBlock.method_26215() || aboveBlock.method_27852(class_2246.field_10382));
        }
        catch (Exception e) {
            return false;
        }
    }

    private class_2338 calculateIslandCenter(List<class_2338> surfacePositions) {
        if (surfacePositions.isEmpty()) {
            return class_2338.field_10980;
        }
        double avgX = surfacePositions.stream().mapToInt(class_2382::method_10263).average().orElse(0.0);
        double avgY = surfacePositions.stream().mapToInt(class_2382::method_10264).average().orElse(0.0);
        double avgZ = surfacePositions.stream().mapToInt(class_2382::method_10260).average().orElse(0.0);
        return new class_2338((int)avgX, (int)avgY, (int)avgZ);
    }

    private int estimateIslandRadius(List<class_2338> surfacePositions, class_2338 center) {
        return surfacePositions.stream().mapToInt(pos -> (int)Math.sqrt(center.method_10262((class_2382)pos))).max().orElse(0);
    }

    private List<class_2338> findLakeAreas(class_5281 world, class_2338 center, int radius) {
        ArrayList<class_2338> lakePositions = new ArrayList<class_2338>();
        int safeRadius = Math.min(radius, 45);
        for (int x = -safeRadius; x <= safeRadius; ++x) {
            for (int z = -safeRadius; z <= safeRadius; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    class_2338 pos = center.method_10069(x, y, z);
                    try {
                        if (!world.method_8320(pos).method_27852(class_2246.field_10382)) continue;
                        lakePositions.add(pos);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return lakePositions;
    }

    private int estimateLakeRadius(List<class_2338> lakePositions, class_2338 center) {
        return lakePositions.stream().mapToInt(pos -> (int)Math.sqrt(center.method_10262((class_2382)pos))).max().orElse(0);
    }

    private List<class_2338> findEdgePositions(List<class_2338> surfacePositions, class_2338 center, int radius) {
        return surfacePositions.stream().filter(pos -> {
            double distance = Math.sqrt(center.method_10262((class_2382)pos));
            double normalizedDistance = distance / (double)Math.max(radius, 1);
            return normalizedDistance > 0.7;
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    private void placeIslandDecorations(class_5281 world, class_5819 random, class_2338 center, int radius, List<class_2338> surfacePositions, int lakeRadius, boolean isMegaIsland, Config config) {
        if (surfacePositions.isEmpty()) {
            return;
        }
        int segments = Math.max(1, radius / 50);
        int treesPerSegment = 2 + random.method_43048(4);
        int mountainsPerSegment = radius >= 20 ? 1 : 0;
        int treeCount = treesPerSegment * segments;
        int mountainCount = mountainsPerSegment * segments;
        ArrayList<class_2338> placedFeatures = new ArrayList<class_2338>();
        this.placeFeatures(world, random, surfacePositions, center, lakeRadius, placedFeatures, treeCount, isMegaIsland ? 196 : 256, this::generateDistortionTree);
        this.placeFeatures(world, random, surfacePositions, center, lakeRadius, placedFeatures, mountainCount, isMegaIsland ? 400 : 484, this::generateMiniMountain);
    }

    private void placeFeatures(class_5281 world, class_5819 random, List<class_2338> surfacePositions, class_2338 center, int lakeRadius, List<class_2338> placedFeatures, int count, int minSpacingSquared, FeaturePlacer placer) {
        int placed = 0;
        int maxAttempts = Math.max(8, count * (surfacePositions.size() > 1000 ? 14 : 10));
        ArrayList<class_2338> shuffledPositions = new ArrayList<class_2338>(surfacePositions);
        for (int attempt = 0; attempt < maxAttempts && placed < count && !shuffledPositions.isEmpty(); ++attempt) {
            int randomIndex = random.method_43048(shuffledPositions.size());
            class_2338 pos = (class_2338)shuffledPositions.get(randomIndex);
            shuffledPositions.remove(randomIndex);
            double distFromCenter = Math.sqrt(pos.method_10262((class_2382)center));
            if (distFromCenter < (double)(lakeRadius + (lakeRadius > 0 ? 6 : 4)) || !this.hasMinimumSpacing(pos, placedFeatures, minSpacingSquared)) continue;
            placer.place(world, random, pos.method_10084());
            placedFeatures.add(pos);
            ++placed;
        }
    }

    private boolean hasMinimumSpacing(class_2338 pos, List<class_2338> existing, int minSpacingSquared) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        for (class_2338 other : existing) {
            int dz;
            int dx = other.method_10263() - x;
            int dist2 = dx * dx + (dz = other.method_10260() - z) * dz;
            if (dist2 >= minSpacingSquared) continue;
            return false;
        }
        return true;
    }

    private void generateDistortionTree(class_5281 world, class_5819 random, class_2338 pos) {
        try {
            class_2338 groundedPos = this.findGroundLevel(world, pos);
            if (groundedPos == null) {
                return;
            }
            if (!this.hasAdequateGroundSupport(world, groundedPos)) {
                return;
            }
            class_5821 context = new class_5821(null, world, null, random, groundedPos, (class_3037)class_3111.field_24894);
            DistortionTreeFeature.DISTORTION_TREE_FEATURE.method_13151(context);
        }
        catch (Exception e) {
            this.generateSimpleDistortionTree(world, random, pos);
        }
    }

    private void generateMiniMountain(class_5281 world, class_5819 random, class_2338 pos) {
        try {
            class_2338 groundedPos = this.findGroundLevel(world, pos);
            if (groundedPos == null) {
                return;
            }
            if (!this.hasAdequateGroundSupport(world, groundedPos)) {
                return;
            }
            class_5821 context = new class_5821(null, world, null, random, groundedPos, (class_3037)class_3111.field_24894);
            MiniMountainFeature.MINI_MOUNTAIN_FEATURE.method_13151(context);
        }
        catch (Exception e) {
            this.generateSimpleRockFormation(world, random, pos);
        }
    }

    private void generateHangingColumns(class_5281 world, class_5819 random, List<class_2338> edgePositions, class_2338 center, int radius, boolean isMegaIsland) {
        if (edgePositions.isEmpty()) {
            return;
        }
        int columnCount = isMegaIsland ? Math.min(20, edgePositions.size() / 20) : Math.min(8, edgePositions.size() / 15);
        block2: for (int i = 0; i < columnCount; ++i) {
            if ((double)random.method_43057() > (isMegaIsland ? 0.4 : 0.3)) continue;
            class_2338 edgePos = edgePositions.get(random.method_43048(edgePositions.size()));
            int maxThickness = isMegaIsland ? 25 : 18;
            int columnHeight = random.method_39332(isMegaIsland ? 15 : 8, maxThickness + (isMegaIsland ? 20 : 10));
            int columnWidth = random.method_39332(1, isMegaIsland ? 4 : 3);
            for (int y = -1; y >= -columnHeight; --y) {
                int currentWidth = Math.max(1, columnWidth - -y / (isMegaIsland ? 10 : 8));
                for (int dx = -currentWidth; dx <= currentWidth; ++dx) {
                    for (int dz = -currentWidth; dz <= currentWidth; ++dz) {
                        if (dx * dx + dz * dz > currentWidth * currentWidth) continue;
                        class_2338 columnPos = edgePos.method_10069(dx, y, dz);
                        class_2680 columnBlock = (double)random.method_43057() < 0.3 ? ModBlocks.DISTORTION_COBBLESTONE.method_9564() : ModBlocks.DISTORTION_STONE.method_9564();
                        try {
                            world.method_8652(columnPos, columnBlock, 3);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if ((double)random.method_43057() < (isMegaIsland ? 0.03 : 0.05)) continue block2;
            }
        }
    }

    private void generateWaterfalls(class_5281 world, class_5819 random, class_2338 center, int radius, boolean isMegaIsland) {
        int waterfallCount = isMegaIsland ? random.method_39332(1, 3) : 1;
        int maxThickness = isMegaIsland ? 25 : 18;
        block2: for (int i = 0; i < waterfallCount; ++i) {
            double angle = random.method_43058() * 2.0 * Math.PI;
            double radiusMultiplier = isMegaIsland ? 0.7 + random.method_43058() * 0.2 : 0.8;
            int waterX = (int)(Math.cos(angle) * (double)Math.min(radius, 45) * radiusMultiplier);
            int waterZ = (int)(Math.sin(angle) * (double)Math.min(radius, 45) * radiusMultiplier);
            int waterLength = random.method_39332(isMegaIsland ? 40 : 25, maxThickness + (isMegaIsland ? 50 : 30));
            class_2338 waterStart = center.method_10069(waterX, isMegaIsland ? 3 : 2, waterZ);
            for (int y = 0; y > -waterLength; --y) {
                int width = y > (isMegaIsland ? -8 : -5) ? (isMegaIsland ? 2 : 1) : ((double)random.method_43057() < (isMegaIsland ? 0.8 : 0.7) ? 1 : 0);
                for (int dx = -width; dx <= width; ++dx) {
                    for (int dz = -width; dz <= width; ++dz) {
                        if (dx * dx + dz * dz > width * width) continue;
                        class_2338 waterPos = waterStart.method_10069(dx, y, dz);
                        try {
                            world.method_8652(waterPos, class_2246.field_10382.method_9564(), 3);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (y >= (isMegaIsland ? -20 : -10)) continue;
                if ((double)random.method_43057() < (isMegaIsland ? 0.08 : 0.1)) continue block2;
            }
        }
    }

    private class_2338 findGroundLevel(class_5281 world, class_2338 startPos) {
        class_2338 checkPos;
        int y;
        for (y = 0; y >= -15; --y) {
            checkPos = startPos.method_10069(0, y, 0);
            try {
                if (!world.method_8320(checkPos).method_26212((class_1922)world, checkPos)) continue;
                return checkPos.method_10084();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (y = 1; y <= 8; ++y) {
            checkPos = startPos.method_10069(0, y, 0);
            class_2338 belowPos = checkPos.method_10074();
            try {
                if (!world.method_8320(belowPos).method_26212((class_1922)world, belowPos) || world.method_8320(checkPos).method_26212((class_1922)world, checkPos)) continue;
                return checkPos;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean hasAdequateGroundSupport(class_5281 world, class_2338 basePos) {
        int solidBlocks = 0;
        int totalBlocks = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                class_2338 checkPos = basePos.method_10069(dx, -1, dz);
                ++totalBlocks;
                try {
                    if (!world.method_8320(checkPos).method_26212((class_1922)world, checkPos)) continue;
                    ++solidBlocks;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return totalBlocks > 0 && (double)solidBlocks / (double)totalBlocks >= 0.6;
    }

    private void generateSimpleDistortionTree(class_5281 world, class_5819 random, class_2338 pos) {
        class_2338 groundedPos = this.findGroundLevel(world, pos);
        if (groundedPos == null) {
            return;
        }
        int height = random.method_39332(5, 8);
        int crownSize = random.method_39332(2, 3);
        class_2338 currentPos = groundedPos;
        for (int y = 0; y < height; ++y) {
            try {
                world.method_8652(currentPos, ModBlocks.DISTORTION_LOG.method_9564(), 3);
                if (y > 2 && (double)random.method_43057() < 0.3) {
                    class_2350[] horizontalDirs = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
                    class_2350 randomDir = horizontalDirs[random.method_43048(horizontalDirs.length)];
                    currentPos = currentPos.method_10079(randomDir, (double)random.method_43057() < 0.5 ? 1 : 0);
                }
                currentPos = currentPos.method_10084();
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        class_2338 crownCenter = currentPos;
        for (int dx = -crownSize; dx <= crownSize; ++dx) {
            for (int dy = -1; dy <= crownSize - 1; ++dy) {
                for (int dz = -crownSize; dz <= crownSize; ++dz) {
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (!(distance <= (double)crownSize) || !((double)random.method_43057() < 0.7)) continue;
                    try {
                        world.method_8652(crownCenter.method_10069(dx, dy, dz), ModBlocks.DISTORTION_LEAVES.method_9564(), 3);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void generateSimpleRockFormation(class_5281 world, class_5819 random, class_2338 pos) {
        class_2338 groundedPos = this.findGroundLevel(world, pos);
        if (groundedPos == null) {
            return;
        }
        int height = random.method_39332(3, 6);
        for (int y = 0; y < height; ++y) {
            int size = Math.max(1, height - y);
            for (int dx = -size; dx <= size; ++dx) {
                for (int dz = -size; dz <= size; ++dz) {
                    if (dx * dx + dz * dz > size * size || !((double)random.method_43057() < 0.8)) continue;
                    try {
                        world.method_8652(groundedPos.method_10069(dx, y, dz), ModBlocks.DISTORTION_COBBLESTONE.method_9564(), 3);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class Config
    implements class_3037 {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("water_fall_chance").forGetter(config -> config.waterFallChance)).apply((Applicative)instance, Config::new));
        public final double waterFallChance;

        public Config(double waterFallChance) {
            this.waterFallChance = waterFallChance;
        }
    }

    @FunctionalInterface
    private static interface FeaturePlacer {
        public void place(class_5281 var1, class_5819 var2, class_2338 var3);
    }
}

