/*
 * Decompiled with CFR 0.152.
 */
package name.modid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import name.modid.CobblemonBattleInfo;
import name.modid.CobblemonBattleInfoClient;

public class BattleExtrasServerConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "cobblemon-battle-extras-server.json";
    private static BattleExtrasServerConfig INSTANCE;
    public boolean hideOpponentPokeballTypes = false;
    public float battleSpeedMultiplier = 1.0f;

    public static BattleExtrasServerConfig get() {
        if (INSTANCE == null) {
            BattleExtrasServerConfig.load(null);
        }
        return INSTANCE;
    }

    public static void load(Path configDir) {
        File configFile = BattleExtrasServerConfig.getConfigFile(configDir);
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                INSTANCE = (BattleExtrasServerConfig)GSON.fromJson((Reader)reader, BattleExtrasServerConfig.class);
                CobblemonBattleInfo.LOGGER.info("[BattleExtras] Loaded server config from {}", (Object)configFile.getAbsolutePath());
            }
            catch (Exception e) {
                CobblemonBattleInfo.LOGGER.error("[BattleExtras] Failed to load server config, using defaults", (Throwable)e);
                INSTANCE = new BattleExtrasServerConfig();
                BattleExtrasServerConfig.save(configDir);
            }
        } else {
            INSTANCE = new BattleExtrasServerConfig();
            BattleExtrasServerConfig.save(configDir);
        }
    }

    public static void save(Path configDir) {
        if (INSTANCE == null) {
            return;
        }
        File configFile = BattleExtrasServerConfig.getConfigFile(configDir);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
            CobblemonBattleInfoClient.debug("[BattleExtras] Saved server config to {}", configFile.getAbsolutePath());
        }
        catch (IOException e) {
            CobblemonBattleInfo.LOGGER.error("[BattleExtras] Failed to save server config", (Throwable)e);
        }
    }

    private static File getConfigFile(Path configDir) {
        if (configDir != null) {
            return configDir.resolve(CONFIG_FILE).toFile();
        }
        return new File("config", CONFIG_FILE);
    }

    public static boolean hideOpponentPokeballTypes() {
        return BattleExtrasServerConfig.get().hideOpponentPokeballTypes;
    }

    public static float getBattleSpeedMultiplier() {
        float speed = BattleExtrasServerConfig.get().battleSpeedMultiplier;
        return Math.max(0.5f, Math.min(4.0f, speed));
    }

    public static boolean isBattleSpeedModified() {
        float speed = BattleExtrasServerConfig.getBattleSpeedMultiplier();
        return speed < 0.99f || speed > 1.01f;
    }
}

