/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.platform.Services;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;

public class AbilityPopupRenderer {
    private static final List<AbilityPopup> activePopups = new ArrayList<AbilityPopup>();
    private static final Set<String> recentlyShown = new HashSet<String>();
    private static final long DUPLICATE_COOLDOWN_MS = 5000L;
    private static final long SLIDE_IN_DURATION_MS = 300L;
    private static final long SLIDE_OUT_DURATION_MS = 400L;
    private static final int BG_COLOR = -535816152;
    private static final int BORDER_TOP = -570435840;
    private static final int BORDER_BOTTOM = -573794048;
    private static final int HEADER_COLOR = -10496;
    private static final int ACCENT_COLOR = -22016;
    private static final int TEXT_COLOR = -1;
    private static final int GLOW_COLOR = 1090508544;

    public static void init() {
        Services.EVENTS.registerHudRender((guiGraphics, tickDelta) -> {
            try {
                AbilityPopupRenderer.renderPopups(guiGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Ability popup renderer initialized", new Object[0]);
    }

    public static void showAbilityPopup(class_2561 pokemonComponent, class_2561 abilityComponent) {
        String dedupKey;
        String[] parts;
        class_2588 tc;
        String key;
        String[] parts2;
        class_2588 tc2;
        String key2;
        class_7417 class_74172;
        String pokemonDisplayName = pokemonComponent != null ? pokemonComponent.getString() : "Unknown";
        String abilityDisplayName = abilityComponent != null ? abilityComponent.getString() : "Unknown";
        CobblemonBattleInfoClient.debug("[AbilityPopup] Pokemon: '{}', Ability: '{}'", pokemonDisplayName, abilityDisplayName);
        if (abilityComponent != null) {
            CobblemonBattleInfoClient.debug("[AbilityPopup] Ability Component type: {}", abilityComponent.method_10851().getClass().getSimpleName());
            class_7417 class_74173 = abilityComponent.method_10851();
            if (class_74173 instanceof class_2588) {
                class_2588 tc3 = (class_2588)class_74173;
                CobblemonBattleInfoClient.debug("[AbilityPopup] Ability translation key: {}", tc3.method_11022());
            }
        }
        String pokemonKey = pokemonDisplayName;
        if (pokemonComponent != null && (class_74172 = pokemonComponent.method_10851()) instanceof class_2588 && (key2 = (tc2 = (class_2588)class_74172).method_11022()) != null && key2.startsWith("cobblemon.species.") && (parts2 = key2.split("\\.")).length >= 3) {
            pokemonKey = parts2[2];
        }
        String abilityKey = abilityDisplayName;
        if (abilityComponent != null && (parts2 = abilityComponent.method_10851()) instanceof class_2588 && (key = (tc = (class_2588)parts2).method_11022()) != null && key.startsWith("cobblemon.ability.") && (parts = key.split("\\.")).length >= 3) {
            abilityKey = parts[2];
        }
        if (recentlyShown.contains(dedupKey = pokemonKey + ":" + abilityKey)) {
            return;
        }
        recentlyShown.add(dedupKey);
        float durationSeconds = BattleExtrasConfig.getAbilityPopupDurationSeconds();
        long durationMs = (long)(durationSeconds * 1000.0f);
        boolean isPlayer = AbilityPopupRenderer.isPlayerPokemon(pokemonDisplayName);
        activePopups.add(new AbilityPopup(pokemonComponent, abilityComponent, durationMs, dedupKey, isPlayer));
    }

    public static void showAbilityPopup(class_2561 pokemonComponent, String abilityName) {
        abilityName = AbilityPopupRenderer.formatAbilityName(abilityName);
        AbilityPopupRenderer.showAbilityPopup(pokemonComponent, (class_2561)class_2561.method_43470((String)abilityName));
    }

    public static void showAbilityPopup(String pokemonName, String abilityName) {
        if (pokemonName != null && !((String)pokemonName).isEmpty()) {
            pokemonName = ((String)pokemonName).substring(0, 1).toUpperCase() + ((String)pokemonName).substring(1);
        }
        abilityName = AbilityPopupRenderer.formatAbilityName(abilityName);
        AbilityPopupRenderer.showAbilityPopup((class_2561)class_2561.method_43470((String)pokemonName), (class_2561)class_2561.method_43470((String)abilityName));
    }

    private static String capitalizeName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static boolean isPlayerPokemon(String pokemonName) {
        try {
            ClientBattleSide side2;
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            if (battle == null) {
                return true;
            }
            String strippedPokemonName = AbilityPopupRenderer.stripTrainerPrefix(pokemonName);
            ClientBattleSide side = battle.getSide1();
            if (side != null) {
                for (ClientBattleActor actor : side.getActors()) {
                    for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                        ClientBattlePokemon battlePokemon;
                        if (activePokemon == null || (battlePokemon = activePokemon.getBattlePokemon()) == null) continue;
                        String name = battlePokemon.getDisplayName().getString();
                        String strippedName = AbilityPopupRenderer.stripTrainerPrefix(name);
                        if (!name.equalsIgnoreCase(pokemonName) && !strippedName.equalsIgnoreCase(strippedPokemonName) && !pokemonName.contains(name) && !pokemonName.contains(strippedName)) continue;
                        CobblemonBattleInfoClient.debug("[AbilityPopup] Matched player Pokemon: '{}' (stripped: '{}') vs battle name: '{}' (stripped: '{}')", name, strippedName, pokemonName, strippedPokemonName);
                        return true;
                    }
                }
            }
            if ((side2 = battle.getSide2()) != null) {
                for (ClientBattleActor actor : side2.getActors()) {
                    for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                        ClientBattlePokemon battlePokemon;
                        if (activePokemon == null || (battlePokemon = activePokemon.getBattlePokemon()) == null) continue;
                        String name = battlePokemon.getDisplayName().getString();
                        String strippedName = AbilityPopupRenderer.stripTrainerPrefix(name);
                        if (!name.equalsIgnoreCase(pokemonName) && !strippedName.equalsIgnoreCase(strippedPokemonName) && !pokemonName.contains(name) && !pokemonName.contains(strippedName)) continue;
                        CobblemonBattleInfoClient.debug("[AbilityPopup] Matched opponent Pokemon: '{}' (stripped: '{}') vs battle name: '{}' (stripped: '{}')", name, strippedName, pokemonName, strippedPokemonName);
                        return false;
                    }
                }
            }
            CobblemonBattleInfoClient.debug("[AbilityPopup] No match found for '{}' (stripped: '{}'), defaulting to player side", pokemonName, strippedPokemonName);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[AbilityPopup] Exception in isPlayerPokemon: {}", t.getMessage());
        }
        return true;
    }

    private static String stripTrainerPrefix(String pokemonName) {
        if (pokemonName == null) {
            return "";
        }
        int apostropheIdx = pokemonName.lastIndexOf("'s ");
        if (apostropheIdx >= 0) {
            return pokemonName.substring(apostropheIdx + 3).trim();
        }
        apostropheIdx = pokemonName.lastIndexOf("'s ");
        if (apostropheIdx >= 0) {
            return pokemonName.substring(apostropheIdx + 3).trim();
        }
        int deIdx = pokemonName.indexOf(" de ");
        if (deIdx >= 0) {
            return pokemonName.substring(0, deIdx).trim();
        }
        int doIdx = pokemonName.indexOf(" do ");
        if (doIdx >= 0) {
            return pokemonName.substring(0, doIdx).trim();
        }
        int daIdx = pokemonName.indexOf(" da ");
        if (daIdx >= 0) {
            return pokemonName.substring(0, daIdx).trim();
        }
        return pokemonName.trim();
    }

    private static String formatAbilityName(String abilityName) {
        if (abilityName == null || abilityName.isEmpty()) {
            return abilityName;
        }
        if (abilityName.contains(" ")) {
            return abilityName;
        }
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < abilityName.length(); ++i) {
            char c = abilityName.charAt(i);
            if (i > 0 && Character.isUpperCase(c) && Character.isLowerCase(abilityName.charAt(i - 1))) {
                formatted.append(' ');
            }
            formatted.append(c);
        }
        return formatted.toString();
    }

    public static void showAbility(String pokemonName, String abilityName) {
        AbilityPopupRenderer.showAbilityPopup(pokemonName, abilityName);
    }

    private static void renderPopups(class_332 gui) {
        if (activePopups.isEmpty()) {
            return;
        }
        if (!BattleExtrasConfig.isAbilityPopupsEnabled()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        boolean centered = BattleExtrasConfig.isAbilityPopupCentered();
        int playerY = screenHeight / 2 - 40;
        int opponentY = screenHeight / 2 - 40;
        int centeredY = screenHeight - 100;
        long currentTime = System.currentTimeMillis();
        Iterator<AbilityPopup> iterator = activePopups.iterator();
        while (iterator.hasNext()) {
            int x;
            int y;
            AbilityPopup popup = iterator.next();
            long elapsed = currentTime - popup.startTime;
            long remaining = popup.durationMs - elapsed;
            if (remaining <= 0L) {
                recentlyShown.remove(popup.key);
                iterator.remove();
                continue;
            }
            float slideProgress = Math.min(1.0f, (float)elapsed / 300.0f);
            slideProgress = 1.0f - (1.0f - slideProgress) * (1.0f - slideProgress) * (1.0f - slideProgress);
            long fadeStartTime = popup.durationMs * 2L / 3L;
            float alpha = 1.0f;
            float slideOutProgress = 0.0f;
            if (elapsed > fadeStartTime) {
                long fadeElapsed = elapsed - fadeStartTime;
                long fadeDuration = popup.durationMs - fadeStartTime;
                alpha = 1.0f - (float)fadeElapsed / (float)fadeDuration;
                slideOutProgress = (float)fadeElapsed / (float)Math.min(fadeDuration, 400L);
                slideOutProgress = Math.min(1.0f, slideOutProgress);
                slideOutProgress *= slideOutProgress;
            }
            class_5250 headerComp = class_2561.method_43471((String)"ability.popup.header");
            class_5250 abilityComp = class_2561.method_43469((String)"ability.popup.message", (Object[])new Object[]{popup.pokemonComponent, popup.abilityComponent});
            int headerWidth = mc.field_1772.method_27525((class_5348)headerComp);
            int abilityWidth = mc.field_1772.method_27525((class_5348)abilityComp);
            int maxWidth = Math.max(headerWidth, abilityWidth);
            int padding = 12;
            int boxWidth = maxWidth + padding * 2;
            int boxHeight = 28;
            if (centered) {
                targetX = (screenWidth - boxWidth) / 2;
                int startY = screenHeight + 10;
                int targetY = centeredY;
                y = (int)((float)startY + (float)(targetY - startY) * slideProgress);
                if (slideOutProgress > 0.0f) {
                    y = (int)((float)y + (float)(screenHeight - y + 20) * slideOutProgress);
                }
                x = targetX;
                centeredY -= boxHeight + 6;
            } else {
                int startX;
                if (popup.isPlayer) {
                    targetX = 10;
                    startX = -boxWidth - 20;
                    y = playerY;
                    playerY += boxHeight + 6;
                } else {
                    targetX = screenWidth - boxWidth - 10;
                    startX = screenWidth + 20;
                    y = opponentY;
                    opponentY += boxHeight + 6;
                }
                if (popup.isPlayer) {
                    x = (int)((float)startX + (float)(targetX - startX) * slideProgress);
                    if (slideOutProgress > 0.0f) {
                        x = (int)((float)x - (float)(x + boxWidth + 20) * slideOutProgress);
                    }
                } else {
                    x = (int)((float)startX + (float)(targetX - startX) * slideProgress);
                    if (slideOutProgress > 0.0f) {
                        x = (int)((float)x + (float)(screenWidth - x + 20) * slideOutProgress);
                    }
                }
            }
            AbilityPopupRenderer.renderFancyPopup(gui, mc, x, y, boxWidth, boxHeight, (class_2561)headerComp, (class_2561)abilityComp, alpha, popup.isPlayer);
        }
    }

    private static void renderFancyPopup(class_332 gui, class_310 mc, int x, int y, int width, int height, class_2561 header, class_2561 ability, float alpha, boolean isPlayer) {
        if (alpha <= 0.0f) {
            return;
        }
        int cornerRadius = 3;
        int bgAlpha = (int)(alpha * 224.0f);
        int borderAlpha = (int)(alpha * 221.0f);
        int textAlpha = (int)(alpha * 255.0f);
        int bg = bgAlpha << 24 | 0x101828;
        int borderTop = borderAlpha << 24 | 0xFFD700;
        int borderBottom = borderAlpha << 24 | 0xCC9900;
        int headerColor = textAlpha << 24 | 0xFFD700;
        int textColor = textAlpha << 24 | 0xFFFFFF;
        int accentColor = borderAlpha << 24 | 0xFFAA00;
        int glowColor = (int)(alpha * 64.0f) << 24 | 0xFFD700;
        AbilityPopupRenderer.drawRoundedRect(gui, x, y, width, height, bg, cornerRadius);
        AbilityPopupRenderer.drawGradientBorder(gui, x, y, width, height, borderTop, borderBottom, cornerRadius);
        if (isPlayer) {
            gui.method_25294(x + 3, y + 4, x + 5, y + height - 4, accentColor);
        } else {
            gui.method_25294(x + width - 5, y + 4, x + width - 3, y + height - 4, accentColor);
        }
        int glowX = x + (width - mc.field_1772.method_27525((class_5348)header)) / 2;
        gui.method_25294(glowX - 4, y + 2, glowX + mc.field_1772.method_27525((class_5348)header) + 4, y + 12, glowColor);
        int headerX = x + (width - mc.field_1772.method_27525((class_5348)header)) / 2;
        gui.method_51439(mc.field_1772, header, headerX, y + 4, headerColor, true);
        int abilityX = x + (width - mc.field_1772.method_27525((class_5348)ability)) / 2;
        int abilityTextEnd = abilityX + mc.field_1772.method_27525((class_5348)ability);
        gui.method_51439(mc.field_1772, ability, abilityX, y + 16, textColor, true);
        int diamondColor = borderAlpha << 24 | 0xFFD700;
        int diamondSpacing = 6;
        int rightDiamondX = abilityTextEnd + diamondSpacing;
        AbilityPopupRenderer.drawSmallDiamond(gui, rightDiamondX, y + 4, diamondColor);
        AbilityPopupRenderer.drawSmallDiamond(gui, rightDiamondX, y + height - 6, diamondColor);
    }

    private static void drawRoundedRect(class_332 g, int x, int y, int w, int h, int color, int r) {
        g.method_25294(x + r, y, x + w - r, y + h, color);
        g.method_25294(x, y + r, x + w, y + h - r, color);
        g.method_25294(x + 1, y + 1, x + r, y + r, color);
        g.method_25294(x + w - r, y + 1, x + w - 1, y + r, color);
        g.method_25294(x + 1, y + h - r, x + r, y + h - 1, color);
        g.method_25294(x + w - r, y + h - r, x + w - 1, y + h - 1, color);
    }

    private static void drawGradientBorder(class_332 g, int x, int y, int w, int h, int topColor, int bottomColor, int r) {
        int color;
        float progress;
        int i;
        g.method_25294(x + r, y, x + w - r, y + 1, topColor);
        g.method_25294(x + r, y + h - 1, x + w - r, y + h, bottomColor);
        for (i = r; i < h - r; ++i) {
            progress = (float)i / (float)h;
            color = AbilityPopupRenderer.mixColors(topColor, bottomColor, progress);
            g.method_25294(x, y + i, x + 1, y + i + 1, color);
        }
        for (i = r; i < h - r; ++i) {
            progress = (float)i / (float)h;
            color = AbilityPopupRenderer.mixColors(topColor, bottomColor, progress);
            g.method_25294(x + w - 1, y + i, x + w, y + i + 1, color);
        }
        g.method_25294(x + 1, y + 1, x + 2, y + 2, topColor);
        g.method_25294(x + w - 2, y + 1, x + w - 1, y + 2, topColor);
        g.method_25294(x + 1, y + h - 2, x + 2, y + h - 1, bottomColor);
        g.method_25294(x + w - 2, y + h - 2, x + w - 1, y + h - 1, bottomColor);
    }

    private static void drawSmallDiamond(class_332 g, int cx, int cy, int color) {
        g.method_25294(cx, cy - 1, cx + 1, cy + 2, color);
        g.method_25294(cx - 1, cy, cx + 2, cy + 1, color);
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * ratio);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static class AbilityPopup {
        class_2561 pokemonComponent;
        class_2561 abilityComponent;
        long startTime;
        long durationMs;
        String key;
        boolean isPlayer;

        AbilityPopup(class_2561 pokemonComponent, class_2561 abilityComponent, long durationMs, String key, boolean isPlayer) {
            this.pokemonComponent = pokemonComponent;
            this.abilityComponent = abilityComponent;
            this.startTime = System.currentTimeMillis();
            this.durationMs = durationMs;
            this.key = key;
            this.isPlayer = isPlayer;
        }
    }
}

