/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Desktop;
import java.util.ArrayList;
import java.util.List;
import name.modid.client.BattleLogger;
import name.modid.client.BattleMessageColorizer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class BattleLogScreen
extends class_437 {
    private static final int LIST_ITEM_HEIGHT = 24;
    private static final int LOG_VIEW_WIDTH = 400;
    private List<BattleLogger.BattleLogEntry> logs = new ArrayList<BattleLogger.BattleLogEntry>();
    private List<String> currentLogContent = new ArrayList<String>();
    private List<class_2561> currentLogContentColored = new ArrayList<class_2561>();
    private int selectedLogIndex = -1;
    private int listScrollOffset = 0;
    private int contentScrollOffset = 0;
    private int maxVisibleListItems = 10;
    private int maxVisibleContentLines = 20;
    private int listX;
    private int listY;
    private int listWidth;
    private int listHeight;
    private int contentX;
    private int contentY;
    private int contentWidth;
    private int contentHeight;
    private class_4185 openFolderButton;
    private class_4185 deleteButton;
    private class_4185 closeButton;

    public BattleLogScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.cobblemon-battle-extras.battle_logs.title"));
    }

    protected void method_25426() {
        super.method_25426();
        this.logs = BattleLogger.getAllLogs();
        int padding = 20;
        int centerGap = 10;
        this.listWidth = 200;
        this.listHeight = this.field_22790 - padding * 2 - 50;
        this.listX = padding;
        this.listY = padding + 30;
        this.contentX = this.listX + this.listWidth + centerGap;
        this.contentY = this.listY;
        this.contentWidth = this.field_22789 - this.contentX - padding;
        this.contentHeight = this.listHeight;
        this.maxVisibleListItems = this.listHeight / 24;
        this.maxVisibleContentLines = this.contentHeight / 12;
        int buttonY = this.field_22790 - padding - 18;
        int buttonWidth = 100;
        int buttonSpacing = 10;
        this.openFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cobblemon-battle-extras.battle_logs.open_folder"), button -> this.openLogsFolder()).method_46434(this.listX, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.openFolderButton);
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cobblemon-battle-extras.battle_logs.delete"), button -> this.deleteSelectedLog()).method_46434(this.listX + buttonWidth + buttonSpacing, buttonY, 80, 20).method_46431();
        this.deleteButton.field_22763 = this.selectedLogIndex >= 0;
        this.method_37063((class_364)this.deleteButton);
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cobblemon-battle-extras.battle_logs.close"), button -> this.method_25419()).method_46434(this.field_22789 - padding - 80, buttonY, 80, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -16119270);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int logIndex;
        this.method_25420(graphics, mouseX, mouseY, partialTick);
        graphics.method_25300(this.field_22793, "Battle Logs", this.field_22789 / 2, 10, 0xFFFFFF);
        graphics.method_25294(this.listX - 2, this.listY - 2, this.listX + this.listWidth + 2, this.listY + this.listHeight + 2, -13421739);
        graphics.method_25294(this.listX, this.listY, this.listX + this.listWidth, this.listY + this.listHeight, -15066578);
        graphics.method_25303(this.field_22793, "Recent Battles (" + this.logs.size() + ")", this.listX + 5, this.listY - 15, -5592321);
        int visibleItems = Math.min(this.maxVisibleListItems, this.logs.size() - this.listScrollOffset);
        for (int i = 0; i < visibleItems && (logIndex = i + this.listScrollOffset) < this.logs.size(); ++i) {
            BattleLogger.BattleLogEntry log = this.logs.get(logIndex);
            int itemY = this.listY + i * 24;
            if (logIndex == this.selectedLogIndex) {
                graphics.method_25294(this.listX, itemY, this.listX + this.listWidth, itemY + 24 - 2, -12298838);
            } else if (this.isMouseOverListItem(mouseX, mouseY, itemY)) {
                graphics.method_25294(this.listX, itemY, this.listX + this.listWidth, itemY + 24 - 2, -13421722);
            }
            String title = this.truncateString(log.getDisplayTitle(), 22);
            String date = log.getShortDate();
            graphics.method_25303(this.field_22793, title, this.listX + 5, itemY + 3, -1);
            graphics.method_25303(this.field_22793, date, this.listX + 5, itemY + 13, -5592406);
            if (log.result == null || log.result.isEmpty()) continue;
            int resultColor = -5592406;
            if (log.result.toLowerCase().contains("win") || log.result.toLowerCase().contains("victory")) {
                resultColor = -11141291;
            } else if (log.result.toLowerCase().contains("lose") || log.result.toLowerCase().contains("defeat")) {
                resultColor = -43691;
            }
            graphics.method_25303(this.field_22793, "\u25cf", this.listX + this.listWidth - 15, itemY + 8, resultColor);
        }
        if (this.listScrollOffset > 0) {
            graphics.method_25300(this.field_22793, "\u25b2", this.listX + this.listWidth / 2, this.listY - 10, -5592321);
        }
        if (this.listScrollOffset + this.maxVisibleListItems < this.logs.size()) {
            graphics.method_25300(this.field_22793, "\u25bc", this.listX + this.listWidth / 2, this.listY + this.listHeight + 2, -5592321);
        }
        graphics.method_25294(this.contentX - 2, this.contentY - 2, this.contentX + this.contentWidth + 2, this.contentY + this.contentHeight + 2, -13421739);
        graphics.method_25294(this.contentX, this.contentY, this.contentX + this.contentWidth, this.contentY + this.contentHeight, -15066578);
        if (this.selectedLogIndex >= 0 && this.selectedLogIndex < this.logs.size()) {
            BattleLogger.BattleLogEntry log = this.logs.get(this.selectedLogIndex);
            String vsHeader = log.playerName + " VS " + log.opponentName;
            graphics.method_25300(this.field_22793, vsHeader, this.contentX + this.contentWidth / 2, this.contentY - 15, -21931);
        } else {
            graphics.method_25303(this.field_22793, "Select a battle to view", this.contentX + 5, this.contentY - 15, -7829368);
        }
        if (!this.currentLogContent.isEmpty()) {
            RenderSystem.enableScissor((int)(this.contentX * (int)this.field_22787.method_22683().method_4495()), (int)((this.field_22790 - this.contentY - this.contentHeight) * (int)this.field_22787.method_22683().method_4495()), (int)(this.contentWidth * (int)this.field_22787.method_22683().method_4495()), (int)(this.contentHeight * (int)this.field_22787.method_22683().method_4495()));
            int lineY = this.contentY + 5 - this.contentScrollOffset * 12;
            for (int i = 0; i < this.currentLogContent.size(); ++i) {
                if (lineY >= this.contentY - 12 && lineY < this.contentY + this.contentHeight) {
                    if (i < this.currentLogContentColored.size()) {
                        class_2561 coloredLine = this.currentLogContentColored.get(i);
                        graphics.method_27535(this.field_22793, coloredLine, this.contentX + 5, lineY, -1);
                    } else {
                        String line = this.currentLogContent.get(i);
                        int color = this.getLineColor(line);
                        graphics.method_25303(this.field_22793, line, this.contentX + 5, lineY, color);
                    }
                }
                lineY += 12;
            }
            RenderSystem.disableScissor();
            if (this.contentScrollOffset > 0) {
                graphics.method_25300(this.field_22793, "\u25b2", this.contentX + this.contentWidth / 2, this.contentY - 10, -5592321);
            }
            if (this.contentScrollOffset + this.maxVisibleContentLines < this.currentLogContent.size()) {
                graphics.method_25300(this.field_22793, "\u25bc", this.contentX + this.contentWidth / 2, this.contentY + this.contentHeight + 2, -5592321);
            }
        } else if (this.selectedLogIndex < 0) {
            graphics.method_25300(this.field_22793, "Click a battle on the left", this.contentX + this.contentWidth / 2, this.contentY + 50, -10066330);
            graphics.method_25300(this.field_22793, "to view its log", this.contentX + this.contentWidth / 2, this.contentY + 65, -10066330);
        }
        this.openFolderButton.method_25394(graphics, mouseX, mouseY, partialTick);
        this.deleteButton.method_25394(graphics, mouseX, mouseY, partialTick);
        this.closeButton.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private int getLineColor(String line) {
        if (line.contains("\u2550") || line.contains("\u2500")) {
            return -10057473;
        }
        if (line.contains("BATTLE START") || line.contains("BATTLE END")) {
            return -22016;
        }
        if (line.startsWith("Result:")) {
            if (line.toLowerCase().contains("win") || line.toLowerCase().contains("victory")) {
                return -11141291;
            }
            if (line.toLowerCase().contains("lose") || line.toLowerCase().contains("defeat")) {
                return -43691;
            }
            return -1;
        }
        if (line.toLowerCase().contains("super effective")) {
            return -11141291;
        }
        if (line.toLowerCase().contains("not very effective")) {
            return -30635;
        }
        if (line.toLowerCase().contains("fainted") || line.toLowerCase().contains("was knocked out")) {
            return -43691;
        }
        if (line.contains("Turn ")) {
            return -171;
        }
        if (line.startsWith("  \u2022")) {
            return -5592321;
        }
        if (line.startsWith("---") || line.startsWith("Date:") || line.startsWith("Duration:")) {
            return -5592406;
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (button == 0 && mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listWidth) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listHeight) && (clickedIndex = (int)((mouseY - (double)this.listY) / 24.0) + this.listScrollOffset) >= 0 && clickedIndex < this.logs.size()) {
            this.selectLog(clickedIndex);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listWidth) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listHeight)) {
            if (scrollY > 0.0) {
                this.listScrollOffset = Math.max(0, this.listScrollOffset - 1);
            } else if (scrollY < 0.0) {
                this.listScrollOffset = Math.min(Math.max(0, this.logs.size() - this.maxVisibleListItems), this.listScrollOffset + 1);
            }
            return true;
        }
        if (mouseX >= (double)this.contentX && mouseX < (double)(this.contentX + this.contentWidth) && mouseY >= (double)this.contentY && mouseY < (double)(this.contentY + this.contentHeight)) {
            if (scrollY > 0.0) {
                this.contentScrollOffset = Math.max(0, this.contentScrollOffset - 3);
            } else if (scrollY < 0.0) {
                this.contentScrollOffset = Math.min(Math.max(0, this.currentLogContent.size() - this.maxVisibleContentLines), this.contentScrollOffset + 3);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 265 && this.selectedLogIndex > 0) {
            this.selectLog(this.selectedLogIndex - 1);
            if (this.selectedLogIndex < this.listScrollOffset) {
                this.listScrollOffset = this.selectedLogIndex;
            }
            return true;
        }
        if (keyCode == 264 && this.selectedLogIndex < this.logs.size() - 1) {
            this.selectLog(this.selectedLogIndex + 1);
            if (this.selectedLogIndex >= this.listScrollOffset + this.maxVisibleListItems) {
                this.listScrollOffset = this.selectedLogIndex - this.maxVisibleListItems + 1;
            }
            return true;
        }
        if (keyCode == 266) {
            this.contentScrollOffset = Math.max(0, this.contentScrollOffset - this.maxVisibleContentLines);
            return true;
        }
        if (keyCode == 267) {
            this.contentScrollOffset = Math.min(Math.max(0, this.currentLogContent.size() - this.maxVisibleContentLines), this.contentScrollOffset + this.maxVisibleContentLines);
            return true;
        }
        if (keyCode == 261 && this.selectedLogIndex >= 0) {
            this.deleteSelectedLog();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void selectLog(int index) {
        if (index < 0 || index >= this.logs.size()) {
            return;
        }
        this.selectedLogIndex = index;
        this.contentScrollOffset = 0;
        BattleLogger.BattleLogEntry log = this.logs.get(index);
        this.currentLogContent = log.fileName != null && !log.fileName.isEmpty() ? BattleLogger.loadBattleLog(log.fileName) : new ArrayList<String>(log.messages);
        this.currentLogContentColored = new ArrayList<class_2561>();
        BattleMessageColorizer.setPlayerName(log.playerName);
        BattleMessageColorizer.setOpponentName(log.opponentName);
        for (String line : this.currentLogContent) {
            class_2561 coloredLine = BattleMessageColorizer.colorizeLineByParts(line);
            this.currentLogContentColored.add(coloredLine);
        }
        this.deleteButton.field_22763 = true;
    }

    private void openLogsFolder() {
        block8: {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                String path = BattleLogger.getLogDirectory().toAbsolutePath().toString();
                if (os.contains("win")) {
                    Runtime.getRuntime().exec(new String[]{"explorer", path});
                } else if (os.contains("mac")) {
                    Runtime.getRuntime().exec(new String[]{"open", path});
                } else if (os.contains("nix") || os.contains("nux")) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", path});
                } else {
                    Desktop.getDesktop().open(BattleLogger.getLogDirectory().toFile());
                }
            }
            catch (Exception e) {
                if (this.field_22787 == null) break block8;
                this.field_22787.field_1774.method_1455(BattleLogger.getLogDirectory().toString());
                if (this.field_22787.field_1724 == null) break block8;
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"gui.cobblemon-battle-extras.battle_logs.path_copied", (Object[])new Object[]{BattleLogger.getLogDirectory()}), false);
            }
        }
    }

    private void deleteSelectedLog() {
        if (this.selectedLogIndex < 0 || this.selectedLogIndex >= this.logs.size()) {
            return;
        }
        BattleLogger.BattleLogEntry log = this.logs.get(this.selectedLogIndex);
        if (BattleLogger.deleteLog(log.fileName)) {
            this.logs.remove(this.selectedLogIndex);
            if (this.logs.isEmpty()) {
                this.selectedLogIndex = -1;
                this.currentLogContent.clear();
                this.deleteButton.field_22763 = false;
            } else if (this.selectedLogIndex >= this.logs.size()) {
                this.selectLog(this.logs.size() - 1);
            } else {
                this.selectLog(this.selectedLogIndex);
            }
        }
    }

    private boolean isMouseOverListItem(int mouseX, int mouseY, int itemY) {
        return mouseX >= this.listX && mouseX < this.listX + this.listWidth && mouseY >= itemY && mouseY < itemY + 24 - 2;
    }

    private String truncateString(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public boolean method_25421() {
        return false;
    }

    public static void open() {
        class_310.method_1551().method_1507((class_437)new BattleLogScreen());
    }
}

