/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.SingleActionRequest;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleLogger;
import name.modid.client.BattleMessageColorizer;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.TypeIconRenderer;
import name.modid.client.net.TeraTypeClientData;
import name.modid.platform.Services;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class CustomBattleController {
    private static boolean initialized = false;
    private static int selectedButton = 0;
    private static boolean wasInBattle = false;
    private static class_437 lastRegisteredScreen = null;
    private static String currentSelectionType = "none";
    private static int maxButtons = 4;
    private static int numMoveTiles = 4;
    private static boolean upPressed = false;
    private static boolean downPressed = false;
    private static boolean leftPressed = false;
    private static boolean rightPressed = false;
    private static boolean selectPressed = false;
    private static boolean backPressed = false;
    private static long lastInputTime = 0L;
    private static final long INPUT_COOLDOWN = 150L;
    private static long lastNavigationTime = 0L;
    private static final long NAVIGATION_HIDE_DURATION = 80L;
    private static long battleGuiClosedTime = 0L;
    private static final long JUMP_SUPPRESS_DURATION = 200L;
    private static boolean hasAutoExpandedLog = false;
    private static int BUTTON_WIDTH = 139;
    private static int BUTTON_HEIGHT = 26;
    private static int MEGA_ICON_OFFSET_X_SWITCH = 5;
    private static int MEGA_ICON_OFFSET_Y_SWITCH = -5;
    private static int MEGA_ICON_SIZE_SWITCH = 8;
    private static Object[] cachedTiles = null;
    private static class_437 cachedScreen = null;
    private static boolean minimisedBackPressed = false;
    private static final Map<String, Map<String, int[]>> cachedPartyPP = new ConcurrentHashMap<String, Map<String, int[]>>();
    private static final Map<String, String> cachedTeraTypes = new ConcurrentHashMap<String, String>();
    private static final int GLFW_KEY_UP = 265;
    private static final int GLFW_KEY_DOWN = 264;
    private static final int GLFW_KEY_LEFT = 263;
    private static final int GLFW_KEY_RIGHT = 262;
    private static final int GLFW_KEY_W = 87;
    private static final int GLFW_KEY_A = 65;
    private static final int GLFW_KEY_S = 83;
    private static final int GLFW_KEY_D = 68;
    private static final int GLFW_KEY_ENTER = 257;
    private static final int GLFW_KEY_KP_ENTER = 335;
    private static final int GLFW_KEY_SPACE = 32;
    private static final int GLFW_KEY_BACKSPACE = 259;
    private static final int GLFW_KEY_ESCAPE = 256;
    private static final int GLFW_PRESS = 1;
    private static final float STICK_DEADZONE = 0.5f;
    private static boolean wasInBattleForJump = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        Services.EVENTS.registerClientTick(CustomBattleController::onClientTick);
        Services.EVENTS.registerScreenRender((screen, graphics, mouseX, mouseY, tickDelta) -> {
            if (CustomBattleController.isBattleGUI(screen)) {
                CustomBattleController.onScreenRender(screen, graphics, mouseX, mouseY, tickDelta);
            }
        });
        CobblemonBattleInfoClient.debug("[CustomController] Initialized custom battle controller", new Object[0]);
    }

    private static void onClientTick(class_310 mc) {
        try {
            boolean inBattle;
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            boolean bl = inBattle = battle != null;
            if (inBattle && !wasInBattle) {
                CustomBattleController.onBattleStart();
            }
            if (!inBattle && wasInBattle) {
                CustomBattleController.onBattleEnd();
            }
            wasInBattle = inBattle;
            if (inBattle && CustomBattleController.isBattleGUI(mc.field_1755) && !hasAutoExpandedLog && BattleExtrasConfig.isAutoExpandLogEnabled()) {
                CustomBattleController.autoExpandBattleLog(mc.field_1755);
                hasAutoExpandedLog = true;
            }
            if (!BattleExtrasConfig.isControllerNavigationEnabled()) {
                return;
            }
            if (inBattle && CustomBattleController.isBattleGUI(mc.field_1755)) {
                CustomBattleController.handleInput(mc, mc.field_1755);
            }
            if (BattleExtrasConfig.isBButtonReenterBattleEnabled() && inBattle && !CustomBattleController.isBattleGUI(mc.field_1755) && mc.field_1755 == null) {
                CustomBattleController.handleMinimisedBattleInput(battle);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void handleMinimisedBattleInput(ClientBattle battle) {
        boolean backNow = CustomBattleController.isBackPressed();
        if (backNow && !minimisedBackPressed) {
            CobblemonBattleInfoClient.debug("[CustomController] B pressed while battle minimised, opening BattleGUI", new Object[0]);
            CustomBattleController.openBattleGUI();
            backPressed = true;
        }
        minimisedBackPressed = backNow;
    }

    private static void onScreenRender(class_437 screen, class_332 graphics, int mouseX, int mouseY, float delta) {
        try {
            if (!CustomBattleController.isBattleGUI(screen)) {
                return;
            }
            if (currentSelectionType.equals("switch") && BattleExtrasConfig.isTypeIconsEnabled() && CustomBattleController.isSwitchScreenActive(screen)) {
                CustomBattleController.renderSwitchScreenTypeIcons(graphics);
            }
            CustomBattleController.renderMouseHoverTooltips(graphics, mouseX, mouseY);
            if (!BattleExtrasConfig.isSelectionHighlightEnabled()) {
                return;
            }
            if (!BattleExtrasConfig.isControllerNavigationEnabled()) {
                return;
            }
            CustomBattleController.drawButtonHighlight(graphics, screen, mouseX, mouseY);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderMouseHoverTooltips(class_332 graphics, int mouseX, int mouseY) {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen != null && CustomBattleController.isBattleGUI(currentScreen)) {
            Object[] newTiles = CustomBattleController.findBattleOptionTiles(currentScreen);
            if (newTiles == null || newTiles.length == 0) {
                cachedTiles = null;
                return;
            }
        } else {
            cachedTiles = null;
            return;
        }
        if (cachedTiles == null || cachedTiles.length == 0) {
            return;
        }
        for (Object tile : cachedTiles) {
            if (tile == null) continue;
            try {
                int tileX = CustomBattleController.getTileX(tile);
                int tileY = CustomBattleController.getTileY(tile);
                int tileWidth = CustomBattleController.getTileWidth(tile);
                int tileHeight = CustomBattleController.getTileHeight(tile);
                if (tileX <= 0 || tileY <= 0 || tileWidth <= 0 || tileHeight <= 0) continue;
                String tileClassName = tile.getClass().getName();
                if (mouseX < tileX || mouseX > tileX + tileWidth || mouseY < tileY || mouseY > tileY + tileHeight) continue;
                if (tileClassName.contains("BackButton")) {
                    CustomBattleController.renderBackButtonTooltip(graphics, tileX + 4, tileY);
                    return;
                }
                if (CustomBattleController.isGimmickButton(tile)) {
                    CustomBattleController.renderGimmickTooltip(graphics, tile, tileX, tileY);
                    return;
                }
                if (!currentSelectionType.equals("switch") || !tileClassName.contains("SwitchTile")) continue;
                CustomBattleController.renderSwitchMovesTooltip(graphics, tile, tileX, tileY, tileWidth, tileHeight);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean isMouseOverAnyTile(int mouseX, int mouseY) {
        if (cachedTiles == null || cachedTiles.length == 0) {
            return false;
        }
        for (Object tile : cachedTiles) {
            if (tile == null) continue;
            try {
                int tileX = CustomBattleController.getTileX(tile);
                int tileY = CustomBattleController.getTileY(tile);
                int tileWidth = CustomBattleController.getTileWidth(tile);
                int tileHeight = CustomBattleController.getTileHeight(tile);
                if (tileX <= 0 || tileY <= 0 || tileWidth <= 0 || tileHeight <= 0) continue;
                String tileClassName = tile.getClass().getName();
                if (tileClassName.contains("MoveTile") || tileClassName.contains("GimmickTile") || tileClassName.contains("DynamaxTile")) {
                    tileX -= 10;
                    tileWidth += 10;
                }
                if (mouseX < tileX || mouseX > tileX + tileWidth || mouseY < tileY || mouseY > tileY + tileHeight) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void drawButtonHighlight(class_332 graphics, class_437 gui, int mouseX, int mouseY) {
        try {
            Object selectedTile;
            if (System.currentTimeMillis() - lastNavigationTime < 80L) {
                return;
            }
            Object[] tiles = CustomBattleController.findBattleOptionTiles(gui);
            if (tiles == null || tiles.length == 0) {
                return;
            }
            boolean mouseOverTile = CustomBattleController.isMouseOverAnyTile(mouseX, mouseY);
            if (selectedButton >= tiles.length) {
                selectedButton = 0;
            }
            if ((selectedTile = tiles[selectedButton]) == null) {
                return;
            }
            int x = CustomBattleController.getTileX(selectedTile);
            int y = CustomBattleController.getTileY(selectedTile);
            int width = CustomBattleController.getTileWidth(selectedTile);
            int height = CustomBattleController.getTileHeight(selectedTile);
            if (x <= 0 || y <= 0 || width <= 0 || height <= 0) {
                return;
            }
            String tileClassName = selectedTile.getClass().getName();
            if (tileClassName.contains("MoveTile") || tileClassName.contains("GimmickTile") || tileClassName.contains("DynamaxTile")) {
                x -= 10;
                width += 10;
            }
            if (tileClassName.contains("BackButton")) {
                x += 4;
            }
            if (tileClassName.contains("MoveTile") || tileClassName.contains("GimmickTile") || tileClassName.contains("DynamaxTile")) {
                boolean isLeftColumn = selectedButton % 2 == 0;
                CustomBattleController.renderSelectionArrows(graphics, x, y, width, height, isLeftColumn);
            } else if (currentSelectionType.equals("general") && tileClassName.contains("BattleOptionTile")) {
                boolean isLeftColumn = selectedButton % 2 == 0;
                CustomBattleController.renderSelectionArrows(graphics, x, y, width, height, isLeftColumn);
            } else if (tileClassName.contains("BackButton")) {
                CustomBattleController.renderSelectionArrows(graphics, x, y, width, height, true);
            } else if (CustomBattleController.isGimmickButton(selectedTile)) {
                CustomBattleController.renderSelectionArrows(graphics, x, y, width, height, false);
            } else {
                int brightnessOverlay = 0x30FFFFFF;
                graphics.method_25294(x, y, x + width, y + height, brightnessOverlay);
            }
            if (!mouseOverTile) {
                if (CustomBattleController.isGimmickButton(selectedTile)) {
                    CustomBattleController.renderGimmickTooltip(graphics, selectedTile, x, y);
                }
                if (tileClassName.contains("BackButton")) {
                    CustomBattleController.renderBackButtonTooltip(graphics, x, y);
                }
                if (currentSelectionType.equals("switch") && tileClassName.contains("SwitchTile")) {
                    CustomBattleController.renderSwitchMovesTooltip(graphics, selectedTile, x, y, width, height);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isSwitchScreenActive(class_437 screen) {
        try {
            Object actionSelection = CustomBattleController.getActionSelection(screen);
            if (actionSelection == null) {
                return false;
            }
            String selectionClassName = actionSelection.getClass().getName();
            return selectionClassName.contains("SwitchPokemonSelection");
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void drawFallbackHighlight(class_332 graphics, class_437 gui) {
        try {
            int OPTION_ROOT_X = 6;
            int OPTION_VERTICAL_OFFSET = 101;
            int OPTION_HORIZONTAL_SPACING = 3;
            int OPTION_VERTICAL_SPACING = 3;
            int TILE_WIDTH = 139;
            int TILE_HEIGHT = 39;
            try {
                Class<?> battleGUIClass = gui.getClass();
                Field rootXField = battleGUIClass.getDeclaredField("OPTION_ROOT_X");
                rootXField.setAccessible(true);
                OPTION_ROOT_X = (Integer)rootXField.get(null);
                Field vertOffsetField = battleGUIClass.getDeclaredField("OPTION_VERTICAL_OFFSET");
                vertOffsetField.setAccessible(true);
                OPTION_VERTICAL_OFFSET = (Integer)vertOffsetField.get(null);
                Field hSpacingField = battleGUIClass.getDeclaredField("OPTION_HORIZONTAL_SPACING");
                hSpacingField.setAccessible(true);
                OPTION_HORIZONTAL_SPACING = (Integer)hSpacingField.get(null);
                Field vSpacingField = battleGUIClass.getDeclaredField("OPTION_VERTICAL_SPACING");
                vSpacingField.setAccessible(true);
                OPTION_VERTICAL_SPACING = (Integer)vSpacingField.get(null);
            }
            catch (Throwable battleGUIClass) {
                // empty catch block
            }
            try {
                Class<?> tileClass = Class.forName("com.cobblemon.mod.common.client.gui.battle.widgets.BattleOptionTile");
                Field widthField = tileClass.getDeclaredField("OPTION_WIDTH");
                widthField.setAccessible(true);
                TILE_WIDTH = (Integer)widthField.get(null);
                Field heightField = tileClass.getDeclaredField("OPTION_HEIGHT");
                heightField.setAccessible(true);
                TILE_HEIGHT = (Integer)heightField.get(null);
            }
            catch (Throwable tileClass) {
                // empty catch block
            }
            int screenHeight = class_310.method_1551().method_22683().method_4502();
            int row = selectedButton / 2;
            int col = selectedButton % 2;
            int bottomRowBottom = screenHeight - 10;
            int y = row == 1 ? bottomRowBottom - TILE_HEIGHT : bottomRowBottom - TILE_HEIGHT - OPTION_VERTICAL_SPACING - TILE_HEIGHT;
            int x = OPTION_ROOT_X + col * (TILE_WIDTH + OPTION_HORIZONTAL_SPACING);
            int color = -1;
            graphics.method_25294(x - 2, y - 2, x + TILE_WIDTH + 2, y - 1, color);
            graphics.method_25294(x - 2, y + TILE_HEIGHT + 1, x + TILE_WIDTH + 2, y + TILE_HEIGHT + 2, color);
            graphics.method_25294(x - 2, y - 1, x - 1, y + TILE_HEIGHT + 1, color);
            graphics.method_25294(x + TILE_WIDTH + 1, y - 1, x + TILE_WIDTH + 2, y + TILE_HEIGHT + 1, color);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Object[] findBattleOptionTiles(class_437 gui) {
        List<Object> tiles = new ArrayList();
        try {
            Object actionSelection = CustomBattleController.getActionSelection(gui);
            if (actionSelection == null) {
                return null;
            }
            String selectionClassName = actionSelection.getClass().getName();
            if (selectionClassName.contains("GeneralActionSelection")) {
                currentSelectionType = "general";
                tiles = CustomBattleController.getTilesFromSelection(actionSelection, "getTiles");
                maxButtons = 4;
            } else if (selectionClassName.contains("MoveSelection")) {
                currentSelectionType = "moves";
                tiles = CustomBattleController.getTilesFromSelection(actionSelection, "getMoveTiles");
                if (tiles.isEmpty()) {
                    tiles = CustomBattleController.getTilesFromSelection(actionSelection, "getBaseTiles");
                }
                numMoveTiles = tiles.size();
                if (!tiles.isEmpty()) {
                    Object[] sorted = CustomBattleController.sortTilesByPosition(tiles);
                    tiles.clear();
                    for (Object t : sorted) {
                        if (t == null) continue;
                        tiles.add(t);
                    }
                    numMoveTiles = tiles.size();
                }
                if ((backButton = CustomBattleController.getBackButton(actionSelection)) != null) {
                    tiles.add(backButton);
                }
                List<Object> gimmickButtons = CustomBattleController.getAllGimmickButtons(actionSelection);
                for (Object gimmickButton : gimmickButtons) {
                    tiles.add(gimmickButton);
                }
                maxButtons = tiles.size();
            } else if (selectionClassName.contains("SwitchPokemonSelection")) {
                currentSelectionType = "switch";
                tiles = CustomBattleController.getTilesFromSelection(actionSelection, "getTiles");
                backButton = CustomBattleController.getBackButton(actionSelection);
                if (backButton != null) {
                    tiles.add(backButton);
                }
                maxButtons = tiles.size();
                CustomBattleController.refreshPartyPPData();
            } else if (selectionClassName.contains("TargetSelection")) {
                currentSelectionType = "target";
                tiles = CustomBattleController.getTilesFromSelection(actionSelection, "getTiles");
                if (tiles.isEmpty()) {
                    tiles = CustomBattleController.findTilesInFields(actionSelection);
                }
                maxButtons = tiles.size();
            } else {
                currentSelectionType = "unknown";
                tiles = CustomBattleController.getTilesFromSelection(actionSelection, "getTiles");
                if (tiles.isEmpty()) {
                    tiles = CustomBattleController.findTilesInFields(actionSelection);
                }
                maxButtons = tiles.size();
            }
            if (selectedButton >= maxButtons && maxButtons > 0) {
                selectedButton = 0;
            }
            if (!tiles.isEmpty()) {
                Object[] result = currentSelectionType.equals("general") ? CustomBattleController.sortTilesByPosition(tiles) : tiles.toArray();
                cachedTiles = result;
                return result;
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error finding tiles: {}", (Object)t.getMessage());
        }
        cachedTiles = null;
        return null;
    }

    private static Object getActionSelection(class_437 gui) {
        try {
            Method getSelectionMethod = gui.getClass().getMethod("getCurrentActionSelection", new Class[0]);
            return getSelectionMethod.invoke((Object)gui, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            for (Class<?> currentClass = gui.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field f : currentClass.getDeclaredFields()) {
                    String fieldName = f.getName().toLowerCase();
                    if (!fieldName.contains("action") && !fieldName.contains("selection")) continue;
                    try {
                        f.setAccessible(true);
                        Object value = f.get(gui);
                        if (value == null || !value.getClass().getName().contains("ActionSelection")) continue;
                        return value;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static List<Object> getTilesFromSelection(Object actionSelection, String methodName) {
        ArrayList<Object> tiles = new ArrayList<Object>();
        try {
            Method getTilesMethod = actionSelection.getClass().getMethod(methodName, new Class[0]);
            Object tilesObj = getTilesMethod.invoke(actionSelection, new Object[0]);
            if (tilesObj instanceof List) {
                List tilesList = (List)tilesObj;
                for (Object tile : tilesList) {
                    if (tile == null) continue;
                    tiles.add(tile);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tiles;
    }

    private static List<Object> findTilesInFields(Object actionSelection) {
        ArrayList<Object> tiles = new ArrayList<Object>();
        try {
            for (Field f : actionSelection.getClass().getDeclaredFields()) {
                if (!f.getName().toLowerCase().contains("tile") && !f.getType().getName().contains("List")) continue;
                try {
                    f.setAccessible(true);
                    Object value = f.get(actionSelection);
                    if (!(value instanceof List)) continue;
                    List tilesList = (List)value;
                    for (Object tile : tilesList) {
                        if (tile == null || !tile.getClass().getName().contains("Tile")) continue;
                        tiles.add(tile);
                    }
                    if (tiles.isEmpty()) continue;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tiles;
    }

    private static Object getBackButton(Object actionSelection) {
        try {
            Method getBackButtonMethod = actionSelection.getClass().getMethod("getBackButton", new Class[0]);
            return getBackButtonMethod.invoke(actionSelection, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Field backButtonField = actionSelection.getClass().getDeclaredField("backButton");
                backButtonField.setAccessible(true);
                return backButtonField.get(actionSelection);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Object getGimmickButton(Object actionSelection) {
        try {
            Object button;
            Method method2;
            try {
                List buttonList;
                method2 = actionSelection.getClass().getMethod("getGimmickButtons", new Class[0]);
                Object buttons = method2.invoke(actionSelection, new Object[0]);
                if (buttons instanceof List && !(buttonList = (List)buttons).isEmpty()) {
                    Object firstButton = buttonList.get(0);
                    return firstButton;
                }
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
            try {
                method2 = actionSelection.getClass().getMethod("getMegaTeraButton", new Class[0]);
                button = method2.invoke(actionSelection, new Object[0]);
                if (button != null) {
                    return button;
                }
            }
            catch (NoSuchMethodException method3) {
                // empty catch block
            }
            try {
                method2 = actionSelection.getClass().getMethod("getGimmickButton", new Class[0]);
                button = method2.invoke(actionSelection, new Object[0]);
                if (button != null) {
                    return button;
                }
            }
            catch (NoSuchMethodException method4) {
                // empty catch block
            }
            for (Class<?> currentClass = actionSelection.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field f : currentClass.getDeclaredFields()) {
                    String fieldName = f.getName().toLowerCase();
                    if (!fieldName.contains("mega") && !fieldName.contains("tera") && !fieldName.contains("gimmick") && !fieldName.contains("zmove") && !fieldName.contains("dynamax")) continue;
                    try {
                        String className;
                        f.setAccessible(true);
                        Object value = f.get(actionSelection);
                        if (value == null || !(className = value.getClass().getName().toLowerCase()).contains("button") && !className.contains("widget") && !className.contains("tile") && !className.contains("component")) continue;
                        return value;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error finding gimmick button: {}", (Object)t.getMessage());
        }
        return null;
    }

    private static List<Object> getAllGimmickButtons(Object actionSelection) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            try {
                Method method = actionSelection.getClass().getMethod("getGimmickButtons", new Class[0]);
                Object buttons = method.invoke(actionSelection, new Object[0]);
                if (buttons instanceof List) {
                    List buttonList = (List)buttons;
                    for (Object button : buttonList) {
                        if (button == null || !CustomBattleController.isGimmickButtonEnabled(button)) continue;
                        result.add(button);
                    }
                    if (!result.isEmpty()) {
                        return result;
                    }
                }
            }
            catch (NoSuchMethodException method) {
                // empty catch block
            }
            Object singleButton = CustomBattleController.getGimmickButton(actionSelection);
            if (singleButton != null && CustomBattleController.isGimmickButtonEnabled(singleButton)) {
                result.add(singleButton);
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error finding all gimmick buttons: {}", (Object)t.getMessage());
        }
        return result;
    }

    private static boolean isGimmickButtonEnabled(Object button) {
        if (button == null) {
            return false;
        }
        try {
            Object result;
            Object value;
            Class<?> cls;
            try {
                Field activeField = null;
                for (cls = button.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                    try {
                        activeField = cls.getDeclaredField("active");
                        break;
                    }
                    catch (NoSuchFieldException ignored) {
                        continue;
                    }
                }
                if (activeField != null) {
                    activeField.setAccessible(true);
                    value = activeField.get(button);
                    if (value instanceof Boolean) {
                        boolean active = (Boolean)value;
                        CobblemonBattleInfoClient.debug("[CustomController] Gimmick button active field: {}", active);
                        return active;
                    }
                }
            }
            catch (Throwable activeField) {
                // empty catch block
            }
            try {
                Method isActiveMethod = button.getClass().getMethod("isActive", new Class[0]);
                result = isActiveMethod.invoke(button, new Object[0]);
                if (result instanceof Boolean) {
                    boolean active = (Boolean)result;
                    CobblemonBattleInfoClient.debug("[CustomController] Gimmick button isActive(): {}", active);
                    return active;
                }
            }
            catch (NoSuchMethodException isActiveMethod) {
                // empty catch block
            }
            try {
                Method getEnabledMethod = button.getClass().getMethod("getEnabled", new Class[0]);
                result = getEnabledMethod.invoke(button, new Object[0]);
                if (result instanceof Boolean) {
                    boolean enabled = (Boolean)result;
                    CobblemonBattleInfoClient.debug("[CustomController] Gimmick button getEnabled(): {}", enabled);
                    return enabled;
                }
            }
            catch (NoSuchMethodException getEnabledMethod) {
                // empty catch block
            }
            try {
                Field enabledField = null;
                for (cls = button.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                    try {
                        enabledField = cls.getDeclaredField("enabled");
                        break;
                    }
                    catch (NoSuchFieldException ignored) {
                        continue;
                    }
                }
                if (enabledField != null) {
                    enabledField.setAccessible(true);
                    value = enabledField.get(button);
                    if (value instanceof Boolean) {
                        boolean enabled = (Boolean)value;
                        CobblemonBattleInfoClient.debug("[CustomController] Gimmick button enabled field: {}", enabled);
                        return enabled;
                    }
                }
            }
            catch (Throwable enabledField) {
                // empty catch block
            }
            CobblemonBattleInfoClient.debug("[CustomController] Could not determine gimmick button state, defaulting to enabled", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error checking gimmick button enabled state: {}", (Object)t.getMessage());
            return true;
        }
    }

    private static boolean isGimmickButton(Object tile) {
        if (tile == null) {
            return false;
        }
        String className = tile.getClass().getName();
        if (className.contains("GimmickTile") || className.contains("Tile")) {
            return false;
        }
        return className.contains("GimmickButton") || className.contains("DynamaxButton") || className.contains("ZPowerButton") || className.contains("MegaButton") || className.contains("TeraButton");
    }

    private static void renderSelectionArrows(class_332 graphics, int x, int y, int width, int height, boolean isLeftColumn) {
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        long time = System.currentTimeMillis();
        float bobOffset = (float)Math.sin((double)time / 150.0) * 3.0f;
        float colorPhase = (float)(0.5 + 0.5 * Math.sin((double)time / 300.0));
        int red1 = 255;
        int green1 = 50;
        int blue1 = 50;
        int red2 = 255;
        int green2 = 180;
        int blue2 = 50;
        int r = (int)((float)red1 + (float)(red2 - red1) * colorPhase);
        int g = (int)((float)green1 + (float)(green2 - green1) * colorPhase);
        int b = (int)((float)blue1 + (float)(blue2 - blue1) * colorPhase);
        float pulse = (float)(0.85 + 0.15 * Math.sin((double)time / 200.0));
        int alpha = (int)(255.0f * pulse);
        int arrowColor = alpha << 24 | r << 16 | g << 8 | b;
        int shadowColor = Integer.MIN_VALUE;
        int glowAlpha = (int)(180.0f * pulse);
        int glowColor = glowAlpha << 24 | Math.min(255, r + 30) << 16 | Math.min(255, g + 30) << 8 | Math.min(255, b + 30);
        String leftArrow = ">>";
        String rightArrow = "<<";
        Objects.requireNonNull(font);
        int centerY = y + (height - 9) / 2;
        float arrowScale = 1.2f;
        if (isLeftColumn) {
            int arrowWidth = (int)((float)font.method_1727(leftArrow) * arrowScale);
            int leftArrowX = x - arrowWidth - 4 + (int)bobOffset;
            if (leftArrowX < 2) {
                leftArrowX = 2;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)leftArrowX, (float)centerY, 0.0f);
            graphics.method_51448().method_22905(arrowScale, arrowScale, 1.0f);
            graphics.method_51433(font, leftArrow, 1, 1, shadowColor, false);
            graphics.method_51433(font, leftArrow, -1, 0, glowColor, false);
            graphics.method_51433(font, leftArrow, 1, 0, glowColor, false);
            graphics.method_51433(font, leftArrow, 0, 0, arrowColor, false);
            graphics.method_51448().method_22909();
        } else {
            int rightArrowX = x + width + 4 - (int)bobOffset;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)rightArrowX, (float)centerY, 0.0f);
            graphics.method_51448().method_22905(arrowScale, arrowScale, 1.0f);
            graphics.method_51433(font, rightArrow, 1, 1, shadowColor, false);
            graphics.method_51433(font, rightArrow, -1, 0, glowColor, false);
            graphics.method_51433(font, rightArrow, 1, 0, glowColor, false);
            graphics.method_51433(font, rightArrow, 0, 0, arrowColor, false);
            graphics.method_51448().method_22909();
        }
    }

    private static void renderGimmickTooltip(class_332 graphics, Object gimmickButton, int buttonX, int buttonY) {
        try {
            int tooltipColor;
            class_5250 tooltipText;
            String className = gimmickButton.getClass().getName().toLowerCase();
            boolean isTerastallize = false;
            if (className.contains("mega")) {
                tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.mega");
                tooltipColor = -5635841;
            } else if (className.contains("tera")) {
                tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.tera");
                tooltipColor = -16733441;
                isTerastallize = true;
            } else if (className.contains("dynamax") || className.contains("gigantamax")) {
                tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.dynamax");
                tooltipColor = -65434;
            } else if (className.contains("zpower") || className.contains("zmove")) {
                tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.zmove");
                tooltipColor = -22016;
            } else {
                String gimmickType = CustomBattleController.getGimmickType(gimmickButton);
                if (gimmickType.contains("mega")) {
                    tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.mega");
                    tooltipColor = -5635841;
                } else if (gimmickType.contains("tera")) {
                    tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.tera");
                    tooltipColor = -16733441;
                    isTerastallize = true;
                } else if (gimmickType.contains("dynamax")) {
                    tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.dynamax");
                    tooltipColor = -65434;
                } else if (gimmickType.contains("z")) {
                    tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.zmove");
                    tooltipColor = -22016;
                } else {
                    tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.gimmick.generic");
                    tooltipColor = -1;
                }
            }
            String teraTypeName = null;
            if (isTerastallize) {
                teraTypeName = CustomBattleController.getActiveTeraType();
            }
            class_327 font = class_310.method_1551().field_1772;
            int textWidth = font.method_27525((class_5348)tooltipText);
            int textHeight = 9;
            int iconSize = 14;
            int iconPadding = 3;
            int totalWidth = textWidth;
            if (teraTypeName != null) {
                totalWidth += iconSize + iconPadding;
            }
            int paddingH = 4;
            int paddingV = 3;
            int boxWidth = totalWidth + paddingH * 2;
            int boxHeight = textHeight + paddingV * 2;
            int tooltipX = buttonX + 8 - boxWidth / 2;
            int tooltipY = buttonY - boxHeight - 3;
            int screenWidth = class_310.method_1551().method_22683().method_4486();
            if (tooltipX < 5) {
                tooltipX = 5;
            }
            if (tooltipX + boxWidth > screenWidth - 5) {
                tooltipX = screenWidth - boxWidth - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int bgColor = -535816152;
            int borderStart = tooltipColor;
            int borderEnd = CustomBattleController.darkenColor(tooltipColor, 0.6f);
            CustomBattleController.drawFancyTooltipBox(graphics, tooltipX, tooltipY, boxWidth, boxHeight, bgColor, borderStart, borderEnd);
            int textX = tooltipX + paddingH;
            int textY = tooltipY + paddingV;
            graphics.method_51439(font, (class_2561)tooltipText, textX, textY, -1, true);
            if (teraTypeName != null) {
                int iconX = textX + textWidth + iconPadding;
                int iconY = textY + (textHeight - iconSize) / 2;
                boolean megaShowdownLoaded = Services.PLATFORM.isModLoaded("mega_showdown");
                if (megaShowdownLoaded) {
                    class_2960 teraIcon = class_2960.method_60654((String)("mega_showdown:textures/gui/summary/tera_types/" + teraTypeName.toLowerCase() + ".png"));
                    graphics.method_25293(teraIcon, iconX, iconY, iconSize, iconSize, 0.0f, 0.0f, 32, 32, 32, 32);
                } else {
                    ElementalType elementType = TypeIconRenderer.stringToElementalType(teraTypeName);
                    if (elementType != null) {
                        class_2960 typeSheet = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
                        int textureX = elementType.getTextureXMultiplier() * 36;
                        graphics.method_25293(typeSheet, iconX, iconY, iconSize, iconSize, (float)textureX, 0.0f, 36, 36, 648, 36);
                    }
                }
            }
            RenderSystem.disableBlend();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderBackButtonTooltip(class_332 graphics, int buttonX, int buttonY) {
        try {
            class_5250 tooltipText = class_2561.method_43471((String)"tooltip.cobblemon-battle-extras.back");
            int tooltipColor = -3355444;
            class_327 font = class_310.method_1551().field_1772;
            int textWidth = font.method_27525((class_5348)tooltipText);
            int paddingH = 6;
            int paddingV = 4;
            int boxWidth = textWidth + paddingH * 2;
            int boxHeight = 9 + paddingV * 2;
            int tooltipX = buttonX + 8 - boxWidth / 2;
            int tooltipY = buttonY - boxHeight - 4;
            int screenWidth = class_310.method_1551().method_22683().method_4486();
            if (tooltipX < 5) {
                tooltipX = 5;
            }
            if (tooltipX + boxWidth > screenWidth - 5) {
                tooltipX = screenWidth - boxWidth - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int bgColor = -535816152;
            int borderStart = tooltipColor;
            int borderEnd = CustomBattleController.darkenColor(tooltipColor, 0.6f);
            CustomBattleController.drawFancyTooltipBox(graphics, tooltipX, tooltipY, boxWidth, boxHeight, bgColor, borderStart, borderEnd);
            int textX = tooltipX + paddingH;
            int textY = tooltipY + paddingV;
            graphics.method_51439(font, (class_2561)tooltipText, textX, textY, -1, true);
            RenderSystem.disableBlend();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderSwitchScreenTypeIcons(class_332 graphics) {
        if (cachedTiles == null || cachedTiles.length == 0) {
            return;
        }
        try {
            class_2960 typeSheet = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
            int iconSrcSize = 36;
            int sheetWidth = 648;
            int sheetHeight = 36;
            int displaySize = 12;
            int iconSpacing = 1;
            String teraIconPath = "mega_showdown:textures/gui/summary/tera_types/";
            int teraIconSize = 32;
            boolean megaShowdownLoaded = Services.PLATFORM.isModLoaded("mega_showdown");
            for (Object tile : cachedTiles) {
                String tileClassName;
                if (tile == null || !(tileClassName = tile.getClass().getName()).contains("SwitchTile")) continue;
                try {
                    boolean isStellar;
                    Object pokemon;
                    int tileX = CustomBattleController.getTileX(tile);
                    int tileY = CustomBattleController.getTileY(tile);
                    int tileWidth = CustomBattleController.getTileWidth(tile);
                    int tileHeight = CustomBattleController.getTileHeight(tile);
                    if (tileX <= 0 || tileY <= 0 || (pokemon = CustomBattleController.getPokemonFromSwitchTile(tile)) == null) continue;
                    String pokemonName = CustomBattleController.getPokemonSpeciesName(pokemon);
                    boolean isTerastallized = pokemonName != null && BattleMessageSubscriber.isTerastallized(pokemonName);
                    String teraType = pokemonName != null ? BattleMessageSubscriber.getTeraType(pokemonName) : null;
                    String pokemonUUID = CustomBattleController.getPokemonUuidString(pokemon);
                    List<ElementalType> types = CustomBattleController.getTypesDirectlyFromPokemon(pokemon, pokemonName);
                    boolean bl = isStellar = isTerastallized && megaShowdownLoaded && teraType != null && teraType.equalsIgnoreCase("stellar");
                    if ((types == null || types.isEmpty()) && !isStellar) continue;
                    int iconX = tileX + tileWidth - 18;
                    int iconY = tileY + tileHeight - displaySize - 4;
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int offsetX = 0;
                    if (isStellar) {
                        class_2960 stellarIcon = class_2960.method_60654((String)(teraIconPath + "stellar.png"));
                        graphics.method_25293(stellarIcon, iconX - offsetX - displaySize, iconY, displaySize, displaySize, 0.0f, 0.0f, teraIconSize, teraIconSize, teraIconSize, teraIconSize);
                    } else {
                        for (ElementalType type : types) {
                            if (isTerastallized && megaShowdownLoaded) {
                                String typeName = type.getName().toLowerCase();
                                class_2960 teraIcon = class_2960.method_60654((String)(teraIconPath + typeName + ".png"));
                                graphics.method_25293(teraIcon, iconX - offsetX - displaySize, iconY, displaySize, displaySize, 0.0f, 0.0f, teraIconSize, teraIconSize, teraIconSize, teraIconSize);
                            } else {
                                int textureX = type.getTextureXMultiplier() * iconSrcSize;
                                graphics.method_25293(typeSheet, iconX - offsetX - displaySize, iconY, displaySize, displaySize, (float)textureX, 0.0f, iconSrcSize, iconSrcSize, sheetWidth, sheetHeight);
                            }
                            offsetX += displaySize + iconSpacing;
                        }
                    }
                    if (pokemonName == null || !BattleMessageSubscriber.isMegaEvolved(pokemonName)) continue;
                    class_2960 megaIcon = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/mega_icon.png");
                    int megaIconSize = 64;
                    int megaDisplaySize = MEGA_ICON_SIZE_SWITCH;
                    int typeIconsWidth = types.size() * displaySize + (types.size() - 1) * iconSpacing;
                    int megaIconX = iconX - typeIconsWidth - megaDisplaySize - 2 + MEGA_ICON_OFFSET_X_SWITCH;
                    int megaIconY = iconY + MEGA_ICON_OFFSET_Y_SWITCH;
                    graphics.method_25293(megaIcon, megaIconX, megaIconY, megaDisplaySize, megaDisplaySize, 0.0f, 0.0f, megaIconSize, megaIconSize, megaIconSize, megaIconSize);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static List<ElementalType> getTypesFromPokemon(Object pokemon) {
        ArrayList<ElementalType> result = new ArrayList<ElementalType>();
        try {
            List<String> megaTypes;
            Object teraElementType;
            String teraType;
            ElementalType waterType;
            String pokemonUUID;
            String pokemonName;
            block45: {
                pokemonName = CustomBattleController.getPokemonSpeciesName(pokemon);
                pokemonUUID = CustomBattleController.getPokemonUuidString(pokemon);
                try {
                    Class<?> randomizerClientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
                    Method isRunActive = randomizerClientClass.getMethod("isRunActive", new Class[0]);
                    if (!((Boolean)isRunActive.invoke(null, new Object[0])).booleanValue()) break block45;
                    String[] randomizedTypes = null;
                    if (pokemonUUID != null && !pokemonUUID.isEmpty()) {
                        try {
                            Method hasOpponentTypes = randomizerClientClass.getMethod("hasOpponentPokemonTypes", new Class[0]);
                            if (((Boolean)hasOpponentTypes.invoke(null, new Object[0])).booleanValue()) {
                                Method getOpponentTypes = randomizerClientClass.getMethod("getOpponentPokemonTypes", String.class);
                                randomizedTypes = (String[])getOpponentTypes.invoke(null, pokemonUUID);
                            }
                        }
                        catch (Throwable hasOpponentTypes) {
                            // empty catch block
                        }
                        if (randomizedTypes == null || randomizedTypes.length == 0) {
                            try {
                                Method getWildTypes = randomizerClientClass.getMethod("getWildPokemonTypes", String.class);
                                randomizedTypes = (String[])getWildTypes.invoke(null, pokemonUUID);
                            }
                            catch (Throwable getWildTypes) {
                                // empty catch block
                            }
                        }
                    }
                    if (!(randomizedTypes != null && randomizedTypes.length != 0 || pokemonUUID == null || pokemonUUID.isEmpty() || pokemonName == null)) {
                        Method getTypesForPokemon = randomizerClientClass.getMethod("getTypesForPokemon", String.class, String.class);
                        randomizedTypes = (String[])getTypesForPokemon.invoke(null, pokemonName, pokemonUUID);
                    }
                    if ((randomizedTypes == null || randomizedTypes.length == 0) && pokemonName != null) {
                        String[] getTypesForSpecies = randomizerClientClass.getMethod("getTypesForSpecies", String.class);
                        randomizedTypes = (String[])getTypesForSpecies.invoke(null, pokemonName);
                    }
                    if (randomizedTypes != null && randomizedTypes.length > 0) {
                        for (Method method : randomizedTypes) {
                            ElementalType type2 = CustomBattleController.stringToElementalType((String)((Object)method));
                            if (type2 == null) continue;
                            result.add(type2);
                        }
                        if (!result.isEmpty()) {
                            CobblemonBattleInfoClient.debug("[CustomBattleController] Got {} randomized types from Randomizer for {} (UUID: {})", result.size(), pokemonName, pokemonUUID);
                            return result;
                        }
                    }
                }
                catch (ClassNotFoundException randomizerClientClass) {
                }
                catch (Throwable t) {
                    CobblemonBattleInfoClient.debug("[CustomBattleController] Failed to get randomized types: {}", t.getMessage());
                }
            }
            if (pokemonName != null && BattleMessageSubscriber.isSoaked(pokemonName) && (waterType = CustomBattleController.stringToElementalType("water")) != null) {
                result.add(waterType);
                return result;
            }
            if (pokemonName != null && (teraType = BattleMessageSubscriber.getTeraType(pokemonName)) != null && !teraType.isEmpty() && (teraElementType = CustomBattleController.stringToElementalType(teraType)) != null) {
                result.add((ElementalType)teraElementType);
                return result;
            }
            if (pokemonName != null && (megaTypes = BattleMessageSubscriber.getMegaTypes(pokemonName)) != null && !megaTypes.isEmpty()) {
                for (String typeName : megaTypes) {
                    ElementalType megaType = CustomBattleController.stringToElementalType(typeName);
                    if (megaType == null) continue;
                    result.add(megaType);
                }
                if (!result.isEmpty()) {
                    if (BattleMessageSubscriber.isRoosted(pokemonName)) {
                        ElementalType normalType;
                        result.removeIf(type -> type.getName().equalsIgnoreCase("flying"));
                        if (result.isEmpty() && (normalType = CustomBattleController.stringToElementalType("normal")) != null) {
                            result.add(normalType);
                        }
                    }
                    return result;
                }
            }
            try {
                Method getSecondary;
                Object secondary;
                Method getPrimary = pokemon.getClass().getMethod("getPrimaryType", new Class[0]);
                Object primary = getPrimary.invoke(pokemon, new Object[0]);
                if (primary instanceof ElementalType) {
                    result.add((ElementalType)primary);
                }
                if ((secondary = (getSecondary = pokemon.getClass().getMethod("getSecondaryType", new Class[0])).invoke(pokemon, new Object[0])) instanceof ElementalType) {
                    result.add((ElementalType)secondary);
                }
            }
            catch (Throwable getPrimary) {
                // empty catch block
            }
            if (!result.isEmpty()) {
                CobblemonBattleInfoClient.debug("[CustomBattleController] Got {} types from getPrimaryType/getSecondaryType for {} (UUID: {})", result.size(), pokemonName, pokemonUUID);
            } else {
                Method getTypes;
                Object types = null;
                try {
                    Method getForm = pokemon.getClass().getMethod("getForm", new Class[0]);
                    Object form = getForm.invoke(pokemon, new Object[0]);
                    if (form != null) {
                        getTypes = form.getClass().getMethod("getTypes", new Class[0]);
                        types = getTypes.invoke(form, new Object[0]);
                    }
                }
                catch (Throwable getForm) {
                    // empty catch block
                }
                if (types == null) {
                    try {
                        Method getSpecies = pokemon.getClass().getMethod("getSpecies", new Class[0]);
                        Object species = getSpecies.invoke(pokemon, new Object[0]);
                        if (species != null) {
                            getTypes = species.getClass().getMethod("getTypes", new Class[0]);
                            types = getTypes.invoke(species, new Object[0]);
                        }
                    }
                    catch (Throwable getSpecies) {
                        // empty catch block
                    }
                }
                if (types == null) {
                    try {
                        Method getTypes2 = pokemon.getClass().getMethod("getTypes", new Class[0]);
                        types = getTypes2.invoke(pokemon, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (types instanceof Iterable) {
                    for (Object type3 : (Iterable)types) {
                        if (!(type3 instanceof ElementalType)) continue;
                        result.add((ElementalType)type3);
                    }
                }
            }
            if (pokemonName != null && BattleMessageSubscriber.isRoosted(pokemonName) && !result.isEmpty()) {
                ElementalType normalType;
                result.removeIf(type -> {
                    String typeName = type.getName().toLowerCase();
                    return typeName.equals("flying");
                });
                if (result.isEmpty() && (normalType = CustomBattleController.stringToElementalType("normal")) != null) {
                    result.add(normalType);
                }
            }
            if (pokemonName != null && BattleMessageSubscriber.hasBurnedUp(pokemonName) && !result.isEmpty()) {
                result.removeIf(type -> {
                    String typeName = type.getName().toLowerCase();
                    return typeName.equals("fire");
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static List<ElementalType> getTypesDirectlyFromPokemon(Object pokemon, String pokemonName) {
        ArrayList<ElementalType> result = new ArrayList<ElementalType>();
        if (pokemonName != null) {
            String teraType = BattleMessageSubscriber.getTeraType(pokemonName);
            if (teraType != null && !teraType.isEmpty()) {
                if (teraType.equalsIgnoreCase("Stellar")) {
                    return null;
                }
                ElementalType teraElementType = CustomBattleController.stringToElementalType(teraType);
                if (teraElementType != null) {
                    result.add(teraElementType);
                    return result;
                }
            }
            if (BattleMessageSubscriber.isSoaked(pokemonName)) {
                ElementalType waterType = CustomBattleController.stringToElementalType("water");
                if (waterType != null) {
                    result.add(waterType);
                }
                return result;
            }
        }
        try {
            Method getSecondary;
            Object secondary;
            Method getPrimary = pokemon.getClass().getMethod("getPrimaryType", new Class[0]);
            Object primary = getPrimary.invoke(pokemon, new Object[0]);
            if (primary instanceof ElementalType) {
                result.add((ElementalType)primary);
            }
            if ((secondary = (getSecondary = pokemon.getClass().getMethod("getSecondaryType", new Class[0])).invoke(pokemon, new Object[0])) instanceof ElementalType) {
                result.add((ElementalType)secondary);
            }
            CobblemonBattleInfoClient.debug("[CustomBattleController] Got {} types from Pokemon.getPrimaryType/getSecondaryType for {}", result.size(), pokemonName);
        }
        catch (Throwable e) {
            CobblemonBattleInfoClient.debug("[CustomBattleController] Failed to get types from Pokemon for {}: {}", pokemonName, e.getMessage());
        }
        return result;
    }

    private static ElementalType stringToElementalType(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        try {
            Class<?> elementalTypesClass = Class.forName("com.cobblemon.mod.common.api.types.ElementalTypes");
            Method getMethod = elementalTypesClass.getMethod("get", String.class);
            Object result = getMethod.invoke(null, typeName.toLowerCase());
            if (result instanceof ElementalType) {
                return (ElementalType)result;
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("Could not resolve type: {}", typeName);
        }
        return null;
    }

    private static void renderSwitchMovesTooltip(class_332 graphics, Object switchTile, int tileX, int tileY, int tileWidth, int tileHeight) {
        if (!BattleExtrasConfig.isSwitchTooltipsEnabled()) {
            return;
        }
        try {
            int screenWidth;
            int tileCenterX;
            class_5250 abilityComponent;
            int abilityWidth;
            Object pokemon = CustomBattleController.getPokemonFromSwitchTile(switchTile);
            if (pokemon == null) {
                return;
            }
            List<MoveDisplayInfo> moveInfos = CustomBattleController.getMovesWithPPFromPokemon(pokemon);
            if (moveInfos.isEmpty()) {
                return;
            }
            String abilityName = CustomBattleController.getAbilityFromPokemon(pokemon);
            class_327 font = class_310.method_1551().field_1772;
            class_2960 typeSheet = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
            int iconSrcSize = 36;
            int sheetWidth = 648;
            int sheetHeight = 36;
            int iconDisplaySize = 10;
            int lineHeight = 12;
            int maxWidth = 0;
            for (MoveDisplayInfo info : moveInfos) {
                String displayText = info.displayName + " " + info.currentPP + "/" + info.maxPP;
                int width = font.method_1727(displayText);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            if (abilityName != null && !abilityName.isEmpty() && (abilityWidth = font.method_27525((class_5348)(abilityComponent = class_2561.method_43469((String)"move.battleinfo.ability", (Object[])new Object[]{abilityName})))) > maxWidth) {
                maxWidth = abilityWidth;
            }
            int padding = 6;
            int boxWidth = maxWidth + padding * 2 + iconDisplaySize + 8;
            int boxHeight = moveInfos.size() * lineHeight + padding * 2;
            if (abilityName != null && !abilityName.isEmpty()) {
                boxHeight += lineHeight + 8;
            }
            boolean isLeftColumn = (tileCenterX = tileX + tileWidth / 2) < (screenWidth = class_310.method_1551().method_22683().method_4486()) / 2;
            int tooltipX = isLeftColumn ? tileX - boxWidth - 8 : tileX + tileWidth + 8;
            int tooltipY = tileY + tileHeight / 2 - boxHeight / 2;
            if (tooltipX < 5) {
                tooltipX = 5;
            }
            if (tooltipX + boxWidth > screenWidth - 5) {
                tooltipX = screenWidth - boxWidth - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            CustomBattleController.drawFancySwitchTooltipBox(graphics, tooltipX, tooltipY, boxWidth, boxHeight);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int yOffset = tooltipY + padding;
            for (MoveDisplayInfo info : moveInfos) {
                int iconX = tooltipX + padding;
                int iconY = yOffset;
                if (info.moveType != null) {
                    try {
                        Method getXMultiplier = info.moveType.getClass().getMethod("getTextureXMultiplier", new Class[0]);
                        Object xMultResult = getXMultiplier.invoke(info.moveType, new Object[0]);
                        if (xMultResult instanceof Number) {
                            int textureX = ((Number)xMultResult).intValue() * iconSrcSize;
                            graphics.method_25293(typeSheet, iconX, iconY, iconDisplaySize, iconDisplaySize, (float)textureX, 0.0f, iconSrcSize, iconSrcSize, sheetWidth, sheetHeight);
                        }
                    }
                    catch (Exception e) {
                        Integer typeColor = BattleMessageColorizer.getMoveTypeColor(info.rawName);
                        if (typeColor == null) {
                            typeColor = -1;
                        }
                        graphics.method_25294(iconX, iconY + 1, iconX + iconDisplaySize, iconY + 1 + iconDisplaySize - 2, typeColor | 0xFF000000);
                    }
                } else {
                    Integer typeColor = BattleMessageColorizer.getMoveTypeColor(info.rawName);
                    if (typeColor == null) {
                        typeColor = -1;
                    }
                    graphics.method_25294(iconX, iconY + 1, iconX + iconDisplaySize, iconY + 1 + iconDisplaySize - 2, typeColor | 0xFF000000);
                }
                String displayName = info.displayName;
                int nameX = tooltipX + padding + iconDisplaySize + 4;
                graphics.method_25303(font, displayName, nameX, yOffset + 1, -1);
                String ppText = " " + info.currentPP + "/" + info.maxPP;
                int ppX = nameX + font.method_1727(displayName);
                int ppColor = CustomBattleController.getPPColor(info.currentPP, info.maxPP);
                graphics.method_25303(font, ppText, ppX, yOffset + 1, ppColor);
                yOffset += lineHeight;
            }
            if (abilityName != null && !abilityName.isEmpty()) {
                CustomBattleController.drawFancySwitchSeparator(graphics, tooltipX + padding, yOffset += 3, boxWidth - padding * 2);
                class_5250 abilityComponent2 = class_2561.method_43469((String)"move.battleinfo.ability", (Object[])new Object[]{abilityName});
                graphics.method_27535(font, (class_2561)abilityComponent2, tooltipX + padding, yOffset += 6, -10035764);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void drawFancySwitchTooltipBox(class_332 graphics, int x, int y, int width, int height) {
        int borderColor;
        float progress;
        int i;
        int cornerRadius = 3;
        int bgColor = -535816152;
        graphics.method_25294(x + cornerRadius, y, x + width - cornerRadius, y + height, bgColor);
        graphics.method_25294(x, y + cornerRadius, x + width, y + height - cornerRadius, bgColor);
        graphics.method_25294(x + 1, y + 1, x + cornerRadius, y + cornerRadius, bgColor);
        graphics.method_25294(x + width - cornerRadius, y + 1, x + width - 1, y + cornerRadius, bgColor);
        graphics.method_25294(x + 1, y + height - cornerRadius, x + cornerRadius, y + height - 1, bgColor);
        graphics.method_25294(x + width - cornerRadius, y + height - cornerRadius, x + width - 1, y + height - 1, bgColor);
        int borderTop = -582689332;
        int borderBottom = -584939401;
        graphics.method_25294(x + cornerRadius, y, x + width - cornerRadius, y + 1, borderTop);
        graphics.method_25294(x + cornerRadius, y + height - 1, x + width - cornerRadius, y + height, borderBottom);
        for (i = cornerRadius; i < height - cornerRadius; ++i) {
            progress = (float)i / (float)height;
            borderColor = CustomBattleController.mixColors(borderTop, borderBottom, progress);
            graphics.method_25294(x, y + i, x + 1, y + i + 1, borderColor);
        }
        for (i = cornerRadius; i < height - cornerRadius; ++i) {
            progress = (float)i / (float)height;
            borderColor = CustomBattleController.mixColors(borderTop, borderBottom, progress);
            graphics.method_25294(x + width - 1, y + i, x + width, y + i + 1, borderColor);
        }
        graphics.method_25294(x + 1, y + 1, x + 2, y + 2, borderTop);
        graphics.method_25294(x + width - 2, y + 1, x + width - 1, y + 2, borderTop);
        graphics.method_25294(x + 1, y + height - 2, x + 2, y + height - 1, borderBottom);
        graphics.method_25294(x + width - 2, y + height - 2, x + width - 1, y + height - 1, borderBottom);
        int highlightColor = 0x30FFFFFF;
        graphics.method_25294(x + cornerRadius, y + 1, x + width - cornerRadius, y + 2, highlightColor);
    }

    private static void drawFancySwitchSeparator(class_332 graphics, int x, int y, int width) {
        int centerX = x + width / 2;
        int diamondSize = 2;
        int adjustedCenterX = centerX - 1;
        for (int i = 0; i < adjustedCenterX - x - diamondSize - 2; ++i) {
            float progress = (float)i / (float)(adjustedCenterX - x - diamondSize - 2);
            int alpha = (int)(progress * 120.0f);
            int lineColor = alpha << 24 | 0x44DDCC;
            graphics.method_25294(x + i, y, x + i + 1, y + 1, lineColor);
        }
        int rightStart = adjustedCenterX + diamondSize + 3;
        int rightLen = x + width - rightStart;
        for (int i = 0; i < rightLen; ++i) {
            float progress = 1.0f - (float)i / (float)rightLen;
            int alpha = (int)(progress * 120.0f);
            int lineColor = alpha << 24 | 0x44DDCC;
            graphics.method_25294(rightStart + i, y, rightStart + i + 1, y + 1, lineColor);
        }
        int diamondColor = -867902004;
        graphics.method_25294(adjustedCenterX, y - diamondSize, adjustedCenterX + 1, y + diamondSize + 1, diamondColor);
        graphics.method_25294(adjustedCenterX - diamondSize, y, adjustedCenterX + diamondSize + 1, y + 1, diamondColor);
    }

    private static int getPPColor(int current, int max) {
        if (max <= 0) {
            return -5592406;
        }
        float ratio = (float)current / (float)max;
        if (current == 0) {
            return -48060;
        }
        if (ratio <= 0.25f) {
            return -22016;
        }
        if (ratio <= 0.5f) {
            return -256;
        }
        return -12255420;
    }

    private static List<MoveDisplayInfo> getMovesWithPPFromPokemon(Object pokemon) {
        ArrayList<MoveDisplayInfo> result;
        block51: {
            result = new ArrayList<MoveDisplayInfo>();
            try {
                String pokemonName = CustomBattleController.getPokemonSpeciesName(pokemon);
                Object moveSet = null;
                for (String methodName : new String[]{"getMoveSet", "getMoves", "moveSet", "moves", "getMoveset"}) {
                    try {
                        Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                        moveSet = method.invoke(pokemon, new Object[0]);
                        if (moveSet == null) continue;
                        break;
                    }
                    catch (NoSuchMethodException method) {
                        // empty catch block
                    }
                }
                if (moveSet == null) {
                    return result;
                }
                Iterable moveIterable = null;
                try {
                    Method getMovesMethod = moveSet.getClass().getMethod("getMoves", new Class[0]);
                    Object movesObj = getMovesMethod.invoke(moveSet, new Object[0]);
                    if (movesObj instanceof Iterable) {
                        moveIterable = (Iterable)movesObj;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (moveIterable == null && moveSet instanceof Iterable) {
                    moveIterable = (Iterable)moveSet;
                }
                if (moveIterable == null) break block51;
                for (Object move : moveIterable) {
                    String effectDescription;
                    double effectChance;
                    String displayName;
                    Object moveType;
                    int maxPP;
                    int currentPP;
                    String moveName;
                    block52: {
                        Method getTemplate3;
                        if (move == null) continue;
                        moveName = null;
                        currentPP = 0;
                        maxPP = 0;
                        for (String methodName : new String[]{"getName", "getDisplayName", "name"}) {
                            try {
                                Method method = move.getClass().getMethod(methodName, new Class[0]);
                                Object nameResult = method.invoke(move, new Object[0]);
                                if (nameResult == null) continue;
                                moveName = nameResult.toString();
                                break;
                            }
                            catch (NoSuchMethodException method) {
                                // empty catch block
                            }
                        }
                        if (moveName == null) {
                            try {
                                Method nameMethod;
                                Object nameResult;
                                Method getTemplate2 = move.getClass().getMethod("getTemplate", new Class[0]);
                                Object template = getTemplate2.invoke(move, new Object[0]);
                                if (template != null && (nameResult = (nameMethod = template.getClass().getMethod("getName", new Class[0])).invoke(template, new Object[0])) != null) {
                                    moveName = nameResult.toString();
                                }
                            }
                            catch (NoSuchMethodException getTemplate2) {
                                // empty catch block
                            }
                        }
                        try {
                            Method getPP = move.getClass().getMethod("getCurrentPp", new Class[0]);
                            Object ppResult = getPP.invoke(move, new Object[0]);
                            if (ppResult instanceof Number) {
                                currentPP = ((Number)ppResult).intValue();
                            }
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                Method getPP = move.getClass().getMethod("getPp", new Class[0]);
                                Object ppResult = getPP.invoke(move, new Object[0]);
                                if (ppResult instanceof Number) {
                                    currentPP = ((Number)ppResult).intValue();
                                }
                            }
                            catch (NoSuchMethodException getPP) {
                                // empty catch block
                            }
                        }
                        try {
                            Method getMaxPP = move.getClass().getMethod("getMaxPp", new Class[0]);
                            Object maxPPResult = getMaxPP.invoke(move, new Object[0]);
                            if (maxPPResult instanceof Number) {
                                maxPP = ((Number)maxPPResult).intValue();
                            }
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                Method ppMethod;
                                Object ppResult;
                                getTemplate3 = move.getClass().getMethod("getTemplate", new Class[0]);
                                Object template = getTemplate3.invoke(move, new Object[0]);
                                if (template != null && (ppResult = (ppMethod = template.getClass().getMethod("getPp", new Class[0])).invoke(template, new Object[0])) instanceof Number) {
                                    maxPP = ((Number)ppResult).intValue();
                                }
                            }
                            catch (NoSuchMethodException getTemplate3) {
                                // empty catch block
                            }
                        }
                        if (maxPP == 0 && currentPP > 0) {
                            maxPP = currentPP;
                        }
                        if (moveName != null) {
                            int[] battleTrackedPP = BattleMessageSubscriber.getMovePP(pokemonName, moveName);
                            if (battleTrackedPP != null) {
                                currentPP = battleTrackedPP[0];
                                maxPP = battleTrackedPP[1];
                                CobblemonBattleInfoClient.debug("[CustomController] Using BATTLE-TRACKED PP for {}'s {} -> {}/{}", pokemonName, moveName, currentPP, maxPP);
                            } else {
                                BattleMessageSubscriber.initializeMovePP(pokemonName, moveName, currentPP, maxPP);
                                CobblemonBattleInfoClient.debug("[CustomController] Initialized PP tracking for {}'s {} -> {}/{}", pokemonName, moveName, currentPP, maxPP);
                            }
                        }
                        moveType = null;
                        try {
                            getTemplate3 = move.getClass().getMethod("getTemplate", new Class[0]);
                            Object template = getTemplate3.invoke(move, new Object[0]);
                            if (template != null) {
                                Method getElementalType = template.getClass().getMethod("getElementalType", new Class[0]);
                                moveType = getElementalType.invoke(template, new Object[0]);
                            }
                        }
                        catch (NoSuchMethodException ignored) {
                            try {
                                Method getElementalType = move.getClass().getMethod("getElementalType", new Class[0]);
                                moveType = getElementalType.invoke(move, new Object[0]);
                            }
                            catch (NoSuchMethodException getElementalType) {
                                // empty catch block
                            }
                        }
                        if (moveType == null) {
                            try {
                                Method getType = move.getClass().getMethod("getType", new Class[0]);
                                moveType = getType.invoke(move, new Object[0]);
                            }
                            catch (NoSuchMethodException getType) {
                                // empty catch block
                            }
                        }
                        if (moveName == null || moveName.isEmpty()) continue;
                        displayName = moveName;
                        effectChance = 0.0;
                        effectDescription = null;
                        try {
                            Method getTemplate4 = move.getClass().getMethod("getTemplate", new Class[0]);
                            Object template = getTemplate4.invoke(move, new Object[0]);
                            if (template == null) break block52;
                            try {
                                Method getDisplayName = template.getClass().getMethod("getDisplayName", new Class[0]);
                                Object displayNameComponent = getDisplayName.invoke(template, new Object[0]);
                                if (displayNameComponent != null) {
                                    Method getString = displayNameComponent.getClass().getMethod("getString", new Class[0]);
                                    displayName = getString.invoke(displayNameComponent, new Object[0]).toString();
                                }
                            }
                            catch (Exception e) {
                                displayName = CustomBattleController.formatMoveName(moveName);
                            }
                            try {
                                Method getEffectChance = template.getClass().getMethod("getEffectChance", new Class[0]);
                                Object chanceResult = getEffectChance.invoke(template, new Object[0]);
                                if (chanceResult instanceof Number) {
                                    effectChance = ((Number)chanceResult).doubleValue();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (effectChance > 0.0) {
                                effectDescription = "";
                            }
                        }
                        catch (Exception e) {
                            displayName = CustomBattleController.formatMoveName(moveName);
                        }
                    }
                    result.add(new MoveDisplayInfo(moveName, displayName, currentPP, maxPP, moveType, effectChance, effectDescription));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private static String getPokemonSpeciesName(Object pokemon) {
        if (pokemon == null) {
            return null;
        }
        try {
            Object name;
            try {
                Method getName;
                Object name2;
                Method getSpecies = pokemon.getClass().getMethod("getSpecies", new Class[0]);
                Object species = getSpecies.invoke(pokemon, new Object[0]);
                if (species != null && (name2 = (getName = species.getClass().getMethod("getName", new Class[0])).invoke(species, new Object[0])) != null) {
                    return name2.toString();
                }
            }
            catch (NoSuchMethodException getSpecies) {
                // empty catch block
            }
            try {
                Method getDisplayName = pokemon.getClass().getMethod("getDisplayName", new Class[0]);
                name = getDisplayName.invoke(pokemon, new Object[0]);
                if (name != null) {
                    return name.toString();
                }
            }
            catch (NoSuchMethodException getDisplayName) {
                // empty catch block
            }
            try {
                Method getName = pokemon.getClass().getMethod("getName", new Class[0]);
                name = getName.invoke(pokemon, new Object[0]);
                if (name != null) {
                    return name.toString();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getPokemonUuidString(Object pokemon) {
        if (pokemon == null) {
            return null;
        }
        for (String methodName : new String[]{"getUuid", "getUUID", "uuid", "getId", "getIdAsString"}) {
            try {
                String uuidStr;
                Method getUuidMethod = pokemon.getClass().getMethod(methodName, new Class[0]);
                Object uuidObj = getUuidMethod.invoke(pokemon, new Object[0]);
                if (uuidObj == null || !CustomBattleController.isValidUuidString(uuidStr = uuidObj.toString())) continue;
                return uuidStr;
            }
            catch (Throwable getUuidMethod) {
                // empty catch block
            }
        }
        try {
            for (Class<?> clazz = pokemon.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = fieldArray.length;
                for (int methodName = 0; methodName < n; ++methodName) {
                    String uuidStr;
                    Field field = fieldArray[methodName];
                    String fieldName = field.getName().toLowerCase();
                    if (!fieldName.contains("uuid") && !fieldName.equals("id")) continue;
                    field.setAccessible(true);
                    Object uuidObj = field.get(pokemon);
                    if (uuidObj == null || !CustomBattleController.isValidUuidString(uuidStr = uuidObj.toString())) continue;
                    return uuidStr;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (String methodName : new String[]{"getPokemon", "pokemon", "getOriginalPokemon", "getEffectedPokemon"}) {
            try {
                String innerUuid;
                Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                Object inner = method.invoke(pokemon, new Object[0]);
                if (inner == null || inner == pokemon || (innerUuid = CustomBattleController.getPokemonUuidString(inner)) == null || innerUuid.isEmpty()) continue;
                return innerUuid;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isValidUuidString(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            UUID.fromString(value);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    private static void refreshPartyPPData() {
        block29: {
            cachedPartyPP.clear();
            try {
                Class<?> cobblemonClass = Class.forName("com.cobblemon.mod.common.Cobblemon");
                Method getStorage = cobblemonClass.getMethod("getStorage", new Class[0]);
                Object storage = getStorage.invoke(null, new Object[0]);
                if (storage == null) {
                    return;
                }
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 == null) {
                    return;
                }
                Method getParty = storage.getClass().getMethod("getParty", class_1657.class);
                Object party = getParty.invoke(storage, mc.field_1724);
                if (party == null) {
                    return;
                }
                Method iterator = party.getClass().getMethod("iterator", new Class[0]);
                Object iter = iterator.invoke(party, new Object[0]);
                if (!(iter instanceof Iterator)) break block29;
                Iterator it = (Iterator)iter;
                while (it.hasNext()) {
                    String pokemonName;
                    Object pokemon = it.next();
                    if (pokemon == null || (pokemonName = CustomBattleController.getPokemonSpeciesName(pokemon)) == null) continue;
                    ConcurrentHashMap<String, int[]> movePPMap = new ConcurrentHashMap<String, int[]>();
                    Object moveSet = null;
                    try {
                        Method getMoveSet = pokemon.getClass().getMethod("getMoveSet", new Class[0]);
                        moveSet = getMoveSet.invoke(pokemon, new Object[0]);
                    }
                    catch (NoSuchMethodException getMoveSet) {
                        // empty catch block
                    }
                    if (moveSet == null) continue;
                    Iterable moveIterable = null;
                    try {
                        Method getMoves = moveSet.getClass().getMethod("getMoves", new Class[0]);
                        Object movesObj = getMoves.invoke(moveSet, new Object[0]);
                        if (movesObj instanceof Iterable) {
                            moveIterable = (Iterable)movesObj;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (moveIterable == null && moveSet instanceof Iterable) {
                        moveIterable = (Iterable)moveSet;
                    }
                    if (moveIterable != null) {
                        for (Object move : moveIterable) {
                            if (move == null) continue;
                            String moveName = null;
                            int currentPP = 0;
                            int maxPP = 0;
                            try {
                                Method getName = move.getClass().getMethod("getName", new Class[0]);
                                Object nameResult = getName.invoke(move, new Object[0]);
                                if (nameResult != null) {
                                    moveName = nameResult.toString();
                                }
                            }
                            catch (NoSuchMethodException ignored) {
                                try {
                                    Method templateName;
                                    Object nameResult;
                                    Method getTemplate = move.getClass().getMethod("getTemplate", new Class[0]);
                                    Object template = getTemplate.invoke(move, new Object[0]);
                                    if (template != null && (nameResult = (templateName = template.getClass().getMethod("getName", new Class[0])).invoke(template, new Object[0])) != null) {
                                        moveName = nameResult.toString();
                                    }
                                }
                                catch (NoSuchMethodException getTemplate) {
                                    // empty catch block
                                }
                            }
                            try {
                                Method getCurrentPp = move.getClass().getMethod("getCurrentPp", new Class[0]);
                                Object ppResult = getCurrentPp.invoke(move, new Object[0]);
                                if (ppResult instanceof Number) {
                                    currentPP = ((Number)ppResult).intValue();
                                }
                            }
                            catch (NoSuchMethodException ignored) {
                                try {
                                    Method getPp = move.getClass().getMethod("getPp", new Class[0]);
                                    Object ppResult = getPp.invoke(move, new Object[0]);
                                    if (ppResult instanceof Number) {
                                        currentPP = ((Number)ppResult).intValue();
                                    }
                                }
                                catch (NoSuchMethodException getPp) {
                                    // empty catch block
                                }
                            }
                            try {
                                Method getMaxPp = move.getClass().getMethod("getMaxPp", new Class[0]);
                                Object maxResult = getMaxPp.invoke(move, new Object[0]);
                                if (maxResult instanceof Number) {
                                    maxPP = ((Number)maxResult).intValue();
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            if (moveName == null || moveName.isEmpty()) continue;
                            movePPMap.put(moveName.toLowerCase(), new int[]{currentPP, maxPP});
                        }
                    }
                    if (movePPMap.isEmpty()) continue;
                    cachedPartyPP.put(pokemonName.toLowerCase(), movePPMap);
                    CobblemonBattleInfoClient.debug("[CustomController] Cached PP for {}: {}", pokemonName, movePPMap.size() + " moves");
                }
            }
            catch (Throwable t) {
                CobblemonBattleInfoClient.debug("[CustomController] Error refreshing party PP: {}", t.getMessage());
            }
        }
    }

    private static int[] getPartyPokemonMovePP(String pokemonName, String moveName) {
        if (pokemonName == null || moveName == null) {
            return null;
        }
        String lowerPokemon = pokemonName.toLowerCase();
        String lowerMove = moveName.toLowerCase();
        Map<String, int[]> moves = cachedPartyPP.get(lowerPokemon);
        if (moves != null) {
            return moves.get(lowerMove);
        }
        for (Map<String, int[]> moveMap : cachedPartyPP.values()) {
            if (!moveMap.containsKey(lowerMove)) continue;
            return moveMap.get(lowerMove);
        }
        return null;
    }

    public static void clearTeraTypeCache() {
        cachedTeraTypes.clear();
        CobblemonBattleInfoClient.debug("[CustomController] Tera type cache cleared", new Object[0]);
    }

    private static String getActiveTeraType() {
        try {
            ClientBattlePokemon battlePokemon;
            block37: {
                class_746 player;
                String syncedTeraType;
                ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
                if (battle == null) {
                    return null;
                }
                SingleActionRequest request = battle.getFirstUnansweredRequest();
                if (request == null) {
                    return null;
                }
                ActiveClientBattlePokemon activePokemon = request.getActivePokemon();
                if (activePokemon == null) {
                    return null;
                }
                battlePokemon = activePokemon.getBattlePokemon();
                if (battlePokemon == null) {
                    return null;
                }
                UUID pokemonUuid = null;
                try {
                    Method getUuidMethod = battlePokemon.getClass().getMethod("getUuid", new Class[0]);
                    Object uuidObj = getUuidMethod.invoke((Object)battlePokemon, new Object[0]);
                    if (uuidObj instanceof UUID) {
                        pokemonUuid = (UUID)uuidObj;
                    }
                }
                catch (NoSuchMethodException getUuidMethod) {
                    // empty catch block
                }
                if (pokemonUuid != null && (syncedTeraType = TeraTypeClientData.getTeraType(pokemonUuid.toString())) != null && !syncedTeraType.isEmpty()) {
                    CobblemonBattleInfoClient.debug("[CustomController] Got tera type from synced data (PRIORITY 1): {}", syncedTeraType);
                    return syncedTeraType;
                }
                String pokemonName = null;
                try {
                    Method getSpeciesMethod = battlePokemon.getClass().getMethod("getSpecies", new Class[0]);
                    Object species = getSpeciesMethod.invoke((Object)battlePokemon, new Object[0]);
                    if (species != null) {
                        Method getNameMethod = species.getClass().getMethod("getName", new Class[0]);
                        pokemonName = (String)getNameMethod.invoke(species, new Object[0]);
                    }
                }
                catch (Exception getSpeciesMethod) {
                    // empty catch block
                }
                if (pokemonName != null) {
                    String subscriberTeraType = BattleMessageSubscriber.getTeraType("player", pokemonName);
                    if (subscriberTeraType == null || subscriberTeraType.isEmpty()) {
                        subscriberTeraType = BattleMessageSubscriber.getTeraType(pokemonName);
                    }
                    if (subscriberTeraType != null && !subscriberTeraType.isEmpty()) {
                        CobblemonBattleInfoClient.debug("[CustomController] Got tera type from BattleMessageSubscriber: {}", subscriberTeraType);
                        if (pokemonUuid != null) {
                            cachedTeraTypes.put(pokemonUuid.toString(), subscriberTeraType);
                        }
                        return subscriberTeraType;
                    }
                }
                if (pokemonUuid != null && (player = class_310.method_1551().field_1724) != null) {
                    try {
                        Method getStorageMethod;
                        Object storage;
                        Class<?> cobblemonClass = Class.forName("com.cobblemon.mod.common.Cobblemon");
                        Field instanceField = cobblemonClass.getField("INSTANCE");
                        Object cobblemonInstance = instanceField.get(null);
                        if (cobblemonInstance == null || (storage = (getStorageMethod = cobblemonInstance.getClass().getMethod("getStorage", new Class[0])).invoke(cobblemonInstance, new Object[0])) == null) break block37;
                        Object party = null;
                        Method getPartyMethod = null;
                        Class<?> secondParamClass = null;
                        for (Method method : storage.getClass().getMethods()) {
                            Class<?>[] params;
                            if (!method.getName().equals("getParty") || method.getParameterCount() != 2 || (params = method.getParameterTypes())[0] != UUID.class) continue;
                            getPartyMethod = method;
                            secondParamClass = params[1];
                            break;
                        }
                        if (getPartyMethod == null || secondParamClass == null) break block37;
                        class_5455 secondParam = null;
                        if (secondParamClass.isEnum()) {
                            T[] enumConstants = secondParamClass.getEnumConstants();
                            if (enumConstants != null && enumConstants.length > 0) {
                                secondParam = (class_5455)enumConstants[0];
                            }
                        } else if (secondParamClass.getName().contains("class_5455") || secondParamClass.getName().contains("RegistryAccess")) {
                            class_310 mc = class_310.method_1551();
                            if (mc.field_1687 != null) {
                                secondParam = mc.field_1687.method_30349();
                            }
                        }
                        if (secondParam == null || (party = getPartyMethod.invoke(storage, player.method_5667(), secondParam)) == null) break block37;
                        Method iteratorMethod = party.getClass().getMethod("iterator", new Class[0]);
                        Iterator iterator = (Iterator)iteratorMethod.invoke(party, new Object[0]);
                        while (iterator.hasNext()) {
                            Object pokemon = iterator.next();
                            if (pokemon == null) continue;
                            try {
                                String teraTypeName;
                                Method getUuidMethod = pokemon.getClass().getMethod("getUuid", new Class[0]);
                                Object uuidObj = getUuidMethod.invoke(pokemon, new Object[0]);
                                if (!pokemonUuid.equals(uuidObj)) continue;
                                Method getTeraTypeMethod = pokemon.getClass().getMethod("getTeraType", new Class[0]);
                                Object teraType = getTeraTypeMethod.invoke(pokemon, new Object[0]);
                                if (teraType != null && (teraTypeName = CustomBattleController.getTeraTypeName(teraType)) != null) {
                                    CobblemonBattleInfoClient.debug("[CustomController] Got tera type from party (PRIORITY 1): {}", teraTypeName);
                                    return teraTypeName;
                                }
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    catch (Exception e) {
                        CobblemonBattleInfoClient.debug("[CustomController] Failed to get tera type from party: {}", e.getMessage());
                    }
                }
            }
            try {
                String teraTypeName;
                Method getTeraTypeMethod = battlePokemon.getClass().getMethod("getTeraType", new Class[0]);
                Object teraType = getTeraTypeMethod.invoke((Object)battlePokemon, new Object[0]);
                if (teraType != null && (teraTypeName = CustomBattleController.getTeraTypeName(teraType)) != null) {
                    CobblemonBattleInfoClient.debug("[CustomController] Got tera type from battlePokemon: {}", teraTypeName);
                    return teraTypeName;
                }
            }
            catch (NoSuchMethodException getTeraTypeMethod) {
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[CustomController] Failed to get tera type from battlePokemon: {}", e.getMessage());
            }
            try {
                String teraTypeName;
                Method getTeraTypeMethod;
                Object teraType;
                Method createMethod;
                Object pokemon;
                Method getPropertiesMethod = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                Object properties = getPropertiesMethod.invoke((Object)battlePokemon, new Object[0]);
                if (properties != null && (pokemon = (createMethod = properties.getClass().getMethod("create", new Class[0])).invoke(properties, new Object[0])) != null && (teraType = (getTeraTypeMethod = pokemon.getClass().getMethod("getTeraType", new Class[0])).invoke(pokemon, new Object[0])) != null && (teraTypeName = CustomBattleController.getTeraTypeName(teraType)) != null) {
                    CobblemonBattleInfoClient.debug("[CustomController] Got tera type from properties.create() (fallback): {}", teraTypeName);
                    return teraTypeName;
                }
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[CustomController] Failed to get tera type from properties.create(): {}", e.getMessage());
            }
            return null;
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[CustomController] Error getting active tera type: {}", t.getMessage());
            return null;
        }
    }

    private static String getTeraTypeName(Object teraType) {
        if (teraType == null) {
            return null;
        }
        try {
            Method showdownIdMethod = teraType.getClass().getMethod("showdownId", new Class[0]);
            return (String)showdownIdMethod.invoke(teraType, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            try {
                Method getTypeMethod = teraType.getClass().getMethod("getType", new Class[0]);
                Object elementalType = getTypeMethod.invoke(teraType, new Object[0]);
                if (elementalType != null) {
                    Method getNameMethod = elementalType.getClass().getMethod("getName", new Class[0]);
                    return (String)getNameMethod.invoke(elementalType, new Object[0]);
                }
            }
            catch (Exception e2) {
                CobblemonBattleInfoClient.debug("[CustomController] Failed to get tera type name: {}", e2.getMessage());
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[CustomController] Failed to call showdownId: {}", e.getMessage());
        }
        return null;
    }

    private static String getAbilityFromPokemon(Object pokemon) {
        try {
            String abilityName;
            block29: {
                Object ability;
                block28: {
                    ability = null;
                    for (String methodName : new String[]{"getAbility", "ability"}) {
                        try {
                            Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                            ability = method.invoke(pokemon, new Object[0]);
                            if (ability == null) continue;
                            break;
                        }
                        catch (NoSuchMethodException method) {
                            // empty catch block
                        }
                    }
                    if (ability == null) {
                        return null;
                    }
                    abilityName = null;
                    try {
                        Method getDisplayName = ability.getClass().getMethod("getDisplayName", new Class[0]);
                        Object displayName = getDisplayName.invoke(ability, new Object[0]);
                        if (displayName == null) break block28;
                        try {
                            Method getString = displayName.getClass().getMethod("getString", new Class[0]);
                            Object str = getString.invoke(displayName, new Object[0]);
                            if (str != null) {
                                abilityName = str.toString();
                            }
                        }
                        catch (NoSuchMethodException e) {
                            abilityName = displayName.toString();
                        }
                    }
                    catch (NoSuchMethodException getDisplayName) {
                        // empty catch block
                    }
                }
                if (abilityName == null || abilityName.isEmpty()) {
                    try {
                        Method getName = ability.getClass().getMethod("getName", new Class[0]);
                        Object name = getName.invoke(ability, new Object[0]);
                        if (name != null) {
                            abilityName = name.toString();
                        }
                    }
                    catch (NoSuchMethodException getName) {
                        // empty catch block
                    }
                }
                if (abilityName == null || abilityName.isEmpty()) {
                    try {
                        Method getName;
                        Object name;
                        Object template;
                        block30: {
                            Method getTemplate = ability.getClass().getMethod("getTemplate", new Class[0]);
                            template = getTemplate.invoke(ability, new Object[0]);
                            if (template == null) break block29;
                            try {
                                Method getDisplayName = template.getClass().getMethod("getDisplayName", new Class[0]);
                                Object displayName = getDisplayName.invoke(template, new Object[0]);
                                if (displayName == null) break block30;
                                try {
                                    Method getString = displayName.getClass().getMethod("getString", new Class[0]);
                                    Object str = getString.invoke(displayName, new Object[0]);
                                    if (str != null) {
                                        abilityName = str.toString();
                                    }
                                }
                                catch (NoSuchMethodException e) {
                                    abilityName = displayName.toString();
                                }
                            }
                            catch (NoSuchMethodException getDisplayName) {
                                // empty catch block
                            }
                        }
                        if ((abilityName == null || abilityName.isEmpty()) && (name = (getName = template.getClass().getMethod("getName", new Class[0])).invoke(template, new Object[0])) != null) {
                            abilityName = name.toString();
                        }
                    }
                    catch (NoSuchMethodException getTemplate) {
                        // empty catch block
                    }
                }
            }
            if (abilityName != null && !abilityName.isEmpty()) {
                String translationKey;
                class_5250 translated;
                String translatedName;
                int lastDot;
                if (abilityName.contains(":")) {
                    abilityName = abilityName.substring(abilityName.indexOf(":") + 1);
                }
                if (abilityName.contains(".") && (lastDot = abilityName.lastIndexOf(".")) >= 0 && lastDot < abilityName.length() - 1) {
                    abilityName = abilityName.substring(lastDot + 1);
                }
                if ((translatedName = (translated = class_2561.method_43471((String)(translationKey = "cobblemon.ability." + abilityName.toLowerCase()))).getString()).equals(translationKey)) {
                    return CustomBattleController.formatMoveName(abilityName);
                }
                return translatedName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Object getPokemonFromSwitchTile(Object switchTile) {
        try {
            for (String methodName : new String[]{"getPokemon", "pokemon", "getBattlePokemon"}) {
                try {
                    Method method = switchTile.getClass().getMethod(methodName, new Class[0]);
                    Object result = method.invoke(switchTile, new Object[0]);
                    if (result == null) continue;
                    return result;
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            for (Class<?> clazz = switchTile.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    String fieldName = field.getName().toLowerCase();
                    if (!fieldName.contains("pokemon")) continue;
                    field.setAccessible(true);
                    Object result = field.get(switchTile);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static List<String> getMovesFromPokemon(Object pokemon) {
        ArrayList<String> moves = new ArrayList<String>();
        try {
            Object moveSet = null;
            for (String methodName : new String[]{"getMoveSet", "getMoves", "moveSet", "moves", "getMoveset"}) {
                try {
                    Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                    moveSet = method.invoke(pokemon, new Object[0]);
                    if (moveSet == null) continue;
                    break;
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            if (moveSet == null) {
                block13: for (Class<?> clazz = pokemon.getClass(); clazz != null && clazz != Object.class && moveSet == null; clazz = clazz.getSuperclass()) {
                    for (Field field : clazz.getDeclaredFields()) {
                        String fieldName = field.getName().toLowerCase();
                        if (!fieldName.contains("move")) continue;
                        field.setAccessible(true);
                        moveSet = field.get(pokemon);
                        if (moveSet != null) continue block13;
                    }
                }
            }
            if (moveSet == null) {
                return moves;
            }
            Iterable moveIterable = null;
            try {
                Method getMovesMethod = moveSet.getClass().getMethod("getMoves", new Class[0]);
                Object movesObj = getMovesMethod.invoke(moveSet, new Object[0]);
                if (movesObj instanceof Iterable) {
                    moveIterable = (Iterable)movesObj;
                }
            }
            catch (NoSuchMethodException getMovesMethod) {
                // empty catch block
            }
            if (moveIterable == null && moveSet instanceof Iterable) {
                moveIterable = (Iterable)moveSet;
            }
            if (moveIterable == null) {
                try {
                    Method toListMethod = moveSet.getClass().getMethod("toList", new Class[0]);
                    Object listObj = toListMethod.invoke(moveSet, new Object[0]);
                    if (listObj instanceof Iterable) {
                        moveIterable = (Iterable)listObj;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (moveIterable != null) {
                for (Object move : moveIterable) {
                    if (move == null) continue;
                    String moveName = null;
                    for (String methodName : new String[]{"getName", "getDisplayName", "name", "getTemplate"}) {
                        try {
                            Method method = move.getClass().getMethod(methodName, new Class[0]);
                            Object result = method.invoke(move, new Object[0]);
                            if (result == null) continue;
                            if (methodName.equals("getTemplate") && result != null) {
                                try {
                                    Method nameMethod = result.getClass().getMethod("getName", new Class[0]);
                                    Object nameResult = nameMethod.invoke(result, new Object[0]);
                                    if (nameResult == null) continue;
                                    moveName = nameResult.toString();
                                    break;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    continue;
                                }
                            }
                            moveName = result.toString();
                            break;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (moveName == null || moveName.isEmpty()) continue;
                    moves.add(moveName);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return moves;
    }

    private static String formatMoveName(String moveName) {
        String processed;
        if (moveName == null || moveName.isEmpty()) {
            return "";
        }
        if (moveName.contains(":")) {
            moveName = moveName.substring(moveName.indexOf(":") + 1);
        }
        if (!(processed = moveName.replace("_", " ")).contains(" ") && processed.length() > 6) {
            processed = CustomBattleController.splitConcatenatedWords(processed.toLowerCase());
        }
        String[] words = processed.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1).toLowerCase());
        }
        return result.toString();
    }

    private static String splitConcatenatedWords(String name) {
        String[] wordParts = new String[]{"thunder", "shadow", "dragon", "psychic", "sacred", "ancient", "bullet", "cosmic", "double", "energy", "extreme", "future", "giga", "harsh", "heavy", "hyper", "leafy", "mega", "night", "origin", "phantom", "power", "quick", "rapid", "razor", "seismic", "signal", "solar", "spacial", "stealth", "strange", "super", "water", "weather", "wicked", "destiny", "natural", "refresh", "punishment", "confusion", "fire", "ice", "rock", "steel", "fairy", "dark", "ghost", "grass", "ground", "flying", "poison", "bug", "electric", "fighting", "normal", "beam", "blast", "blitz", "blow", "bomb", "breath", "buzz", "cannon", "charge", "claw", "combat", "crash", "cutter", "dance", "drain", "edge", "energy", "fang", "force", "gem", "gleam", "hammer", "head", "horn", "impact", "kick", "leaf", "meteor", "mash", "palm", "peck", "power", "pulse", "punch", "rage", "rush", "seed", "slam", "slash", "slide", "smash", "sneak", "speed", "spin", "storm", "strike", "sweep", "swing", "tackle", "tail", "terrain", "throw", "toss", "veil", "wave", "wheel", "whip", "wind", "wing", "gift", "bond", "switch", "gun", "ally", "stomping", "tantrum", "plot", "smack", "attack", "ball", "burst", "ray", "shot"};
        String remaining = name.toLowerCase();
        StringBuilder result = new StringBuilder();
        while (!remaining.isEmpty()) {
            boolean found = false;
            for (String part : wordParts) {
                if (!remaining.startsWith(part)) continue;
                if (result.length() > 0) {
                    result.append(" ");
                }
                result.append(part);
                remaining = remaining.substring(part.length());
                found = true;
                break;
            }
            if (found) continue;
            int earliestMatch = remaining.length();
            String matchedPart = null;
            for (String part : wordParts) {
                int idx = remaining.indexOf(part);
                if (idx <= 0 || idx >= earliestMatch) continue;
                earliestMatch = idx;
                matchedPart = part;
            }
            if (matchedPart != null && earliestMatch > 0) {
                if (result.length() > 0) {
                    result.append(" ");
                }
                result.append(remaining.substring(0, earliestMatch));
                remaining = remaining.substring(earliestMatch);
                continue;
            }
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(remaining);
            break;
        }
        return result.toString();
    }

    private static String getGimmickType(Object gimmickButton) {
        try {
            try {
                Method getGimmick = gimmickButton.getClass().getMethod("getGimmick", new Class[0]);
                Object gimmick = getGimmick.invoke(gimmickButton, new Object[0]);
                if (gimmick != null) {
                    String gimmickStr = gimmick.toString().toLowerCase();
                    return gimmickStr;
                }
            }
            catch (NoSuchMethodException getGimmick) {
                // empty catch block
            }
            try {
                Method getType = gimmickButton.getClass().getMethod("getType", new Class[0]);
                Object type = getType.invoke(gimmickButton, new Object[0]);
                if (type != null) {
                    String typeStr = type.toString().toLowerCase();
                    return typeStr;
                }
            }
            catch (NoSuchMethodException getType) {
                // empty catch block
            }
            try {
                Method getName = gimmickButton.getClass().getMethod("getName", new Class[0]);
                Object name = getName.invoke(gimmickButton, new Object[0]);
                if (name != null) {
                    String nameStr = name.toString().toLowerCase();
                    return nameStr;
                }
            }
            catch (NoSuchMethodException getName) {
                // empty catch block
            }
            for (Class<?> clazz = gimmickButton.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field f : clazz.getDeclaredFields()) {
                    try {
                        String valueStr;
                        f.setAccessible(true);
                        Object value = f.get(gimmickButton);
                        if (value == null || !(valueStr = value.toString().toLowerCase()).contains("mega") && !valueStr.contains("tera") && !valueStr.contains("dynamax") && !valueStr.contains("zmove") && !valueStr.contains("z_move") && !valueStr.contains("gigantamax")) continue;
                        return valueStr;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error getting gimmick type: {}", (Object)t.getMessage());
        }
        return "";
    }

    private static boolean isBackButton(Object tile) {
        if (tile == null) {
            return false;
        }
        String className = tile.getClass().getName();
        return className.contains("BackButton") || className.contains("BattleBackButton");
    }

    private static Object[] sortTilesByPosition(List<Object> tiles) {
        int[][] positions = new int[tiles.size()][2];
        for (int i = 0; i < tiles.size(); ++i) {
            positions[i][0] = CustomBattleController.getTileX(tiles.get(i));
            positions[i][1] = CustomBattleController.getTileY(tiles.get(i));
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int[] pos : positions) {
            minX = Math.min(minX, pos[0]);
            maxX = Math.max(maxX, pos[0]);
            minY = Math.min(minY, pos[1]);
            maxY = Math.max(maxY, pos[1]);
        }
        int midX = (minX + maxX) / 2;
        int midY = (minY + maxY) / 2;
        Object[] result = new Object[4];
        for (int i = 0; i < tiles.size() && i < 4; ++i) {
            boolean isTop;
            Object tile = tiles.get(i);
            int x = positions[i][0];
            int y = positions[i][1];
            boolean isLeft = x < midX;
            boolean bl = isTop = y < midY;
            int idx = isTop && isLeft ? 0 : (isTop && !isLeft ? 1 : (!isTop && isLeft ? 2 : 3));
            result[idx] = tile;
        }
        return result;
    }

    private static int getTileX(Object tile) {
        try {
            Method method = tile.getClass().getMethod("getX", new Class[0]);
            Object result = method.invoke(tile, new Object[0]);
            if (result instanceof Float) {
                return ((Float)result).intValue();
            }
            return ((Number)result).intValue();
        }
        catch (Throwable t) {
            try {
                Field field = tile.getClass().getDeclaredField("x");
                field.setAccessible(true);
                Object result = field.get(tile);
                if (result instanceof Float) {
                    return ((Float)result).intValue();
                }
                return ((Number)result).intValue();
            }
            catch (Throwable t2) {
                return 0;
            }
        }
    }

    private static int getTileY(Object tile) {
        try {
            Method method = tile.getClass().getMethod("getY", new Class[0]);
            Object result = method.invoke(tile, new Object[0]);
            if (result instanceof Float) {
                return ((Float)result).intValue();
            }
            return ((Number)result).intValue();
        }
        catch (Throwable t) {
            try {
                Field field = tile.getClass().getDeclaredField("y");
                field.setAccessible(true);
                Object result = field.get(tile);
                if (result instanceof Float) {
                    return ((Float)result).intValue();
                }
                return ((Number)result).intValue();
            }
            catch (Throwable t2) {
                return 0;
            }
        }
    }

    private static int getTileWidth(Object tile) {
        String tileClassName = tile.getClass().getName();
        if (tileClassName.contains("BackButton")) {
            return 24;
        }
        if (CustomBattleController.isGimmickButton(tile)) {
            return 20;
        }
        if (tileClassName.contains("MoveTile") || tileClassName.contains("GimmickTile") || tileClassName.contains("DynamaxTile")) {
            return 91;
        }
        if (tileClassName.contains("SwitchPokemonSelection")) {
            return 91;
        }
        try {
            Field widthField = tile.getClass().getDeclaredField("OPTION_WIDTH");
            widthField.setAccessible(true);
            Object value = widthField.get(null);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        catch (Throwable widthField) {
            // empty catch block
        }
        try {
            int width;
            Method method = tile.getClass().getMethod("getWidth", new Class[0]);
            Object result = method.invoke(tile, new Object[0]);
            if (result instanceof Number && (width = ((Number)result).intValue()) > 0 && width <= 200) {
                return width;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return BUTTON_WIDTH;
    }

    private static int getTileHeight(Object tile) {
        String tileClassName = tile.getClass().getName();
        CobblemonBattleInfoClient.debug("[CustomController] getTileHeight for class: {}", tileClassName);
        if (tileClassName.contains("BackButton")) {
            return 15;
        }
        if (CustomBattleController.isGimmickButton(tile)) {
            return 15;
        }
        if (tileClassName.contains("MoveTile") || tileClassName.contains("GimmickTile") || tileClassName.contains("DynamaxTile")) {
            return 24;
        }
        if (tileClassName.contains("SwitchPokemonSelection")) {
            return 23;
        }
        try {
            Field heightField = tile.getClass().getDeclaredField("OPTION_HEIGHT");
            heightField.setAccessible(true);
            Object value = heightField.get(null);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        catch (Throwable heightField) {
            // empty catch block
        }
        try {
            int height;
            Method method = tile.getClass().getMethod("getHeight", new Class[0]);
            Object result = method.invoke(tile, new Object[0]);
            if (result instanceof Number && (height = ((Number)result).intValue()) > 0 && height <= 100) {
                return height;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return BUTTON_HEIGHT;
    }

    private static boolean isBattleGUI(class_437 screen) {
        if (screen == null) {
            return false;
        }
        return screen.getClass().getName().contains("BattleGUI");
    }

    private static void invokeMouseMoved(class_437 gui, double x, double y) {
        try {
            Method method = gui.getClass().getMethod("mouseMoved", Double.TYPE, Double.TYPE);
            method.invoke((Object)gui, x, y);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void handleInput(class_310 mc, class_437 gui) {
        long now = System.currentTimeMillis();
        if (now - lastInputTime < 150L) {
            return;
        }
        boolean upNow = CustomBattleController.isUpPressed();
        boolean downNow = CustomBattleController.isDownPressed();
        boolean leftNow = CustomBattleController.isLeftPressed();
        boolean rightNow = CustomBattleController.isRightPressed();
        boolean selectNow = CustomBattleController.isSelectPressed();
        boolean backNow = CustomBattleController.isBackPressed();
        if (upNow && !upPressed) {
            CustomBattleController.navigateUp();
            lastInputTime = now;
        }
        if (downNow && !downPressed) {
            CustomBattleController.navigateDown();
            lastInputTime = now;
        }
        if (leftNow && !leftPressed) {
            CustomBattleController.navigateLeft();
            lastInputTime = now;
        }
        if (rightNow && !rightPressed) {
            CustomBattleController.navigateRight();
            lastInputTime = now;
        }
        if (selectNow && !selectPressed) {
            CobblemonBattleInfoClient.debug("[CustomController] SELECT pressed! Activating button {}", selectedButton);
            CustomBattleController.activateButton(gui);
            lastInputTime = now;
        }
        if (backNow && !backPressed) {
            CobblemonBattleInfoClient.debug("[CustomController] BACK pressed! Going back from {}", currentSelectionType);
            CustomBattleController.goBack(gui);
            lastInputTime = now;
        }
        upPressed = upNow;
        downPressed = downNow;
        leftPressed = leftNow;
        rightPressed = rightNow;
        selectPressed = selectNow;
        backPressed = backNow;
    }

    private static void navigateUp() {
        int cols = CustomBattleController.getGridColumns();
        if (currentSelectionType.equals("moves") && selectedButton >= numMoveTiles) {
            int bottomMoveRow = (numMoveTiles - 1) / cols;
            int bottomLeftMove = bottomMoveRow * cols;
            selectedButton = bottomLeftMove < numMoveTiles ? bottomLeftMove : 0;
            lastNavigationTime = System.currentTimeMillis();
        } else if (currentSelectionType.equals("switch")) {
            int backButtonIndex;
            int numPokemonTiles = backButtonIndex = maxButtons - 1;
            if (selectedButton == backButtonIndex) {
                int bottomPokemonRow = (numPokemonTiles - 1) / cols;
                int bottomLeftPokemon = bottomPokemonRow * cols;
                selectedButton = bottomLeftPokemon < numPokemonTiles ? bottomLeftPokemon : 0;
                lastNavigationTime = System.currentTimeMillis();
            } else {
                int newButton = selectedButton - cols;
                if (newButton >= 0) {
                    selectedButton = newButton;
                    lastNavigationTime = System.currentTimeMillis();
                }
            }
        } else {
            int newButton = selectedButton - cols;
            if (newButton >= 0) {
                selectedButton = newButton;
                lastNavigationTime = System.currentTimeMillis();
            }
        }
        CobblemonBattleInfoClient.debug("[CustomController] UP -> Button {} (type: {}, numMoves: {})", selectedButton, currentSelectionType, numMoveTiles);
    }

    private static void navigateDown() {
        int cols = CustomBattleController.getGridColumns();
        if (currentSelectionType.equals("moves")) {
            int row = selectedButton / cols;
            int col = selectedButton % cols;
            int bottomMoveRow = (numMoveTiles - 1) / cols;
            if (selectedButton < numMoveTiles) {
                if (row == bottomMoveRow) {
                    int backButtonIndex = numMoveTiles;
                    int firstGimmickIndex = numMoveTiles + 1;
                    if (col == 0) {
                        selectedButton = backButtonIndex;
                        lastNavigationTime = System.currentTimeMillis();
                    } else if (col == 1 && maxButtons > firstGimmickIndex) {
                        selectedButton = firstGimmickIndex;
                        lastNavigationTime = System.currentTimeMillis();
                    } else if (maxButtons > backButtonIndex) {
                        selectedButton = backButtonIndex;
                        lastNavigationTime = System.currentTimeMillis();
                    }
                } else {
                    int newButton = selectedButton + cols;
                    if (newButton < numMoveTiles) {
                        selectedButton = newButton;
                        lastNavigationTime = System.currentTimeMillis();
                    } else if (newButton >= numMoveTiles) {
                        int backButtonIndex;
                        selectedButton = backButtonIndex = numMoveTiles;
                        lastNavigationTime = System.currentTimeMillis();
                    }
                }
            }
        } else if (currentSelectionType.equals("switch")) {
            int backButtonIndex = maxButtons - 1;
            int numPokemonTiles = backButtonIndex;
            if (selectedButton < numPokemonTiles) {
                int newButton = selectedButton + cols;
                if (newButton < numPokemonTiles) {
                    selectedButton = newButton;
                    lastNavigationTime = System.currentTimeMillis();
                } else {
                    selectedButton = backButtonIndex;
                    lastNavigationTime = System.currentTimeMillis();
                }
            }
        } else {
            int newButton = selectedButton + cols;
            if (newButton < maxButtons) {
                selectedButton = newButton;
                lastNavigationTime = System.currentTimeMillis();
            }
        }
        CobblemonBattleInfoClient.debug("[CustomController] DOWN -> Button {} (type: {}, numMoves: {})", selectedButton, currentSelectionType, numMoveTiles);
    }

    private static void navigateLeft() {
        int cols = CustomBattleController.getGridColumns();
        if (currentSelectionType.equals("moves") && selectedButton >= numMoveTiles) {
            int backButtonIndex = numMoveTiles;
            if (selectedButton > backButtonIndex) {
                --selectedButton;
                lastNavigationTime = System.currentTimeMillis();
            }
        } else if (selectedButton % cols > 0) {
            --selectedButton;
            lastNavigationTime = System.currentTimeMillis();
        }
        CobblemonBattleInfoClient.debug("[CustomController] LEFT -> Button {} (type: {})", selectedButton, currentSelectionType);
    }

    private static void navigateRight() {
        int cols = CustomBattleController.getGridColumns();
        if (currentSelectionType.equals("moves") && selectedButton >= numMoveTiles) {
            if (selectedButton + 1 < maxButtons) {
                ++selectedButton;
                lastNavigationTime = System.currentTimeMillis();
            }
        } else if (currentSelectionType.equals("moves") && selectedButton < numMoveTiles) {
            int firstGimmickIndex;
            int row = selectedButton / cols;
            int col = selectedButton % cols;
            int bottomMoveRow = (numMoveTiles - 1) / cols;
            int rightNeighbor = selectedButton + 1;
            if (col + 1 < cols && rightNeighbor < numMoveTiles) {
                selectedButton = rightNeighbor;
                lastNavigationTime = System.currentTimeMillis();
            } else if (col == 0 && row == bottomMoveRow && numMoveTiles % cols == 1 && maxButtons > (firstGimmickIndex = numMoveTiles + 1)) {
                selectedButton = firstGimmickIndex;
                lastNavigationTime = System.currentTimeMillis();
            }
        } else if (selectedButton % cols < cols - 1 && selectedButton + 1 < maxButtons) {
            ++selectedButton;
            lastNavigationTime = System.currentTimeMillis();
        }
        CobblemonBattleInfoClient.debug("[CustomController] RIGHT -> Button {} (type: {})", selectedButton, currentSelectionType);
    }

    private static int getGridColumns() {
        switch (currentSelectionType) {
            case "general": 
            case "moves": {
                return 2;
            }
            case "switch": {
                return 2;
            }
            case "target": {
                return maxButtons;
            }
        }
        return 2;
    }

    private static void activateButton(class_437 gui) {
        try {
            Object[] tiles = CustomBattleController.findBattleOptionTiles(gui);
            if ("general".equals(currentSelectionType) && selectedButton == 3) {
                CustomBattleController.setBattleGuiClosed();
                CobblemonBattleInfoClient.debug("[CustomController] Run button clicked, marking GUI closed for jump suppression", new Object[0]);
            }
            if (tiles != null && selectedButton < tiles.length && tiles[selectedButton] != null) {
                Object result;
                Method method;
                Object selectedTile = tiles[selectedButton];
                int x = CustomBattleController.getTileX(selectedTile);
                int y = CustomBattleController.getTileY(selectedTile);
                int width = CustomBattleController.getTileWidth(selectedTile);
                int height = CustomBattleController.getTileHeight(selectedTile);
                int centerX = x + width / 2;
                int centerY = y + height / 2;
                CobblemonBattleInfoClient.debug("[CustomController] ACTIVATE {} at tile ({}, {}) type: {}", selectedButton, x, y, currentSelectionType);
                boolean clicked = false;
                if (CustomBattleController.isBackButton(selectedTile)) {
                    boolean backHandled = false;
                    try {
                        Method onClickMethod = selectedTile.getClass().getMethod("onClick", new Class[0]);
                        onClickMethod.invoke(selectedTile, new Object[0]);
                        backHandled = true;
                        CobblemonBattleInfoClient.debug("[CustomController] back onClick() invoked", new Object[0]);
                    }
                    catch (Throwable onClickMethod) {
                        // empty catch block
                    }
                    if (!backHandled) {
                        try {
                            Method m = selectedTile.getClass().getMethod("mouseClicked", Double.TYPE, Double.TYPE, Integer.TYPE);
                            Object res = m.invoke(selectedTile, centerX, centerY, 0);
                            if (res instanceof Boolean && ((Boolean)res).booleanValue()) {
                                backHandled = true;
                            }
                        }
                        catch (Throwable m) {
                            // empty catch block
                        }
                    }
                    if (!backHandled) {
                        try {
                            Method m2 = selectedTile.getClass().getMethod("mousePrimaryClicked", Double.TYPE, Double.TYPE);
                            Object res2 = m2.invoke(selectedTile, centerX, centerY);
                            if (res2 instanceof Boolean && ((Boolean)res2).booleanValue()) {
                                backHandled = true;
                            }
                        }
                        catch (Throwable m2) {
                            // empty catch block
                        }
                    }
                    if (!backHandled) {
                        try {
                            Method getOn = selectedTile.getClass().getMethod("getOnClick", new Class[0]);
                            Object onClick = getOn.invoke(selectedTile, new Object[0]);
                            if (onClick != null) {
                                Method invokeMethod = onClick.getClass().getMethod("invoke", new Class[0]);
                                invokeMethod.invoke(onClick, new Object[0]);
                                backHandled = true;
                            }
                        }
                        catch (Throwable getOn) {
                            // empty catch block
                        }
                    }
                    if (!backHandled) {
                        CustomBattleController.goBack(gui);
                    }
                    return;
                }
                if (CustomBattleController.isGimmickButton(selectedTile)) {
                    boolean gimmickHandled = false;
                    CobblemonBattleInfoClient.debug("[CustomController] Activating gimmick button: {}", selectedTile.getClass().getName());
                    Object actionSelection = CustomBattleController.getActionSelection(gui);
                    if (actionSelection != null) {
                        try {
                            Method toggleMethod;
                            Object toggleResult;
                            Method getGimmickButtons = actionSelection.getClass().getMethod("getGimmickButtons", new Class[0]);
                            Object buttons = getGimmickButtons.invoke(actionSelection, new Object[0]);
                            if (buttons instanceof List) {
                                List buttonList = (List)buttons;
                                for (Object button : buttonList) {
                                    if (button == selectedTile) continue;
                                    try {
                                        Method setToggled = button.getClass().getMethod("setToggled", Boolean.TYPE);
                                        setToggled.invoke(button, false);
                                    }
                                    catch (Throwable setToggled) {}
                                }
                            }
                            boolean isToggled = (toggleResult = (toggleMethod = selectedTile.getClass().getMethod("toggle", new Class[0])).invoke(selectedTile, new Object[0])) instanceof Boolean && (Boolean)toggleResult != false;
                            Method setMoveTiles = actionSelection.getClass().getMethod("setMoveTiles", List.class);
                            if (isToggled) {
                                Method getTiles = selectedTile.getClass().getMethod("getTiles", new Class[0]);
                                Object gimmickTiles = getTiles.invoke(selectedTile, new Object[0]);
                                setMoveTiles.invoke(actionSelection, gimmickTiles);
                                CobblemonBattleInfoClient.debug("[CustomController] Gimmick toggled ON - using gimmick tiles", new Object[0]);
                            } else {
                                Method getBaseTiles = actionSelection.getClass().getMethod("getBaseTiles", new Class[0]);
                                Object baseTiles = getBaseTiles.invoke(actionSelection, new Object[0]);
                                setMoveTiles.invoke(actionSelection, baseTiles);
                                CobblemonBattleInfoClient.debug("[CustomController] Gimmick toggled OFF - using base tiles", new Object[0]);
                            }
                            gimmickHandled = true;
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] Gimmick full toggle failed: {}", t.getMessage());
                        }
                    }
                    if (!gimmickHandled) {
                        try {
                            Method toggleMethod = selectedTile.getClass().getMethod("toggle", new Class[0]);
                            Object result2 = toggleMethod.invoke(selectedTile, new Object[0]);
                            gimmickHandled = true;
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick toggle() succeeded, result: {}", result2);
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick toggle() failed: {}", t.getMessage());
                        }
                    }
                    if (!gimmickHandled) {
                        try {
                            Method onClickMethod = selectedTile.getClass().getMethod("onClick", new Class[0]);
                            onClickMethod.invoke(selectedTile, new Object[0]);
                            gimmickHandled = true;
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick onClick() succeeded", new Object[0]);
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick onClick() failed: {}", t.getMessage());
                        }
                    }
                    if (!gimmickHandled) {
                        try {
                            Method m = selectedTile.getClass().getMethod("mouseClicked", Double.TYPE, Double.TYPE, Integer.TYPE);
                            Object res = m.invoke(selectedTile, centerX, centerY, 0);
                            if (res instanceof Boolean && ((Boolean)res).booleanValue()) {
                                gimmickHandled = true;
                                CobblemonBattleInfoClient.debug("[CustomController] gimmick mouseClicked succeeded", new Object[0]);
                            }
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick mouseClicked failed: {}", t.getMessage());
                        }
                    }
                    if (!gimmickHandled) {
                        try {
                            Method m2 = selectedTile.getClass().getMethod("mousePrimaryClicked", Double.TYPE, Double.TYPE);
                            Object res2 = m2.invoke(selectedTile, centerX, centerY);
                            if (res2 instanceof Boolean && ((Boolean)res2).booleanValue()) {
                                gimmickHandled = true;
                                CobblemonBattleInfoClient.debug("[CustomController] gimmick mousePrimaryClicked succeeded", new Object[0]);
                            }
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick mousePrimaryClicked failed: {}", t.getMessage());
                        }
                    }
                    if (!gimmickHandled) {
                        try {
                            Method getOn = selectedTile.getClass().getMethod("getOnClick", new Class[0]);
                            Object onClick = getOn.invoke(selectedTile, new Object[0]);
                            if (onClick != null) {
                                Method invokeMethod = onClick.getClass().getMethod("invoke", new Class[0]);
                                invokeMethod.invoke(onClick, new Object[0]);
                                gimmickHandled = true;
                                CobblemonBattleInfoClient.debug("[CustomController] gimmick getOnClick() succeeded", new Object[0]);
                            }
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick getOnClick failed: {}", t.getMessage());
                        }
                    }
                    if (!gimmickHandled) {
                        try {
                            gui.method_25402((double)centerX, (double)centerY, 0);
                            gimmickHandled = true;
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick gui.mouseClicked fallback succeeded", new Object[0]);
                        }
                        catch (Throwable t) {
                            CobblemonBattleInfoClient.debug("[CustomController] gimmick gui.mouseClicked failed: {}", t.getMessage());
                        }
                    }
                    if (gimmickHandled) {
                        CobblemonBattleInfoClient.debug("[CustomController] Gimmick button activated successfully", new Object[0]);
                    } else {
                        CobblemonBattleInfoClient.LOGGER.warn("[CustomController] Failed to activate gimmick button");
                    }
                    return;
                }
                if (currentSelectionType.equals("moves") || currentSelectionType.equals("switch")) {
                    try {
                        Method onClickMethod = selectedTile.getClass().getMethod("onClick", new Class[0]);
                        onClickMethod.invoke(selectedTile, new Object[0]);
                        clicked = true;
                        selectedButton = 0;
                        CobblemonBattleInfoClient.debug("[CustomController] onClick() succeeded!", new Object[0]);
                    }
                    catch (Throwable t) {
                        CobblemonBattleInfoClient.debug("[CustomController] onClick() failed: {}", t.getMessage());
                    }
                }
                if (!clicked) {
                    try {
                        method = selectedTile.getClass().getMethod("mouseClicked", Double.TYPE, Double.TYPE, Integer.TYPE);
                        result = method.invoke(selectedTile, centerX, centerY, 0);
                        if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                            clicked = true;
                            selectedButton = 0;
                            CobblemonBattleInfoClient.debug("[CustomController] mouseClicked succeeded!", new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        CobblemonBattleInfoClient.debug("[CustomController] mouseClicked failed: {}", t.getMessage());
                    }
                }
                if (!clicked) {
                    try {
                        method = selectedTile.getClass().getMethod("mousePrimaryClicked", Double.TYPE, Double.TYPE);
                        result = method.invoke(selectedTile, centerX, centerY);
                        if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                            clicked = true;
                            selectedButton = 0;
                            CobblemonBattleInfoClient.debug("[CustomController] mousePrimaryClicked succeeded!", new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        CobblemonBattleInfoClient.debug("[CustomController] mousePrimaryClicked failed: {}", t.getMessage());
                    }
                }
                if (!clicked) {
                    try {
                        method = selectedTile.getClass().getMethod("getOnClick", new Class[0]);
                        Object onClick = method.invoke(selectedTile, new Object[0]);
                        if (onClick != null) {
                            Method invokeMethod = onClick.getClass().getMethod("invoke", new Class[0]);
                            invokeMethod.invoke(onClick, new Object[0]);
                            clicked = true;
                            selectedButton = 0;
                            CobblemonBattleInfoClient.debug("[CustomController] getOnClick().invoke() succeeded!", new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        CobblemonBattleInfoClient.debug("[CustomController] getOnClick failed: {}", t.getMessage());
                    }
                }
                if (!clicked) {
                    try {
                        gui.method_25402((double)centerX, (double)centerY, 0);
                        clicked = true;
                        selectedButton = 0;
                        CobblemonBattleInfoClient.debug("[CustomController] gui.mouseClicked fallback succeeded!", new Object[0]);
                    }
                    catch (Throwable t) {
                        CobblemonBattleInfoClient.debug("[CustomController] gui.mouseClicked failed: {}", t.getMessage());
                    }
                }
                if (clicked) {
                    return;
                }
            }
            CobblemonBattleInfoClient.debug("[CustomController] Using fallback click for button {}", selectedButton);
            CustomBattleController.activateButtonFallback(gui);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Failed to activate button", t);
            CustomBattleController.activateButtonFallback(gui);
        }
    }

    private static void activateButtonFallback(class_437 gui) {
        try {
            int OPTION_ROOT_X = 6;
            int OPTION_VERTICAL_OFFSET = 101;
            int OPTION_HORIZONTAL_SPACING = 3;
            int OPTION_VERTICAL_SPACING = 3;
            int TILE_WIDTH = 139;
            int TILE_HEIGHT = 39;
            try {
                Class<?> battleGUIClass = gui.getClass();
                Field rootXField = battleGUIClass.getDeclaredField("OPTION_ROOT_X");
                rootXField.setAccessible(true);
                OPTION_ROOT_X = (Integer)rootXField.get(null);
                Field vertOffsetField = battleGUIClass.getDeclaredField("OPTION_VERTICAL_OFFSET");
                vertOffsetField.setAccessible(true);
                OPTION_VERTICAL_OFFSET = (Integer)vertOffsetField.get(null);
                Field hSpacingField = battleGUIClass.getDeclaredField("OPTION_HORIZONTAL_SPACING");
                hSpacingField.setAccessible(true);
                OPTION_HORIZONTAL_SPACING = (Integer)hSpacingField.get(null);
                Field vSpacingField = battleGUIClass.getDeclaredField("OPTION_VERTICAL_SPACING");
                vSpacingField.setAccessible(true);
                OPTION_VERTICAL_SPACING = (Integer)vSpacingField.get(null);
            }
            catch (Throwable battleGUIClass) {
                // empty catch block
            }
            try {
                Class<?> tileClass = Class.forName("com.cobblemon.mod.common.client.gui.battle.widgets.BattleOptionTile");
                Field widthField = tileClass.getDeclaredField("OPTION_WIDTH");
                widthField.setAccessible(true);
                TILE_WIDTH = (Integer)widthField.get(null);
                Field heightField = tileClass.getDeclaredField("OPTION_HEIGHT");
                heightField.setAccessible(true);
                TILE_HEIGHT = (Integer)heightField.get(null);
            }
            catch (Throwable tileClass) {
                // empty catch block
            }
            int screenHeight = class_310.method_1551().method_22683().method_4502();
            int row = selectedButton / 2;
            int col = selectedButton % 2;
            int bottomRowBottom = screenHeight - 10;
            int y = row == 1 ? bottomRowBottom - TILE_HEIGHT : bottomRowBottom - TILE_HEIGHT - OPTION_VERTICAL_SPACING - TILE_HEIGHT;
            int x = OPTION_ROOT_X + col * (TILE_WIDTH + OPTION_HORIZONTAL_SPACING);
            int centerX = x + TILE_WIDTH / 2;
            int centerY = y + TILE_HEIGHT / 2;
            CobblemonBattleInfoClient.debug("[CustomController] Fallback ACTIVATE {} at ({}, {})", CustomBattleController.getButtonName(selectedButton), centerX, centerY);
            CustomBattleController.invokeMouseClicked(gui, centerX, centerY, 0);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Fallback activation failed", t);
        }
    }

    private static void invokeMouseClicked(class_437 gui, double x, double y, int button) {
        try {
            gui.method_25402(x, y, button);
            CobblemonBattleInfoClient.debug("[CustomController] mouseClicked({}, {}, {}) called successfully", x, y, button);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Failed to invoke mouseClicked: {}", (Object)t.getMessage());
        }
    }

    private static void onBattleStart() {
        selectedButton = 0;
        hasAutoExpandedLog = false;
        CobblemonBattleInfoClient.debug("[CustomController] Battle started, selected Fight", new Object[0]);
        BattleLogger.onBattleStart();
    }

    private static void onBattleEnd() {
        selectedButton = 0;
        hasAutoExpandedLog = false;
        CobblemonBattleInfoClient.debug("[CustomController] Battle ended", new Object[0]);
        String result = CustomBattleController.determineBattleResult();
        BattleLogger.onBattleEnd(result);
    }

    private static String determineBattleResult() {
        try {
            return "Battle Ended";
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    private static void autoExpandBattleLog(class_437 gui) {
        try {
            Class<?> currentClass;
            Field messagePaneField = null;
            for (currentClass = gui.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field f : currentClass.getDeclaredFields()) {
                    String fieldName = f.getName().toLowerCase();
                    if (!fieldName.contains("message") && !fieldName.contains("log")) continue;
                    f.setAccessible(true);
                    Object value = f.get(gui);
                    if (value == null || !value.getClass().getName().contains("BattleMessagePane")) continue;
                    messagePaneField = f;
                    CustomBattleController.setMessagePaneExpanded(value);
                    CobblemonBattleInfoClient.debug("[CustomController] Auto-expanded battle log via field '{}'", f.getName());
                    return;
                }
            }
            for (currentClass = gui.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field f : currentClass.getDeclaredFields()) {
                    try {
                        f.setAccessible(true);
                        Object value = f.get(gui);
                        if (value == null || !value.getClass().getName().contains("BattleMessagePane")) continue;
                        CustomBattleController.setMessagePaneExpanded(value);
                        CobblemonBattleInfoClient.debug("[CustomController] Auto-expanded battle log via field '{}'", f.getName());
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            CobblemonBattleInfoClient.debug("[CustomController] Could not find BattleMessagePane to auto-expand", new Object[0]);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error auto-expanding battle log: {}", (Object)t.getMessage());
        }
    }

    private static void setMessagePaneExpanded(Object messagePane) {
        try {
            for (Class<?> currentClass = messagePane.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field f : currentClass.getDeclaredFields()) {
                    String fieldName = f.getName().toLowerCase();
                    if (!fieldName.contains("minimi") && !fieldName.equals("expanded") && !fieldName.contains("collapse")) continue;
                    f.setAccessible(true);
                    if (f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                    boolean currentValue = f.getBoolean(messagePane);
                    if (fieldName.contains("expand")) {
                        if (!currentValue) {
                            f.setBoolean(messagePane, true);
                            CobblemonBattleInfoClient.debug("[CustomController] Set {} to true", f.getName());
                        }
                    } else if (currentValue) {
                        f.setBoolean(messagePane, false);
                        CobblemonBattleInfoClient.debug("[CustomController] Set {} to false", f.getName());
                    }
                    return;
                }
            }
            try {
                Method toggleMethod = messagePane.getClass().getMethod("toggleMinimised", new Class[0]);
                try {
                    Method isMinimisedMethod = messagePane.getClass().getMethod("isMinimised", new Class[0]);
                    boolean isMinimised = (Boolean)isMinimisedMethod.invoke(messagePane, new Object[0]);
                    if (isMinimised) {
                        toggleMethod.invoke(messagePane, new Object[0]);
                        CobblemonBattleInfoClient.debug("[CustomController] Toggled battle log to expanded via toggleMinimised()", new Object[0]);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            CobblemonBattleInfoClient.debug("[CustomController] Could not find minimised field to set", new Object[0]);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error setting message pane expanded: {}", (Object)t.getMessage());
        }
    }

    private static String getButtonName(int index) {
        switch (index) {
            case 0: {
                return "Fight";
            }
            case 1: {
                return "Bag";
            }
            case 2: {
                return "Switch";
            }
            case 3: {
                return "Run";
            }
        }
        return "Unknown";
    }

    private static int getFieldInt(Object obj, String fieldName, int defaultValue) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(obj);
            if (value instanceof Integer) {
                return (Integer)value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    private static void drawFancyTooltipBox(class_332 graphics, int x, int y, int width, int height, int backgroundColor, int borderStart, int borderEnd) {
        int r = 3;
        graphics.method_25294(x + r, y + r, x + width - r, y + height - r, backgroundColor);
        graphics.method_25294(x + r, y + 1, x + width - r, y + r, backgroundColor);
        graphics.method_25294(x + r, y + height - r, x + width - r, y + height - 1, backgroundColor);
        graphics.method_25294(x + 1, y + r, x + r, y + height - r, backgroundColor);
        graphics.method_25294(x + width - r, y + r, x + width - 1, y + height - r, backgroundColor);
        graphics.method_25294(x + 2, y + 2, x + r, y + r, backgroundColor);
        graphics.method_25294(x + width - r, y + 2, x + width - 2, y + r, backgroundColor);
        graphics.method_25294(x + 2, y + height - r, x + r, y + height - 2, backgroundColor);
        graphics.method_25294(x + width - r, y + height - r, x + width - 2, y + height - 2, backgroundColor);
        graphics.method_25296(x + r, y, x + width - r, y + 1, borderStart, borderEnd);
        graphics.method_25296(x + r, y + height - 1, x + width - r, y + height, borderEnd, borderStart);
        graphics.method_25296(x, y + r, x + 1, y + height - r, borderStart, borderEnd);
        graphics.method_25296(x + width - 1, y + r, x + width, y + height - r, borderEnd, borderStart);
        graphics.method_25294(x + 1, y + 2, x + 2, y + r, borderStart);
        graphics.method_25294(x + 2, y + 1, x + r, y + 2, borderStart);
        int topRightColor = CustomBattleController.mixColors(borderStart, borderEnd, 0.5f);
        graphics.method_25294(x + width - 2, y + 2, x + width - 1, y + r, topRightColor);
        graphics.method_25294(x + width - r, y + 1, x + width - 2, y + 2, topRightColor);
        int bottomLeftColor = CustomBattleController.mixColors(borderStart, borderEnd, 0.5f);
        graphics.method_25294(x + 1, y + height - r, x + 2, y + height - 2, bottomLeftColor);
        graphics.method_25294(x + 2, y + height - 2, x + r, y + height - 1, bottomLeftColor);
        graphics.method_25294(x + width - 2, y + height - r, x + width - 1, y + height - 2, borderEnd);
        graphics.method_25294(x + width - r, y + height - 2, x + width - 2, y + height - 1, borderEnd);
    }

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static boolean isUpPressed() {
        class_310 mc = class_310.method_1551();
        long window = mc.method_22683().method_4490();
        if (GLFW.glfwGetKey((long)window, (int)265) == 1) {
            return true;
        }
        if (GLFW.glfwGetKey((long)window, (int)87) == 1) {
            return true;
        }
        if (mc.field_1690.field_1894.method_1434()) {
            return true;
        }
        if (CustomBattleController.isGlfwGamepadUp()) {
            return true;
        }
        try {
            return CustomBattleController.isControllerButtonPressed("DPAD_UP") || CustomBattleController.isControllerAxisUp();
        }
        catch (Throwable throwable) {
            try {
                return CustomBattleController.isControlifyUp();
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
    }

    private static boolean isDownPressed() {
        class_310 mc = class_310.method_1551();
        long window = mc.method_22683().method_4490();
        if (GLFW.glfwGetKey((long)window, (int)264) == 1) {
            return true;
        }
        if (GLFW.glfwGetKey((long)window, (int)83) == 1) {
            return true;
        }
        if (mc.field_1690.field_1881.method_1434()) {
            return true;
        }
        if (CustomBattleController.isGlfwGamepadDown()) {
            return true;
        }
        try {
            return CustomBattleController.isControllerButtonPressed("DPAD_DOWN") || CustomBattleController.isControllerAxisDown();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isLeftPressed() {
        class_310 mc = class_310.method_1551();
        long window = mc.method_22683().method_4490();
        if (GLFW.glfwGetKey((long)window, (int)263) == 1) {
            return true;
        }
        if (GLFW.glfwGetKey((long)window, (int)65) == 1) {
            return true;
        }
        if (mc.field_1690.field_1913.method_1434()) {
            return true;
        }
        if (CustomBattleController.isGlfwGamepadLeft()) {
            return true;
        }
        try {
            return CustomBattleController.isControllerButtonPressed("DPAD_LEFT") || CustomBattleController.isControllerAxisLeft();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isRightPressed() {
        class_310 mc = class_310.method_1551();
        long window = mc.method_22683().method_4490();
        if (GLFW.glfwGetKey((long)window, (int)262) == 1) {
            return true;
        }
        if (GLFW.glfwGetKey((long)window, (int)68) == 1) {
            return true;
        }
        if (mc.field_1690.field_1849.method_1434()) {
            return true;
        }
        if (CustomBattleController.isGlfwGamepadRight()) {
            return true;
        }
        try {
            return CustomBattleController.isControllerButtonPressed("DPAD_RIGHT") || CustomBattleController.isControllerAxisRight();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isSelectPressed() {
        class_310 mc = class_310.method_1551();
        long window = mc.method_22683().method_4490();
        if (GLFW.glfwGetKey((long)window, (int)257) == 1) {
            return true;
        }
        if (GLFW.glfwGetKey((long)window, (int)335) == 1) {
            return true;
        }
        if (GLFW.glfwGetKey((long)window, (int)32) == 1) {
            return true;
        }
        if (mc.field_1690.field_1904.method_1434()) {
            return true;
        }
        if (CustomBattleController.isGlfwGamepadButtonA()) {
            return true;
        }
        try {
            return CustomBattleController.isControllerButtonPressed("A") || CustomBattleController.isControllerButtonPressed("SOUTH");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isBackPressed() {
        class_310 mc = class_310.method_1551();
        long window = mc.method_22683().method_4490();
        int backKey = BattleExtrasConfig.getBattleBackKey();
        if (backKey != -1 && GLFW.glfwGetKey((long)window, (int)backKey) == 1) {
            return true;
        }
        if (CustomBattleController.isGlfwGamepadButtonB()) {
            return true;
        }
        try {
            return CustomBattleController.isControllerButtonPressed("B") || CustomBattleController.isControllerButtonPressed("EAST");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static int findConnectedGamepad() {
        for (int jid = 0; jid <= 15; ++jid) {
            if (!GLFW.glfwJoystickPresent((int)jid) || !GLFW.glfwJoystickIsGamepad((int)jid)) continue;
            return jid;
        }
        return -1;
    }

    private static boolean isGlfwGamepadUp() {
        int gamepad = CustomBattleController.findConnectedGamepad();
        if (gamepad == -1) {
            return false;
        }
        try {
            GLFWGamepadState state = GLFWGamepadState.create();
            if (GLFW.glfwGetGamepadState((int)gamepad, (GLFWGamepadState)state)) {
                if (state.buttons(11) == 1) {
                    return true;
                }
                if (state.axes(1) < -0.5f) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isGlfwGamepadDown() {
        int gamepad = CustomBattleController.findConnectedGamepad();
        if (gamepad == -1) {
            return false;
        }
        try {
            GLFWGamepadState state = GLFWGamepadState.create();
            if (GLFW.glfwGetGamepadState((int)gamepad, (GLFWGamepadState)state)) {
                if (state.buttons(13) == 1) {
                    return true;
                }
                if (state.axes(1) > 0.5f) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isGlfwGamepadLeft() {
        int gamepad = CustomBattleController.findConnectedGamepad();
        if (gamepad == -1) {
            return false;
        }
        try {
            GLFWGamepadState state = GLFWGamepadState.create();
            if (GLFW.glfwGetGamepadState((int)gamepad, (GLFWGamepadState)state)) {
                if (state.buttons(14) == 1) {
                    return true;
                }
                if (state.axes(0) < -0.5f) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isGlfwGamepadRight() {
        int gamepad = CustomBattleController.findConnectedGamepad();
        if (gamepad == -1) {
            return false;
        }
        try {
            GLFWGamepadState state = GLFWGamepadState.create();
            if (GLFW.glfwGetGamepadState((int)gamepad, (GLFWGamepadState)state)) {
                if (state.buttons(12) == 1) {
                    return true;
                }
                if (state.axes(0) > 0.5f) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isGlfwGamepadButtonA() {
        int gamepad = CustomBattleController.findConnectedGamepad();
        if (gamepad == -1) {
            return false;
        }
        try {
            GLFWGamepadState state = GLFWGamepadState.create();
            if (GLFW.glfwGetGamepadState((int)gamepad, (GLFWGamepadState)state)) {
                return state.buttons(0) == 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isGlfwGamepadButtonB() {
        int gamepad = CustomBattleController.findConnectedGamepad();
        if (gamepad == -1) {
            return false;
        }
        try {
            GLFWGamepadState state = GLFWGamepadState.create();
            if (GLFW.glfwGetGamepadState((int)gamepad, (GLFWGamepadState)state)) {
                return state.buttons(1) == 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isControlifyUp() {
        return false;
    }

    private static boolean isControlifyDown() {
        return false;
    }

    private static boolean isControlifyLeft() {
        return false;
    }

    private static boolean isControlifyRight() {
        return false;
    }

    private static boolean isControlifyA() {
        return false;
    }

    private static boolean isControlifyB() {
        return false;
    }

    private static void toggleBattleMinimised() {
        try {
            Class<?> cobblemonClientClass = Class.forName("com.cobblemon.mod.common.client.CobblemonClient");
            Field battleField = cobblemonClientClass.getDeclaredField("battle");
            battleField.setAccessible(true);
            Object battle = battleField.get(null);
            if (battle != null) {
                Field minimisedField = battle.getClass().getDeclaredField("minimised");
                minimisedField.setAccessible(true);
                boolean currentMinimised = minimisedField.getBoolean(battle);
                minimisedField.setBoolean(battle, !currentMinimised);
                CobblemonBattleInfoClient.debug("[CustomController] Toggled battle minimised: {} -> {}", currentMinimised, !currentMinimised);
                if (currentMinimised && !class_310.method_1551().field_1690.field_1842) {
                    Class<?> battleGUIClass = Class.forName("com.cobblemon.mod.common.client.gui.battle.BattleGUI");
                    Object battleGUI = battleGUIClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    class_310.method_1551().method_1507((class_437)battleGUI);
                    CobblemonBattleInfoClient.debug("[CustomController] Opened BattleGUI after un-minimising", new Object[0]);
                } else {
                    class_310.method_1551().method_1507(null);
                }
            } else {
                CobblemonBattleInfoClient.debug("[CustomController] No active battle to toggle minimised state", new Object[0]);
                class_310.method_1551().method_1507(null);
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Failed to toggle battle minimised: {}", (Object)t.getMessage());
            class_310.method_1551().method_1507(null);
        }
    }

    private static void openBattleGUI() {
        try {
            Class<?> cobblemonClientClass = Class.forName("com.cobblemon.mod.common.client.CobblemonClient");
            Field battleField = cobblemonClientClass.getDeclaredField("battle");
            battleField.setAccessible(true);
            Object battle = battleField.get(null);
            if (battle != null) {
                Field minimisedField = battle.getClass().getDeclaredField("minimised");
                minimisedField.setAccessible(true);
                minimisedField.setBoolean(battle, false);
                CobblemonBattleInfoClient.debug("[CustomController] Set battle minimised to false", new Object[0]);
                if (!class_310.method_1551().field_1690.field_1842) {
                    Class<?> battleGUIClass = Class.forName("com.cobblemon.mod.common.client.gui.battle.BattleGUI");
                    Object battleGUI = battleGUIClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    class_310.method_1551().method_1507((class_437)battleGUI);
                    CobblemonBattleInfoClient.debug("[CustomController] Opened BattleGUI", new Object[0]);
                }
            } else {
                CobblemonBattleInfoClient.debug("[CustomController] No active battle to open GUI for", new Object[0]);
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Failed to open BattleGUI: {}", (Object)t.getMessage());
        }
    }

    private static void goBack(class_437 gui) {
        try {
            if (currentSelectionType.equals("general") || currentSelectionType.equals("none")) {
                CobblemonBattleInfoClient.debug("[CustomController] On main menu, toggling battle minimised mode", new Object[0]);
                CustomBattleController.toggleBattleMinimised();
                minimisedBackPressed = true;
                return;
            }
            Object actionSelection = CustomBattleController.getActionSelection(gui);
            if (actionSelection == null) {
                CobblemonBattleInfoClient.debug("[CustomController] No action selection, toggling battle minimised mode", new Object[0]);
                CustomBattleController.toggleBattleMinimised();
                minimisedBackPressed = true;
                return;
            }
            try {
                Method getBattleGUIMethod = actionSelection.getClass().getMethod("getBattleGUI", new Class[0]);
                Object battleGUI = getBattleGUIMethod.invoke(actionSelection, new Object[0]);
                if (battleGUI != null) {
                    Method deriveMethod;
                    Object rootSelection;
                    Method getActorMethod = battleGUI.getClass().getMethod("getActor", new Class[0]);
                    Object actor = getActorMethod.invoke(battleGUI, new Object[0]);
                    Method getRequestMethod = actionSelection.getClass().getMethod("getRequest", new Class[0]);
                    Object request = getRequestMethod.invoke(actionSelection, new Object[0]);
                    if (actor != null && request != null && (rootSelection = (deriveMethod = battleGUI.getClass().getMethod("deriveRootActionSelection", actor.getClass(), request.getClass())).invoke(battleGUI, actor, request)) != null) {
                        Method changeMethod = battleGUI.getClass().getMethod("changeActionSelection", rootSelection.getClass().getSuperclass());
                        changeMethod.invoke(battleGUI, rootSelection);
                        selectedButton = 0;
                        CobblemonBattleInfoClient.debug("[CustomController] Went back to main menu!", new Object[0]);
                        return;
                    }
                }
            }
            catch (Throwable t) {
                CobblemonBattleInfoClient.debug("[CustomController] deriveRootActionSelection failed: {}", t.getMessage());
            }
            try {
                Method getBackButtonMethod = actionSelection.getClass().getMethod("getBackButton", new Class[0]);
                Object backButton = getBackButtonMethod.invoke(actionSelection, new Object[0]);
                if (backButton != null) {
                    Method getXMethod = backButton.getClass().getMethod("getX", new Class[0]);
                    Method getYMethod = backButton.getClass().getMethod("getY", new Class[0]);
                    float x = ((Float)getXMethod.invoke(backButton, new Object[0])).floatValue();
                    float y = ((Float)getYMethod.invoke(backButton, new Object[0])).floatValue();
                    gui.method_25402((double)(x + 10.0f), (double)(y + 10.0f), 0);
                    selectedButton = 0;
                    CobblemonBattleInfoClient.debug("[CustomController] Clicked back button at ({}, {})", Float.valueOf(x), Float.valueOf(y));
                    return;
                }
            }
            catch (Throwable t) {
                CobblemonBattleInfoClient.debug("[CustomController] Back button click failed: {}", t.getMessage());
            }
            CobblemonBattleInfoClient.debug("[CustomController] Could not go back", new Object[0]);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[CustomController] Error going back: {}", (Object)t.getMessage());
        }
    }

    private static boolean isControllerButtonPressed(String buttonName) {
        try {
            Class<?> inputManager = Class.forName("eu.midnightdust.midnightcontrols.client.controller.InputManager");
            Class<?> controllerButton = Class.forName("eu.midnightdust.midnightcontrols.client.enums.ControllerButton");
            Object button = Enum.valueOf(controllerButton, buttonName);
            Method method = inputManager.getMethod("isButtonPressed", controllerButton);
            return (Boolean)method.invoke(null, button);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isControllerAxisUp() {
        try {
            Class<?> inputManager = Class.forName("eu.midnightdust.midnightcontrols.client.controller.InputManager");
            Method method = inputManager.getMethod("getLeftStickY", new Class[0]);
            float y = ((Float)method.invoke(null, new Object[0])).floatValue();
            return y < -0.5f;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isControllerAxisDown() {
        try {
            Class<?> inputManager = Class.forName("eu.midnightdust.midnightcontrols.client.controller.InputManager");
            Method method = inputManager.getMethod("getLeftStickY", new Class[0]);
            float y = ((Float)method.invoke(null, new Object[0])).floatValue();
            return y > 0.5f;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isControllerAxisLeft() {
        try {
            Class<?> inputManager = Class.forName("eu.midnightdust.midnightcontrols.client.controller.InputManager");
            Method method = inputManager.getMethod("getLeftStickX", new Class[0]);
            float x = ((Float)method.invoke(null, new Object[0])).floatValue();
            return x < -0.5f;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isControllerAxisRight() {
        try {
            Class<?> inputManager = Class.forName("eu.midnightdust.midnightcontrols.client.controller.InputManager");
            Method method = inputManager.getMethod("getLeftStickX", new Class[0]);
            float x = ((Float)method.invoke(null, new Object[0])).floatValue();
            return x > 0.5f;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isTileControllerSelected(Object tile) {
        if (!BattleExtrasConfig.isControllerNavigationEnabled()) {
            return false;
        }
        if (tile == null) {
            return false;
        }
        if (!"moves".equals(currentSelectionType)) {
            return false;
        }
        if (cachedTiles == null || cachedTiles.length == 0) {
            return false;
        }
        if (selectedButton < 0 || selectedButton >= cachedTiles.length) {
            return false;
        }
        return tile == cachedTiles[selectedButton];
    }

    public static int[] getSelectedTilePosition() {
        if (!"moves".equals(currentSelectionType)) {
            return null;
        }
        if (cachedTiles == null || cachedTiles.length == 0) {
            return null;
        }
        if (selectedButton < 0 || selectedButton >= cachedTiles.length) {
            return null;
        }
        Object tile = cachedTiles[selectedButton];
        if (tile == null) {
            return null;
        }
        try {
            int x = CustomBattleController.getTileX(tile);
            int y = CustomBattleController.getTileY(tile);
            int width = CustomBattleController.getTileWidth(tile);
            int height = CustomBattleController.getTileHeight(tile);
            if (x > 0 && y > 0 && width > 0 && height > 0) {
                return new int[]{x, y, width, height};
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean isMovesSelectionActive() {
        return "moves".equals(currentSelectionType) && cachedTiles != null && cachedTiles.length > 0;
    }

    public static int getSelectedTileIndex() {
        if (!"moves".equals(currentSelectionType)) {
            return -1;
        }
        if (cachedTiles == null || cachedTiles.length == 0) {
            return -1;
        }
        if (selectedButton < 0 || selectedButton >= cachedTiles.length) {
            return -1;
        }
        return selectedButton;
    }

    public static boolean isMouseHoveringAnyMoveTile() {
        try {
            if (!"moves".equals(currentSelectionType)) {
                return false;
            }
            if (cachedTiles == null || cachedTiles.length == 0) {
                return false;
            }
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.method_22683() == null) {
                return false;
            }
            double mouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
            double mouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
            for (Object tile : cachedTiles) {
                if (tile == null) continue;
                int x = CustomBattleController.getTileX(tile);
                int y = CustomBattleController.getTileY(tile);
                int w = CustomBattleController.getTileWidth(tile);
                int h = CustomBattleController.getTileHeight(tile);
                if (w <= 0 || h <= 0 || !(mouseX >= (double)x) || !(mouseX <= (double)(x + w)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + h))) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void setBattleGuiClosed() {
        battleGuiClosedTime = System.currentTimeMillis();
    }

    public static boolean shouldSuppressJump() {
        boolean inBattle;
        if (!BattleExtrasConfig.isControllerNavigationEnabled()) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        boolean bl = inBattle = battle != null;
        if (wasInBattleForJump && !inBattle) {
            battleGuiClosedTime = System.currentTimeMillis();
        }
        wasInBattleForJump = inBattle;
        if (mc.field_1755 != null && CustomBattleController.isBattleGUI(mc.field_1755)) {
            return true;
        }
        if (inBattle) {
            return true;
        }
        return System.currentTimeMillis() - battleGuiClosedTime < 200L;
    }

    private static class MoveDisplayInfo {
        String rawName;
        String displayName;
        int currentPP;
        int maxPP;
        Object moveType;
        double effectChance;
        String effectDescription;

        MoveDisplayInfo(String rawName, String displayName, int currentPP, int maxPP, Object moveType, double effectChance, String effectDescription) {
            this.rawName = rawName;
            this.displayName = displayName;
            this.currentPP = currentPP;
            this.maxPP = maxPP;
            this.moveType = moveType;
            this.effectChance = effectChance;
            this.effectDescription = effectDescription;
        }
    }
}

