/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.cobblemon.mod.common.pokemon.Species;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleOpacityHelper;
import name.modid.client.BattleSideHelper;
import name.modid.platform.Services;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class StatStageRenderer {
    private static final String UP_ARROW = "\u2191";
    private static final String DOWN_ARROW = "\u2193";
    private static final class_2960 LEECH_SEED_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/leech_seed.png");
    private static final class_2960 TAILWIND_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/tailwind.png");
    private static final class_2960 UNGROUNDED_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/ungrounded.png");
    private static final class_2960 GROUNDED_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/grounded.png");
    private static final class_2960 INGRAIN_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/ingrain.png");
    private static final class_2960 AQUA_RING_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/aqua_ring.png");
    private static final class_2960 SUBSTITUTE_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/substitute.png");
    private static final class_2960 EMBARGO_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/embargo.png");
    private static final class_2960 HEAL_BLOCK_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/heal_block.png");
    private static final class_2960 CONFUSION_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/confusion.png");
    private static final class_2960 IDENTIFIED_ICON = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/identified.png");
    private static final int ICON_SIZE = 16;
    private static final int COLOR_POSITIVE = -11141291;
    private static final int COLOR_NEGATIVE = -43691;
    private static final int COLOR_SCREEN_LIGHT = -171;
    private static final int COLOR_SCREEN_REFLECT = -43606;
    private static final int COLOR_SCREEN_VEIL = -11141121;
    private static final int COLOR_SCREEN_SAFEGUARD = -11141291;
    private static final int COLOR_SCREEN_MIST = -5579265;
    private static final int COLOR_SCREEN_LUCKY_CHANT = -10496;
    private static final int PORTRAIT_WIDTH = 35;
    private static final int PORTRAIT_HEIGHT = 33;
    private static final int PORTRAIT_X_OFFSET = 14;
    private static final int PORTRAIT_Y_OFFSET = 16;
    private static final int TYPE_ICON_SIZE = 14;
    private static final int TYPE_ICON_SPACING = 1;
    private static final int TYPE_ICON_BASE_X_PLAYER = 12;
    private static final int TYPE_ICON_BASE_Y = 50;
    private static final int COLOR_SUBSTITUTE = -11162881;
    private static final int COLOR_LEECH_SEED = -11141291;
    private static final int COLOR_INGRAIN = -7820732;
    private static final int COLOR_TAILWIND = -6693377;
    private static final int COLOR_UNGROUNDED = -8875;
    private static final int COLOR_GROUNDED = -7650029;
    private static final int COLOR_EMBARGO = -12303292;
    private static final int COLOR_HEAL_BLOCK = -48060;
    private static final String SUBSTITUTE_SYMBOL = "\u2592";
    private static final String LEECH_SEED_SYMBOL = "\u2740";
    private static final String INGRAIN_SYMBOL = "\u2193";
    private static final String TAILWIND_SYMBOL = "\u21d2";

    public static void init() {
        Services.EVENTS.registerHudRender((gui, tickDelta) -> {
            try {
                StatStageRenderer.render(gui);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("StatStageRenderer initialized", new Object[0]);
    }

    private static void render(class_332 gui) {
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        boolean isCompact = battle.getBattleFormat().getBattleType().getPokemonPerSide() > 1;
        int VERTICAL_INSET = 10;
        int VERTICAL_SPACING = 40;
        int COMPACT_VERTICAL_SPACING = 30;
        float opacity = BattleOpacityHelper.getBattleOpacity();
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        int totalPlayerPokemon = 0;
        for (Object actor : playerSide.getActors()) {
            for (Object active : actor.getActivePokemon()) {
                if (active.getBattlePokemon() == null) continue;
                ++totalPlayerPokemon;
            }
        }
        int playerSlot = 0;
        for (Object actor : playerSide.getActors()) {
            for (Object active : actor.getActivePokemon()) {
                ClientBattlePokemon pokemon = active.getBattlePokemon();
                if (pokemon == null) continue;
                String displayName = pokemon.getDisplayName().getString();
                String speciesName = pokemon.getSpecies().getName();
                String searchName = displayName;
                Map<String, Integer> stats = StatStageRenderer.findStatsForPokemon("player", searchName);
                if (stats.isEmpty() && !displayName.equals(speciesName)) {
                    stats = StatStageRenderer.findStatsForPokemon("player", speciesName);
                }
                if (stats.isEmpty()) {
                    stats = StatStageRenderer.getStatsFromPokemon(pokemon);
                }
                if (BattleExtrasConfig.isStatStagesEnabled() && !isCompact) {
                    int baseX = 8;
                    int baseY = 68 + playerSlot * 40;
                    gui.method_51448().method_22903();
                    gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                    StatStageRenderer.renderStats(gui, mc, stats, baseX, baseY, false, opacity, isCompact);
                    gui.method_51448().method_22909();
                }
                if (BattleExtrasConfig.isSpeedRangeEnabled() && !BattleExtrasConfig.isHideBattleTilesEnabled()) {
                    int speedY;
                    int speedX;
                    if (isCompact) {
                        speedX = 98;
                        speedY = 10 + playerSlot * 30 + 22;
                    } else {
                        speedX = 98;
                        speedY = 40 + playerSlot * 40;
                    }
                    StatStageRenderer.renderSpeedRange(gui, mc, (ActiveClientBattlePokemon)active, pokemon, speedX, speedY, false, opacity, "player", screenWidth);
                }
                if (BattleExtrasConfig.isScreensDisplayEnabled() && (!isCompact || playerSlot == 0)) {
                    Map<String, Integer> playerScreens = BattleMessageSubscriber.getScreensForSide("player");
                    int portraitX = 14;
                    int portraitY = 16 + playerSlot * 50;
                    int numTypes = StatStageRenderer.getTypeCount(pokemon);
                    int typeIconsY = 50 + playerSlot * 50;
                    StatStageRenderer.renderScreenOverlays(gui, mc, playerScreens, portraitX, portraitY, 35, 33, false, opacity, numTypes, typeIconsY, screenWidth, isCompact, totalPlayerPokemon);
                }
                if (BattleExtrasConfig.isVolatileStatusIconsEnabled()) {
                    int statusX = 165;
                    int statusY = 16 + playerSlot * 50;
                    StatStageRenderer.renderVolatileStatus(gui, mc, speciesName, statusX, statusY, false, opacity, "player");
                }
                ++playerSlot;
            }
        }
        int totalOpponentPokemon = 0;
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                if (active.getBattlePokemon() == null) continue;
                ++totalOpponentPokemon;
            }
        }
        int oppSlot = 0;
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon pokemon = active.getBattlePokemon();
                if (pokemon == null) continue;
                String displayName = pokemon.getDisplayName().getString();
                String speciesName = pokemon.getSpecies().getName();
                Map<String, Integer> stats = StatStageRenderer.findStatsForPokemon("opponent", displayName);
                if (stats.isEmpty() && !displayName.equals(speciesName)) {
                    stats = StatStageRenderer.findStatsForPokemon("opponent", speciesName);
                }
                if (stats.isEmpty()) {
                    stats = StatStageRenderer.getStatsFromPokemon(pokemon);
                }
                int reversedSlot = totalOpponentPokemon - oppSlot - 1;
                if (BattleExtrasConfig.isStatStagesEnabled() && !isCompact) {
                    int baseX = screenWidth - 18;
                    int baseY = 64 + reversedSlot * 40;
                    gui.method_51448().method_22903();
                    gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                    StatStageRenderer.renderStats(gui, mc, stats, baseX, baseY, true, opacity, isCompact);
                    gui.method_51448().method_22909();
                }
                if (BattleExtrasConfig.isSpeedRangeEnabled() && !BattleExtrasConfig.isHideBattleTilesEnabled()) {
                    int speedY;
                    int speedX;
                    if (isCompact) {
                        speedX = screenWidth - 140;
                        speedY = 10 + reversedSlot * 30 + 22;
                    } else {
                        speedX = screenWidth - 145;
                        speedY = 40 + reversedSlot * 40;
                    }
                    StatStageRenderer.renderSpeedRange(gui, mc, active, pokemon, speedX, speedY, true, opacity, "opponent", screenWidth);
                }
                if (BattleExtrasConfig.isScreensDisplayEnabled() && (!isCompact || oppSlot == 0)) {
                    Map<String, Integer> oppScreens = BattleMessageSubscriber.getScreensForSide("opponent");
                    int portraitX = screenWidth - 35 - 14;
                    int portraitY = 16 + reversedSlot * 50;
                    int numTypes = StatStageRenderer.getTypeCount(pokemon);
                    int typeIconsY = 50 + reversedSlot * 50;
                    StatStageRenderer.renderScreenOverlays(gui, mc, oppScreens, portraitX, portraitY, 35, 33, true, opacity, numTypes, typeIconsY, screenWidth, isCompact, totalOpponentPokemon);
                }
                if (BattleExtrasConfig.isVolatileStatusIconsEnabled()) {
                    int statusX = screenWidth - 165;
                    int statusY = 16 + reversedSlot * 50;
                    StatStageRenderer.renderVolatileStatus(gui, mc, speciesName, statusX, statusY, true, opacity, "opponent");
                }
                ++oppSlot;
            }
        }
    }

    private static Map<String, Integer> findStatsForPokemon(String side, String searchName) {
        if (searchName == null || searchName.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Integer> stats = BattleMessageSubscriber.getStatStagesForPokemon(side, searchName);
        if (stats != null && !stats.isEmpty()) {
            return stats;
        }
        return Collections.emptyMap();
    }

    private static Map<String, Integer> getStatsFromPokemon(ClientBattlePokemon pokemon) {
        if (pokemon == null) {
            return Collections.emptyMap();
        }
        try {
            Map statChanges = pokemon.getStatChanges();
            if (statChanges == null || statChanges.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            block22: for (Map.Entry entry : statChanges.entrySet()) {
                String statName;
                if (entry.getValue() == null || (Integer)entry.getValue() == 0) continue;
                switch (statName = entry.getKey().toString().toLowerCase(Locale.ROOT)) {
                    case "attack": {
                        result.put("atk", (Integer)entry.getValue());
                        continue block22;
                    }
                    case "defence": 
                    case "defense": {
                        result.put("def", (Integer)entry.getValue());
                        continue block22;
                    }
                    case "special_attack": {
                        result.put("spa", (Integer)entry.getValue());
                        continue block22;
                    }
                    case "special_defence": 
                    case "special_defense": {
                        result.put("spd", (Integer)entry.getValue());
                        continue block22;
                    }
                    case "speed": {
                        result.put("spe", (Integer)entry.getValue());
                        continue block22;
                    }
                    case "accuracy": {
                        result.put("accuracy", (Integer)entry.getValue());
                        continue block22;
                    }
                    case "evasion": {
                        result.put("evasion", (Integer)entry.getValue());
                        continue block22;
                    }
                }
                result.put(statName, (Integer)entry.getValue());
            }
            return result;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private static Map<String, Integer> findStatsForPokemon(String searchName) {
        String keyLower;
        if (searchName == null || searchName.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Integer> stats = BattleMessageSubscriber.getStatStagesForPokemon(searchName);
        if (stats != null && !stats.isEmpty()) {
            return stats;
        }
        Map<String, Map<String, Integer>> allStats = BattleMessageSubscriber.getAllStatStages();
        String searchLower = searchName.toLowerCase();
        for (Map.Entry<String, Map<String, Integer>> entry : allStats.entrySet()) {
            keyLower = entry.getKey().toLowerCase();
            if (keyLower.startsWith("player_") || keyLower.startsWith("opponent_") || !keyLower.equals(searchLower)) continue;
            return entry.getValue();
        }
        if (searchName.length() >= 3) {
            for (Map.Entry<String, Map<String, Integer>> entry : allStats.entrySet()) {
                keyLower = entry.getKey().toLowerCase();
                if (keyLower.startsWith("player_") || keyLower.startsWith("opponent_") || entry.getKey().length() < 3 || !keyLower.contains(searchLower) && !searchLower.contains(keyLower)) continue;
                return entry.getValue();
            }
        }
        return Collections.emptyMap();
    }

    private static int renderStats(class_332 gui, class_310 mc, Map<String, Integer> stats, int x, int y, boolean alignRight, float opacity, boolean isCompact) {
        if (stats == null || stats.isEmpty()) {
            return 0;
        }
        boolean hasChanges = stats.values().stream().anyMatch(v -> v != null && v != 0);
        if (!hasChanges) {
            return 0;
        }
        float scale = isCompact ? 0.6f : 0.75f;
        int lineSpacing = isCompact ? 7 : 9;
        gui.method_51448().method_22903();
        gui.method_51448().method_22905(scale, scale, 1.0f);
        int lineY = y;
        for (Map.Entry<String, Integer> entry : stats.entrySet()) {
            Integer val = entry.getValue();
            if (val == null || val == 0) continue;
            String statLabel = StatStageRenderer.abbreviateStatKey(entry.getKey());
            int absVal = Math.abs(val);
            boolean isPositive = val > 0;
            int statColor = isPositive ? -11141291 : -43691;
            int pipFilledColor = BattleOpacityHelper.applyOpacity(statColor, opacity);
            int pipEmptyColor = BattleOpacityHelper.applyOpacity(-13421773, opacity * 0.5f);
            int labelColor = BattleOpacityHelper.applyOpacity(-3355444, opacity);
            int scaledX = (int)((float)x / scale);
            int scaledY = (int)((float)lineY / scale);
            String label = statLabel;
            int labelWidth = mc.field_1772.method_1727(label);
            int pipWidth = 4;
            int pipGap = 1;
            int maxPips = 6;
            int pipsWidth = maxPips * (pipWidth + pipGap);
            int totalWidth = labelWidth + 3 + pipsWidth;
            int drawX = alignRight ? scaledX - totalWidth : scaledX;
            gui.method_51433(mc.field_1772, label, drawX + 1, scaledY + 1, 0x40000000, false);
            gui.method_51433(mc.field_1772, label, drawX, scaledY, labelColor, false);
            int pipStartX = drawX + labelWidth + 3;
            int pipY = scaledY + 2;
            int pipHeight = 5;
            for (int i = 0; i < maxPips; ++i) {
                boolean filled;
                int pipX = pipStartX + i * (pipWidth + pipGap);
                boolean bl = filled = i < absVal;
                if (filled) {
                    gui.method_25294(pipX, pipY, pipX + pipWidth, pipY + pipHeight, pipFilledColor);
                    int highlightColor = isPositive ? 0x4000FF00 : 0x40FF0000;
                    gui.method_25294(pipX, pipY, pipX + pipWidth, pipY + 1, BattleOpacityHelper.applyOpacity(highlightColor, opacity));
                    continue;
                }
                gui.method_25294(pipX, pipY, pipX + pipWidth, pipY + pipHeight, pipEmptyColor);
            }
            lineY += lineSpacing;
        }
        gui.method_51448().method_22909();
        return lineY - y;
    }

    private static String abbreviateStatKey(String raw) {
        String upper;
        if (raw == null) {
            return "";
        }
        String s = raw.trim();
        if (s.isEmpty()) {
            return s;
        }
        switch (upper = s.toUpperCase(Locale.ROOT)) {
            case "ATK": 
            case "DEF": 
            case "SPE": 
            case "ACC": 
            case "EVA": 
            case "CRIT": 
            case "SP.ATK": 
            case "SP.AT": 
            case "SPATK": 
            case "SPA": 
            case "SP. DEF": 
            case "SP.DEF": 
            case "SPDEF": 
            case "SPD": {
                return switch (upper) {
                    case "SP.AT", "SPATK", "SPA" -> "SP.ATK";
                    case "SP. DEF", "SPDEF", "SPD" -> "SP.DEF";
                    default -> upper;
                };
            }
        }
        String lower = s.toLowerCase(Locale.ROOT);
        if (lower.contains("special") && lower.contains("attack")) {
            return "SP.ATK";
        }
        if (lower.contains("special") && lower.contains("def")) {
            return "SP.DEF";
        }
        if (lower.contains("sp") && (lower.contains("atk") || lower.contains("attack"))) {
            return "SP.ATK";
        }
        if (lower.contains("sp") && (lower.contains("def") || lower.contains("defense") || lower.contains("defence"))) {
            return "SP.DEF";
        }
        if (lower.contains("attack")) {
            return "ATK";
        }
        if (lower.contains("defense") || lower.contains("defence")) {
            return "DEF";
        }
        if (lower.contains("speed")) {
            return "SPE";
        }
        if (lower.contains("accuracy") || lower.contains("acc")) {
            return "ACC";
        }
        if (lower.contains("evasion") || lower.contains("evasiveness") || lower.contains("eva")) {
            return "EVA";
        }
        if (lower.contains("crit")) {
            return "CRIT";
        }
        if (lower.contains("ataque") && !lower.contains("especial")) {
            return "ATK";
        }
        if (lower.contains("defensa") && !lower.contains("especial")) {
            return "DEF";
        }
        if (lower.contains("especial") && lower.contains("ataque")) {
            return "SP.ATK";
        }
        if (lower.contains("especial") && lower.contains("defensa")) {
            return "SP.DEF";
        }
        if (lower.contains("velocidad")) {
            return "SPE";
        }
        if (lower.contains("precisi")) {
            return "ACC";
        }
        if (lower.contains("evasi")) {
            return "EVA";
        }
        if (lower.contains("cr\u0000edt") || lower.contains("crit")) {
            return "CRIT";
        }
        return s;
    }

    private static void renderScreenOverlays(class_332 gui, class_310 mc, Map<String, Integer> screens, int x, int y, int width, int height, boolean alignRight, float opacity, int numTypes, int typeIconsY, int screenWidth, boolean isCompact, int totalSlots) {
        if (screens == null || screens.isEmpty()) {
            return;
        }
        ArrayList<CallSite> labels = new ArrayList<CallSite>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (Map.Entry<String, Integer> entry : screens.entrySet()) {
            Integer turns = entry.getValue();
            if (turns == null || turns <= 0) continue;
            String screenName = entry.getKey();
            int baseColor = StatStageRenderer.getScreenColor(screenName);
            if (!isCompact) {
                int r = baseColor >> 16 & 0xFF;
                int g = baseColor >> 8 & 0xFF;
                int b = baseColor & 0xFF;
                int baseAlpha = 96;
                int alpha = (int)((float)baseAlpha * opacity);
                int overlayColor = alpha << 24 | r << 16 | g << 8 | b;
                gui.method_25294(x, y, x + width, y + height, overlayColor);
            }
            String abbrev = StatStageRenderer.getScreenAbbrev(screenName);
            labels.add((CallSite)((Object)(abbrev + ":" + turns)));
            colors.add(baseColor);
        }
        if (!labels.isEmpty()) {
            gui.method_51448().method_22903();
            gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            if (isCompact) {
                int textY;
                int textX;
                float scale = 0.7f;
                gui.method_51448().method_22905(scale, scale, 1.0f);
                StringBuilder combined = new StringBuilder();
                for (int i = 0; i < labels.size(); ++i) {
                    if (i > 0) {
                        combined.append(" ");
                    }
                    combined.append((String)labels.get(i));
                }
                String labelText = combined.toString();
                int textWidth = mc.field_1772.method_1727(labelText);
                int bottomPortraitY = 10 + (totalSlots - 1) * 30 + 35;
                if (alignRight) {
                    textX = (int)((float)(screenWidth - 10) / scale) - textWidth;
                    textY = (int)((float)bottomPortraitY / scale);
                } else {
                    textX = (int)(10.0f / scale);
                    textY = (int)((float)bottomPortraitY / scale);
                }
                int textColor = BattleOpacityHelper.applyOpacity((Integer)colors.get(0), opacity);
                gui.method_51433(mc.field_1772, labelText, textX, textY, textColor, true);
            } else {
                int textX;
                Objects.requireNonNull(mc.field_1772);
                int textY = typeIconsY + (14 - 9) / 2;
                int typeIconsWidth = numTypes * 14 + (numTypes - 1) * 1;
                int gap = 3;
                int totalWidth = 0;
                for (int i = 0; i < labels.size(); ++i) {
                    if (i > 0) {
                        totalWidth += mc.field_1772.method_1727(" ");
                    }
                    totalWidth += mc.field_1772.method_1727((String)labels.get(i));
                }
                if (alignRight) {
                    int typeIconsRightEdge = screenWidth - 15;
                    int typeIconsLeftEdge = typeIconsRightEdge - typeIconsWidth;
                    textX = typeIconsLeftEdge - totalWidth - gap;
                } else {
                    textX = 12 + typeIconsWidth + gap;
                }
                int currentX = textX;
                for (int i = 0; i < labels.size(); ++i) {
                    if (i > 0) {
                        currentX += mc.field_1772.method_1727(" ");
                    }
                    String label = (String)labels.get(i);
                    int textColor = BattleOpacityHelper.applyOpacity((Integer)colors.get(i), opacity);
                    gui.method_51433(mc.field_1772, label, currentX, textY, textColor, true);
                    currentX += mc.field_1772.method_1727(label);
                }
            }
            gui.method_51448().method_22909();
        }
    }

    private static void renderScreenOverlays(class_332 gui, class_310 mc, Map<String, Integer> screens, int x, int y, int width, int height, boolean alignRight, float opacity, int numTypes, int typeIconsY, int screenWidth) {
        StatStageRenderer.renderScreenOverlays(gui, mc, screens, x, y, width, height, alignRight, opacity, numTypes, typeIconsY, screenWidth, false, 1);
    }

    private static String getScreenAbbrev(String screen) {
        return switch (screen) {
            case "Light Screen" -> "LS";
            case "Reflect" -> "Ref";
            case "Aurora Veil" -> "AV";
            case "Safeguard" -> "SG";
            case "Mist" -> "Mst";
            case "Lucky Chant" -> "LC";
            default -> screen;
        };
    }

    private static int getTypeCount(ClientBattlePokemon pokemon) {
        boolean hasAddedType;
        if (pokemon == null) {
            return 1;
        }
        String pokemonName = pokemon.getSpecies().getName();
        String addedType = BattleMessageSubscriber.getAddedType(pokemonName);
        boolean bl = hasAddedType = addedType != null && !addedType.isEmpty();
        if (BattleMessageSubscriber.isTerastallized(pokemonName)) {
            return 1;
        }
        if (BattleMessageSubscriber.isSoaked(pokemonName)) {
            return hasAddedType ? 2 : 1;
        }
        String transformedType = BattleMessageSubscriber.getTransformedType(pokemonName);
        if (transformedType != null && !transformedType.isEmpty()) {
            return hasAddedType ? 2 : 1;
        }
        try {
            Iterable types = pokemon.getSpecies().getTypes();
            int baseCount = 1;
            if (types != null) {
                int count = 0;
                for (ElementalType ignored : types) {
                    ++count;
                }
                baseCount = count > 0 ? count : 1;
            }
            return hasAddedType ? baseCount + 1 : baseCount;
        }
        catch (Exception e) {
            return hasAddedType ? 2 : 1;
        }
    }

    private static int getScreenColor(String screen) {
        return switch (screen) {
            case "Light Screen" -> -171;
            case "Reflect" -> -43606;
            case "Aurora Veil" -> -11141121;
            case "Safeguard" -> -11141291;
            case "Mist" -> -5579265;
            case "Lucky Chant" -> -10496;
            default -> -1;
        };
    }

    private static void renderVolatileStatus(class_332 gui, class_310 mc, String speciesName, int x, int y, boolean alignRight, float opacity, String side) {
        int drawX;
        int healBlockTurns;
        boolean showGroundedIcon;
        int tailwindTurns;
        int drawX2;
        float scale = 1.5f;
        int iconGap = 2;
        int iconWithTurnsWidth = 26;
        int iconOnlyWidth = 16 + iconGap;
        int offset = 0;
        if (BattleMessageSubscriber.hasAquaRing(side, speciesName)) {
            drawX2 = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, AQUA_RING_ICON, drawX2, y, 16, opacity);
            offset += iconOnlyWidth;
        }
        if (BattleMessageSubscriber.isIngrained(side, speciesName)) {
            drawX2 = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, INGRAIN_ICON, drawX2, y, 16, opacity);
            offset += iconOnlyWidth;
        }
        if (BattleMessageSubscriber.hasSubstitute(side, speciesName)) {
            drawX2 = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, SUBSTITUTE_ICON, drawX2, y, 16, opacity);
            offset += iconOnlyWidth;
        }
        if (BattleMessageSubscriber.isLeechSeeded(side, speciesName)) {
            drawX2 = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, LEECH_SEED_ICON, drawX2, y, 16, opacity);
            offset += iconOnlyWidth;
        }
        if ((tailwindTurns = BattleMessageSubscriber.getTailwindTurns(side)) > 0) {
            int drawX3 = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, TAILWIND_ICON, drawX3, y, 16, opacity);
            int textColor = BattleOpacityHelper.applyOpacity(-6693377, opacity);
            int textX = alignRight ? drawX3 - 8 : drawX3 + 16 + 1;
            gui.method_51433(mc.field_1772, String.valueOf(tailwindTurns), textX, y + 4, textColor, true);
            offset += iconWithTurnsWidth;
        }
        boolean isSmackDownGrounded = BattleMessageSubscriber.isSmackDownGrounded(side, speciesName);
        int ungroundedTurns = BattleMessageSubscriber.getUngroundedTurns(side, speciesName);
        boolean bl = showGroundedIcon = isSmackDownGrounded && !BattleMessageSubscriber.isIngrained(side, speciesName);
        if (showGroundedIcon) {
            drawX = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, GROUNDED_ICON, drawX, y, 16, opacity);
            offset += iconOnlyWidth;
        } else if (ungroundedTurns > 0) {
            drawX = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, UNGROUNDED_ICON, drawX, y, 16, opacity);
            int textColor = BattleOpacityHelper.applyOpacity(-8875, opacity);
            int textX = alignRight ? drawX - 8 : drawX + 16 + 1;
            gui.method_51433(mc.field_1772, String.valueOf(ungroundedTurns), textX, y + 4, textColor, true);
            offset += iconWithTurnsWidth;
        }
        int embargoTurns = BattleMessageSubscriber.getEmbargoTurns(side, speciesName);
        if (embargoTurns > 0) {
            int drawX4 = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, EMBARGO_ICON, drawX4, y, 16, opacity);
            int textColor = BattleOpacityHelper.applyOpacity(-12303292, opacity);
            int textX = alignRight ? drawX4 - 8 : drawX4 + 16 + 1;
            gui.method_51433(mc.field_1772, String.valueOf(embargoTurns), textX, y + 4, textColor, true);
            offset += iconWithTurnsWidth;
        }
        if ((healBlockTurns = BattleMessageSubscriber.getHealBlockTurns(side, speciesName)) > 0) {
            drawX = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, HEAL_BLOCK_ICON, drawX, y, 16, opacity);
            int textColor = BattleOpacityHelper.applyOpacity(-48060, opacity);
            int textX = alignRight ? drawX - 8 : drawX + 16 + 1;
            gui.method_51433(mc.field_1772, String.valueOf(healBlockTurns), textX, y + 4, textColor, true);
            offset += iconWithTurnsWidth;
        }
        if (BattleMessageSubscriber.isConfused(side, speciesName)) {
            drawX = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, CONFUSION_ICON, drawX, y, 16, opacity);
            offset += iconOnlyWidth;
        }
        if (BattleMessageSubscriber.isIdentified(side, speciesName)) {
            drawX = alignRight ? x - offset - 16 : x + offset;
            StatStageRenderer.renderIcon(gui, IDENTIFIED_ICON, drawX, y, 16, opacity);
            offset += iconOnlyWidth;
        }
    }

    private static void renderVolatileStatus(class_332 gui, class_310 mc, String speciesName, int x, int y, boolean alignRight, float opacity) {
        StatStageRenderer.renderVolatileStatus(gui, mc, speciesName, x, y, alignRight, opacity, alignRight ? "opponent" : "player");
    }

    private static void renderSingleSymbol(class_332 gui, class_310 mc, String symbol, int color, int x, int y, float scale, float opacity) {
        gui.method_51448().method_22903();
        gui.method_51448().method_46416((float)x, (float)y, 0.0f);
        gui.method_51448().method_22905(scale, scale, 1.0f);
        int finalColor = BattleOpacityHelper.applyOpacity(color, opacity);
        gui.method_51433(mc.field_1772, symbol, 0, 0, finalColor, true);
        gui.method_51448().method_22909();
    }

    private static void renderIcon(class_332 gui, class_2960 texture, int x, int y, int size, float opacity) {
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int alpha = (int)(255.0f * opacity);
        int color = alpha << 24 | 0xFFFFFF;
        gui.method_51422(1.0f, 1.0f, 1.0f, opacity);
        gui.method_25290(texture, x, y, 0.0f, 0.0f, size, size, size, size);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_51448().method_22909();
    }

    private static int getStatLinesCount(Map<String, Integer> stats) {
        if (stats == null) {
            return 0;
        }
        return (int)stats.values().stream().filter(v -> v != null && v != 0).count();
    }

    private static int calculateMinSpeed(int baseSpeed, int level) {
        int rawStat = (2 * baseSpeed + 0 + 0) * level / 100 + 5;
        return (int)Math.floor((double)rawStat * 0.9);
    }

    private static int calculateMaxSpeed(int baseSpeed, int level) {
        int rawStat = (2 * baseSpeed + 31 + 63) * level / 100 + 5;
        return (int)Math.floor((double)rawStat * 1.1);
    }

    private static int applyStatStage(int speed, int stage) {
        if (stage == 0) {
            return speed;
        }
        if (stage > 0) {
            return speed * (2 + stage) / 2;
        }
        return speed * 2 / (2 - stage);
    }

    private static void renderSpeedRange(class_332 gui, class_310 mc, ActiveClientBattlePokemon active, ClientBattlePokemon pokemon, int x, int y, boolean alignRight, float opacity, String side, int screenWidth) {
        try {
            String pokemonName;
            int level;
            int baseSpeed;
            block20: {
                Species species2;
                block19: {
                    baseSpeed = 0;
                    level = pokemon.getLevel();
                    pokemonName = pokemon.getSpecies().getName().toLowerCase();
                    String formName = "unknown";
                    try {
                        species2 = pokemon.getSpecies();
                        Set aspects = null;
                        try {
                            Field aspectsField = pokemon.getClass().getDeclaredField("aspects");
                            aspectsField.setAccessible(true);
                            aspects = (Set)aspectsField.get(pokemon);
                        }
                        catch (Exception aspectsField) {
                            // empty catch block
                        }
                        if (species2 == null || aspects == null || aspects.isEmpty()) break block19;
                        try {
                            Method getForm = species2.getClass().getMethod("getForm", Set.class);
                            Object form = getForm.invoke((Object)species2, aspects);
                            if (form == null) break block19;
                            formName = form.getClass().getSimpleName();
                            try {
                                Method getName = form.getClass().getMethod("getName", new Class[0]);
                                formName = (String)getName.invoke(form, new Object[0]);
                            }
                            catch (Exception getName) {
                                // empty catch block
                            }
                            Method getBaseStats = form.getClass().getMethod("getBaseStats", new Class[0]);
                            Object baseStats = getBaseStats.invoke(form, new Object[0]);
                            if (baseStats instanceof Map) {
                                Map statsMap = (Map)baseStats;
                                for (Map.Entry entry : statsMap.entrySet()) {
                                    String statName = entry.getKey().toString().toLowerCase();
                                    if (!statName.contains("speed") && !statName.equals("spe")) continue;
                                    baseSpeed = (Integer)entry.getValue();
                                }
                            }
                        }
                        catch (Exception getForm) {}
                    }
                    catch (Throwable species2) {
                        // empty catch block
                    }
                }
                if (baseSpeed == 0) {
                    try {
                        Method getBaseStats;
                        Object baseStats;
                        species2 = pokemon.getSpecies();
                        if (species2 == null || !((baseStats = (getBaseStats = species2.getClass().getMethod("getBaseStats", new Class[0])).invoke((Object)species2, new Object[0])) instanceof Map)) break block20;
                        Map statsMap = (Map)baseStats;
                        for (Map.Entry entry : statsMap.entrySet()) {
                            String statName = entry.getKey().toString().toLowerCase();
                            if (!statName.contains("speed") && !statName.equals("spe")) continue;
                            baseSpeed = (Integer)entry.getValue();
                            break;
                        }
                    }
                    catch (Throwable e) {
                        CobblemonBattleInfoClient.debug("[StatStageRenderer 2D Tile] Failed to get base speed: {}", e.getMessage());
                    }
                }
            }
            if (baseSpeed <= 0) {
                return;
            }
            int minSpeed = StatStageRenderer.calculateMinSpeed(baseSpeed, level);
            int maxSpeed = StatStageRenderer.calculateMaxSpeed(baseSpeed, level);
            int speedStage = BattleMessageSubscriber.getStatStage(side, pokemonName, "speed");
            if (speedStage != 0) {
                minSpeed = StatStageRenderer.applyStatStage(minSpeed, speedStage);
                maxSpeed = StatStageRenderer.applyStatStage(maxSpeed, speedStage);
            }
            if (BattleMessageSubscriber.getTailwindTurns(side) > 0) {
                minSpeed *= 2;
                maxSpeed *= 2;
            }
            String label = "SPD ";
            String numbers = minSpeed + "-" + maxSpeed;
            String fullText = label + numbers;
            float scale = 0.75f;
            int textWidth = (int)((float)mc.field_1772.method_1727(fullText) * scale);
            Objects.requireNonNull(mc.field_1772);
            int textHeight = (int)(9.0f * scale);
            int paddingH = 2;
            int paddingV = 1;
            int panelWidth = textWidth + paddingH * 2;
            int panelHeight = textHeight + paddingV * 2;
            int labelColor = BattleOpacityHelper.applyOpacity(-7811841, opacity);
            int numberColor = speedStage > 0 ? BattleOpacityHelper.applyOpacity(-11141291, opacity) : (speedStage < 0 ? BattleOpacityHelper.applyOpacity(-43691, opacity) : BattleOpacityHelper.applyOpacity(-10027009, opacity));
            int bgColor = BattleOpacityHelper.applyOpacity(-870700486, opacity);
            int borderTop = BattleOpacityHelper.applyOpacity(1720241407, opacity);
            int borderBottom = BattleOpacityHelper.applyOpacity(860120712, opacity);
            int panelX = x - paddingH;
            int panelY = y - paddingV;
            gui.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, bgColor);
            gui.method_25294(panelX, panelY, panelX + panelWidth, panelY + 1, borderTop);
            gui.method_25294(panelX, panelY + panelHeight - 1, panelX + panelWidth, panelY + panelHeight, borderBottom);
            gui.method_25294(panelX, panelY, panelX + 1, panelY + panelHeight, borderTop);
            gui.method_25294(panelX + panelWidth - 1, panelY, panelX + panelWidth, panelY + panelHeight, borderBottom);
            gui.method_51448().method_22903();
            gui.method_51448().method_46416((float)x, (float)y, 200.0f);
            gui.method_51448().method_22905(scale, scale, 1.0f);
            gui.method_51433(mc.field_1772, label, 0, 0, labelColor, true);
            int labelWidth = mc.field_1772.method_1727(label);
            gui.method_51433(mc.field_1772, numbers, labelWidth, 0, numberColor, true);
            gui.method_51448().method_22909();
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[StatStageRenderer] Error rendering speed range: {}", t.getMessage());
        }
    }
}

