/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import name.modid.CobblemonBattleInfoClient;
import name.modid.platform.Services;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class UpdateChecker {
    private static final String MOD_ID = "cobblemon-battle-extras";
    private static final String MODRINTH_PROJECT_ID = "cobblemon-battle-extras";
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/cobblemon-battle-extras/version";
    private static final String MODRINTH_PAGE_URL = "https://modrinth.com/mod/cobblemon-battle-extras";
    private static String currentVersion = null;
    private static final String MINECRAFT_VERSION = "1.21.1";
    private static boolean hasChecked = false;
    private static boolean updateAvailable = false;
    private static String latestVersion = null;
    private static boolean notificationShown = false;
    private static boolean pendingJoinNotification = false;

    public static void init() {
        UpdateChecker.checkForUpdatesAsync();
    }

    private static void checkForUpdatesAsync() {
        CompletableFuture.runAsync(() -> {
            try {
                String latest = UpdateChecker.fetchLatestVersion();
                String resolvedVersion = UpdateChecker.getCurrentVersion();
                if (latest != null && UpdateChecker.isNewerVersion(latest, resolvedVersion)) {
                    updateAvailable = true;
                    latestVersion = latest;
                    CobblemonBattleInfoClient.LOGGER.info("[Battle Extras] Update available! Current: {}, Latest: {}", (Object)resolvedVersion, (Object)latest);
                } else {
                    CobblemonBattleInfoClient.debug("[UpdateChecker] No update available. Current: {}, Latest: {}", resolvedVersion, latest);
                }
                hasChecked = true;
                UpdateChecker.tryScheduleNotification();
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[UpdateChecker] Failed to check for updates: {}", e.getMessage());
                hasChecked = true;
            }
        });
    }

    public static void onPlayerJoin() {
        if (notificationShown) {
            return;
        }
        pendingJoinNotification = true;
        UpdateChecker.tryScheduleNotification();
    }

    private static void tryScheduleNotification() {
        if (notificationShown || !pendingJoinNotification || !hasChecked || !updateAvailable) {
            return;
        }
        pendingJoinNotification = false;
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null && updateAvailable && !notificationShown) {
                UpdateChecker.showUpdateNotification(mc);
                notificationShown = true;
            }
        });
    }

    private static void showUpdateNotification(class_310 mc) {
        mc.execute(() -> {
            if (mc.field_1724 == null) {
                return;
            }
            class_5250 prefix = class_2561.method_43470((String)"[Battle Extras] ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
            class_5250 message = class_2561.method_43470((String)"Update available! ").method_27692(class_124.field_1054);
            class_5250 versionInfo = class_2561.method_43470((String)("v" + UpdateChecker.getCurrentVersion() + " \u2192 v" + latestVersion)).method_27692(class_124.field_1068);
            class_5250 clickHere = class_2561.method_43470((String)" [Click to download]").method_27694(style -> style.method_10977(class_124.field_1075).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, MODRINTH_PAGE_URL)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Open Modrinth page"))));
            mc.field_1724.method_43496((class_2561)prefix.method_10852((class_2561)message).method_10852((class_2561)versionInfo).method_10852((class_2561)clickHere));
        });
    }

    private static String fetchLatestVersion() {
        try {
            String line;
            URL url = new URL("https://api.modrinth.com/v2/project/cobblemon-battle-extras/version?game_versions=[\"1.21.1\"]");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "CobblemonBattleExtras/" + UpdateChecker.getCurrentVersion());
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                CobblemonBattleInfoClient.debug("[UpdateChecker] Modrinth API returned code: {}", responseCode);
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            JsonArray versions = JsonParser.parseString((String)response.toString()).getAsJsonArray();
            if (versions.size() == 0) {
                return null;
            }
            for (JsonElement element : versions) {
                JsonObject version = element.getAsJsonObject();
                String versionType = version.get("version_type").getAsString();
                if (!"release".equals(versionType)) continue;
                return version.get("version_number").getAsString();
            }
            return versions.get(0).getAsJsonObject().get("version_number").getAsString();
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[UpdateChecker] Error fetching version: {}", e.getMessage());
            return null;
        }
    }

    private static boolean isNewerVersion(String latest, String current) {
        try {
            latest = UpdateChecker.cleanVersion(latest);
            current = UpdateChecker.cleanVersion(current);
            String[] latestParts = latest.split("\\.");
            String[] currentParts = current.split("\\.");
            int maxLength = Math.max(latestParts.length, currentParts.length);
            for (int i = 0; i < maxLength; ++i) {
                int currentNum;
                int latestNum = i < latestParts.length ? UpdateChecker.parseVersionPart(latestParts[i]) : 0;
                int n = currentNum = i < currentParts.length ? UpdateChecker.parseVersionPart(currentParts[i]) : 0;
                if (latestNum > currentNum) {
                    return true;
                }
                if (latestNum >= currentNum) continue;
                return false;
            }
            return false;
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[UpdateChecker] Error comparing versions: {}", e.getMessage());
            return false;
        }
    }

    private static String cleanVersion(String version) {
        int dashIndex;
        if (version.startsWith("v") || version.startsWith("V")) {
            version = version.substring(1);
        }
        if ((dashIndex = version.indexOf(45)) > 0) {
            version = version.substring(0, dashIndex);
        }
        return version;
    }

    private static int parseVersionPart(String part) {
        StringBuilder digits = new StringBuilder();
        for (char c : part.toCharArray()) {
            if (!Character.isDigit(c)) break;
            digits.append(c);
        }
        if (digits.length() == 0) {
            return 0;
        }
        return Integer.parseInt(digits.toString());
    }

    public static boolean isUpdateAvailable() {
        return updateAvailable;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }

    public static String getCurrentVersion() {
        if (currentVersion == null) {
            currentVersion = Services.PLATFORM.getModVersion("cobblemon-battle-extras");
        }
        return currentVersion;
    }
}

