/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.mojang.blaze3d.systems.RenderSystem;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleOpacityHelper;
import name.modid.platform.Services;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class WeatherTerrainRenderer {
    private static final int WEATHER_COLOR_SANDSTORM = -2841228;
    private static final int WEATHER_COLOR_RAIN = -9728044;
    private static final int WEATHER_COLOR_SUN = -10496;
    private static final int WEATHER_COLOR_SNOW = -5383962;
    private static final int TERRAIN_COLOR_ELECTRIC = -256;
    private static final int TERRAIN_COLOR_GRASSY = -16711936;
    private static final int TERRAIN_COLOR_PSYCHIC = -38476;
    private static final int TERRAIN_COLOR_MISTY = -1644806;
    private static final int TRICK_ROOM_COLOR = -38476;
    private static final int WATER_SPORT_COLOR = -9728044;
    private static final int MUD_SPORT_COLOR = -7640812;
    private static final int GRAVITY_COLOR = -6723892;
    private static final int WONDER_ROOM_COLOR = -65281;
    private static final int MAGIC_ROOM_COLOR = -10496;

    public static void init() {
        Services.EVENTS.registerHudRender((gui, tickDelta) -> {
            try {
                WeatherTerrainRenderer.render(gui);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("WeatherTerrainRenderer initialized", new Object[0]);
    }

    private static void render(class_332 gui) {
        int arrowColor;
        int arrowX;
        int sheetHeight;
        int sheetWidth;
        int iconSrcSize;
        class_2960 typeSheet;
        int iconY;
        int iconX;
        int x;
        int totalWidth;
        int arrowWidth;
        int iconSize;
        int x2;
        int bgColor;
        int color;
        Object text;
        String displayName;
        boolean hasMagicRoom;
        if (!BattleExtrasConfig.isWeatherTerrainEnabled()) {
            return;
        }
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        String weather = BattleMessageSubscriber.getCurrentWeather();
        String terrain = BattleMessageSubscriber.getCurrentTerrain();
        int weatherTurns = BattleMessageSubscriber.getWeatherTurns();
        int terrainTurns = BattleMessageSubscriber.getTerrainTurns();
        int trickRoomTurns = BattleMessageSubscriber.getTrickRoomTurns();
        int waterSportTurns = BattleMessageSubscriber.getWaterSportTurns();
        int mudSportTurns = BattleMessageSubscriber.getMudSportTurns();
        int gravityTurns = BattleMessageSubscriber.getGravityTurns();
        int wonderRoomTurns = BattleMessageSubscriber.getWonderRoomTurns();
        int magicRoomTurns = BattleMessageSubscriber.getMagicRoomTurns();
        boolean hasWeather = weather != null && !weather.isEmpty();
        boolean hasTerrain = terrain != null && !terrain.isEmpty();
        boolean hasTrickRoom = trickRoomTurns > 0;
        boolean hasWaterSport = waterSportTurns > 0;
        boolean hasMudSport = mudSportTurns > 0;
        boolean hasGravity = gravityTurns > 0;
        boolean hasWonderRoom = wonderRoomTurns > 0;
        boolean bl = hasMagicRoom = magicRoomTurns > 0;
        if (!(hasWeather || hasTerrain || hasTrickRoom || hasWaterSport || hasMudSport || hasGravity || hasWonderRoom || hasMagicRoom)) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float opacity = BattleOpacityHelper.getBattleOpacity();
        class_327 font = mc.field_1772;
        int screenWidth = mc.method_22683().method_4486();
        int y = 20;
        if (hasWeather) {
            displayName = WeatherTerrainRenderer.getWeatherKey(weather);
            text = weatherTurns < 0 ? displayName + " (\u221e)" : (weatherTurns > 0 ? displayName + " (" + weatherTurns + ")" : displayName);
            color = BattleOpacityHelper.applyOpacity(WeatherTerrainRenderer.getWeatherColor(weather), opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            x2 = (screenWidth - font.method_1727((String)text)) / 2;
            gui.method_25294(x2 - 4, y - 2, x2 + font.method_1727((String)text) + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x2, y, color, true);
            y += 14;
        }
        if (hasTerrain) {
            displayName = class_2561.method_43471((String)WeatherTerrainRenderer.getTerrainKey(terrain)).getString();
            text = terrainTurns > 0 ? displayName + " (" + terrainTurns + ")" : displayName;
            color = BattleOpacityHelper.applyOpacity(WeatherTerrainRenderer.getTerrainColor(terrain), opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            x2 = (screenWidth - font.method_1727((String)text)) / 2;
            gui.method_25294(x2 - 4, y - 2, x2 + font.method_1727((String)text) + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x2, y, color, true);
            y += 14;
        }
        if (hasTrickRoom) {
            displayName = class_2561.method_43471((String)"field.trick_room").getString();
            text = displayName + " (" + trickRoomTurns + ")";
            color = BattleOpacityHelper.applyOpacity(-38476, opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            x2 = (screenWidth - font.method_1727((String)text)) / 2;
            gui.method_25294(x2 - 4, y - 2, x2 + font.method_1727((String)text) + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x2, y, color, true);
            y += 14;
        }
        if (hasGravity) {
            displayName = class_2561.method_43471((String)"field.gravity").getString();
            text = displayName + " (" + gravityTurns + ")";
            color = BattleOpacityHelper.applyOpacity(-6723892, opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            x2 = (screenWidth - font.method_1727((String)text)) / 2;
            gui.method_25294(x2 - 4, y - 2, x2 + font.method_1727((String)text) + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x2, y, color, true);
            y += 14;
        }
        if (hasWonderRoom) {
            displayName = class_2561.method_43471((String)"field.wonder_room").getString();
            text = displayName + " (" + wonderRoomTurns + ")";
            color = BattleOpacityHelper.applyOpacity(-65281, opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            x2 = (screenWidth - font.method_1727((String)text)) / 2;
            gui.method_25294(x2 - 4, y - 2, x2 + font.method_1727((String)text) + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x2, y, color, true);
            y += 14;
        }
        if (hasMagicRoom) {
            displayName = class_2561.method_43471((String)"field.magic_room").getString();
            text = displayName + " (" + magicRoomTurns + ")";
            color = BattleOpacityHelper.applyOpacity(-10496, opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            x2 = (screenWidth - font.method_1727((String)text)) / 2;
            gui.method_25294(x2 - 4, y - 2, x2 + font.method_1727((String)text) + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x2, y, color, true);
            y += 14;
        }
        if (hasWaterSport) {
            displayName = class_2561.method_43471((String)"field.water_sport").getString();
            text = displayName + " (" + waterSportTurns + ")";
            color = BattleOpacityHelper.applyOpacity(-9728044, opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            iconSize = 10;
            arrowWidth = font.method_1727(" v");
            totalWidth = font.method_1727((String)text) + 4 + iconSize + arrowWidth;
            x = (screenWidth - totalWidth) / 2;
            gui.method_25294(x - 4, y - 2, x + totalWidth + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x, y, color, true);
            iconX = x + font.method_1727((String)text) + 4;
            iconY = y;
            typeSheet = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
            int fireTypeIndex = 1;
            iconSrcSize = 36;
            sheetWidth = 648;
            sheetHeight = 36;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            gui.method_25293(typeSheet, iconX, iconY, iconSize, iconSize, (float)(fireTypeIndex * iconSrcSize), 0.0f, iconSrcSize, iconSrcSize, sheetWidth, sheetHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            arrowX = iconX + iconSize + 2;
            arrowColor = BattleOpacityHelper.applyOpacity(-38037, opacity);
            gui.method_51433(font, "\u2193", arrowX, y, arrowColor, true);
            y += 14;
        }
        if (hasMudSport) {
            displayName = class_2561.method_43471((String)"field.mud_sport").getString();
            text = displayName + " (" + mudSportTurns + ")";
            color = BattleOpacityHelper.applyOpacity(-7640812, opacity);
            bgColor = BattleOpacityHelper.applyOpacity(Integer.MIN_VALUE, opacity);
            iconSize = 10;
            arrowWidth = font.method_1727(" v");
            totalWidth = font.method_1727((String)text) + 4 + iconSize + arrowWidth;
            x = (screenWidth - totalWidth) / 2;
            gui.method_25294(x - 4, y - 2, x + totalWidth + 4, y + 10, bgColor);
            gui.method_51433(font, (String)text, x, y, color, true);
            iconX = x + font.method_1727((String)text) + 4;
            iconY = y;
            typeSheet = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
            int electricTypeIndex = 4;
            iconSrcSize = 36;
            sheetWidth = 648;
            sheetHeight = 36;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            gui.method_25293(typeSheet, iconX, iconY, iconSize, iconSize, (float)(electricTypeIndex * iconSrcSize), 0.0f, iconSrcSize, iconSrcSize, sheetWidth, sheetHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            arrowX = iconX + iconSize + 2;
            arrowColor = BattleOpacityHelper.applyOpacity(-38037, opacity);
            gui.method_51433(font, "\u2193", arrowX, y, arrowColor, true);
        }
    }

    private static String getWeatherKey(String w) {
        return w;
    }

    private static int getWeatherColor(String w) {
        return switch (w) {
            case "Sandstorm" -> -2841228;
            case "Sun" -> -10496;
            case "Rain" -> -9728044;
            case "Snow", "Hail" -> -5383962;
            case "Heavy Rain" -> -12490271;
            case "Harsh Sunlight" -> -29696;
            case "Strong Winds" -> -16724271;
            default -> -1;
        };
    }

    private static String getTerrainKey(String t) {
        return switch (t) {
            case "Electric Terrain" -> "terrain.electric_terrain";
            case "Grassy Terrain" -> "terrain.grassy_terrain";
            case "Psychic Terrain" -> "terrain.psychic_terrain";
            case "Misty Terrain" -> "terrain.misty_terrain";
            default -> t;
        };
    }

    private static int getTerrainColor(String t) {
        return switch (t) {
            case "Electric Terrain" -> -256;
            case "Grassy Terrain" -> -16711936;
            case "Psychic Terrain" -> -38476;
            case "Misty Terrain" -> -1644806;
            default -> -1;
        };
    }
}

