/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleMessageColorizer;
import name.modid.client.battlelog.BattleLogEntry;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleLogManager");
    private static final int MAX_ENTRIES = 500;
    private static final String TURN_KEY = "cobblemon.battle.turn";
    private static final Pattern TURN_PATTERN = Pattern.compile("Turn\\s+(\\d+)", 2);
    private static final List<BattleLogEntry> entries = new CopyOnWriteArrayList<BattleLogEntry>();
    private static int currentTurn = 0;
    private static boolean inBattle = false;

    public static void addMessage(class_2561 message, String translationKey) {
        Integer turnNum;
        if (!inBattle) {
            CobblemonBattleInfoClient.debug("[BattleLogManager] Received message before battle start, auto-initializing", new Object[0]);
            BattleLogManager.onBattleStart();
        }
        String messageText = message.getString();
        if (TURN_KEY.equals(translationKey) && (turnNum = BattleLogManager.extractTurnNumber(message, translationKey)) != null) {
            currentTurn = turnNum;
            return;
        }
        class_2561 finalMessage = BattleLogManager.colorizeByTranslationKey(message, translationKey, messageText);
        BattleLogEntry.EntryType type = BattleLogManager.categorizeMessage(translationKey, messageText);
        BattleLogEntry entry = new BattleLogEntry(currentTurn, type, finalMessage, translationKey);
        entries.add(entry);
        while (entries.size() > 500) {
            entries.remove(0);
        }
    }

    private static class_2561 colorizeByTranslationKey(class_2561 message, String translationKey, String messageText) {
        LOGGER.debug("[BattleLogManager] Translation key: '{}' | Message: '{}'", (Object)translationKey, (Object)messageText);
        if (translationKey == null) {
            class_2561 colorized = BattleMessageColorizer.colorizeLineByParts(messageText);
            return colorized != null ? colorized : message;
        }
        String key = translationKey.toLowerCase();
        if (key.contains("supereffective")) {
            return message.method_27661().method_27694(style -> style.method_36139(0x55FF55));
        }
        if (key.contains("resisted") || key.contains("notveryeffective")) {
            return message.method_27661().method_27694(style -> style.method_36139(0xAAAAAA));
        }
        if (key.contains("crit")) {
            return message.method_27661().method_27694(style -> style.method_36139(0xFFAA00));
        }
        if (key.contains("weather") || key.contains("terrain")) {
            int color = key.contains("rain") || key.contains("drizzle") ? 6852848 : (key.contains("sun") || key.contains("harsh") || key.contains("drought") ? 16306224 : (key.contains("sand") ? 12756557 : (key.contains("hail") ? 0x98D8D8 : (key.contains("snow") ? 12116192 : 0xFFFFFF))));
            return message.method_27661().method_27694(style -> style.method_36139(color));
        }
        class_2561 colorized = BattleMessageColorizer.colorizeLineByParts(messageText);
        return colorized != null ? colorized : message;
    }

    private static Integer extractTurnNumber(class_2561 message, String translationKey) {
        String text;
        Matcher matcher;
        class_2588 tc;
        Object[] args;
        class_7417 class_74172 = message.method_10851();
        if (class_74172 instanceof class_2588 && (args = (tc = (class_2588)class_74172).method_11023()) != null && args.length > 0) {
            Object arg = args[0];
            if (arg instanceof Number) {
                return ((Number)arg).intValue();
            }
            if (arg instanceof class_2561) {
                class_2561 c = (class_2561)arg;
                try {
                    return Integer.parseInt(c.getString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (arg != null) {
                try {
                    return Integer.parseInt(arg.toString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((matcher = TURN_PATTERN.matcher(text = message.getString())).find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void addTurnMarker(int turn) {
        currentTurn = turn;
        class_5250 turnMsg = class_2561.method_43470((String)("\u2500\u2500\u2500 Turn " + turn + " \u2500\u2500\u2500"));
        BattleLogEntry entry = new BattleLogEntry(turn, BattleLogEntry.EntryType.TURN, (class_2561)turnMsg, "battle.turn");
        entries.add(entry);
    }

    public static void addXPMessage(class_2561 message) {
        if (!inBattle) {
            // empty if block
        }
        BattleLogEntry entry = new BattleLogEntry(currentTurn, BattleLogEntry.EntryType.OTHER, message, "battle.xp_gained");
        entries.add(entry);
        while (entries.size() > 500) {
            entries.remove(0);
        }
    }

    public static void addHpChangeEntry(String pokemonName, float percentChange, boolean isHealing) {
        String arrow = isHealing ? "\u2191" : "\u2193";
        String sign = isHealing ? "+" : "-";
        String formattedPercent = BattleLogManager.formatPercent(Math.abs(percentChange));
        class_5250 msg = class_2561.method_43470((String)(arrow + " " + sign + formattedPercent + "% \u2192 " + pokemonName));
        BattleLogEntry.EntryType type = isHealing ? BattleLogEntry.EntryType.HEALING : BattleLogEntry.EntryType.HP;
        BattleLogEntry entry = new BattleLogEntry(currentTurn, type, (class_2561)msg, "battle.hp_change");
        entries.add(entry);
    }

    private static BattleLogEntry.EntryType categorizeMessage(String translationKey, String messageText) {
        if (translationKey == null) {
            return BattleLogEntry.EntryType.OTHER;
        }
        String key = translationKey.toLowerCase();
        String text = messageText.toLowerCase();
        if (key.equals(TURN_KEY) || text.startsWith("turn ")) {
            return BattleLogEntry.EntryType.TURN;
        }
        if (key.contains("move.") || key.contains("used") || key.contains("effectiveness") || key.contains("critical") || key.contains("missed") || key.contains("failed")) {
            return BattleLogEntry.EntryType.MOVE;
        }
        if (key.contains("faint") || key.contains("damage") || key.contains("switch") || key.contains("sentout") || text.contains("fainted")) {
            return BattleLogEntry.EntryType.HP;
        }
        if (key.contains("heal") || key.contains("restore") || key.contains("drain") || text.contains("restored") || text.contains("regained")) {
            return BattleLogEntry.EntryType.HEALING;
        }
        if (key.contains("stat") || key.contains("status") || key.contains("ability") || key.contains("boost") || key.contains("lower") || key.contains("raise") || key.contains("cure") || key.contains("inflict") || key.contains("volatile")) {
            return BattleLogEntry.EntryType.EFFECT;
        }
        if (key.contains("weather") || key.contains("terrain") || key.contains("screen") || key.contains("hazard") || key.contains("trick") || key.contains("tailwind") || key.contains("rain") || key.contains("sun") || key.contains("sand") || key.contains("hail") || key.contains("snow") || key.contains("electric") || key.contains("grassy") || key.contains("misty") || key.contains("psychic")) {
            return BattleLogEntry.EntryType.FIELD;
        }
        return BattleLogEntry.EntryType.OTHER;
    }

    private static String formatPercent(float percent) {
        if (percent == (float)((int)percent)) {
            return String.valueOf((int)percent);
        }
        return String.format("%.1f", Float.valueOf(percent));
    }

    public static List<BattleLogEntry> getEntries() {
        return new ArrayList<BattleLogEntry>(entries);
    }

    public static List<BattleLogEntry> getEntriesByType(BattleLogEntry.EntryType type) {
        ArrayList<BattleLogEntry> filtered = new ArrayList<BattleLogEntry>();
        for (BattleLogEntry entry : entries) {
            if (entry.getType() != type) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public static void onBattleStart() {
        if (!inBattle) {
            CobblemonBattleInfoClient.debug("[BattleLogManager] Battle started - clearing entries", new Object[0]);
            entries.clear();
            currentTurn = 0;
        } else {
            CobblemonBattleInfoClient.debug("[BattleLogManager] Battle already started - preserving {} early entries", entries.size());
        }
        inBattle = true;
    }

    public static void onBattleEnd() {
        CobblemonBattleInfoClient.debug("[BattleLogManager] Battle ended, {} entries recorded", entries.size());
        inBattle = false;
        entries.clear();
        currentTurn = 0;
    }

    public static void clear() {
        entries.clear();
        currentTurn = 0;
    }

    public static boolean isInBattle() {
        return inBattle;
    }

    public static int getCurrentTurn() {
        return currentTurn;
    }

    public static int getEntryCount() {
        return entries.size();
    }
}

