/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.renderer.screen;

import de.markusbordihn.easynpc.client.renderer.screen.EntityScreenRenderer;
import de.markusbordihn.easynpc.data.model.ModelAnimationData;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.render.RenderDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import net.minecraft.class_332;

public class EntityConfigScreenRenderer
extends EntityScreenRenderer {
    private EntityConfigScreenRenderer() {
    }

    public static void renderEntity(class_332 guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        ConfigRenderState backupState = new ConfigRenderState(easyNPC);
        EntityConfigScreenRenderer.applyConfigOverrides(easyNPC, config);
        EntityScreenRenderer.renderEntity((class_332)guiGraphics, easyNPC, (EntityRenderConfig)config, (float)mouseX, (float)mouseY);
        EntityConfigScreenRenderer.restoreConfigState(easyNPC, backupState);
    }

    private static void applyConfigOverrides(EasyNPC<?> easyNPC, EntityRenderConfig config) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        EntityRenderOverrides overrides = config.overrides();
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData != null && renderData.getRenderDataEntry() != null) {
            RenderDataEntry renderDataSet = renderData.getRenderDataEntry();
            if (overrides.renderType() != null) {
                renderDataSet = renderDataSet.withRenderType(overrides.renderType());
            }
            if (overrides.renderEntityType() != null) {
                renderDataSet = renderDataSet.withRenderEntityType(overrides.renderEntityType());
            }
            renderData.setRenderData(renderDataSet);
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && (overrides.skinType() != null || overrides.skinUUID() != null)) {
            SkinDataEntry skinDataEntry = skinData.getSkinDataEntry();
            if (overrides.skinType() != null) {
                skinDataEntry = skinDataEntry.withType(overrides.skinType());
            }
            if (overrides.skinUUID() != null) {
                skinDataEntry = skinDataEntry.withUUID(overrides.skinUUID());
            }
            skinData.setSkinDataEntry(skinDataEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && overrides.variant() != null) {
            variantData.setSkinVariantType(overrides.variant());
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && overrides.profession() != null) {
            professionData.setProfession(overrides.profession());
        }
    }

    private static void restoreConfigState(EasyNPC<?> easyNPC, ConfigRenderState backupState) {
        ModelDataCapable animationData;
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData != null && backupState.renderDataEntry != null) {
            renderData.setRenderData(backupState.renderDataEntry);
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && backupState.skinDataEntry != null) {
            skinData.setSkinDataEntry(backupState.skinDataEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && backupState.variantType != null) {
            variantData.setSkinVariantType(backupState.variantType);
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && backupState.profession != null) {
            professionData.setProfession(backupState.profession);
        }
        if ((animationData = easyNPC.getEasyNPCModelData()) != null && backupState.modelAnimationData != null) {
            animationData.setModelAnimationData(backupState.modelAnimationData);
        }
    }

    private static class ConfigRenderState {
        final SkinDataEntry skinDataEntry;
        final Enum<?> variantType;
        final Profession profession;
        final RenderDataEntry renderDataEntry;
        final ModelAnimationData modelAnimationData;

        ConfigRenderState(EasyNPC<?> easyNPC) {
            RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
            this.renderDataEntry = renderData != null ? renderData.getRenderDataEntry() : null;
            SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
            this.skinDataEntry = skinData != null ? skinData.getSkinDataEntry() : null;
            VariantDataCapable variantData = easyNPC.getEasyNPCVariantData();
            this.variantType = variantData != null ? variantData.getSkinVariantType() : null;
            ProfessionDataCapable professionData = easyNPC.getEasyNPCProfessionData();
            this.profession = professionData != null ? professionData.getProfession() : null;
            ModelDataCapable animationData = easyNPC.getEasyNPCModelData();
            this.modelAnimationData = animationData != null ? animationData.getModelAnimationData() : null;
        }
    }
}

