/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.MultiStateToggleButton;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.class_2561;

public class NameVisibilityToggleButton
extends MultiStateToggleButton {
    public static final int SPRITE_OFFSET_X = 92;
    public static final int SPRITE_OFFSET_Y_NEVER = 166;
    public static final int SPRITE_OFFSET_Y_MID = 178;
    public static final int SPRITE_OFFSET_Y_NEAR = 190;
    public static final int SPRITE_OFFSET_Y_MOUSE_OVER = 202;
    public static final int SPRITE_OFFSET_Y_ALWAYS = 154;
    private NameVisibilityType currentVisibilityType;

    public NameVisibilityToggleButton(int left, int top, NameVisibilityType initialType, OnVisibilityChange onVisibilityChange) {
        this(left, top, 18, 18, initialType, onVisibilityChange);
    }

    public NameVisibilityToggleButton(int left, int top, int width, int height, NameVisibilityType initialType, OnVisibilityChange onVisibilityChange) {
        super(left, top, width, height, NameVisibilityToggleButton.createVisibilityStates(), NameVisibilityToggleButton.getStateIndexFromType(initialType), (button, newStateIndex) -> {
            NameVisibilityToggleButton nameButton = (NameVisibilityToggleButton)button;
            nameButton.currentVisibilityType = NameVisibilityToggleButton.getTypeFromStateIndex(newStateIndex);
            if (onVisibilityChange != null) {
                onVisibilityChange.onVisibilityChange(nameButton, nameButton.currentVisibilityType);
            }
        });
        this.currentVisibilityType = initialType;
    }

    private static MultiStateToggleButton.ToggleState[] createVisibilityStates() {
        return new MultiStateToggleButton.ToggleState[]{new MultiStateToggleButton.ToggleState(92, 154, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.always")), new MultiStateToggleButton.ToggleState(92, 178, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.mid")), new MultiStateToggleButton.ToggleState(92, 190, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.near")), new MultiStateToggleButton.ToggleState(92, 202, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.mouse_over")), new MultiStateToggleButton.ToggleState(92, 166, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.never"))};
    }

    private static int getStateIndexFromType(NameVisibilityType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case NameVisibilityType.ALWAYS -> 0;
            case NameVisibilityType.MID -> 1;
            case NameVisibilityType.NEAR -> 2;
            case NameVisibilityType.MOUSE_OVER -> 3;
            case NameVisibilityType.NEVER -> 4;
        };
    }

    private static NameVisibilityType getTypeFromStateIndex(int stateIndex) {
        return switch (stateIndex) {
            case 0 -> NameVisibilityType.ALWAYS;
            case 1 -> NameVisibilityType.MID;
            case 2 -> NameVisibilityType.NEAR;
            case 3 -> NameVisibilityType.MOUSE_OVER;
            case 4 -> NameVisibilityType.NEVER;
            default -> NameVisibilityType.ALWAYS;
        };
    }

    public NameVisibilityType getVisibilityType() {
        return this.currentVisibilityType;
    }

    public void setVisibilityType(NameVisibilityType type) {
        this.currentVisibilityType = type;
        this.setCurrentStateIndex(NameVisibilityToggleButton.getStateIndexFromType(type));
    }

    @FunctionalInterface
    public static interface OnVisibilityChange {
        public void onVisibilityChange(NameVisibilityToggleButton var1, NameVisibilityType var2);
    }
}

